/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.protocol.SSLSocketFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.admintask.SetLdapConfig;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.net.SocketFactory;

public class ValidateLdapSSLSocketFactory
extends SSLSocketFactory {
    private static final TraceComponent tc = Tr.register(ValidateLdapSSLSocketFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static int hashCode = 0;
    private static ValidateLdapSSLSocketFactory defaultFactory = new ValidateLdapSSLSocketFactory();

    private ValidateLdapSSLSocketFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateLdapSSLSocketFactory");
        }
        this.props = ValidateLdapSSLSocketFactory.getCurrentSSLProp();
        this.default_constructor = false;
        if (this.props != null) {
            hashCode = this.props.hashCode();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateLdapSSLSocketFactory");
        }
    }

    private ValidateLdapSSLSocketFactory(Properties newProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ValidateLdapSSLSocketFactory(Properties)");
        }
        this.default_constructor = false;
        if (newProps != null) {
            this.props = newProps;
            hashCode = newProps.hashCode();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ValidateLdapSSLSocketFactory(Properties");
        }
    }

    private static Properties getCurrentSSLProp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentSSLProp");
        }
        Properties newProps = null;
        try {
            Properties ldapProperties = SetLdapConfig.getLdapProperties();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ldapProperties = " + ldapProperties.toString());
            }
            String LdapSslAliasTmp = null;
            String host = null;
            String port = null;
            if (ldapProperties != null) {
                LdapSslAliasTmp = (String)ldapProperties.get("security.registry.ldap.SSLAlias");
                host = (String)ldapProperties.get("com.ibm.ssl.remoteHost");
                port = (String)ldapProperties.get("com.ibm.ssl.remotePort");
            }
            final String LdapSslAlias = LdapSslAliasTmp;
            final HashMap<String, String> connectionInfo = new HashMap<String, String>();
            connectionInfo.put("com.ibm.ssl.direction", "outbound");
            connectionInfo.put("com.ibm.ssl.endPointName", "LDAP");
            if (host != null && !host.equals("")) {
                connectionInfo.put("com.ibm.ssl.remoteHost", host);
            }
            if (port != null && !port.equals("")) {
                connectionInfo.put("com.ibm.ssl.remotePort", port);
            }
            try {
                newProps = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JSSEHelper.getInstance().getProperties(LdapSslAlias, connectionInfo, null);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.registry.ldap.ValidateLdapSSLSocketFactory.getCurrentSSLProp", "64");
            Tr.error(tc, "security.registry.ldap.initerror", e.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "props =" + newProps);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentSSLProp");
        }
        return newProps;
    }

    public static SocketFactory getDefault() {
        Properties tempProps = ValidateLdapSSLSocketFactory.getCurrentSSLProp();
        if (tempProps != null && hashCode != tempProps.hashCode()) {
            defaultFactory = new ValidateLdapSSLSocketFactory(tempProps);
        }
        return defaultFactory;
    }

    public static Properties getDefaultConfig() {
        return defaultFactory.getConfig();
    }

    public Properties getConfig() {
        return this.props;
    }
}

