/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.registry.ldap.LdapConfig;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class LdapLoadBalanceImpl {
    private static TraceComponent tc = Tr.register(LdapLoadBalanceImpl.class, null, "com.ibm.ejs.resources.security");
    private static int selectionCursor = -1;
    private static int loadBalancePolicy = 1;
    private static final int RoundRobin = 1;
    private static final int WeightedRoundRobin = 2;
    private static final int RandomWalk = 3;
    private static final int WeightedRandomWalk = 4;
    private static final int UsePrefer = 5;
    private static int maintainWindowTime = 300000;
    private static Vector ldapServers = new Vector();
    private static Hashtable contextTable = new Hashtable();
    private static Hashtable ldapStatusTable = new Hashtable();
    private static Vector ldapLoads = new Vector();
    private static LdapConfig baseLdapConfig;
    private static Thread ldapServiceThread;
    private static TraceComponent innerTc;

    public LdapLoadBalanceImpl(LdapConfig ldapConfig) {
        this.initialize(ldapConfig);
    }

    public synchronized void initialize(LdapConfig ldapConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize Ldap Load Balance.");
        }
        if (ldapServiceThread == null) {
            baseLdapConfig = new LdapConfig(ldapConfig);
            selectionCursor = 0;
            this.readLoadBalancePolicy();
            this.readGroupOfLdapServers();
            this.createCtxPool();
            ldapServiceThread = new LdapServiceMonitor();
            ldapServiceThread.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize Ldap Load Balance.");
        }
    }

    private void readLoadBalancePolicy() {
        loadBalancePolicy = 1;
        if (tc.isEntryEnabled()) {
            String sPol = new Integer(loadBalancePolicy).toString();
            Tr.debug(tc, "Use load balance policy: ", sPol);
        }
    }

    private void readGroupOfLdapServers() {
        ldapServers.clear();
        ldapLoads.clear();
        String ldapUrl = "ldap://secfvt2.austin.ibm.com:389/";
        ldapServers.addElement(ldapUrl);
        ldapStatusTable.put(ldapUrl, "-1");
        ldapLoads.addElement("2");
        ldapUrl = "ldap://cliang.austin.ibm.com:389/";
        ldapServers.addElement(ldapUrl);
        ldapStatusTable.put(ldapUrl, "-1");
        ldapLoads.addElement("1");
        if (ldapServers.size() == 1) {
            loadBalancePolicy = 1;
        }
    }

    private synchronized void createCtxPool() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Create Ldap context pools.");
        }
        String ldapUrl = null;
        Enumeration elem = ldapServers.elements();
        while (elem.hasMoreElements()) {
            ldapUrl = (String)elem.nextElement();
            LdapConfig tmpLdapConfig = new LdapConfig(baseLdapConfig);
            tmpLdapConfig.put("java.naming.provider.url", ldapUrl);
            InitialDirContext ctx = null;
            try {
                ctx = new InitialDirContext(tmpLdapConfig);
                contextTable.put(ldapUrl, ctx);
                ldapStatusTable.put(ldapUrl, "0");
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "create context for ", ldapUrl);
            }
            catch (NamingException ne) {
                ldapStatusTable.put(ldapUrl, "-1");
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "can not create context for ", ldapUrl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create Ldap context pools.");
        }
    }

    public String getLdapServer() {
        if (!this.isLdapOnLine()) {
            this.recoverLdapService();
            selectionCursor = 0;
        }
        if (!this.isLdapOnLine()) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "can not connect to any Ldap server.");
            }
            return null;
        }
        if (ldapServers.size() == 1) {
            return (String)ldapServers.firstElement();
        }
        String ldapUrl = null;
        switch (loadBalancePolicy) {
            case 1: {
                ldapUrl = this.RoundRobinWithRotation();
                break;
            }
            case 2: {
                ldapUrl = this.WeightedRoundRobinWithRotation();
                break;
            }
            case 3: {
                ldapUrl = this.RandomSchedule();
                break;
            }
            case 4: {
                ldapUrl = this.WeightedRandomSchedule();
                break;
            }
            case 5: {
                ldapUrl = this.FailOverWithPrefer();
                break;
            }
            default: {
                ldapUrl = this.RoundRobinWithRotation();
            }
        }
        String ldapStatus = (String)ldapStatusTable.get(ldapUrl);
        if (ldapStatus.equals("0")) {
            ldapStatusTable.put(ldapUrl, "1");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The target Ldap server is ", ldapUrl);
        }
        return ldapUrl;
    }

    private boolean isLdapOnLine() {
        String ldapUrl = null;
        int index = 0;
        for (index = 0; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            String ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            if (ldapStatus.equals("-1")) continue;
            return true;
        }
        return false;
    }

    private int getTotalLdapOnLine() {
        String ldapUrl = null;
        int index = 0;
        int iActive = 0;
        for (index = 0; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            String ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            if (ldapStatus.equals("-1")) continue;
            ++iActive;
        }
        return iActive;
    }

    private synchronized String RoundRobinWithRotation() {
        String ldapStatus;
        String ldapUrl = null;
        int index = selectionCursor;
        boolean foundLdap = false;
        for (index = selectionCursor; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            if (ldapStatus.equals("-1")) continue;
            selectionCursor = index + 1;
            if (selectionCursor == ldapServers.size()) {
                selectionCursor = 0;
            }
            foundLdap = true;
            break;
        }
        if (!foundLdap) {
            for (index = 0; index < selectionCursor; ++index) {
                ldapUrl = (String)ldapServers.elementAt(index);
                ldapStatus = (String)ldapStatusTable.get(ldapUrl);
                if (ldapStatus.equals("-1")) continue;
                selectionCursor = index + 1;
                break;
            }
        }
        return ldapUrl;
    }

    private synchronized String WeightedRoundRobinWithRotation() {
        String loadLimit;
        String ldapStatus;
        String ldapUrl = null;
        int index = 0;
        boolean foundLdap = false;
        boolean resetCount = true;
        for (index = 0; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            loadLimit = (String)ldapLoads.elementAt(index);
            if (!ldapStatus.equals("-1") && !ldapStatus.equals(loadLimit)) {
                resetCount = false;
            }
            if (!resetCount) break;
        }
        if (resetCount) {
            for (index = 0; index < ldapServers.size(); ++index) {
                ldapUrl = (String)ldapServers.elementAt(index);
                ldapStatus = (String)ldapStatusTable.get(ldapUrl);
                if (ldapStatus.equals("-1")) continue;
                ldapStatusTable.put(ldapUrl, "0");
            }
            selectionCursor = 0;
        }
        index = selectionCursor;
        for (index = selectionCursor; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            loadLimit = (String)ldapLoads.elementAt(index);
            if (ldapStatus.equals("-1") || ldapStatus.equals(loadLimit)) continue;
            selectionCursor = index + 1;
            if (selectionCursor == ldapServers.size()) {
                selectionCursor = 0;
            }
            foundLdap = true;
            break;
        }
        if (!foundLdap) {
            for (index = 0; index < selectionCursor; ++index) {
                ldapUrl = (String)ldapServers.elementAt(index);
                ldapStatus = (String)ldapStatusTable.get(ldapUrl);
                loadLimit = (String)ldapLoads.elementAt(index);
                if (ldapStatus.equals("-1") || ldapStatus.equals(loadLimit)) continue;
                selectionCursor = index + 1;
                break;
            }
        }
        ldapStatus = (String)ldapStatusTable.get(ldapUrl);
        Integer IStatus2 = new Integer(ldapStatus);
        int iStatus = IStatus2 + 1;
        IStatus2 = new Integer(iStatus);
        ldapStatusTable.put(ldapUrl, IStatus2.toString());
        return ldapUrl;
    }

    private String RandomSchedule() {
        String ldapStatus;
        String ldapUrl = null;
        int index = 0;
        int numLdap = 0;
        for (index = 0; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            if (ldapStatus.equals("-1")) continue;
            ++numLdap;
        }
        Random random = new Random();
        int num = random.nextInt(numLdap);
        numLdap = 0;
        for (index = 0; index < ldapServers.size() && ((ldapStatus = (String)ldapStatusTable.get(ldapUrl = (String)ldapServers.elementAt(index))).equals("-1") || ++numLdap != num); ++index) {
        }
        return ldapUrl;
    }

    private String WeightedRandomSchedule() {
        Integer ILoad;
        String ldapStatus;
        String ldapUrl = null;
        int index = 0;
        int iLoad = 0;
        for (index = 0; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            if (ldapStatus.equals("-1")) continue;
            ILoad = new Integer((String)ldapLoads.elementAt(index));
            iLoad += ILoad.intValue();
        }
        String sLoad = new Integer(iLoad).toString();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "total loads = : ", sLoad);
        }
        Random random = new Random();
        int num = random.nextInt(iLoad);
        iLoad = 0;
        for (index = 0; index < ldapServers.size() && ((ldapStatus = (String)ldapStatusTable.get(ldapUrl = (String)ldapServers.elementAt(index))).equals("-1") || num >= (iLoad += (ILoad = new Integer((String)ldapLoads.elementAt(index))).intValue())); ++index) {
        }
        return ldapUrl;
    }

    private String FailOverWithPrefer() {
        String ldapUrl = null;
        int index = 0;
        ldapUrl = (String)ldapServers.elementAt(index);
        String ldapStatus = (String)ldapStatusTable.get(ldapUrl);
        if (!ldapStatus.equals("-1")) {
            return ldapUrl;
        }
        ldapUrl = this.RoundRobinWithRotation();
        return ldapUrl;
    }

    public InitialDirContext getLdapContext(String ldapUrl) throws NamingException {
        InitialDirContext ctx = (InitialDirContext)contextTable.get(ldapUrl);
        return ctx;
    }

    public void removeCtx(String ldapUrl, InitialDirContext ctx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close context of ", ldapUrl);
        }
        try {
            ldapStatusTable.put(ldapUrl, "-1");
            contextTable.remove(ldapUrl);
            ctx.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close context of ", ldapUrl);
        }
    }

    private synchronized void recoverLdapService() {
        String ldapUrl = null;
        int index = 0;
        for (index = 0; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            String ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            if (!ldapStatus.equals("-1")) continue;
            LdapConfig ldapcfg = baseLdapConfig;
            ldapcfg.put("java.naming.provider.url", ldapUrl);
            InitialDirContext ctx = null;
            try {
                ctx = new InitialDirContext(ldapcfg);
                contextTable.put(ldapUrl, ctx);
                ldapStatusTable.put(ldapUrl, "0");
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Reconnect to Ldap server: ", ldapUrl);
                continue;
            }
            catch (NamingException ne) {
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Fail to reconnect to Ldap server: ", ldapUrl);
            }
        }
    }

    public void pingLdap() {
        String ldapUrl = null;
        int index = 0;
        for (index = 0; index < ldapServers.size(); ++index) {
            ldapUrl = (String)ldapServers.elementAt(index);
            String ldapStatus = (String)ldapStatusTable.get(ldapUrl);
            if (ldapStatus.equals("0")) {
                InitialDirContext dirCtx = (InitialDirContext)contextTable.get(ldapUrl);
                try {
                    String[] att = new String[]{"port"};
                    Attributes atb = dirCtx.getAttributes(ldapUrl, att);
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Ldap server is functional: ", ldapUrl);
                }
                catch (NamingException ne) {
                    this.removeCtx(ldapUrl, dirCtx);
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Ldap server is unavailable: ", ldapUrl);
                }
                continue;
            }
            if (ldapStatus.equals("-1")) continue;
            ldapStatusTable.put(ldapUrl, "0");
        }
    }

    private void updateLdapAccessTime(String ldapUrl) {
        long accessTime = new Date().getTime();
        Long Lacc = new Long(accessTime);
        String Sacc = Lacc.toString();
        ldapStatusTable.put(ldapUrl, Sacc);
    }

    static {
        innerTc = Tr.register(LdapServiceMonitor.class.getName(), null, "com.ibm.ejs.resources.security");
    }

    private final class LdapServiceMonitor
    extends Thread {
        private LdapServiceMonitor() {
        }

        public void run() {
            Tr.entry(innerTc, "run");
            try {
                while (true) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(innerTc, "Ldap service Thread going to sleep...");
                    }
                    try {
                        ldapServiceThread;
                        Thread.sleep(maintainWindowTime);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug(innerTc, "Ldap service Thread is waking up and dispatching...");
                    }
                    LdapLoadBalanceImpl.this.pingLdap();
                    LdapLoadBalanceImpl.this.recoverLdapService();
                }
            }
            catch (Exception e) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(innerTc, "run");
                }
                return;
            }
        }
    }
}

