/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.ldap.LdapConfig;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class IdMap {
    public static final String USERIDMAP = "user.idmap";
    public static final String GROUPIDMAP = "group.idmap";
    public static final String GROUPMEMBERIDMAP = "groupmember.idmap";
    private static IdEntry[] defaultIds = new IdEntry[]{new IdEntry("*", "cn")};
    private static IdEntry[] defaultMemberIds = new IdEntry[0];
    private IdEntry[] userIds = null;
    private IdEntry[] groupIds = null;
    private IdEntry[] groupMemberIds = null;
    private String[] attrs = null;

    public IdMap(LdapConfig ldapConfig) {
        this.userIds = this.parseIdMap(ldapConfig.getProperty(USERIDMAP), defaultIds);
        this.groupIds = this.parseIdMap(ldapConfig.getProperty(GROUPIDMAP), defaultIds);
        this.groupMemberIds = this.parseIdMap(ldapConfig.getProperty(GROUPMEMBERIDMAP), defaultMemberIds);
        Vector<String> v = new Vector<String>();
        v.addElement("objectclass");
        this.addAttributes(v, this.userIds);
        this.addAttributes(v, this.groupIds);
        this.attrs = new String[v.size()];
        v.copyInto(this.attrs);
    }

    public String getUserName(Attributes attrs) {
        return this.getName(this.userIds, attrs);
    }

    public String getGroupName(Attributes attrs) {
        return this.getName(this.groupIds, attrs);
    }

    public IdEntry[] getGroupMembers() {
        return this.groupMemberIds;
    }

    private String getName(IdEntry[] ids, Attributes attrs) {
        String retName = null;
        Attribute objClasses = attrs.get("objectclass");
        if (objClasses != null) {
            int bestMatch = Integer.MAX_VALUE;
            try {
                NamingEnumeration<?> ne = objClasses.getAll();
                while (ne.hasMoreElements()) {
                    String objClass = (String)ne.nextElement();
                    for (int i = 0; i < ids.length; ++i) {
                        Attribute attr;
                        if (!ids[i].equals(objClass) || i >= bestMatch || (attr = attrs.get(ids[i].getAttributeName())) == null) continue;
                        bestMatch = i;
                        retName = (String)attr.get();
                    }
                }
            }
            catch (NamingException ne) {
                FFDCFilter.processException((Throwable)ne, "com.ibm.ws.security.registry.ldap.IdMap.getName", "96", this);
            }
        }
        return retName;
    }

    public String[] getAttributes() {
        return this.attrs;
    }

    private IdEntry[] parseIdMap(String idmap, IdEntry[] defaults) {
        Vector<IdEntry> v = new Vector<IdEntry>();
        if (idmap != null) {
            StringTokenizer st = new StringTokenizer(idmap, ";");
            while (st.hasMoreTokens()) {
                String piece = st.nextToken();
                int idx = piece.indexOf(58);
                if (idx == -1) continue;
                String attr = piece.substring(idx + 1).trim();
                StringTokenizer objs = new StringTokenizer(piece.substring(0, idx), ",");
                while (objs.hasMoreTokens()) {
                    String objclass = objs.nextToken().trim();
                    v.addElement(new IdEntry(objclass, attr));
                }
            }
        }
        if (v.size() > 0) {
            Object[] ids = new IdEntry[v.size()];
            v.copyInto(ids);
            return ids;
        }
        return defaults;
    }

    private void addAttributes(Vector result, IdEntry[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            String attr = ids[i].getAttributeName();
            if (result.contains(attr)) continue;
            result.addElement(attr);
        }
    }

    public static class IdEntry {
        private static final String wildCard = new String("*");
        String objClassName;
        String attrName;

        public IdEntry(String objClassName, String attrName) {
            this.objClassName = wildCard.equals(objClassName) ? wildCard : objClassName.toLowerCase();
            this.attrName = attrName.toLowerCase();
        }

        public String getObjectClassName() {
            return this.objClassName;
        }

        public String getAttributeName() {
            return this.attrName;
        }

        public boolean equals(Object o) {
            return this.objClassName.equalsIgnoreCase(o.toString()) || this.objClassName == wildCard;
        }
    }
}

