/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.provider.AllPolicyConfigs;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;

public class WSPolicyConfigurationImpl
implements PolicyConfiguration {
    private static TraceComponent tc = Tr.register(WSPolicyConfigurationImpl.class, null, "com.ibm.ejs.resources.security");
    String contextID = null;
    ArrayList excludedList = null;
    ArrayList uncheckedList = null;
    HashMap roleToPermMap = new HashMap();
    int state = 0;

    public WSPolicyConfigurationImpl(String s) throws PolicyContextException {
        this.contextID = s;
    }

    public String getContextID() throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextID");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextID", this.contextID);
        }
        return this.contextID;
    }

    public void addToRole(String s, PermissionCollection permissioncollection) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToRole ", new Object[]{s, permissioncollection});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToRole called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (permissioncollection != null) {
            ArrayList permList = (ArrayList)this.roleToPermMap.get(s);
            if (permList == null) {
                ArrayList<Permission> newPermList = new ArrayList<Permission>();
                Enumeration<Permission> e = permissioncollection.elements();
                while (e.hasMoreElements()) {
                    newPermList.add(e.nextElement());
                }
                this.roleToPermMap.put(s, newPermList);
            } else {
                Enumeration<Permission> e = permissioncollection.elements();
                while (e.hasMoreElements()) {
                    permList.add(e.nextElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToRole ");
        }
    }

    public void addToRole(String s, Permission permission) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToRole.", new Object[]{s, permission});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToRole called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (permission != null) {
            ArrayList permList = (ArrayList)this.roleToPermMap.get(s);
            if (permList == null) {
                ArrayList<Permission> newPermList = new ArrayList<Permission>();
                newPermList.add(permission);
                this.roleToPermMap.put(s, newPermList);
            } else {
                permList.add(permission);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToRole.", permission);
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissioncollection) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToUncheckedPolicy", new Object[]{permissioncollection});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToUncheckedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.uncheckedList == null && permissioncollection != null) {
            this.uncheckedList = new ArrayList();
        }
        if (permissioncollection != null) {
            Enumeration<Permission> e = permissioncollection.elements();
            while (e.hasMoreElements()) {
                this.uncheckedList.add(e.nextElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToUncheckedPolicy");
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToUncheckedPolicy.", new Object[]{permission});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToUncheckedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.uncheckedList == null && permission != null) {
            this.uncheckedList = new ArrayList();
        }
        if (permission != null) {
            this.uncheckedList.add(permission);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToUncheckedPolicy.");
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissioncollection) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToExcludedPolicy", new Object[]{permissioncollection});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToExcludedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.excludedList == null && permissioncollection != null) {
            this.excludedList = new ArrayList();
        }
        if (permissioncollection != null) {
            Enumeration<Permission> e = permissioncollection.elements();
            while (e.hasMoreElements()) {
                this.excludedList.add(e.nextElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToExcludedPolicy");
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToExcludedPolicy.", new Object[]{permission});
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToExcludedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.excludedList == null && permission != null) {
            this.excludedList = new ArrayList();
        }
        if (permission != null) {
            this.excludedList.add(permission);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToExcludedPolicy.");
        }
    }

    public void removeRole(String s) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRole ", s);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("removeRole called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRole");
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeUncheckedPolicy");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("removeUncheckedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeUncheckedPolicy");
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeExcludedPolicy");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("removeExcludedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeExcludedPolicy");
        }
    }

    public void linkConfiguration(PolicyConfiguration policyconfiguration) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "linkConfiguration", policyconfiguration);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("linkConfiguration called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "linkConfiguration");
        }
    }

    public void delete() throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delete");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        this.state = 2;
        AllPolicyConfigs.getInstance().remove(this.contextID);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", String.valueOf(this.state));
        }
    }

    public void commit() throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state == 2) {
            throw new UnsupportedOperationException("commit called when the PolicyConfiguration is in the delete state");
        }
        this.state = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit", String.valueOf(this.state));
        }
    }

    public boolean inService() throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inService");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inService", String.valueOf(this.state));
        }
        return this.state == 1;
    }

    public void setState(int newState) throws PolicyContextException {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setState", String.valueOf(newState));
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (newState != 0) {
            throw new PolicyContextException("The PolicyConfiguration state can only be set to open(0)");
        }
        this.state = newState;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setState");
        }
    }

    public ArrayList getExcludedList() {
        return this.excludedList;
    }

    public ArrayList getUncheckedList() {
        return this.uncheckedList;
    }

    public HashMap getRoleToPermMap() {
        return this.roleToPermMap;
    }
}

