/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.provider.WSPolicyConfigurationImpl;
import java.util.Hashtable;

public class AllPolicyConfigs {
    private static TraceComponent tc = Tr.register(AllPolicyConfigs.class, null, "com.ibm.ejs.resources.security");
    private static AllPolicyConfigs policyConfig;
    private static boolean initialized;
    private Hashtable policyConfigTable = new Hashtable();

    public static AllPolicyConfigs getInstance() {
        if (!initialized) {
            policyConfig = new AllPolicyConfigs();
            initialized = true;
        }
        return policyConfig;
    }

    private AllPolicyConfigs() {
    }

    public void setPolicyConfig(String contextId, WSPolicyConfigurationImpl policyConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPolicyConfig", contextId);
        }
        this.policyConfigTable.put(contextId, policyConfig);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPolicyConfig", contextId);
        }
    }

    public WSPolicyConfigurationImpl getPolicyConfig(String contextId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyConfig", contextId);
        }
        WSPolicyConfigurationImpl wsPolicyConfig = (WSPolicyConfigurationImpl)this.policyConfigTable.get(contextId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyConfig", contextId);
        }
        return wsPolicyConfig;
    }

    public void remove(String contextId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", contextId);
        }
        if (this.policyConfigTable.containsKey(contextId)) {
            this.policyConfigTable.remove(contextId);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Removed contextId:" + contextId + " from the policyConfigTable");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove", contextId);
        }
    }

    static {
        initialized = false;
    }
}

