/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.profiletask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ApplyProfileSecuritySettings
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ApplyProfileSecuritySettings.class, "ApplyProfileSecuritySettings", "com.ibm.ws.security.profiletask");
    String enableAdmin = null;
    Boolean enableAdminSec = new Boolean(false);
    String adminUser = null;
    String adminPwd = null;
    static final String wimUR = "WIMUserRegistry";

    public ApplyProfileSecuritySettings(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ApplyProfileSecuritySettings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        this.enableAdmin = (String)this.getParameter("enableAdmin");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableAdmin = " + this.enableAdmin);
        }
        if (this.enableAdmin.equalsIgnoreCase("true")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableAdminSec = true");
            }
            this.enableAdminSec = new Boolean(true);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enableAdminSec = false");
            }
            this.enableAdminSec = new Boolean(false);
        }
        if (this.enableAdmin.equalsIgnoreCase("true")) {
            this.adminUser = (String)this.getParameter("adminUser");
            this.adminPwd = (String)this.getParameter("adminPwd");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enableAdmin: " + this.enableAdminSec.toString());
            if (this.adminUser != null && this.adminPwd != null) {
                Tr.debug(tc, "adminUser: " + this.adminUser);
                Tr.debug(tc, "adminPwd: " + this.adminPwd);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void afterStepsExecuted() {
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        Object ipcFactory = null;
        Object propertiesFactory = null;
        Boolean booleanFalse = new Boolean(false);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            block28: {
                CommandResult cmdResult;
                AdminCommand getUserCmd;
                CommandMgr commandMgr;
                Session s;
                block32: {
                    block31: {
                        String userRegistryType;
                        block30: {
                            block29: {
                                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Security");
                                ConfigService cs = ConfigServiceFactory.getConfigService();
                                s = this.getConfigSession();
                                ObjectName cellName = cs.resolve(s, "Cell=")[0];
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "cell = " + cellName.toString());
                                }
                                if (cellName != null) {
                                    security2 = cs.queryConfigObjects(s, cellName, pattern, null)[0];
                                }
                                AttributeList attrListEnable = new AttributeList();
                                attrListEnable.add(new Attribute("enabled", this.enableAdminSec));
                                cs.setAttributes(s, security2, attrListEnable);
                                if (!this.enableAdminSec.booleanValue()) break block28;
                                AttributeList attrList = new AttributeList();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "enableAdminSec = true, setting application security to false");
                                }
                                attrList.add(new Attribute("appEnabled", booleanFalse));
                                ArrayList urs = (ArrayList)cs.getAttribute(s, security2, "userRegistries");
                                for (int i = 0; i < urs.size(); ++i) {
                                    AttributeList urAttrs = (AttributeList)urs.get(i);
                                    Object urObj = ConfigServiceHelper.getAttributeValue(urAttrs, "_Websphere_Config_Data_Type");
                                    if (!urObj.toString().equals(wimUR)) continue;
                                    ObjectName[] matches = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(urAttrs), null);
                                    attrList.add(new Attribute("activeUserRegistry", matches[0]));
                                }
                                cs.setAttributes(s, security2, attrList);
                                ObjectName activeUserRegistry = (ObjectName)cs.getAttribute(s, security2, "activeUserRegistry");
                                AttributeList realmAttrs = new AttributeList();
                                realmAttrs.add(new Attribute("realm", "defaultWIMFileBasedRealm"));
                                cs.setAttributes(s, activeUserRegistry, realmAttrs);
                                userRegistryType = wimUR;
                                commandMgr = CommandMgr.getCommandMgr();
                                getUserCmd = commandMgr.createCommand("addAdminIdToUserRegObj");
                                getUserCmd.setConfigSession(s);
                                getUserCmd.setParameter("adminUser", this.adminUser);
                                getUserCmd.setParameter("registryType", userRegistryType);
                                getUserCmd.execute();
                                cmdResult = getUserCmd.getCommandResult();
                                if (!cmdResult.isSuccessful()) break block29;
                                if (((Boolean)cmdResult.getResult()).booleanValue()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Successfully set adminId in user registry object");
                                    }
                                    break block30;
                                } else {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Could not successfully set adminId in user registry object");
                                    }
                                    String msg = this.getMsg(resBundle, "security.profiletask.FailedAddAdminId", null);
                                    result.addWarnings(msg);
                                    result.setResult(new Boolean(false));
                                    return;
                                }
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Could not successfully set adminId in user registry object");
                            }
                            String msg = this.getMsg(resBundle, "security.profiletask.FailedAddAdminId", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            return;
                        }
                        commandMgr = CommandMgr.getCommandMgr();
                        getUserCmd = commandMgr.createCommand("setUseRegistryServerId");
                        getUserCmd.setConfigSession(s);
                        getUserCmd.setParameter("userRegistryType", userRegistryType);
                        getUserCmd.setParameter("useRegistryServerId", new Boolean(false));
                        getUserCmd.execute();
                        cmdResult = getUserCmd.getCommandResult();
                        if (!cmdResult.isSuccessful()) break block31;
                        if (((Boolean)cmdResult.getResult()).booleanValue()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Successfully set useRegistryServerId to false");
                            }
                            break block32;
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Could not successfully set useRegistryServerId to false");
                            }
                            String msg = this.getMsg(resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            return;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not successfully set useRegistryServerId to false");
                    }
                    String msg = this.getMsg(resBundle, "security.admintask.ExceptionUseRegistryServerId", null);
                    result.addWarnings(msg);
                    result.setResult(new Boolean(false));
                    return;
                }
                if (this.adminUser != null && this.adminUser.length() != 0 && this.adminPwd != null && this.adminPwd.length() != 0) {
                    try {
                        commandMgr = CommandMgr.getCommandMgr();
                        getUserCmd = commandMgr.createCommand("addFileRegistryAccount");
                        getUserCmd.setConfigSession(s);
                        getUserCmd.setParameter("userId", this.adminUser);
                        getUserCmd.setParameter("password", this.adminPwd);
                        getUserCmd.execute();
                        cmdResult = getUserCmd.getCommandResult();
                        if (cmdResult.isSuccessful()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " added to WIM UR");
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " not added toWIM UR");
                            }
                            String msg = this.getMsg(resBundle, "security.profiletask.failAddingAdminToWim", null);
                            result.addWarnings(msg);
                            result.setResult(new Boolean(false));
                            return;
                        }
                        result.setResult(new Boolean(true));
                    }
                    catch (Exception e) {
                        result.setResult(new Boolean(false));
                        String msg = this.getMsg(resBundle, "security.profiletask.failAddingAdminToWim", null);
                        result.setException(new CommandException(e, msg));
                        return;
                    }
                }
            }
            result.setResult(new Boolean(true));
        }
        catch (Throwable th) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, th.toString());
                Tr.debug(tc, th.getMessage());
            }
            String msg = this.getMsg(resBundle, "security.profiletask.failAddingAdminToWim", null);
            result.addWarnings(msg);
            result.setResult(new Boolean(false));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

