/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.policy.ApplicationParserTr;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.FilePathUtil;
import com.ibm.ws.security.policy.FilterParser;
import com.ibm.ws.security.policy.FilterParserTr;
import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.policy.SystemExtensionParserTr;
import com.ibm.ws.security.util.ParserException;
import java.io.File;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.ResourceAdapter;
import org.eclipse.jst.j2ee.jca.SecurityPermission;

public final class WSDynamicPolicy
extends Policy
implements DynamicPolicy {
    private Policy policy;
    private boolean expandProp;
    private List codeSourceList;
    private Map csPermsHashMap;
    private Map templates;
    private ArrayList staticFilterPermissions;
    private ArrayList runtimeFilterPermissions;
    private String cellDir;
    private String nodeDir;
    private String nodeName;
    private String cellName;
    private String srvrName;
    private final boolean debug;
    private static boolean wccmWarningFlag = true;
    private static final String WAS_POLICY = "/META-INF/was.policy";
    private static final PrivilegedAction getUserDirAction = new PrivilegedAction(){

        public Object run() {
            String str = System.getProperty("user.dir");
            return str == null ? "" : str;
        }
    };
    private File file;
    private String newPath;
    private boolean endsWithMinus;
    private boolean endsWithStar;
    private ProtectionDomain self;
    private static final String MINUS_TRAIL = File.separator + "-";
    private static final String STAR_TRAIL = File.separator + "*";
    private static final TraceComponent tc = Tr.register(WSDynamicPolicy.class, null, "com.ibm.ejs.resources.security");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSDynamicPolicy(Policy policy, Repository rep) throws IOException, ParserException {
        block11: {
            this.expandProp = true;
            this.codeSourceList = new ArrayList(256);
            this.csPermsHashMap = new WeakHashMap(256);
            this.templates = new HashMap(5);
            this.staticFilterPermissions = new ArrayList();
            this.runtimeFilterPermissions = new ArrayList();
            this.debug = Boolean.getBoolean("com.ibm.ws.security.policy.DynamicPolicy.debug");
            this.endsWithMinus = false;
            this.endsWithStar = false;
            this.self = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSDynamicPolicy(" + policy + ", " + rep + ")");
            }
            final WSDynamicPolicy p = this;
            this.self = (ProtectionDomain)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return p.getClass().getProtectionDomain();
                }
            });
            String file = null;
            InputStreamReader fr = null;
            try {
                try {
                    file = System.getProperty("java.security.policy");
                    if (file.charAt(0) == '=') {
                        file = file.substring(1);
                    }
                    fr = new FileReader(file);
                    ApplicationParserTr parser2 = new ApplicationParserTr(fr, true);
                    parser2.parse();
                    if (tc.isDebugEnabled()) {
                        StringBuffer buf = new StringBuffer("Contents of ");
                        buf.append(file).append(": ").append(Parser.NEW_LINE);
                        Iterator it = parser2.grants.iterator();
                        while (it.hasNext()) {
                            buf.append(Parser.NEW_LINE);
                            buf.append(it.next().toString());
                        }
                        Tr.debug(tc, buf.toString());
                    }
                }
                catch (ParserException e) {
                    Tr.error(tc, "security.policy.parser.syntax.error", new Object[]{file, e});
                    throw e;
                }
                Object var10_10 = null;
                if (fr == null) break block11;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (fr != null) {
                    fr.close();
                }
                throw throwable;
            }
            fr.close();
        }
        this.policy = policy;
        this.cellName = rep.getCellName();
        this.cellDir = rep.getRootURI() + File.separator + "cells" + File.separator + this.cellName;
        this.nodeName = rep.getNodeName();
        this.srvrName = rep.getServerName();
        this.nodeDir = this.cellDir + File.separator + "nodes" + File.separator + this.nodeName;
        this.cellDir = this.cellDir.replace('/', File.separatorChar);
        this.nodeDir = this.nodeDir.replace('/', File.separatorChar);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cellDir = " + this.cellDir);
            Tr.debug(tc, "nodeDir = " + this.nodeDir);
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSDynamicPolicy()");
        }
    }

    public final PermissionCollection getPermissions(CodeSource codeSource) {
        CodeSource newCodeSource;
        if (codeSource != null && (newCodeSource = this.canonicalized(codeSource)) != null) {
            codeSource = newCodeSource;
        }
        return this.getPermissions_s(codeSource);
    }

    public final ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        CodeSource newCodeSource;
        ProtectionDomain pd = null;
        if (codeSource != null && (newCodeSource = this.canonicalized(codeSource)) != null) {
            pd = new ProtectionDomain(newCodeSource, this.getPermissions_s(newCodeSource));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created protection domain:  " + pd);
            }
        }
        return pd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPermissions_s(CodeSource codeSource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions_s", codeSource);
        }
        PermissionCollection permCollection = this.policy.getPermissions(codeSource);
        if (codeSource != null) {
            WSDynamicPolicy wSDynamicPolicy = this;
            synchronized (wSDynamicPolicy) {
                int maxNumCSources = this.codeSourceList.size();
                for (int i = 0; i < maxNumCSources; ++i) {
                    CodeSource cs = (CodeSource)this.codeSourceList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cs(" + i + ") = " + cs);
                    }
                    if (!cs.implies(codeSource)) continue;
                    ArrayList permissions = (ArrayList)this.csPermsHashMap.get(cs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getting for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
                    }
                    int maxNum = permissions.size();
                    for (int j = 0; j < maxNum; ++j) {
                        permCollection.add((Permission)permissions.get(j));
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, cs + " implies " + codeSource + ", permissions added " + permissions);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Effective Policy for " + codeSource + " = " + permCollection);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions_s");
        }
        return permCollection;
    }

    public final PermissionCollection getPermissions(CodeSource codeSource, Map csPerms) {
        CodeSource newCodeSource;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions", new Object[]{codeSource, csPerms});
        }
        if (codeSource != null && (newCodeSource = this.canonicalized(codeSource)) != null) {
            codeSource = newCodeSource;
        }
        PermissionCollection permCollection = this.getPermissions_s(codeSource);
        if (codeSource != null) {
            Set cslist = csPerms.keySet();
            for (CodeSource cs : cslist) {
                if (!cs.implies(codeSource)) continue;
                ArrayList permissions = (ArrayList)csPerms.get(cs);
                int maxNum = permissions.size();
                for (int j = 0; j < maxNum; ++j) {
                    permCollection.add((Permission)permissions.get(j));
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, cs + " implies " + codeSource + ", permissions added " + permissions);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Effective Policy(Application and library) for " + codeSource + " = " + permCollection);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions(Map, CodeSource)");
        }
        return permCollection;
    }

    public final void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh()");
        }
        this.policy.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh()");
        }
    }

    public final void getSecurityPolicy(Map map, Map csPerms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityPolicy", new Object[]{map, csPerms});
        }
        String type = null;
        try {
            type = (String)map.get("type");
        }
        catch (Exception e) {
            Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{e, "type"});
            return;
        }
        if (type.equals("library")) {
            ArrayList permissionEntries;
            WSPolicyTemplate polTemplate = null;
            try {
                polTemplate = (WSPolicyTemplate)this.templates.get(type);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "templete for library.policy -> " + polTemplate);
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.sysext.param", new Object[]{e, type});
                return;
            }
            if (polTemplate != null && (permissionEntries = polTemplate.get("${default}")) != null) {
                ArrayList permissions = (ArrayList)permissionEntries.clone();
                String[] classpath = (String[])map.get("classpath");
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("classpath: [ ");
                    if (classpath == null) {
                        buf.append("<null>");
                    } else {
                        int ii = classpath.length;
                        for (int i = 0; i < ii; ++i) {
                            buf.append(classpath[i]).append(" ");
                        }
                    }
                    buf.append("]");
                    Tr.debug(tc, buf.toString());
                }
                if (classpath != null) {
                    int len = classpath.length;
                    for (int i = 0; i < len; ++i) {
                        this.updateCodeSourceRepository(classpath[i], permissions, csPerms);
                    }
                }
            }
        } else if (type.equals("application")) {
            DynamicPolicy.Application app;
            try {
                app = (DynamicPolicy.Application)map.get("application");
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{e, "deployedApp"});
                return;
            }
            if (app != null) {
                String base;
                WSPolicyTemplate wastmp;
                block59: {
                    wastmp = null;
                    base = app.getbinarypath();
                    String wasFileName = app.getpathToWasPolicy();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Load was.policy from " + wasFileName);
                    }
                    File wasFile = new File(wasFileName);
                    try {
                        if (wasFile.exists()) {
                            wastmp = this.loadWasPolicyTemplate(wasFile, wasFileName);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load was.policy because " + wasFile.getCanonicalPath() + " does not exist");
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block59;
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        Tr.debug(tc, "Caught an Exception while trying to load was policy file " + sw.toString());
                    }
                }
                WSPolicyTemplate apptmp = (WSPolicyTemplate)this.templates.get(type);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "template for app.policy -> " + apptmp);
                    Tr.debug(tc, "template for was.policy -> " + wastmp);
                }
                if (wastmp != null) {
                    wastmp.addAll(apptmp);
                } else if (apptmp != null) {
                    wastmp = new WSPolicyTemplate();
                    wastmp.addAll(apptmp);
                }
                String binaryURL = app.getbinarypath();
                if (wastmp != null) {
                    StringBuffer buf = new StringBuffer(binaryURL);
                    buf.append(File.separator).append("-");
                    CodeSource cs = this.createCodeSource(buf.toString());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, binaryURL + " --> " + cs);
                    }
                    this.expandAppTemplates(cs, wastmp, "${application}", null, base, null, csPerms);
                }
                DynamicPolicy.Module[] mdls = app.getmodules();
                int msize = mdls.length;
                for (int i = 0; i < msize; ++i) {
                    DynamicPolicy.Module mm = mdls[i];
                    if (mm == null) continue;
                    String mName = mm.getmoduleName();
                    String mtype = mm.gettype();
                    String[] mPaths = mm.getclasspaths();
                    if (tc.isDebugEnabled()) {
                        int nsize = mPaths.length;
                        if (nsize == 1) {
                            Tr.debug(tc, "module[" + i + "] : " + mName + " type:" + mtype + " path[] = " + mPaths[0]);
                        } else {
                            Tr.debug(tc, "module[" + i + "] : " + mName + " type:" + mtype);
                            for (int ii = 0; ii < nsize; ++ii) {
                                Tr.debug(tc, "                     path[ " + ii + "] = " + mPaths[ii]);
                            }
                        }
                    }
                    if (mtype.equals("RARFile")) {
                        WSPolicyTemplate ratmp = null;
                        ratmp = this.loadRAPolicyTemplate(mm);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "template for ra.xml -> " + ratmp);
                        }
                        if (wastmp != null) {
                            wastmp.addAll(ratmp);
                        } else if (ratmp != null) {
                            wastmp = ratmp;
                        }
                    }
                    CodeSource cs = null;
                    String mPath = null;
                    String wPath = base + File.separator + mName;
                    if (wastmp == null || mPaths == null) continue;
                    int psize = mPaths.length;
                    for (int j = 0; j < psize; ++j) {
                        String name = null;
                        mPath = mPaths[j];
                        try {
                            StringBuffer buf = new StringBuffer(mPath);
                            if (mtype.equals("web") || mtype.equals("connector")) {
                                buf.append(File.separator).append("-");
                            } else if (mtype.equals("ejb") || mtype.equals("RARFile")) {
                                int index = mPath.indexOf(".jar");
                                if (index == -1) {
                                    buf.append(File.separator).append("-");
                                } else if (index + 4 != mPath.length()) {
                                    buf.append(File.separator).append("-");
                                }
                            }
                            cs = this.createCodeSource(buf.toString());
                        }
                        catch (Exception ex) {
                            Tr.warning(tc, "security.policy.module.path", new Object[]{ex, mName});
                        }
                        if (mtype.equals("ejb")) {
                            this.expandAppTemplates(cs, wastmp, "${ejbcomponent}", mName, base, wPath, csPerms);
                            continue;
                        }
                        if (mtype.equals("web")) {
                            this.expandAppTemplates(cs, wastmp, "${webcomponent}", mName, base, wPath, csPerms);
                            continue;
                        }
                        if (mtype.equals("connector")) {
                            this.expandAppTemplates(cs, wastmp, "${connectorcomponent}", mName, base, wPath, csPerms);
                            continue;
                        }
                        if (mtype.equals("RARFile")) {
                            this.expandAppTemplates(cs, wastmp, "${default}", mName, base, wPath, csPerms);
                            this.expandAppTemplates(cs, wastmp, "${connectorcomponent}", mName, base, wPath, csPerms);
                            continue;
                        }
                        if (!mtype.equals("utility")) continue;
                        try {
                            int indx = mPath.lastIndexOf(File.separatorChar);
                            name = indx + 1 <= mPath.length() ? mPath.substring(indx + 1, mPath.length()) : null;
                            StringBuffer buf = new StringBuffer(mPath);
                            cs = this.createCodeSource(buf.toString());
                        }
                        catch (Exception ex) {
                            Tr.warning(tc, "security.policy.module.path", new Object[]{ex, mName});
                        }
                        this.expandAppTemplates(cs, wastmp, "${jars}", name, base, mPath, csPerms);
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Incorrect type" + type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityPolicy()");
        }
    }

    public final void setupPolicy(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupPolicy(" + map + ")");
        }
        String type = null;
        try {
            type = (String)map.get("type");
        }
        catch (Exception e) {
            Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{e, "type"});
            return;
        }
        if (type.equals("spi")) {
            ArrayList permissionEntries;
            WSPolicyTemplate polTemplate = null;
            try {
                polTemplate = (WSPolicyTemplate)this.templates.get(type);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Policy Template[" + type + "] = " + polTemplate);
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.sysext.param", new Object[]{e, type});
                return;
            }
            if (polTemplate != null && (permissionEntries = polTemplate.get("${default}")) != null) {
                ArrayList permissions = (ArrayList)permissionEntries.clone();
                String[] classpath = (String[])map.get("classpath");
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("classpath: [ ");
                    if (classpath == null) {
                        buf.append("<null>");
                    } else {
                        for (int i = 0; i < classpath.length; ++i) {
                            buf.append(classpath[i]).append(" ");
                        }
                    }
                    buf.append("]");
                    Tr.debug(tc, buf.toString());
                }
                if (classpath != null) {
                    for (String temp : classpath) {
                        if (temp == null || temp.length() == 0) continue;
                        this.updateCodeSourceRepository(temp, permissions, null);
                    }
                }
            }
        } else if (type.equals("ra")) {
            RARFile rarFile = null;
            try {
                rarFile = (RARFile)map.get("RARFile");
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{e, "RARFile"});
                return;
            }
            String rarPath = null;
            try {
                if (rarFile.getEARFile() == null) {
                    rarPath = rarFile.getAbsolutePath();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rarFile.getAbsolutePath()" + rarFile);
                    }
                } else {
                    rarPath = rarFile.getEARFile().getAbsolutePath() + File.separator + rarFile.getURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "earPath#rarPath" + rarPath);
                    }
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{e, "RARFile"});
                return;
            }
            CodeSource cs = null;
            try {
                StringBuffer tmpBuf = new StringBuffer(rarPath);
                tmpBuf.append(File.separator).append("-");
                cs = this.createCodeSource(tmpBuf.toString());
            }
            catch (Exception ex) {
                Tr.error(tc, "security.policy.rar.path", new Object[]{ex});
                return;
            }
            WSPolicyTemplate ratmp = null;
            ratmp = this.loadRAPolicyTemplate(rarFile);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Policy Template for ra.xml -> " + ratmp);
            }
            if (ratmp != null) {
                this.expandAppTemplates(cs, ratmp, "${default}", null, null, null, null);
            }
            WSPolicyTemplate apptmp = (WSPolicyTemplate)this.templates.get("application");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template for app.policy -> " + apptmp);
            }
            if (apptmp != null) {
                this.expandAppTemplates(cs, apptmp, "${connectorcomponent}", null, null, null, null);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Incorrect type" + type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupPolicy()");
        }
    }

    private void expandAppTemplates(CodeSource cs, WSPolicyTemplate ptmp, String ptype, String mName, String app, String was, Map csPerms) {
        ArrayList specific;
        ArrayList template;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandAppTemplates(" + cs + ", " + ptmp + ", " + ptype + ", " + mName + ", " + app + ", " + was + ", " + csPerms + ")");
        }
        if ((template = ptmp.get(ptype)) == null) {
            template = new ArrayList(10);
        }
        if (mName != null && (specific = ptmp.get(mName)) != null) {
            template.addAll(specific);
        }
        if (template != null && template.size() != 0) {
            if (app == null && was == null) {
                this.updateCodeSourceRepository(cs, template, csPerms);
            } else {
                this.updateCodeSourceRepository(cs, template, app, was, csPerms);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandAppTemplates(CodeSource, WSPolicyTemplate, String, String, String, String, Map)");
        }
    }

    public final void removePolicy(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removePolicy(" + map + ")");
        }
        String type = null;
        try {
            type = (String)map.get("type");
        }
        catch (Exception e) {
            Tr.error(tc, "security.policy.param.setupPolicy", new Object[]{e, "type"});
            return;
        }
        if (type.equals("spi")) {
            String[] classpath = (String[])map.get("classpath");
            if (classpath != null) {
                int len = classpath.length;
                for (int i = 0; i < len; ++i) {
                    try {
                        URL url = FilePathUtil.filePathToURL(new File(classpath[i]));
                        CodeSource newCSource = new CodeSource(url, (Certificate[])null);
                        this.removeCodeSource(newCSource);
                        continue;
                    }
                    catch (MalformedURLException e) {
                        Tr.warning(tc, "security.policy.malformedURL", new Object[]{e, classpath[i]});
                    }
                }
            }
        } else if (type.equals("ra")) {
            RARFile rarFile = null;
            try {
                rarFile = (RARFile)map.get("RARFile");
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{e, "RARFile"});
                return;
            }
            String rarPath = null;
            try {
                if (rarFile.getEARFile() == null) {
                    rarPath = rarFile.getAbsolutePath();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "rarFile.getAbsolutePath()" + rarFile);
                    }
                } else {
                    rarPath = rarFile.getEARFile().getAbsolutePath() + File.separator + rarFile.getURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "earPath#rarPath" + rarPath);
                    }
                }
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.rarfile", new Object[]{e, "RARFile"});
                return;
            }
            CodeSource cs = null;
            try {
                StringBuffer buf = new StringBuffer(rarPath);
                buf.append(File.separator).append("-");
                cs = this.createCodeSource(buf.toString());
            }
            catch (Exception ex) {
                Tr.warning(tc, "security.policy.removepolicy.rarpath", new Object[]{ex, rarFile.getName()});
            }
            this.removeCodeSource(cs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removePolicy()");
        }
    }

    public final PermissionCollection getPermissions(ProtectionDomain domain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions");
        }
        PermissionCollection pc = null;
        if (this.self == domain && this.self != null) {
            pc = new Permissions();
            pc.add(new AllPermission());
        } else {
            PermissionCollection p;
            pc = super.getPermissions(domain);
            if (this.policy != null && (p = this.policy.getPermissions(domain)) != null) {
                Enumeration<Permission> e = p.elements();
                while (e.hasMoreElements()) {
                    pc.add(e.nextElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions", pc);
        }
        return pc;
    }

    public final boolean implies(ProtectionDomain domain, Permission permission) {
        boolean result = false;
        if (this.self == domain && this.self != null) {
            result = true;
        } else {
            result = super.implies(domain, permission);
            if (!result && this.policy != null) {
                result = this.policy.implies(domain, permission);
            }
        }
        return result;
    }

    private void init() {
        block23: {
            block22: {
                block21: {
                    String filter;
                    String s;
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "init()");
                    }
                    if ((s = Security.getProperty("policy.expandProperties")) != null) {
                        this.expandProp = s.equalsIgnoreCase("true");
                    }
                    if ((filter = System.getProperty("ws.filter.policy")) == null || filter.length() == 0) {
                        filter = this.cellDir + File.separator + "filter.policy";
                    }
                    filter = filter.replace('/', File.separatorChar);
                    File filterFile = new File(filter);
                    try {
                        if (filterFile.exists()) {
                            this.setupPolicyFilterPermissions(filterFile);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Could not load default filter.policy file because " + filterFile.getCanonicalPath() + " does not exist");
                        }
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block21;
                        Tr.debug(tc, "Caught an Exception while trying to load filter policy");
                    }
                }
                String spi = System.getProperty("ws.spi.policy");
                if (spi == null || spi.length() == 0) {
                    spi = this.nodeDir + File.separator + "spi.policy";
                }
                spi = spi.replace('/', File.separatorChar);
                File spiFile = new File(spi);
                try {
                    if (spiFile.exists()) {
                        this.loadSystemExtensionPolicyTemplate("spi", spiFile);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not load spi.policy file because " + spiFile.getCanonicalPath() + " does not exist");
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "Caught an Exception while trying to load spi policy");
                }
            }
            String library = System.getProperty("ws.library.policy");
            if (library == null || library.length() == 0) {
                library = this.nodeDir + File.separator + "library.policy";
            }
            library = library.replace('/', File.separatorChar);
            File libraryFile = new File(library);
            try {
                if (libraryFile.exists()) {
                    this.loadSystemExtensionPolicyTemplate("library", libraryFile);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not load library.policy file because " + libraryFile.getCanonicalPath() + " does not exist");
                }
            }
            catch (Exception ioe) {
                if (!tc.isDebugEnabled()) break block23;
                Tr.debug(tc, "Caught an IOException while trying to load library policy");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public final void initApplicationTemplate(Boolean issuedWarningFlag) {
        block6: {
            wccmWarningFlag = issuedWarningFlag;
            String app = System.getProperty("ws.app.policy");
            if (app == null || app.length() == 0) {
                app = this.nodeDir + File.separator + "app.policy";
            }
            app = app.replace('/', File.separatorChar);
            File appFile = new File(app);
            try {
                if (appFile.exists()) {
                    this.loadApplicationPolicyTemplate(appFile, app);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not load app.policy because " + appFile.getCanonicalPath() + " does not exist");
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Caught an Exception while trying to load app policy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadSystemExtensionPolicyTemplate(String type, File file) {
        block18: {
            FileReader fr = null;
            fr = new FileReader(file);
            SystemExtensionParserTr parser2 = new SystemExtensionParserTr(fr, this.expandProp);
            parser2.parse();
            Iterator it = parser2.grantEntries();
            WSPolicyTemplate policyTemplate = new WSPolicyTemplate();
            while (it.hasNext()) {
                policyTemplate.add((Parser.GrantEntry)it.next());
            }
            this.templates.put(type, policyTemplate);
            Object var8_9 = null;
            try {
                if (fr != null) {
                    fr.close();
                }
                break block18;
            }
            catch (IOException ioe2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error closing FileReader for SysExtPolicyTemplate");
                }
                break block18;
            }
            {
                catch (IOException ioe) {
                    Tr.error(tc, "security.policy.sysext.ioexception", new Object[]{ioe, type});
                    Object var8_10 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block18;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for SysExtPolicyTemplate");
                        }
                        break block18;
                    }
                }
                catch (ParserException e) {
                    Tr.error(tc, "security.policy.sysext.parserexception", new Object[]{e, type});
                    Object var8_11 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block18;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for SysExtPolicyTemplate");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var8_12 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!tc.isDebugEnabled()) break block19;
                        Tr.debug(tc, "Error closing FileReader for SysExtPolicyTemplate");
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadApplicationPolicyTemplate(File file, String fname) {
        block26: {
            FileReader fr = null;
            fr = new FileReader(file);
            ApplicationParserTr parser2 = new ApplicationParserTr(fr, this.expandProp);
            parser2.parse();
            Iterator it = parser2.grantEntries();
            WSPolicyTemplate policyTemplate = new WSPolicyTemplate();
            while (it.hasNext()) {
                Parser.GrantEntry g = (Parser.GrantEntry)it.next();
                String symbol = g.codeBase;
                if (symbol == null || symbol.length() == 0) {
                    g.codeBase = "${application}";
                    symbol = "${application}";
                }
                if (parser2.isStandardSymbl(symbol)) {
                    policyTemplate.add(g);
                    continue;
                }
                try {
                    File f;
                    if (symbol.startsWith("file:")) {
                        symbol = symbol.substring(5, symbol.length());
                    }
                    if ((f = new File(symbol)).isAbsolute()) {
                        Iterator pit = g.getPermissions();
                        ArrayList<Permission> list = new ArrayList<Permission>();
                        while (pit.hasNext()) {
                            list.add(this.getPermissionInstance((Parser.PermissionEntry)pit.next()));
                        }
                        this.updateCodeSourceRepository(symbol, list, null);
                        continue;
                    }
                    policyTemplate.add(g);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unrecognized entry in the policy file" + symbol);
                    }
                    policyTemplate.add(g);
                }
            }
            this.filter(policyTemplate, fname);
            this.templates.put("application", policyTemplate);
            Object var15_15 = null;
            try {
                if (fr != null) {
                    fr.close();
                }
                break block26;
            }
            catch (IOException ioe2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error closing FileReader for App Policy");
                }
                break block26;
            }
            {
                catch (IOException ioe) {
                    Tr.error(tc, "security.policy.app.ioexception", new Object[]{fname, ioe});
                    Object var15_16 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block26;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for App Policy");
                        }
                        break block26;
                    }
                }
                catch (ParserException e) {
                    Tr.error(tc, "security.policy.app.parserexception", new Object[]{fname, e});
                    Object var15_17 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block26;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for App Policy");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block27: {
                    Object var15_18 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "Error closing FileReader for App Policy");
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private WSPolicyTemplate loadWasPolicyTemplate(File file, String fname) {
        WSPolicyTemplate policyTemplate;
        block18: {
            policyTemplate = new WSPolicyTemplate();
            FileReader fr = null;
            fr = new FileReader(file);
            ApplicationParserTr parser2 = new ApplicationParserTr(fr, this.expandProp);
            parser2.parse();
            Iterator it = parser2.grantEntries();
            while (it.hasNext()) {
                policyTemplate.add((Parser.GrantEntry)it.next());
            }
            this.filter(policyTemplate, fname);
            Object var10_9 = null;
            try {
                if (fr != null) {
                    fr.close();
                }
                break block18;
            }
            catch (IOException ioe2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error closing FileReader for WAS Policy");
                }
                break block18;
            }
            {
                catch (IOException ioe) {
                    Tr.error(tc, "security.policy.was.ioexception", new Object[]{fname, ioe});
                    Object var10_10 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block18;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for WAS Policy");
                        }
                        break block18;
                    }
                }
                catch (ParserException e) {
                    Tr.error(tc, "security.policy.was.parserexception", new Object[]{fname, e});
                    Object var10_11 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block18;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for WAS Policy");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var10_12 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!tc.isDebugEnabled()) break block19;
                        Tr.debug(tc, "Error closing FileReader for WAS Policy");
                    }
                }
                throw throwable;
            }
        }
        return policyTemplate;
    }

    private WSPolicyTemplate loadRAPolicyTemplate(RARFile rarFile) {
        Connector dd = rarFile.getDeploymentDescriptor();
        ResourceAdapter ra = dd.getResourceAdapter();
        EList permissions = ra.getSecurityPermissions();
        WSPolicyTemplate policyTemplate = this.loadRAPolicyTemplate(permissions, rarFile.getName());
        return policyTemplate;
    }

    private WSPolicyTemplate loadRAPolicyTemplate(DynamicPolicy.Module mm) {
        List permissions = mm.getpermissions();
        WSPolicyTemplate policyTemplate = this.loadRAPolicyTemplate(permissions, mm.getmoduleName());
        return policyTemplate;
    }

    private WSPolicyTemplate loadRAPolicyTemplate(List permissions, String mName) {
        WSPolicyTemplate policyTemplate = new WSPolicyTemplate();
        for (int i = 0; i < permissions.size(); ++i) {
            WSPolicyTemplate tmpTemplate = new WSPolicyTemplate();
            SecurityPermission pp = (SecurityPermission)permissions.get(i);
            String permSpec = pp.getSpecification();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ra[" + i + "]=" + permSpec);
            }
            try {
                SystemExtensionParserTr parser2 = new SystemExtensionParserTr(new StringReader(permSpec), this.expandProp);
                parser2.parse();
                Iterator it = parser2.grantEntries();
                while (it.hasNext()) {
                    policyTemplate.add((Parser.GrantEntry)it.next());
                }
                continue;
            }
            catch (IOException ioe) {
                Tr.error(tc, "security.policy.ratemplate.io", new Object[]{ioe, mName});
                continue;
            }
            catch (ParserException e) {
                Tr.error(tc, "security.policy.ratemplate.parser", new Object[]{mName, permSpec, e});
            }
        }
        return policyTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setupPolicyFilterPermissions(File file) {
        block21: {
            FilterParser.FilterEntry runtimeFilterEntry;
            FileReader fr = null;
            fr = new FileReader(file);
            FilterParserTr parser2 = new FilterParserTr(fr, true);
            parser2.parse();
            FilterParser.FilterEntry staticFilterEntry = parser2.getFilterEntry("filterMask");
            if (staticFilterEntry != null) {
                Iterator itr = staticFilterEntry.getPermissions();
                while (itr.hasNext()) {
                    Permission p = this.getPermissionInstance((Parser.PermissionEntry)itr.next());
                    this.staticFilterPermissions.add(p);
                }
            }
            if ((runtimeFilterEntry = parser2.getFilterEntry("runtimeFilterMask")) != null) {
                Iterator itr = runtimeFilterEntry.getPermissions();
                while (itr.hasNext()) {
                    Permission p = this.getPermissionInstance((Parser.PermissionEntry)itr.next());
                    this.runtimeFilterPermissions.add(p);
                }
            }
            Object var9_10 = null;
            try {
                if (fr != null) {
                    fr.close();
                }
                break block21;
            }
            catch (IOException ioe2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error closing FileReader for filter policy");
                }
                break block21;
            }
            {
                catch (IOException ioe) {
                    Tr.error(tc, "security.policy.filter.ioexception", new Object[]{ioe});
                    Object var9_11 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block21;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for filter policy");
                        }
                        break block21;
                    }
                }
                catch (ParserException e) {
                    Tr.error(tc, "security.policy.filter.parserexception", new Object[]{e});
                    Object var9_12 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                        break block21;
                    }
                    catch (IOException ioe2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Error closing FileReader for filter policy");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Object var9_13 = null;
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (IOException ioe2) {
                        if (!tc.isDebugEnabled()) break block22;
                        Tr.debug(tc, "Error closing FileReader for filter policy");
                    }
                }
                throw throwable;
            }
        }
    }

    private ArrayList performFiltering(ArrayList permissionsArray, String fname) {
        ArrayList<Permission> filteredPermissionsArray = new ArrayList<Permission>();
        boolean notImpliesFlag = true;
        for (Permission permission : permissionsArray) {
            String permissionString = permission.toString();
            if (permission instanceof UnresolvedPermission) {
                Tr.warning(tc, "security.policy.unresolved.permission", new Object[]{permissionString, fname});
                Permission p = this.createPermission0((UnresolvedPermission)permission);
                if (p != null && !(p instanceof UnresolvedPermission)) {
                    permission = p;
                    permissionString = permission.toString();
                } else {
                    Tr.warning(tc, "security.policy.invalid.permission", new Object[]{permissionString, fname});
                }
            }
            if (!(permissionString = permissionString.startsWith("(unresolved ") ? permissionString.substring("(unresolved ".length(), permissionString.length() - 1) : permissionString.substring(1, permissionString.length() - 1)).startsWith("java") && !permissionString.startsWith("javax")) {
                if (wccmWarningFlag) {
                    Tr.warning(tc, "security.policy.wccm.custom.permission", new Object[]{permission, fname});
                }
                filteredPermissionsArray.add(permission);
            } else if (permissionString.startsWith("java.security.AllPermission")) {
                Tr.warning(tc, "security.policy.all.permission", new Object[]{fname});
                filteredPermissionsArray.add(permission);
            } else {
                Iterator itr = this.staticFilterPermissions.iterator();
                while (itr.hasNext() && notImpliesFlag) {
                    Permission fPermission = (Permission)itr.next();
                    if (fPermission instanceof UnresolvedPermission) {
                        Tr.warning(tc, "security.policy.unresolved.permission", new Object[]{fPermission, "filter.policy"});
                        Permission p = this.createPermission0((UnresolvedPermission)fPermission);
                        if (p != null && !(p instanceof UnresolvedPermission)) {
                            fPermission = p;
                        } else {
                            Tr.warning(tc, "security.policy.invalid.filter.permission", new Object[]{fPermission});
                            continue;
                        }
                    }
                    if (fPermission.implies(permission)) {
                        notImpliesFlag = false;
                        continue;
                    }
                    if (!permission.implies(fPermission)) continue;
                    Tr.audit(tc, "security.policy.imcomplete.filter.permission", new Object[]{permission, fname, fPermission});
                }
                if (notImpliesFlag) {
                    filteredPermissionsArray.add(permission);
                } else {
                    Tr.audit(tc, "security.policy.filtered.permission", new Object[]{permission, fname});
                }
            }
            notImpliesFlag = true;
        }
        return filteredPermissionsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCodeSource(CodeSource cs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCodeSource(" + cs + ")");
        }
        WSDynamicPolicy wSDynamicPolicy = this;
        synchronized (wSDynamicPolicy) {
            this.codeSourceList.remove(cs);
            this.csPermsHashMap.remove(cs);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remove for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCodeSource");
        }
    }

    private void filter(WSPolicyTemplate pt, String fname) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filter(" + pt + ")");
        }
        for (String symbol : pt.getSymbols()) {
            ArrayList p = pt.get(symbol);
            pt.replace(symbol, this.performFiltering(p, fname));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filter() returns " + pt);
        }
    }

    private CodeSource canonicalized(CodeSource cs) {
        URL url;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "canonicalized(" + cs + ")");
        }
        CodeSource result = cs;
        if (cs != null && (url = cs.getLocation()) != null && url.getProtocol().equalsIgnoreCase("file")) {
            String file = url.getFile().replace('/', File.separatorChar);
            try {
                file = FilePathUtil.decodeFilePath(file);
                if (file == null || file.equals("")) {
                    file = (String)com.ibm.ws.security.util.AccessController.doPrivileged(getUserDirAction);
                }
                result = this.createCodeSource(file);
            }
            catch (FilePathUtil.DecodeException e) {
                Tr.error(tc, "security.policy.parser.decodeexception", new Object[]{file, e});
                result = cs;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "canonicalized() returns " + result);
        }
        return result;
    }

    private void updateCodeSourceRepository(String path, ArrayList p, Map csPerms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + path + "\", " + p + "," + csPerms + ")");
        }
        CodeSource cs = this.createCodeSource(path);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Code Source for " + path + " is " + cs);
        }
        if (cs != null && p != null && p.size() != 0) {
            this.updateCodeSourceRepository(cs, p, csPerms);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(String, ArrayList, Map)");
        }
    }

    private void updateCodeSourceRepository(String path, ArrayList p, String app, String was, Map csPerms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + path + "\", " + p + ", \"" + app + "\",\"" + was + "\"," + csPerms + ")");
        }
        CodeSource cs = this.createCodeSource(path);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Code Source for " + path + " is " + cs);
        }
        if (cs != null && p != null && p.size() != 0) {
            this.updateCodeSourceRepository(cs, p, app, was, csPerms);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(String, ArrayList, String, String, Map)");
        }
    }

    private ArrayList expand(ArrayList p, String app, String was) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expand(" + p + ",\"" + app + "\",\"" + was + "\")");
        }
        int asize = p.size();
        ArrayList<Permission> perm = new ArrayList<Permission>(p.size());
        for (int i = 0; i < asize; ++i) {
            String pname = null;
            try {
                Permission pe = (Permission)p.get(i);
                if (pe instanceof FilePermission) {
                    int indx5;
                    int indx4;
                    int indx3;
                    StringBuffer buf;
                    int indx;
                    pname = pe.getName();
                    FilePermission fpe = (FilePermission)pe;
                    String action = fpe.getActions();
                    boolean expandflag = false;
                    if (app != null && (indx = pname.indexOf("${app.installed.path}")) != -1) {
                        buf = new StringBuffer(pname.length() + 25);
                        buf.append(pname.substring(0, indx));
                        buf.append(app);
                        buf.append(pname.substring(indx + "${app.installed.path}".length(), pname.length()));
                        pname = buf.toString();
                        pname = pname.replace('/', File.separatorChar);
                        expandflag = true;
                    }
                    int indx2 = pname.indexOf("${was.module.path}");
                    if (was == null && indx2 != -1) {
                        Tr.warning(tc, "security.policy.was.key");
                        continue;
                    }
                    if (was != null && indx2 != -1) {
                        buf = new StringBuffer(pname.length() + 25);
                        buf.append(pname.substring(0, indx2));
                        buf.append(was);
                        buf.append(pname.substring(indx2 + "${was.module.path}".length(), pname.length()));
                        pname = buf.toString();
                        pname = pname.replace('/', File.separatorChar);
                        expandflag = true;
                    }
                    if ((indx3 = pname.indexOf("${current.node.name}")) != -1) {
                        StringBuffer buf2 = new StringBuffer(pname.length() + 25);
                        buf2.append(pname.substring(0, indx3));
                        buf2.append(this.nodeName);
                        buf2.append(pname.substring(indx3 + "${current.node.name}".length(), pname.length()));
                        pname = buf2.toString();
                        expandflag = true;
                    }
                    if ((indx4 = pname.indexOf("${current.cell.name}")) != -1) {
                        StringBuffer buf3 = new StringBuffer(pname.length() + 25);
                        buf3.append(pname.substring(0, indx4));
                        buf3.append(this.cellName);
                        buf3.append(pname.substring(indx4 + "${current.cell.name}".length(), pname.length()));
                        pname = buf3.toString();
                        expandflag = true;
                    }
                    if ((indx5 = pname.indexOf("${current.server.name}")) != -1) {
                        StringBuffer buf4 = new StringBuffer(pname.length() + 25);
                        buf4.append(pname.substring(0, indx5));
                        buf4.append(this.srvrName);
                        buf4.append(pname.substring(indx5 + "${current.server.name}".length(), pname.length()));
                        pname = buf4.toString();
                        expandflag = true;
                    }
                    if (expandflag) {
                        FilePermission npe = new FilePermission(pname, action);
                        perm.add(npe);
                        continue;
                    }
                    perm.add(pe);
                    continue;
                }
                perm.add(pe);
                continue;
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.template.parser", new Object[]{e, pname});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expand");
        }
        return perm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCodeSourceRepository(CodeSource cs, ArrayList pp, String app, String was, Map csPerms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + cs + "\", " + pp + ",\"" + app + "\",\"" + was + "\"," + csPerms + ")");
        }
        if (cs != null && pp != null && pp.size() != 0) {
            WSDynamicPolicy wSDynamicPolicy = this;
            synchronized (wSDynamicPolicy) {
                ArrayList p = this.expand((ArrayList)pp.clone(), app, was);
                ArrayList ppp = null;
                if (csPerms == null) {
                    ppp = (ArrayList)this.csPermsHashMap.get(cs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getting for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
                    }
                    if (ppp != null) {
                        ppp = (ArrayList)ppp.clone();
                    }
                } else {
                    ppp = (ArrayList)csPerms.get(cs);
                }
                if (ppp == null) {
                    if (csPerms == null) {
                        this.codeSourceList.add(cs);
                        this.csPermsHashMap.put(cs, p.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putting for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to code source " + cs + " --> " + p.toString());
                        }
                    } else {
                        csPerms.put(cs, p.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to tmp code source " + cs + " --> " + p.toString());
                        }
                    }
                } else {
                    ArrayList permissions = this.expand((ArrayList)ppp.clone(), app, was);
                    int SIZE = p.size();
                    for (int i = 0; i < SIZE; ++i) {
                        Permission perm = (Permission)p.get(i);
                        if (permissions.contains(perm)) continue;
                        permissions.add(perm);
                    }
                    if (csPerms == null) {
                        this.csPermsHashMap.put(cs, permissions.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putting for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
                        }
                    } else {
                        csPerms.put(cs, permissions.clone());
                    }
                    if (tc.isDebugEnabled()) {
                        if (csPerms == null) {
                            Tr.debug(tc, "Existing entry in code source " + cs + " --> " + ppp.toString());
                        } else {
                            Tr.debug(tc, "Existing entry in tmp code source " + cs + " --> " + ppp.toString());
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    if (csPerms == null) {
                        Tr.debug(tc, "Dynamic Policy Code Source = " + this.codeSourceList);
                        Tr.debug(tc, "Dynamic Policy Code Source to Permissions Mapping = " + this.csPermsHashMap);
                    } else {
                        Tr.debug(tc, "Dynamic Policy tmp Code Source to Permissions Mapping = " + csPerms);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(CodeSource, ArrayList, String, String, Map)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCodeSourceRepository(CodeSource cs, ArrayList p, Map csPerms) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCodeSourceRepository(\"" + cs + "\", " + p + ")");
        }
        if (cs != null && p != null && p.size() != 0) {
            WSDynamicPolicy wSDynamicPolicy = this;
            synchronized (wSDynamicPolicy) {
                ArrayList permissions = null;
                if (csPerms == null) {
                    permissions = (ArrayList)this.csPermsHashMap.get(cs);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getting for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
                    }
                    if (permissions != null) {
                        permissions = (ArrayList)permissions.clone();
                    }
                } else {
                    permissions = (ArrayList)csPerms.get(cs);
                }
                if (permissions == null) {
                    if (csPerms == null) {
                        this.codeSourceList.add(cs);
                        this.csPermsHashMap.put(cs, p.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putting for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to code source " + cs + " --> " + p.toString());
                        }
                    } else {
                        csPerms.put(cs, p.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New entry added to tmp code source " + cs + " --> " + p.toString());
                        }
                    }
                } else {
                    permissions.addAll((ArrayList)p.clone());
                    if (csPerms == null) {
                        this.csPermsHashMap.put(cs, permissions.clone());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putting for cs of: " + cs.toString() + " hashsize: " + this.csPermsHashMap.size());
                        }
                    } else {
                        csPerms.put(cs, permissions.clone());
                    }
                    if (tc.isDebugEnabled()) {
                        if (csPerms == null) {
                            Tr.debug(tc, "Existing entry in code source " + cs + " --> " + permissions.toString());
                        } else {
                            Tr.debug(tc, "Existing entry in tmp code source " + cs + " --> " + permissions.toString());
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    if (csPerms == null) {
                        Tr.debug(tc, "Dynamic Policy Code Source = " + this.codeSourceList);
                        Tr.debug(tc, "Dynamic Policy Code Source to Permissions Mapping = " + this.csPermsHashMap);
                    } else {
                        Tr.debug(tc, "Dynamic Policy tmp Code Source to Permissions Mapping = " + csPerms);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCodeSourceRepository(CodeSource, ArrayList, Map)");
        }
    }

    public final CodeSource createCodeSource(String path) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCodeSource(" + path + ")");
        }
        CodeSource cs = null;
        path = path.replace('/', File.separatorChar);
        boolean endsWithMinus = false;
        boolean endsWithStar = false;
        boolean endsWithDir = false;
        String newPath = null;
        if (path.endsWith("-")) {
            endsWithMinus = true;
            newPath = path.substring(0, path.length() - 2);
        } else if (path.endsWith("*")) {
            endsWithStar = true;
            newPath = path.substring(0, path.length() - 2);
        } else {
            newPath = path;
            if (path.endsWith(File.separator)) {
                endsWithDir = true;
                newPath = path.substring(0, path.length() - 1);
            }
        }
        this.file = new File(newPath);
        String fName = null;
        String trailing = null;
        try {
            String fNameTmp;
            fName = fNameTmp = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WSDynamicPolicy.this.file.getCanonicalPath();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            Tr.warning(tc, "security.policy.fileCanonicalPath", new Object[]{ex, path});
        }
        if (endsWithDir) {
            trailing = endsWithMinus ? MINUS_TRAIL : STAR_TRAIL;
        } else if (endsWithMinus) {
            trailing = MINUS_TRAIL;
        } else if (endsWithStar) {
            trailing = STAR_TRAIL;
        }
        try {
            if (trailing != null && trailing.length() != 0) {
                StringBuffer buf = new StringBuffer(fName);
                buf.append(trailing);
                String s = FilePathUtil.encodeFilePath(new File(buf.toString()).getAbsolutePath());
                if (!s.startsWith("/")) {
                    s = "/" + s;
                }
                URL url1 = this.createURL(s);
                cs = new CodeSource(url1, (Certificate[])null);
            } else {
                String s = FilePathUtil.encodeFilePath(new File(fName).getAbsolutePath());
                if (!s.startsWith("/")) {
                    s = "/" + s;
                }
                URL url1 = this.createURL(s);
                cs = new CodeSource(url1, (Certificate[])null);
            }
        }
        catch (MalformedURLException mf) {
            Tr.warning(tc, "security.policy.parser.malformedurlexception", new Object[]{newPath, mf});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCodeSource() returns " + cs);
        }
        return cs;
    }

    private URL createURL(final String path) throws MalformedURLException {
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL("file", "", -1, path, new URLStreamHandler(){

                        protected URLConnection openConnection(URL url) throws IOException {
                            throw new IOException();
                        }
                    });
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception ex = pae.getException();
            throw (MalformedURLException)ex;
        }
    }

    public final List getRuntimeFilteredPermission() {
        return (List)this.runtimeFilterPermissions.clone();
    }

    private Permission getPermissionInstance(Parser.PermissionEntry permissionEntry) {
        Permission p = null;
        if (permissionEntry.getSignatures() == null) {
            p = this.createPermission(permissionEntry.getPermissionType(), permissionEntry.getName(), permissionEntry.getAction());
        }
        return p;
    }

    private Permission createPermission0(UnresolvedPermission p) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPermission0", p);
        }
        Permission retValue = p;
        if (p != null) {
            StringTokenizer st = new StringTokenizer(p.toString(), "() \t\n\r\f");
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            String c = null;
            if (st.hasMoreTokens()) {
                c = st.nextToken();
            }
            String n = null;
            if (st.hasMoreTokens() && "null".equals(n = st.nextToken())) {
                n = null;
            }
            String a = null;
            if (st.hasMoreTokens() && "null".equals(a = st.nextToken())) {
                a = null;
            }
            retValue = this.createPermission(c, n, a);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPermission0", retValue);
        }
        return retValue;
    }

    private Permission createPermission(String type, String name, String action) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPermission(" + type + ", " + name + ", " + action);
        }
        Permission p = null;
        if (type != null && type.length() != 0) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> permClass = null;
                permClass = cl != null ? cl.loadClass(type) : Class.forName(type);
                Constructor<?> constructor = permClass.getConstructor(String.class, String.class);
                p = (Permission)constructor.newInstance(name, action);
            }
            catch (ClassNotFoundException cnfe) {
                p = new UnresolvedPermission(type, name, action, null);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                Tr.error(tc, "security.policy.perminstance.targetexception", new Object[]{t});
            }
            catch (Exception e) {
                Tr.error(tc, "security.policy.perminstance.exception", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPermission", p);
        }
        return p;
    }

    private class GetCodeSourceAction
    implements PrivilegedAction {
        private File file;
        private String newPath;
        private boolean endsWithMinus = false;
        private boolean endsWithStar = false;

        public GetCodeSourceAction(String newPath, boolean endsWithMinus, boolean endsWithStar) {
            this.file = new File(newPath);
            this.newPath = newPath;
            this.endsWithMinus = endsWithMinus;
            this.endsWithStar = endsWithStar;
        }

        public Object run() {
            CodeSource cs = null;
            String fName = null;
            String trailing = null;
            try {
                fName = this.file.getCanonicalPath();
            }
            catch (IOException ex) {
                Tr.warning(tc, "security.policy.fileCanonicalPath", new Object[]{ex, fName});
            }
            if (this.file.isDirectory()) {
                trailing = this.endsWithMinus ? MINUS_TRAIL : STAR_TRAIL;
            } else if (this.endsWithMinus) {
                trailing = MINUS_TRAIL;
            } else if (this.endsWithStar) {
                trailing = STAR_TRAIL;
            }
            try {
                if (trailing != null && trailing.length() != 0) {
                    StringBuffer buf = new StringBuffer(fName);
                    buf.append(trailing);
                    cs = new CodeSource(FilePathUtil.filePathToURL(new File(buf.toString())), (Certificate[])null);
                } else {
                    cs = new CodeSource(FilePathUtil.filePathToURL(new File(fName)), (Certificate[])null);
                }
            }
            catch (MalformedURLException mf) {
                Tr.warning(tc, "security.policy.parser.malformedurlexception", new Object[]{this.newPath, mf});
            }
            return cs;
        }
    }

    private class WSPolicyTemplate
    implements PolicyTemplate {
        private Map entries = new HashMap();

        public String[] getSymbols() {
            return this.entries.keySet().toArray(new String[this.entries.size()]);
        }

        public ArrayList get(String symbol) {
            ArrayList p = (ArrayList)this.entries.get(symbol);
            if (p != null) {
                p = (ArrayList)p.clone();
            }
            return p;
        }

        public String toString() {
            return this.entries.toString();
        }

        private WSPolicyTemplate() {
        }

        private void add(Parser.GrantEntry g) {
            String symbol = g.codeBase;
            if (symbol == null || symbol.length() == 0) {
                symbol = "${default}";
            } else {
                symbol = g.codeBase;
                if (symbol.startsWith("${") && symbol.endsWith("}")) {
                    symbol = symbol.toLowerCase();
                }
            }
            Object obj = this.entries.get(symbol);
            ArrayList<Permission> list = null;
            if (obj != null) {
                list = (ArrayList<Permission>)obj;
            } else {
                list = new ArrayList<Permission>();
                this.entries.put(symbol, list);
            }
            Iterator it = g.getPermissions();
            while (it.hasNext()) {
                list.add(WSDynamicPolicy.this.getPermissionInstance((Parser.PermissionEntry)it.next()));
            }
        }

        private void addAll(WSPolicyTemplate ptmp) {
            if (ptmp == null) {
                return;
            }
            for (String symbol : ptmp.getSymbols()) {
                this.add(symbol, (ArrayList)ptmp.entries.get(symbol));
            }
        }

        private void replace(String symbol, ArrayList perm) {
            this.entries.put(symbol, perm);
        }

        private void add(String symbol, ArrayList perm) {
            ArrayList p2 = (ArrayList)this.entries.get(symbol);
            if (p2 != null) {
                int SIZE = perm.size();
                for (int i = 0; i < SIZE; ++i) {
                    Permission permission = (Permission)perm.get(i);
                    if (p2.contains(permission)) continue;
                    p2.add(permission);
                }
            } else {
                p2 = (ArrayList)perm.clone();
            }
            this.entries.put(symbol, p2);
        }
    }
}

