/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.util.ParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

abstract class SystemExtensionParser
extends Parser {
    SystemExtensionParser(Reader rdr, boolean expandProp) {
        super(rdr, expandProp);
    }

    void parse() throws IOException, ParserException {
        super.parse();
        this.normalizeGrants();
    }

    private void normalizeGrants() {
        Iterator it = this.grants.iterator();
        Parser.GrantEntry g = new Parser.GrantEntry();
        while (it.hasNext()) {
            Parser.GrantEntry g1 = (Parser.GrantEntry)it.next();
            if (g1.codeBase != null || g1.signedBy != null) {
                this.warning("security.policy.sysextparser.ignoregrant", new Object[]{g1.codeBase, g1.signedBy});
                continue;
            }
            Iterator permissions = g1.getPermissions();
            while (permissions.hasNext()) {
                Parser.PermissionEntry permissionEntry = (Parser.PermissionEntry)permissions.next();
                if (permissionEntry.getSignatures() == null) {
                    g.add(permissionEntry);
                    continue;
                }
                this.warning("security.policy.sysextparser.ignoreperm", new Object[]{permissionEntry.toString()});
            }
        }
        this.grants.clear();
        this.grants.add(g);
    }
}

