/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ffdc.Manager;
import com.ibm.ws.security.policy.FilePathUtil;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.policy.TraceOutput;
import com.ibm.ws.security.util.ParserException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.Permission;
import java.security.UnresolvedPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class Parser
implements TraceOutput {
    private WSPolicyTemplate policyTemplate = new WSPolicyTemplate();
    String keyStoreUrlString;
    String keyStoreType;
    List grants = new ArrayList();
    com.ibm.ws.security.util.Parser parser = null;
    boolean expandProp = false;
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String QUOTED_STRING = "quoted string";
    static final String PERMISSION_TYPE = "permission type";
    static final String GRANT_KEYWORD = "grant";
    static final String KEYSTORE_KEYWORD = "keystore";
    static final String CODEBASE_KEYWORD = "codeBase";
    static final String PERMISSION_KEYWORD = "permission";
    static final String SIGNEDBY_KEYWORD = "signedBy";
    static final String FILTER_KEYWORD = "filterMask";

    Parser(Reader rdr, boolean expandProp) {
        this.init(rdr, expandProp);
    }

    public String toString() {
        return this.getClass().getName();
    }

    Iterator grantEntries() {
        return this.grants.iterator();
    }

    void parse() throws IOException, ParserException {
        this.parser.nextToken();
        while (!this.parser.eof()) {
            if (this.parser.peek(GRANT_KEYWORD)) {
                GrantEntry g = this.parseGrantEntry();
                if (g != null) {
                    this.grants.add(g);
                }
            } else if (this.parser.peek(KEYSTORE_KEYWORD)) {
                if (this.keyStoreUrlString == null) {
                    this.parseKeystoreEntry();
                    if (this.keyStoreType == null) {
                        this.keyStoreType = "JKS";
                    }
                    this.warning("security.policy.parser.keystore", new Object[]{this.keyStoreUrlString, this.keyStoreType});
                }
            } else {
                throw new ParserException(this.parser.getLineNumber(), "Unexpected keyword \"" + this.parser.getStringValue() + "\"");
            }
            this.parser.match(";");
        }
        this.createPolicyTemplate();
    }

    void createPolicyTemplate() {
        Iterator it = this.grantEntries();
        while (it.hasNext()) {
            this.policyTemplate.add((GrantEntry)it.next());
        }
    }

    PolicyTemplate getPolicyTemplate() {
        return this.policyTemplate;
    }

    Permission getPermissionInstance(PermissionEntry permissionEntry) {
        Permission p = null;
        if (permissionEntry.getSignatures() == null) {
            try {
                Class<?> permClass = Class.forName(permissionEntry.getPermissionType());
                Constructor<?> constructor = permClass.getConstructor(String.class, String.class);
                p = (Permission)constructor.newInstance(permissionEntry.getName(), permissionEntry.getAction());
            }
            catch (ClassNotFoundException cnfe) {
                Manager.Ffdc.log(cnfe, this, "com.ibm.ws.security.policy.Parser.getPermissionInstance", "93", this);
                p = new UnresolvedPermission(permissionEntry.getPermissionType(), permissionEntry.getName(), permissionEntry.getAction(), null);
            }
            catch (InvocationTargetException ite) {
                Manager.Ffdc.log(ite, this, "com.ibm.ws.security.policy.Parser.getPermissionInstance", "96", this);
                Throwable t = ite.getTargetException();
                this.error("security.policy.perminstance.targetexception", new Object[]{t});
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.Parser.getPermissionInstance", "100", this);
                this.error("security.policy.perminstance.exception", new Object[]{e});
            }
        }
        return p;
    }

    void parseKeystoreEntry() throws IOException, ParserException {
        this.parser.match(KEYSTORE_KEYWORD);
        this.keyStoreUrlString = this.parser.match(QUOTED_STRING);
        if (!this.parser.peek(",")) {
            return;
        }
        this.parser.match(",");
        if (!this.parser.peek("\"")) {
            throw new ParserException(this.parser.getLineNumber(), "expected keystore type");
        }
        this.keyStoreType = this.parser.match(QUOTED_STRING);
    }

    GrantEntry parseGrantEntry() throws IOException, ParserException {
        GrantEntry g = new GrantEntry();
        this.parser.match(GRANT_KEYWORD);
        while (!this.parser.peek("{")) {
            if (this.parser.peek(CODEBASE_KEYWORD)) {
                this.parser.match(CODEBASE_KEYWORD);
                g.codeBase = this.parser.match(QUOTED_STRING);
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            if (this.parser.peek(SIGNEDBY_KEYWORD)) {
                this.parser.match(SIGNEDBY_KEYWORD);
                g.signedBy = this.parser.match(QUOTED_STRING);
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected codeBase or signedBy");
        }
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek(PERMISSION_KEYWORD)) {
                try {
                    PermissionEntry p = this.parsePermissionEntry();
                    g.add(p);
                }
                catch (ExpandException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.Parser.parseGrantEntry", "147", this);
                    this.warning("security.policy.parser.expandperm", new Object[]{e});
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        try {
            if (g.codeBase != null) {
                g.codeBase = this.expand(g.codeBase, true);
            }
            g.signedBy = this.expand(g.signedBy);
        }
        catch (ExpandException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.Parser.parseGrantEntry", "163", this);
            this.warning("security.policy.parser.expandgrant", new Object[]{e});
            return null;
        }
        return g;
    }

    PermissionEntry parsePermissionEntry() throws IOException, ParserException, ExpandException {
        PermissionEntry p = new PermissionEntry();
        this.parser.match(PERMISSION_KEYWORD);
        p.permissionType = this.parser.match(PERMISSION_TYPE);
        if (this.parser.peek("\"")) {
            p.name = this.expand(this.parser.match_p(QUOTED_STRING)).trim();
        }
        if (!this.parser.peek(",")) {
            return p;
        }
        this.parser.match(",");
        if (this.parser.peek("\"")) {
            p.action = this.expand(this.parser.match(QUOTED_STRING));
            if (!this.parser.peek(",")) {
                return p;
            }
            this.parser.match(",");
        }
        try {
            if (this.parser.peek(SIGNEDBY_KEYWORD)) {
                this.parser.match(SIGNEDBY_KEYWORD);
                p.signedBy = this.expand(this.parser.match(QUOTED_STRING));
            }
        }
        catch (ExpandException e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.policy.Parser.parsePermissionEntry", "198", this);
            this.warning("security.policy.parser.expandsignedby", new Object[]{e});
            return null;
        }
        return p;
    }

    String expand(String str) throws ExpandException {
        return this.expand(str, false);
    }

    String expand(String str, boolean encodeValue) throws ExpandException {
        if (this.expandProp) {
            int strLen = 0;
            if (str == null || (strLen = str.length()) == 0) {
                return str;
            }
            StringBuffer buf = new StringBuffer(strLen + 25);
            int index = 0;
            for (int last = 0; last < strLen; ++last) {
                index = str.indexOf("${", last);
                if (index == -1) {
                    buf.append(str.substring(last));
                    break;
                }
                buf.append(str.substring(last, index));
                last = str.indexOf("}", index);
                if (last == -1) {
                    buf.append(str.substring(index));
                    break;
                }
                String key = str.substring(index + 2, last);
                if (key.equals("/")) {
                    buf.append(File.separator);
                    continue;
                }
                String value = System.getProperty(key);
                if (value != null) {
                    if (encodeValue) {
                        value = FilePathUtil.encodeFilePath(value);
                    }
                    buf.append(value);
                    continue;
                }
                StringBuffer errBuf = new StringBuffer(32);
                errBuf.append("line ").append(this.parser.getLineNumber()).append(": ");
                errBuf.append("unable to expand \"").append(key).append("\"");
                String errStr = errBuf.toString();
                this.error("security.policy.parser.encodeFilePath", new Object[]{errStr});
                throw new ExpandException(errStr);
            }
            return buf.toString();
        }
        return str;
    }

    private void init(Reader rdr, boolean expandProp) {
        this.parser = new com.ibm.ws.security.util.Parser(rdr);
        this.expandProp = expandProp;
    }

    private class WSPolicyTemplate
    implements PolicyTemplate {
        private HashMap entries = new HashMap();

        private WSPolicyTemplate() {
        }

        public String[] getSymbols() {
            return this.entries.keySet().toArray(new String[this.entries.size()]);
        }

        public ArrayList get(String symbol) {
            ArrayList p = (ArrayList)this.entries.get(symbol);
            if (p != null) {
                p = (ArrayList)p.clone();
            }
            return p;
        }

        public String toString() {
            return this.entries.toString();
        }

        private void add(GrantEntry g) {
            String symbol = g.codeBase;
            if (symbol == null || symbol.length() == 0) {
                symbol = "${default}";
            } else {
                symbol = g.codeBase;
                if (symbol.startsWith("${") && symbol.endsWith("}")) {
                    symbol = symbol.toLowerCase();
                }
            }
            Object obj = this.entries.get(symbol);
            ArrayList<Permission> list = null;
            if (obj != null) {
                list = (ArrayList<Permission>)obj;
            } else {
                list = new ArrayList<Permission>();
                this.entries.put(symbol, list);
            }
            Iterator it = g.getPermissions();
            while (it.hasNext()) {
                list.add(Parser.this.getPermissionInstance((PermissionEntry)it.next()));
            }
        }
    }

    class GrantEntry {
        String codeBase;
        String signedBy;
        private List permissionEntries = new ArrayList();

        GrantEntry() {
        }

        GrantEntry(String c, String s) {
            this.codeBase = c;
            this.signedBy = s;
        }

        void add(PermissionEntry p) {
            if (!this.permissionEntries.contains(p)) {
                this.permissionEntries.add(p);
            }
        }

        boolean remove(PermissionEntry p) {
            return this.permissionEntries.remove(p);
        }

        boolean contains(PermissionEntry p) {
            return this.permissionEntries.contains(p);
        }

        Iterator getPermissions() {
            return this.permissionEntries.iterator();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.permissionEntries.size() * 40);
            buf.append(Parser.GRANT_KEYWORD).append(' ');
            if (this.codeBase != null) {
                buf.append(Parser.CODEBASE_KEYWORD).append(" \"").append(this.codeBase).append("\" ");
                if (this.signedBy != null) {
                    buf.append(", ");
                }
            }
            if (this.signedBy != null) {
                buf.append(Parser.SIGNEDBY_KEYWORD).append(" \"").append(this.signedBy).append("\" ");
            }
            buf.append('{').append(NEW_LINE);
            Iterator it = this.permissionEntries.iterator();
            while (it.hasNext()) {
                buf.append(it.next().toString());
            }
            buf.append("};").append(NEW_LINE);
            return buf.toString();
        }
    }

    class PermissionEntry {
        private String permissionType;
        private String name;
        private String action;
        private String signedBy;

        private PermissionEntry() {
        }

        private PermissionEntry(String p, String n, String a, String s) {
            this.permissionType = p;
            this.name = n;
            this.action = a;
            this.signedBy = s;
        }

        public int hashCode() {
            int i = this.permissionType.hashCode();
            if (this.name != null) {
                i ^= this.name.hashCode();
            }
            if (this.action != null) {
                i ^= this.action.hashCode();
            }
            return i;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry other = (PermissionEntry)obj;
            if (this.permissionType == null ? other.permissionType != null : !this.permissionType.equals(other.permissionType)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
                return false;
            }
            return !(this.signedBy == null ? other.signedBy != null : !this.signedBy.equals(other.signedBy));
        }

        public String toString() {
            if (this.permissionType == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer("  ");
            buf.append(Parser.PERMISSION_KEYWORD).append(' ').append(this.permissionType);
            if (this.name != null) {
                buf.append(" \"").append(this.name).append('\"');
            }
            if (this.action != null) {
                buf.append(", \"").append(this.action).append('\"');
            }
            if (this.signedBy != null) {
                buf.append(", ").append(Parser.SIGNEDBY_KEYWORD).append(" \"").append(this.signedBy).append('\"');
            }
            buf.append(';').append(NEW_LINE);
            return buf.toString();
        }

        String getPermissionType() {
            return this.permissionType;
        }

        String getName() {
            return this.name;
        }

        String getAction() {
            return this.action;
        }

        String getSignatures() {
            return this.signedBy;
        }
    }

    class ExpandException
    extends GeneralSecurityException {
        private static final long serialVersionUID = 1483415462597387621L;

        ExpandException(String msg) {
            super(msg);
        }
    }
}

