/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.policy.DynamicPolicy;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Map;

public final class NullDynamicPolicy
extends Policy
implements DynamicPolicy {
    private Policy policy = null;
    private boolean use_default_policy = false;
    private boolean initialize_default_policy_flag = false;
    private static final PermissionCollection EMPTY = new Permissions();
    private static final TraceComponent tc = Tr.register(NullDynamicPolicy.class, null, "com.ibm.ejs.resources.security");

    public NullDynamicPolicy(Policy policy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "NullDynamicPolicy(" + policy + ")");
        }
        this.policy = policy;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "NullDynamicPolicy()");
        }
    }

    public final void refresh() {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy && this.policy != null) {
            this.policy.refresh();
        }
    }

    public final ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        return null;
    }

    public final PermissionCollection getPermissions(CodeSource cs) {
        PermissionCollection pc = EMPTY;
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy && this.policy != null) {
            pc = this.policy.getPermissions(cs);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Permissions for \"" + cs + "\" = " + pc);
            }
        } else {
            pc = new Permissions();
        }
        return pc;
    }

    public final void removePolicy(Map map) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "removePolicy(" + map + ")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removePolicy()");
            }
        }
    }

    public final void setupPolicy(Map map) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupPolicy(" + map + ")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setupPolicy()");
            }
        }
    }

    public final void getSecurityPolicy(Map map, Map csPerms) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityPolicy(" + map + "," + csPerms + ")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityPolicy()");
            }
        }
    }

    public final PermissionCollection getPermissions(CodeSource cs, Map csPerms) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        PermissionCollection pc = EMPTY;
        if (this.use_default_policy && this.policy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Permissions for \"" + cs + "\" = " + pc);
            }
            pc = this.policy.getPermissions(cs);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPermissions()");
            }
        } else {
            pc = new Permissions();
        }
        return pc;
    }

    public final PermissionCollection getPermissions(ProtectionDomain domain) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        PermissionCollection pc = EMPTY;
        if (this.use_default_policy) {
            PermissionCollection p;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPermissions");
            }
            pc = super.getPermissions(domain);
            if (this.policy != null && (p = this.policy.getPermissions(domain)) != null) {
                Enumeration<Permission> e = p.elements();
                while (e.hasMoreElements()) {
                    pc.add(e.nextElement());
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPermissions", pc);
            }
        } else {
            pc = new Permissions();
        }
        return pc;
    }

    public final boolean implies(ProtectionDomain domain, Permission permission) {
        if (!this.initialize_default_policy_flag) {
            this.initializeDefaultPolicyFlag();
        }
        if (this.use_default_policy) {
            boolean result = super.implies(domain, permission);
            if (!result && this.policy != null) {
                result = this.policy.implies(domain, permission);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "implies -> " + result);
            }
            return result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "implies (no policy check) -> true");
        }
        return true;
    }

    private void initializeDefaultPolicyFlag() {
        String use_default_policy_str = SecurityObjectLocator.getSecurityConfigManager().getObject("security").getProperties().getProperty("security.useDefaultPolicyWhenJ2SDisabled");
        if (use_default_policy_str == null || !Boolean.valueOf(use_default_policy_str).booleanValue()) {
            this.use_default_policy = false;
            this.initialize_default_policy_flag = true;
        } else {
            this.use_default_policy = true;
            this.initialize_default_policy_flag = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "use_default_policy -> " + this.use_default_policy);
        }
    }
}

