/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.provider.AllPolicyConfigs;
import com.ibm.ws.security.provider.JaccProvider;
import com.ibm.ws.security.provider.WSPolicyConfigurationImpl;
import com.ibm.ws.security.util.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;

public class JaccPolicyProxy
extends Policy {
    private static Policy policy = null;
    private ProtectionDomain self = null;
    private JaccProvider jaccProvider = null;
    private static final TraceComponent tc = Tr.register(JaccPolicyProxy.class, null, "com.ibm.ejs.resources.security");

    public JaccPolicyProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "JaccPolicyProxy");
        }
        final JaccPolicyProxy p = this;
        this.self = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return p.getClass().getProtectionDomain();
            }
        });
        policy = Policy.getPolicy();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "JaccPolicyProxy()");
        }
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions", new Object[]{codeSource});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions(CodeSource)");
        }
        return policy.getPermissions(codeSource);
    }

    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh()");
        }
        policy.refresh();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh()");
        }
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPermissions");
        }
        PermissionCollection pc = null;
        pc = policy.getPermissions(domain);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPermissions(domain)");
        }
        return pc;
    }

    public boolean implies(ProtectionDomain pd, Permission p) {
        boolean result = false;
        if (this.self == pd && this.self != null) {
            result = true;
        } else {
            if (p instanceof WebResourcePermission) {
                boolean excluded;
                WSPolicyConfigurationImpl pc = this.getPolicyConfiguration();
                if (pc == null) {
                    return false;
                }
                if (pd.getPrincipals() == null || pd.getPrincipals().length < 1) {
                    boolean unCheck;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the unchecked list");
                    }
                    if (unCheck = this.jaccProvider.checkUncheckedPerm(pc, p)) {
                        return unCheck;
                    }
                    return this.jaccProvider.isEveryoneGranted(pc, p, PolicyContext.getContextID());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the excluded list");
                }
                if (excluded = this.jaccProvider.checkExcludedPerm(pc, p)) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the role list");
                }
                return this.jaccProvider.checkRolePerm(pc, p, PolicyContext.getContextID());
            }
            if (p instanceof WebUserDataPermission) {
                boolean excluded;
                WSPolicyConfigurationImpl pc = this.getPolicyConfiguration();
                if (pc == null) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the excluded list");
                }
                if (excluded = this.jaccProvider.checkExcludedPerm(pc, p)) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not in the excluded list: Checking for unchecked");
                }
                boolean unCheck = this.jaccProvider.checkUncheckedPerm(pc, p);
                return unCheck;
            }
            if (p instanceof WebRoleRefPermission || p instanceof EJBRoleRefPermission) {
                WSPolicyConfigurationImpl pc = this.getPolicyConfiguration();
                if (pc == null) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the role list");
                }
                return this.jaccProvider.checkRolePerm(pc, p, PolicyContext.getContextID());
            }
            if (p instanceof EJBMethodPermission) {
                boolean unchecked;
                boolean excluded;
                WSPolicyConfigurationImpl pc = this.getPolicyConfiguration();
                if (pc == null) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the excluded list");
                }
                if (excluded = this.jaccProvider.checkExcludedPerm(pc, p)) {
                    return false;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the unchecked list");
                }
                if (unchecked = this.jaccProvider.checkUncheckedPerm(pc, p)) {
                    return unchecked;
                }
                return this.jaccProvider.checkRolePerm(pc, p, PolicyContext.getContextID());
            }
            result = policy.implies(pd, p);
        }
        return result;
    }

    private WSPolicyConfigurationImpl getPolicyConfiguration() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicyConfiguration");
        }
        String contextID = PolicyContext.getContextID();
        WSPolicyConfigurationImpl pc = null;
        pc = AllPolicyConfigs.getInstance().getPolicyConfig(contextID);
        if (pc == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Cannot get the policy configuration object. exit value:false");
            }
            return null;
        }
        boolean inService = false;
        try {
            inService = pc.inService();
        }
        catch (PolicyContextException pce) {
            FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.policy.JaccPolicyProxy.JaccProvider.getPolicyConfiguration", "208", this);
            Tr.warning(tc, "security.jacc.provider.inservice", new Object[]{pce});
        }
        if (!inService) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The policy configuration object is not in the commit state. exit value:false");
            }
            return null;
        }
        if (this.jaccProvider == null) {
            this.jaccProvider = JaccProvider.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicyConfiguration");
        }
        return pc;
    }
}

