/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.util.ParserException;
import java.io.IOException;
import java.io.Reader;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

abstract class FilterParser
extends Parser {
    private HashMap filterEntries = new HashMap(2);
    private ArrayList filterPermissions = new ArrayList(32);
    static final String FILTER_KEYWORD = "filterMask";
    static final String RUNTIME_FILTER_KEYWORD = "runtimeFilterMask";

    FilterParser(Reader rdr, boolean expandProp) {
        super(rdr, expandProp);
    }

    void parse() throws IOException, ParserException {
        FilterEntry entry;
        this.parser.nextToken();
        while (!this.parser.eof()) {
            if (this.parser.peek(FILTER_KEYWORD)) {
                this.addFilterEntry(this.parseFilterEntry(FILTER_KEYWORD));
            } else if (this.parser.peek(RUNTIME_FILTER_KEYWORD)) {
                this.addFilterEntry(this.parseFilterEntry(RUNTIME_FILTER_KEYWORD));
            } else {
                throw new ParserException(this.parser.getLineNumber(), "Unexpected keyword \"" + this.parser.getStringValue() + "\"");
            }
            this.parser.match(";");
        }
        if (!this.filterEntries.isEmpty() && (entry = (FilterEntry)this.filterEntries.get(FILTER_KEYWORD)) != null) {
            int size = entry.permissionEntries.size();
            for (int x = 0; x < size; ++x) {
                Permission p = this.getPermissionInstance((Parser.PermissionEntry)entry.permissionEntries.get(x));
                this.filterPermissions.add(p);
            }
        }
    }

    ArrayList getFilterPermissions() {
        return (ArrayList)this.filterPermissions.clone();
    }

    FilterEntry getFilterEntry(String type) {
        return (FilterEntry)this.filterEntries.get(type);
    }

    private void addFilterEntry(FilterEntry entry) {
        if (entry != null) {
            FilterEntry existEntry = (FilterEntry)this.filterEntries.get(entry.getType());
            if (existEntry != null) {
                existEntry.add(entry);
            } else {
                this.filterEntries.put(entry.getType(), entry);
            }
        }
    }

    private FilterEntry parseFilterEntry(String stanza) throws IOException, ParserException {
        FilterEntry f = new FilterEntry(stanza);
        this.parser.match(stanza);
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek("permission")) {
                try {
                    Parser.PermissionEntry p = this.parsePermissionEntry();
                    f.add(p);
                }
                catch (Parser.ExpandException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.policy.FilterParser.parseFilterEntry", "102", this);
                    this.warning("security.policy.filterparser.expandperm", new Object[]{e});
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        return f;
    }

    Iterator getFilterEntries() {
        return this.filterEntries.values().iterator();
    }

    public String toString() {
        String ret;
        if (!this.filterEntries.isEmpty()) {
            StringBuffer buf = new StringBuffer(512);
            FilterEntry entry = (FilterEntry)this.filterEntries.get(FILTER_KEYWORD);
            if (entry != null) {
                buf.append(entry.toString()).append(NEW_LINE);
            }
            if ((entry = (FilterEntry)this.filterEntries.get(RUNTIME_FILTER_KEYWORD)) != null) {
                buf.append(entry.toString());
            }
            ret = buf.toString();
        } else {
            ret = "";
        }
        return ret;
    }

    class FilterEntry {
        private List permissionEntries = new ArrayList();
        private String type;

        private FilterEntry(String stanza) {
            this.type = stanza;
        }

        void add(Parser.PermissionEntry p) {
            if (!this.permissionEntries.contains(p)) {
                this.permissionEntries.add(p);
            }
        }

        boolean contains(Parser.PermissionEntry p) {
            return this.permissionEntries.contains(p);
        }

        Iterator getPermissions() {
            return this.permissionEntries.iterator();
        }

        String getType() {
            return this.type;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.permissionEntries.size() * 40);
            buf.append(this.type).append(' ');
            buf.append('{').append(Parser.NEW_LINE);
            Iterator it = this.permissionEntries.iterator();
            while (it.hasNext()) {
                buf.append(it.next().toString());
            }
            buf.append("};").append(Parser.NEW_LINE);
            return buf.toString();
        }

        private void add(FilterEntry entry) {
            if (entry != null) {
                int size = entry.permissionEntries.size();
                for (int x = 0; x < size; ++x) {
                    this.add((Parser.PermissionEntry)entry.permissionEntries.get(x));
                }
            }
        }
    }
}

