/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ws.security.policy.ApplicationParserStrBuf;
import com.ibm.ws.security.util.ParserException;
import com.ibm.ws.security.util.SecurityMessages;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JTextArea;

public class ApplicationGUIParser {
    private ApplicationParserStrBuf appParser = null;

    public ApplicationGUIParser(JTextArea textArea, InputStream im, boolean expandProp) {
        this.appParser = new ApplicationParserStrBuf(new InputStreamReader(im), expandProp);
        try {
            this.appParser.parse();
            String str = this.appParser.getMessage();
            if (str != null && str.length() != 0) {
                textArea.append(str);
            }
        }
        catch (ParserException pe) {
            String str = this.appParser.getMessage();
            textArea.append(str);
            String emsg = null;
            try {
                emsg = SecurityMessages.getMsg("security.policy.sysext.parserexception", new Object[]{pe, "GUI"});
            }
            catch (Exception e) {
                emsg = "Failed to get message. ParserException occurred." + pe;
            }
            textArea.append(emsg);
        }
        catch (Exception e) {
            String str = this.appParser.getMessage();
            textArea.append(str);
            String emsg = null;
            try {
                emsg = SecurityMessages.getMsg("security.policy.sysext.exception", new Object[]{e, "GUI"});
            }
            catch (Exception ex) {
                emsg = "Failed to get message. Exception occurred." + ex;
            }
            textArea.append(emsg);
        }
    }

    public static void main(String[] args) {
        JTextArea jt = new JTextArea();
        try {
            ApplicationGUIParser parser2 = new ApplicationGUIParser(jt, System.in, true);
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace();
            System.exit(2);
        }
        String str = jt.getText();
        System.out.println("Error message:[" + str + "]");
        System.exit(0);
    }
}

