/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.orbssl;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.orbssl.SSLConnectionDataImpl;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;

public class ExtendedSSLConnectionData
extends SSLConnectionDataImpl {
    private static final String variable_data_name = "NATIVE_VARIABLE_DATA";
    private static final String effective_policy_name = "EFFECTIVE_POLICY_DATA";
    private static final TraceComponent tc = Tr.register(ExtendedSSLConnectionData.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private String SSLKeyStoreClientAlias = "";
    private String SSLConfigAlias = "";
    private CSIv2EffectivePerformPolicy effectivePolicy = null;

    public ExtendedSSLConnectionData(String connKey, long connType, short qop, int errorCode, CSIv2EffectivePerformPolicy policy) {
        super(connKey, connType, qop, errorCode);
        this.effectivePolicy = policy;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        this.SSLConfigAlias = csiv2.getString("com.ibm.ssl.csi.outbound.alias");
    }

    public ExtendedSSLConnectionData(byte[] connDataBytes) throws Exception {
        super(null, 0L, (short)0, 0);
        this.constructFromBytes(connDataBytes);
    }

    public byte[] getBytes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes", this);
        }
        ArrayList<TokenHolder> tokenHolders = new ArrayList<TokenHolder>();
        byte[] session_entry_bytes = null;
        try {
            TokenHolder th = this.serializeVariables();
            tokenHolders.add(th);
            if (this.effectivePolicy != null) {
                tokenHolders.add(new TokenHolder(this.effectivePolicy.getBytes(), effective_policy_name, 1));
            }
            session_entry_bytes = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromTokenHolderList(null, tokenHolders);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.getBytes", "137", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting session bytes for private security context.", new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", session_entry_bytes);
        }
        return session_entry_bytes;
    }

    private void constructFromBytes(byte[] session_bytes) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructFromBytes", new Object[]{session_bytes, this});
        }
        if (session_bytes != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ExtendedSSLConnectionData bytes: " + session_bytes);
            }
            try {
                ArrayList tokenHolders = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(session_bytes);
                if (tokenHolders != null) {
                    for (int i = 0; i < tokenHolders.size(); ++i) {
                        TokenHolder th = (TokenHolder)tokenHolders.get(i);
                        String name = th.getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Handling token name: " + name);
                        }
                        if (name != null && name.equals(effective_policy_name)) {
                            this.effectivePolicy = new CSIv2EffectivePerformPolicy(th.getBytes());
                            continue;
                        }
                        if (name == null || !name.equals(variable_data_name)) continue;
                        this.deserializeVariables(th.getBytes());
                    }
                } else {
                    String connectionKey = new String(session_bytes);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ConnectionKey string: " + connectionKey);
                    }
                    this.setConnectionKey(connectionKey);
                    this.setConnectionType(2L);
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.constructFromBytes", "196", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception constructing private service context.", new Object[]{e});
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructFromBytes");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TokenHolder serializeVariables() throws Exception {
        DataOutputStream dos;
        TokenHolder th;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "serializeVariables", this);
            }
            th = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(300);
            dos = new DataOutputStream(baos);
            try {
                try {
                    dos.writeLong(this.getConnectionType());
                    dos.writeShort(this.getPerformQOP());
                    dos.writeInt(this.getErrorCode());
                    String connKey = this.getConnectionKey();
                    if (connKey != null && connKey.length() > 0) {
                        dos.writeInt(connKey.length());
                        dos.write(connKey.getBytes(), 0, connKey.length());
                    } else {
                        dos.writeInt(0);
                    }
                    if (this.SSLKeyStoreClientAlias != null && this.SSLKeyStoreClientAlias.length() > 0) {
                        dos.writeInt(this.SSLKeyStoreClientAlias.length());
                        dos.write(this.SSLKeyStoreClientAlias.getBytes(), 0, this.SSLKeyStoreClientAlias.length());
                    } else {
                        dos.writeInt(0);
                    }
                    if (this.SSLConfigAlias != null && this.SSLConfigAlias.length() > 0) {
                        dos.writeInt(this.SSLConfigAlias.length());
                        dos.write(this.SSLConfigAlias.getBytes(), 0, this.SSLConfigAlias.length());
                    } else {
                        dos.writeInt(0);
                    }
                    th = new TokenHolder(baos.toByteArray(), variable_data_name, 1);
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.serializeVariables", "261", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception serializing native variables.", new Object[]{e});
                    }
                    throw e;
                }
                Object var6_6 = null;
                if (baos == null) break block16;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (baos != null) {
                    baos.close();
                }
                if (dos != null) {
                    dos.close();
                }
                throw throwable;
            }
            baos.close();
        }
        if (dos != null) {
            dos.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeVariables", th);
        }
        return th;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deserializeVariables(byte[] inputData) throws Exception {
        DataInputStream dis;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deserializeVariables", new Object[]{inputData, this});
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(inputData);
            dis = new DataInputStream(bais);
            try {
                try {
                    byte[] stringBytes;
                    this.setConnectionType(dis.readLong());
                    this.setPerformQOP(dis.readShort());
                    this.setErrorCode(dis.readInt());
                    int stringSize = dis.readInt();
                    if (stringSize > 0) {
                        stringBytes = new byte[stringSize];
                        dis.read(stringBytes, 0, stringSize);
                        this.setConnectionKey(new String(stringBytes));
                    }
                    if ((stringSize = dis.readInt()) > 0) {
                        stringBytes = new byte[stringSize];
                        dis.read(stringBytes, 0, stringSize);
                        this.SSLKeyStoreClientAlias = new String(stringBytes);
                    }
                    if ((stringSize = dis.readInt()) > 0) {
                        stringBytes = new byte[stringSize];
                        dis.read(stringBytes, 0, stringSize);
                        this.SSLConfigAlias = new String(stringBytes);
                    }
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.orbssl.ExtendedSSLConnectionData.deserializeVariables", "330", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception de-serializing native variables.", new Object[]{e});
                    }
                    throw e;
                }
                Object var7_7 = null;
                if (bais == null) break block13;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (bais != null) {
                    bais.close();
                }
                if (dis != null) {
                    dis.close();
                }
                throw throwable;
            }
            bais.close();
        }
        if (dis != null) {
            dis.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeVariables");
        }
    }

    public String getKeyStoreClientAlias() {
        return this.SSLKeyStoreClientAlias;
    }

    public String getSSLConfigAlias() {
        return this.SSLConfigAlias;
    }

    public int getSessionTimeout() {
        return 0;
    }

    public boolean getMessageLoggingEnabled() {
        return false;
    }

    public void setMessageLoggingEnabled(boolean SSLMessageLogging) {
    }

    public CSIv2EffectivePerformPolicy getEffectivePolicy() {
        return this.effectivePolicy;
    }

    public void setEffectivePolicy(CSIv2EffectivePerformPolicy policy) {
        this.effectivePolicy = policy;
    }
}

