/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAToken;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.security.Key;
import java.util.Iterator;
import java.util.Map;

public class LTPATokenFactory
implements TokenFactory {
    private static final TraceComponent tc = Tr.register(LTPATokenFactory.class, "Security", "com.ibm.ejs.resources.security");
    private Long _expirationLimit = null;
    private byte[] _sharedKey = null;
    private LTPAPublicKey _publicKey = null;
    private LTPAPrivateKey _privateKey = null;
    private Map _validationKeys = null;

    public void initialize(Map tokenFactoryMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            this._expirationLimit = (Long)tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.expiration");
            this._sharedKey = (byte[])tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
            this._publicKey = (LTPAPublicKey)tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
            this._privateKey = (LTPAPrivateKey)tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
            this._validationKeys = (Map)tokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_validation_keys");
        }
        catch (Exception e) {
            Tr.debug(tc, "Exception initializing LTPAToken2Factory.", new Object[]{e});
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", "56");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Token validateTokenBytes(byte[] _token_data) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenBytes");
        }
        LTPAToken validatedToken = null;
        if (this._sharedKey != null && this._publicKey != null && this._privateKey != null) {
            validatedToken = new LTPAToken(_token_data, this._sharedKey, this._privateKey, this._publicKey);
            if (validatedToken != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateTokenBytes (success)");
                }
                return validatedToken;
            }
        } else if (this._validationKeys != null) {
            Throwable lastException = null;
            for (Map keyMap : this._validationKeys.values()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating using keyMap: " + keyMap);
                }
                if (keyMap == null) continue;
                Iterator keys = keyMap.values().iterator();
                byte[] _sharedKeyForValidation = null;
                LTPAPublicKey _publicKeyForValidation = null;
                LTPAPrivateKey _privateKeyForValidation = null;
                while (keys.hasNext()) {
                    Object keyType = keys.next();
                    if (keyType instanceof Key) {
                        _sharedKeyForValidation = ((Key)keyType).getEncoded();
                        continue;
                    }
                    if (!(keyType instanceof KeyPair)) continue;
                    _publicKeyForValidation = new LTPAPublicKey(((KeyPair)keyType).getPublicKey().getEncoded());
                    _privateKeyForValidation = new LTPAPrivateKey(((KeyPair)keyType).getPrivateKey().getEncoded());
                }
                if (_sharedKeyForValidation == null || _publicKeyForValidation == null || _privateKeyForValidation == null) continue;
                try {
                    validatedToken = new LTPAToken(_token_data, _sharedKeyForValidation, _privateKeyForValidation, _publicKeyForValidation);
                    if (validatedToken == null) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateTokenBytes (success)");
                    }
                    return validatedToken;
                }
                catch (Exception e) {
                    if (e instanceof TokenExpiredException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "validateTokenBytes (expired)");
                        }
                        throw (TokenExpiredException)e;
                    }
                    lastException = e;
                    Tr.debug(tc, "Exception validating LTPAToken using validation keys.", new Object[]{e.getMessage()});
                }
            }
            if (lastException != null && lastException instanceof InvalidTokenException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateTokenBytes (invalid token)");
                }
                throw (InvalidTokenException)lastException;
            }
            if (lastException != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateTokenBytes (" + lastException.getClass().getName() + ")");
                }
                throw new InvalidTokenException(lastException.getMessage(), lastException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateTokenBytes (unknown error)");
            }
            throw new InvalidTokenException("Error validating LTPA token.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenBytes (no keys)");
        }
        throw new InvalidTokenException("Token factory not properly initialized.");
    }

    public Token createToken(Map tokenMap) throws TokenCreationFailedException {
        String userUniqueId = (String)tokenMap.get("com.ibm.wsspi.security.cred.uniqueId");
        if (userUniqueId == null || userUniqueId.length() == 0) {
            throw new TokenCreationFailedException("UniqueID is null.");
        }
        return new LTPAToken(userUniqueId, this._expirationLimit, this._sharedKey, this._privateKey, this._publicKey);
    }
}

