/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ws.security.util.ByteArray;
import java.security.PublicKey;

public final class LTPAPublicKey
implements PublicKey {
    private byte[][] rawKey;
    private byte[] encodedKey = null;
    private int nLength = 129;
    private int eLength = 3;

    public LTPAPublicKey() {
    }

    LTPAPublicKey(byte[][] key) {
        this.rawKey = key;
        this.encodedKey = this.encode();
    }

    LTPAPublicKey(byte[] encodedKey) {
        this.encodedKey = encodedKey;
        this.rawKey = this.decode(encodedKey);
    }

    private byte[][] decode(byte[] encPubKey) {
        byte[][] tmpPub = new byte[][]{new byte[this.nLength], new byte[this.eLength]};
        ByteArray.copy(encPubKey, 0, this.nLength, tmpPub[0], 0);
        ByteArray.copy(encPubKey, this.nLength, this.eLength, tmpPub[1], 0);
        return tmpPub;
    }

    private byte[] encode() {
        int pubLen = this.nLength + this.eLength;
        byte[] encPubKey = new byte[pubLen];
        ByteArray.copy(this.rawKey[0], 0, this.nLength, encPubKey, 0);
        ByteArray.copy(this.rawKey[1], 0, this.eLength, encPubKey, this.nLength);
        this.encodedKey = (byte[])encPubKey.clone();
        return encPubKey;
    }

    public boolean equals(Object object) {
        byte[] enc2;
        int len;
        if (this == object) {
            return true;
        }
        if (object instanceof LTPAPublicKey && (len = this.encodedKey.length) == (enc2 = ((LTPAPublicKey)object).getEncoded()).length) {
            for (int i = 0; i < len; ++i) {
                if (this.encodedKey[i] == enc2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAlgorithm() {
        return "RSA/SHA-1";
    }

    public byte[] getEncoded() {
        return (byte[])this.encodedKey.clone();
    }

    public String getFormat() {
        return "LTPAFormat";
    }

    byte[][] getRawKey() {
        return (byte[][])this.rawKey.clone();
    }
}

