/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import java.util.Map;
import java.util.Properties;

public class LTPAKeyHelper {
    private static final TraceComponent tc = Tr.register(LTPAKeyHelper.class, "Security", "com.ibm.ejs.resources.security");
    public static final String SHARED_KEY_PROPERTY = "com.ibm.websphere.ltpa.3DESKey";
    public static final String PUBLIC_KEY_PROPERTY = "com.ibm.websphere.ltpa.PublicKey";
    public static final String PRIVATE_KEY_PROPERTY = "com.ibm.websphere.ltpa.PrivateKey";
    private String publicKey = null;
    private String privateKey = null;
    private String shareKey = null;
    private String encKeyStorePwd = null;

    public LTPAKeyHelper(String ksGroupName) throws KeyException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LTPAKeyHelper " + ksGroupName);
        }
        Map latestKeys = KeySetGroupManager.getInstance().getKeySetGroup(ksGroupName).getLatestKeys();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get the latest keys = " + latestKeys);
        }
        WSKeySet[] allKeySets = KeySetGroupManager.getInstance().getKeySetGroup(ksGroupName).getAllKeySets();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "get all key sets = " + allKeySets);
        }
        String keyPairPwd = null;
        String sharedKeyPwd = null;
        for (int i = 0; i < allKeySets.length; ++i) {
            WSKeySet kset = allKeySets[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySet = " + kset.toString());
            }
            if (kset == null || kset.getPassword() == null) continue;
            if (kset.getIsKeyPair()) {
                keyPairPwd = kset.getPassword();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "keyPairPwd = " + (keyPairPwd != null ? "*****" : null));
                continue;
            }
            sharedKeyPwd = kset.getPassword();
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "sharedKeyPwd = " + (sharedKeyPwd != null ? "*****" : null));
        }
        String keyStorePwd = null;
        if (keyPairPwd != null) {
            keyStorePwd = keyPairPwd;
        } else if (sharedKeyPwd != null) {
            keyStorePwd = sharedKeyPwd;
        }
        try {
            this.encKeyStorePwd = PasswordUtil.passwordEncode(keyStorePwd);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "encKeyStorePwd = " + (this.encKeyStorePwd != null ? "*****" : null));
            }
            Properties ssoProps = null;
            LTPAServerObject ltpaServer = new LTPAServerObject();
            if (ltpaServer != null) {
                ssoProps = ltpaServer.exportSSOProperties(keyStorePwd.getBytes("UTF8"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaServer is null! not good.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ssoProps = " + ssoProps);
            }
            this.shareKey = ssoProps.getProperty(SHARED_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shareKey = " + this.shareKey);
            }
            this.privateKey = ssoProps.getProperty(PRIVATE_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "privateKey = " + this.privateKey);
            }
            this.publicKey = ssoProps.getProperty(PUBLIC_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "publicKey = " + this.publicKey);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.ltpaKeyHelper", "123", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LTPAKeyHelper", e.getMessage());
            }
            throw e;
        }
        if (this.shareKey == null || this.shareKey.length() == 0) {
            throw new Exception("shareKey is Null");
        }
        if (this.privateKey == null || this.privateKey.length() == 0) {
            throw new Exception("privateKey is Null");
        }
        if (this.publicKey == null || this.publicKey.length() == 0) {
            throw new Exception("publicKey is Null");
        }
        if (keyStorePwd == null || keyStorePwd.length() == 0) {
            throw new Exception("keyStorePwd is Null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LTPAKeyHelper");
        }
    }

    public String getLTPAPublicKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAPublicKey");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAPublicKey " + this.publicKey);
        }
        return this.publicKey;
    }

    public String getLTPAPrivateKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAPrivateKey");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAPrivateKey " + this.privateKey);
        }
        return this.privateKey;
    }

    public String getSharedKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedKey");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedKey " + this.shareKey);
        }
        return this.shareKey;
    }

    public String getKeyStorePassword() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyStorePassword");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStorePassword " + (this.encKeyStorePwd != null ? "*****" : null));
        }
        return this.encKeyStorePwd;
    }
}

