/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.util.ByteArray;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.spec.DESedeKeySpec;

class KeyEncryptor {
    private static final TraceComponent tc = Tr.register(KeyEncryptor.class, null, "com.ibm.ejs.resources.security");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static final String ENCRYPT_ALGORITHM = "DESede";
    byte[] password;
    byte[] desKey;
    LTPACrypto des;

    KeyEncryptor(byte[] password) {
        this.password = password;
        MessageDigest md2 = null;
        if (LTPAServerObject.useFIPS()) {
            try {
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
                this.desKey = new byte[24];
                byte[] digest = md2.digest(this.password);
                ByteArray.copy(digest, 0, digest.length, this.desKey, 0);
                DESedeKeySpec kSpec = new DESedeKeySpec(this.desKey);
                this.desKey = kSpec.getKey();
            }
            catch (NoSuchAlgorithmException e) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{e});
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", "41", this);
            }
            catch (NoSuchProviderException e) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{e});
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", "43", this);
            }
            catch (InvalidKeyException e) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{e});
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", "46", this);
            }
        } else {
            try {
                md2 = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                this.desKey = new byte[24];
                byte[] digest = md2.digest(this.password);
                ByteArray.copy(digest, 0, digest.length, this.desKey, 0);
                this.desKey[20] = 0;
                this.desKey[21] = 0;
                this.desKey[22] = 0;
                this.desKey[23] = 0;
            }
            catch (NoSuchAlgorithmException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", "21", this);
            }
        }
        this.des = new LTPACrypto();
    }

    byte[] decrypt(byte[] encrKey) {
        return LTPACrypto.decrypt(encrKey, this.desKey);
    }

    byte[] encrypt(byte[] key) {
        return LTPACrypto.encrypt(key, this.desKey);
    }
}

