/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustedAuthenticationRealm;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CrossRealmUtil {
    private static final TraceComponent tc = Tr.register(CrossRealmUtil.class, "Security", "com.ibm.ejs.resources.security");
    private static final String realmSeparator = "/";
    private static final String typeSeparator = ":";

    public static boolean isUserFromThisRealm(String name) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUserFromThisRealm", name);
        }
        boolean retVal = false;
        String realm = null;
        try {
            int realmIdx = name.indexOf(realmSeparator);
            realm = CrossRealmUtil.getUserRegistry().getRealm();
            if (realmIdx >= 0) {
                int typeIdx = name.indexOf(typeSeparator);
                retVal = realmIdx - typeIdx - 1 == realm.length() && name.startsWith(realm, typeIdx + 1);
            }
        }
        catch (Exception ex) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CrossRealmUtil.isUserFromThisRealm caught exception: " + ex.getMessage());
            }
            FFDCFilter.processException(ex, "com.ibm.ws.security.ltpa.CrossRealmUtil.isUserFromThisRealm", "71");
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserFromThisRealm", new Boolean(retVal));
        }
        return retVal;
    }

    public static boolean isUserFromTrustedForeignRealm(String name) throws Exception {
        boolean retVal;
        block27: {
            int rIdx;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isUserFromTrustedForeignRealm", name);
            }
            if (name == null || name.length() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isUserFromTrustedForeignRealm", "realm is null. returing false");
                }
                return false;
            }
            retVal = false;
            String adminRealm = SecurityObjectLocator.getSecurityConfig("security").getActiveUserRegistry().getString("realm");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminRealm =  " + adminRealm);
            }
            if ((rIdx = name.indexOf(realmSeparator)) >= 0 && adminRealm != null) {
                int tIdx = name.indexOf(typeSeparator);
                String thisRealm = name.substring(tIdx + 1, rIdx);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "thisRealm = " + thisRealm);
                }
                if (adminRealm.equals(thisRealm)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isUserFromTrustedForeignRealm", "realm matches admin realm, returing true");
                    }
                    return true;
                }
            } else if (rIdx <= 0) {
                try {
                    if (!DomainInfo.isAppRealmDefined()) {
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            TrustedAuthenticationRealm trustedRealms = SecurityObjectLocator.getSecurityConfig().getInboundTrustedAuthenticationRealm();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "trustedRealms = " + trustedRealms);
            }
            if (trustedRealms != null && !(retVal = trustedRealms.getTrustAllRealms())) {
                String realmsList = trustedRealms.getRealmList();
                if (realmsList == null || realmsList.length() <= 0) {
                    retVal = false;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "realmsList = " + realmsList);
                    }
                    try {
                        int realmIdx = name.indexOf(realmSeparator);
                        if (realmIdx >= 0) {
                            StringTokenizer st = new StringTokenizer(realmsList, "|");
                            while (st.hasMoreTokens()) {
                                int typeIdx;
                                String nextRealm = st.nextToken();
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "trying to match a foreign realm: " + name + " to a realm: " + nextRealm + " from the configured inbound trusted relams");
                                }
                                if (realmIdx - (typeIdx = name.indexOf(typeSeparator)) - 1 != nextRealm.length() || !name.startsWith(nextRealm, typeIdx + 1)) continue;
                                retVal = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "matched a trusted realm: " + nextRealm);
                                }
                                break block27;
                            }
                            break block27;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "cannot find relam name for this foreign user: " + name);
                        }
                    }
                    catch (Exception ex) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CrossRealmUtil.isUserFromTrustedForeignRealm caught exception: " + ex.getMessage());
                        }
                        FFDCFilter.processException(ex, "com.ibm.ws.security.ltpa.CrossRealmUtil.isUserFromTrustedForeignRealm", "173");
                        throw ex;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUserFromTrustedForeignRealm", new Boolean(retVal));
        }
        return retVal;
    }

    public static WSCredential getCredForForeignUser(String name) throws Exception {
        String realm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCredForForeignUser: " + name);
        }
        WSCredential cred = null;
        int realmIdx = name.indexOf(realmSeparator);
        int typeIdx = name.indexOf(typeSeparator);
        final String realmPriv = realm = name.substring(typeIdx + 1, realmIdx);
        final String displayNamePriv = name;
        final ArrayList groupListPriv = new ArrayList();
        final String accessId = name;
        final String longSecurityName = name;
        try {
            cred = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new WSCredentialImpl(realmPriv, displayNamePriv, longSecurityName, RegistryUtil.nullString, accessId, null, groupListPriv);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{e.getException()});
            }
            FFDCFilter.processException(e, "com.ibm.ws.security.ltpa.CrossRealmUtil.getCredForForeignUser", "221");
            throw e.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredForForeignUser");
        }
        return cred;
    }

    public static UserRegistryImpl getUserRegistry() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserRegistry");
        }
        UserRegistryImpl userRegistry = (UserRegistryImpl)SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getUserRegistryImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserRegistry");
        }
        return userRegistry;
    }
}

