/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ejb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.ejb.BeanAccessContext;
import com.ibm.ws.security.ejb.BeanAccessPermission;
import com.ibm.ws.security.ejb.BeanPermissionRoleMap;
import com.ibm.wsspi.security.policy.EJBSecurityPolicy;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.ExcludeList;

public class BeanAccessManager
extends WSAccessManager {
    private static TraceComponent tc = Tr.register(BeanAccessManager.class, null, "com.ibm.ejs.resources.security");

    public SecurityRole[] getRequiredRoles(AccessContext ctx, String beanName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRequiredRoles" + ctx.getEnterpriseAppName() + " " + beanName + " " + methodName);
        }
        PermissionRoleMap permRoleMap = ((BeanAccessContext)ctx).getPermissionRoleMap();
        BeanAccessPermission beanAccessPerm = new BeanAccessPermission(beanName, methodName);
        SecurityRole[] roles = null;
        if (permRoleMap != null) {
            roles = permRoleMap.getRequiredRoles(ctx, beanAccessPerm);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returned PermissionRoleMap is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRequiredRoles", roles);
        }
        return roles;
    }

    public boolean allowIfNoRequiredRoles() {
        return true;
    }

    public boolean isExcluded(AccessContext accessCtx, String resourceName, String methodName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExcluded(AccessContext,String,String)", new Object[]{accessCtx, resourceName, methodName});
        }
        boolean result = false;
        BeanAccessContext beanContext = null;
        EJBSecurityPolicy policy = null;
        if (!(accessCtx instanceof BeanAccessContext)) {
            throw new IllegalArgumentException("AccessContext received is not a BeanAccessContext: " + accessCtx);
        }
        beanContext = (BeanAccessContext)accessCtx;
        policy = beanContext.getEJBSecurityPolicy();
        if (policy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EJBSecurityPolicy is null, check in deployment descriptor.");
            }
            result = this.isExcludedFromDD(accessCtx, resourceName, methodName);
        } else {
            result = policy.isDenyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isExcluded(AccessContext,String,String)", result);
        }
        return result;
    }

    public boolean isExcludedFromDD(AccessContext accessCtx, String resourceName, String methodName) {
        BeanAccessContext ctx = (BeanAccessContext)accessCtx;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExcluded " + resourceName + ":" + methodName);
        }
        ExcludeList excludeList = null;
        if (ctx.getEjbJar() != null && ctx.getEjbJar().getAssemblyDescriptor() != null) {
            excludeList = ctx.getEjbJar().getAssemblyDescriptor().getExcludeList();
        }
        if (excludeList == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isExcluded No Exclude List, isExcluded is false ");
            }
            return false;
        }
        EList methodElements = excludeList.getMethodElements();
        int index = resourceName.lastIndexOf(58);
        String beanName = resourceName.substring(index + 1);
        if (methodElements != null && methodElements.size() != 0 && BeanPermissionRoleMap.findMatchingMethod(beanName, methodName, methodElements)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isExcluded is true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isExcluded is false");
        }
        return false;
    }
}

