/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.delegation.MethodDelegation;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.SAFServiceResult;
import com.ibm.ws.security.zOS.authz.SAFRoleMapperFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.security.auth.Subject;

class SAFMethodDelegation
extends MethodDelegation {
    private static final TraceComponent tc = Tr.register(SAFMethodDelegation.class, "Security", "com.ibm.ejs.resources.security");
    private static final SAFRoleMapper _roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();
    public static final String AUTH_CACHE_SUPPORT_CUSTOM_KEY = "com.ibm.websphere.security.util.authCacheCustomKeySupport";
    private boolean customCacheKeySupport = false;
    private String activeUserRegistry = null;
    private static boolean initialized = false;

    public SAFMethodDelegation() {
        String cckSupport;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if ((cckSupport = System.getProperty(AUTH_CACHE_SUPPORT_CUSTOM_KEY)) == null || cckSupport.equalsIgnoreCase("false") || cckSupport.equalsIgnoreCase("no")) {
            this.customCacheKeySupport = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Custom Cache Key support is disabled.");
            }
        } else {
            this.customCacheKeySupport = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Custom Cache Key support is enabled.");
            }
        }
        if (!initialized) {
            Tr.audit(tc, "security.zos.saf.delegation.enabled");
        }
        initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    protected Subject getRunAsSpecifiedUserSubject(String role, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSpecifiedUserSubject", new Object[]{role, appName});
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        Subject invocationSubject = null;
        String profile = _roleMapper.getProfileFromRole(appName, role);
        PlatformCredentialManager pcm = PlatformCredentialManager.instance();
        final PlatformCredential pc = pcm.createRoleCredential(appName, role, profile);
        if (pc != null) {
            String username = pc.getUserId();
            try {
                Subject cacheSubject = null;
                if (!this.customCacheKeySupport) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Custom Cache Key support is disabled, setting the auditString as the cacheKey.");
                    }
                    cacheSubject = new Subject();
                    Hashtable<String, String> cacheKeyTable = new Hashtable<String, String>();
                    cacheKeyTable.put("com.ibm.wsspi.security.cred.cacheKey", pc.getCacheKeyString());
                    cacheSubject.getPublicCredentials().add(cacheKeyTable);
                }
                String realm = contextManager.getDefaultRealm();
                String authMech = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.ws.security.defaultLoginConfig");
                invocationSubject = contextManager.login(realm, username, authMech, null, null, null, cacheSubject);
                final WSCredential invokedCred = SubjectHelper.getWSCredentialFromSubject(invocationSubject);
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        invokedCred.set("com.ibm.ws.security.zos.PlatformCredential", pc);
                        return null;
                    }
                });
                this.clearPropagationTokenIfCallerSubjectNullOrUnauthenticated();
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.delegation.SAFMethodDelegation.getRoleCredential", "197", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception setting PlatformCredential", e.getException());
                }
                invocationSubject = null;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.delegation.SAFMethodDelegation.getRoleCredential", "203", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during SAF role to user mapping", ex);
                }
                Tr.audit(tc, "security.authn.failed.foruser", new Object[]{username});
                invocationSubject = null;
            }
        }
        if (pc == null) {
            SAFServiceResult serviceResult = SAFServiceResult.getSafServiceResult();
            Tr.error(tc, "security.zos.saf.delegation.service.error", new Object[]{role, appName, serviceResult});
        }
        if (invocationSubject == null) {
            Tr.warning(tc, "security.zos.saf.delegation.using.caller.warning", new Object[]{role, appName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsSpecifiedUserSubject", invocationSubject);
        }
        return invocationSubject;
    }
}

