/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;

class NoDelegation
implements Delegation {
    private static AuditService auditService = null;
    private static ContextHandler contextHandler = null;
    private String activeUserRegistry = null;
    private static ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final TraceComponent tc = Tr.register(NoDelegation.class, "Security", "com.ibm.ejs.resources.security");

    NoDelegation() {
    }

    public Subject delegate(EJBKey ejbKey, EJBMethodInfo methodInfo, Subject ownSubject, Subject receivedSubject, SecurityBeanCookie beanCookie, String methodName) throws CSIException {
        if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        if (ownSubject == null) {
            try {
                ownSubject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSSecurityException {
                        return NoDelegation.this.contextManager.getServerSubject();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                WSSecurityException e = (WSSecurityException)pae.getException();
                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".delegate", "69", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting getServerCredential " + e);
                }
                if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_DELEGATION", "FAILURE")) {
                    if (contextHandler != null) {
                        String rSubj = null;
                        if (ownSubject != null) {
                            rSubj = ((Principal)ownSubject.getPrincipals().toArray()[0]).getName();
                        }
                        HashMap data = DataHelper.buildSessionData(null, null, null, null);
                        contextHandler.buildContextObject("SESSION_CONTEXT", data);
                        data = beanCookie != null ? DataHelper.buildAccessData(methodInfo != null ? methodInfo.getMethodName() : null, "delegation", rSubj, rSubj, null, beanCookie.getAppName().concat(":").concat(beanCookie.getBeanName()).concat(":").concat(methodName), ejbKey != null ? "ejb" : "web", new Long(0L), null, null, null, null) : DataHelper.buildAccessData(methodInfo != null ? methodInfo.getMethodName() : null, "delegation", rSubj, rSubj, null, null, ejbKey != null ? "ejb" : "web", new Long(0L), null, null, null, null);
                        contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                        data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                        contextHandler.buildContextObject("EVENT_CONTEXT", data);
                        data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                        contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                        data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                        contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                        data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                        contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                        data = DataHelper.buildDelegationData("noDelegaton", "ownId", rSubj);
                        contextHandler.buildContextObject("APPLICATION_DELEGATION", data);
                        auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(0), new Integer(0), "FAILURE", 87L);
                    }
                    try {
                        auditService.sendEvent("SECURITY_AUTHN_DELEGATION", auditOutcome);
                    }
                    catch (ProviderFailureException pe) {
                        Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pe});
                        String msg = "security.audit.service.sendevent.error";
                        auditService.processAuditFailure(msg, pe);
                    }
                }
                throw new CSIException(e.getMessage(), (Throwable)e);
            }
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_DELEGATION", "SUCCESS")) {
            if (contextHandler != null) {
                String rSubj = null;
                if (ownSubject != null) {
                    rSubj = ((Principal)ownSubject.getPrincipals().toArray()[0]).getName();
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = beanCookie != null ? DataHelper.buildAccessData(methodInfo != null ? methodInfo.getMethodName() : null, "delegation", rSubj, rSubj, null, beanCookie.getAppName().concat(":").concat(beanCookie.getBeanName()).concat(":").concat(methodName), ejbKey != null ? "ejb" : "web", new Long(0L), null, null, null, null) : DataHelper.buildAccessData(methodInfo != null ? methodInfo.getMethodName() : null, "delegation", rSubj, rSubj, null, null, ejbKey != null ? "ejb" : "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildDelegationData("noDelegaton", "ownId", rSubj);
                contextHandler.buildContextObject("APPLICATION_DELEGATION", data);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 86L);
            }
            try {
                auditService.sendEvent("SECURITY_AUTHN_DELEGATION", auditOutcome);
            }
            catch (ProviderFailureException pe) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pe});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, pe);
            }
        }
        return ownSubject;
    }

    public Subject delegate(Subject receivedSubject, String contextRoot, WebAccessContext webAccessContext, String servletName) throws CSIException {
        return this.delegate(null, null, null, null, null, null);
    }
}

