/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.ejb.BeanPermissionRoleMap;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.policy.RunAsPolicyExtension;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.policy.EJBSecurityPolicy;
import com.ibm.wsspi.security.policy.WSPolicy;
import com.ibm.wsspi.security.token.PropagationToken;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

class MethodDelegation
implements Delegation {
    private String runAsValue = new String();
    private static AuditService auditService = null;
    private static ContextHandler contextHandler = null;
    private String activeUserRegistry = null;
    private static ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    private static boolean auditServiceRetrieved = false;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static int MAX_EJBNAME_ENTRIES = 200;
    private static HashMap ejbNameCache = new HashMap(MAX_EJBNAME_ENTRIES);
    private static final TraceComponent tc = Tr.register(MethodDelegation.class, "Security", "com.ibm.ejs.resources.security");

    MethodDelegation() {
    }

    protected boolean checkRunAsMethod(SecurityIdentity secIdentity, String beanName, String methodName) {
        EList methodElements = secIdentity.getMethodElements();
        return methodElements != null && methodElements.size() != 0 && BeanPermissionRoleMap.findMatchingMethod(beanName, methodName, methodElements);
    }

    public Subject delegate(EJBKey ejbKey, EJBMethodInfo methodInfo, Subject ownSubject, Subject receivedSubject, SecurityBeanCookie beanCookie, String methodName) throws CSIException {
        EJBSecurityPolicy policy;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delegate(EJBKey,EJBMethodInfo,Subject,Subject,SecurityBeanCookie,String)", new Object[]{ejbKey, methodInfo, ownSubject, receivedSubject, beanCookie});
        }
        Subject invokedSubject = null;
        EJBSecurityPolicy eJBSecurityPolicy = policy = methodInfo == null ? null : methodInfo.getEJBSecurityPolicy();
        if (policy == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "EJBSecurityPolicy is null, using delegation policy in deployment descriptor.");
            }
            throw new CSIException("Policy is null");
        }
        RunAsPolicyExtension extension2 = (RunAsPolicyExtension)((WSPolicy)((Object)policy)).getExtensionAdapter(RunAsPolicyExtension.class);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Find RunAs delegation policy", new Object[]{policy, extension2});
        }
        if (extension2 != null) {
            String role;
            if (extension2.isRunAsCallerIdentity(methodName) || policy.isRunAsCallerIdentity()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RunAsCallerIdentity");
                }
                this.runAsValue = "clientId";
                invokedSubject = receivedSubject;
            } else if (extension2.isRunAsSystemIdentity(methodName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RunAsSystemIdentity");
                }
                this.runAsValue = "systemId";
                invokedSubject = ownSubject;
            } else if (extension2.isRunAsSpecifiedIdentity(methodName)) {
                role = extension2.getRunAsSpecifiedIdentity(methodName);
                this.runAsValue = "specifiedId".concat(":").concat(role);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RunAsSpecifiedIdentity, role=" + role);
                }
                if ((invokedSubject = this.getRunAsSpecifiedUserSubject(role, beanCookie.getAppName())) == null) {
                    invokedSubject = receivedSubject;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getRunAsSpecifiedUserSubject is null, use received (caller) Subject");
                    }
                }
            } else {
                role = policy.getRunAsSpecifiedIdentity();
                if (role != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RunAsSpecifiedIdentity, role=" + role);
                    }
                    this.runAsValue = "specifiedId".concat(":").concat(role);
                    invokedSubject = this.getRunAsSpecifiedUserSubject(role, beanCookie.getAppName());
                    if (invokedSubject == null) {
                        invokedSubject = receivedSubject;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getRunAsSpecifiedUserSubject is null, use received (caller) Subject");
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No RunAs policy found, RunAs caller by default.");
                    }
                    this.runAsValue = "clientId";
                    invokedSubject = receivedSubject;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delegate(EJBKey,EJBMethodInfo,Subject,Subject,SecurityBeanCookie,String)", invokedSubject);
        }
        if (!auditServiceRetrieved && auditService == null) {
            auditService = ContextManagerFactory.getInstance().getAuditService();
            auditServiceRetrieved = true;
            if (auditService != null && (contextHandler = auditService.getContextHandler()) == null) {
                Tr.error(tc, "security.audit.service.context.error");
                String msg = "security.audit.service.context.error";
                auditService.processAuditFailure(msg, null);
            }
        }
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_DELEGATION", "SUCCESS")) {
            if (contextHandler != null) {
                SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                this.activeUserRegistry = security2.getActiveUserRegistry().getType();
                String rSubj = null;
                if (invokedSubject != null) {
                    rSubj = ((Principal)invokedSubject.getPrincipals().toArray()[0]).getName();
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                String resType = null;
                resType = ejbKey != null ? "ejb" : "sca";
                data = DataHelper.buildAccessData(methodInfo != null ? methodInfo.getMethodName() : null, "delegation", rSubj, rSubj, null, beanCookie.getAppName().concat(":").concat(beanCookie.getBeanName()).concat(":").concat(methodName), resType, new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildDelegationData("runAsDelegaton", this.runAsValue, rSubj);
                contextHandler.buildContextObject("APPLICATION_DELEGATION", data);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 86L);
            }
            try {
                auditService.sendEvent("SECURITY_AUTHN_DELEGATION", auditOutcome);
            }
            catch (ProviderFailureException pe) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pe});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, pe);
            }
        }
        return invokedSubject;
    }

    public Subject delegate(Subject receivedSubject, String contextRoot, WebAccessContext webAccessContext, String servletName) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "delegate " + servletName);
        }
        Subject invokedSubject = receivedSubject;
        this.runAsValue = "clientId";
        WebApp webApp = webAccessContext.getWebApp();
        Servlet servlet = null;
        if (webApp != null && servletName != null) {
            servlet = webApp.getServletNamed(servletName);
        }
        if (servlet != null) {
            RunAsSpecifiedIdentity runAs = servlet.getRunAs();
            if (runAs != null) {
                Identity identity;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RunAs Specified for servlet" + servletName);
                }
                if ((identity = runAs.getIdentity()) != null) {
                    String role = identity.getRoleName();
                    this.runAsValue = "specifiedId".concat(":").concat(role);
                    invokedSubject = this.getRunAsSpecifiedUserSubject(role, webAccessContext.getEnterpriseAppName());
                    if (invokedSubject == null) {
                        this.runAsValue = "clientId";
                        invokedSubject = receivedSubject;
                    }
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servlet not Specified in DD for servlet" + servletName);
        }
        if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        this.activeUserRegistry = security2.getActiveUserRegistry().getType();
        if (auditService != null && auditService.isEventRequired("SECURITY_AUTHN_DELEGATION", "SUCCESS")) {
            if (contextHandler != null) {
                String rSubj = null;
                if (invokedSubject != null) {
                    rSubj = ((Principal)invokedSubject.getPrincipals().toArray()[0]).getName();
                }
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                data = DataHelper.buildAccessData(webAccessContext != null ? webAccessContext.getWebAppName() : null, "delegation", rSubj, rSubj, null, null, "web", new Long(0L), null, null, null, null);
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(auditService.getLastTrailId(), auditService.getEventTrailIds(), new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), ContextManagerFactory.getInstance().getDefaultRealm());
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(this.activeUserRegistry));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildDelegationData("runAsDelegaton", this.runAsValue, rSubj);
                contextHandler.buildContextObject("APPLICATION_DELEGATION", data);
                auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 86L);
            }
            try {
                auditService.sendEvent("SECURITY_AUTHN_DELEGATION", auditOutcome);
            }
            catch (ProviderFailureException pe) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{pe});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, pe);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "delegate");
        }
        return invokedSubject;
    }

    protected static void clearDelegationCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearDelegationCache");
        }
        if (tc.isDebugEnabled()) {
            int size = ejbNameCache.size();
            Tr.debug(tc, "Clearing ejbNameCache. Size:" + size);
        }
        ejbNameCache.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearDelegationCache");
        }
    }

    protected Subject getRunAsSpecifiedUserSubject(String role, final String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSpecifiedUserSubject");
        }
        String myRealm = null;
        myRealm = DomainInfo.isAppRealmDefined() && appName != null && !WSAccessManager.checkIfAdminApp(appName) ? DomainInfo.getAppRealm() : DomainInfo.getAdminRealm();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsSpecifiedUserSubject: using realm: " + myRealm);
        }
        BasicAuthData authData = null;
        Subject invokedSubject = null;
        SecurityRole secRole = WCCMHelper.createSecurityRole(null, role);
        RunAsMap runAsMap = (RunAsMap)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityCollaborator.getRunAsMapTable();
                return RunAsMapTable.getRunAsMap(appName);
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RunAs set to Specified Identity : RunAs Role = " + role);
        }
        if (runAsMap != null) {
            authData = (BasicAuthData)runAsMap.getAuthData(secRole);
            if (authData != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "authData.getUserId(): " + authData.getUserId() + " length: " + authData.getUserId().length());
                }
                try {
                    invokedSubject = this.contextManager.login(myRealm, authData.getUserId(), authData.getPassword());
                    this.clearPropagationTokenIfCallerSubjectNullOrUnauthenticated();
                }
                catch (Exception e) {
                    if (authData.getUserId() != null && authData.getUserId().length() > 0) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.getRunAsSpecifiedUserSubject", "293", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception during user authentication:", e);
                        }
                        Tr.audit(tc, "security.authn.failed.foruser", new Object[]{authData.getUserId()});
                    }
                    invokedSubject = null;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRunAsSpecifiedUserSubject");
                }
                return invokedSubject;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Application Identity Not Configured");
                Tr.debug(tc, "Invocation (SPECIFIED) identity is set to ClientIdentity");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsSpecifiedUserSubject");
        }
        return invokedSubject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void clearPropagationTokenIfCallerSubjectNullOrUnauthenticated() {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated");
            }
            if (!WSCredentialTokenMapper.isAnyPropagationEnabled()) {
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated (prop disabled)");
                return;
            }
            try {
                String[] callerAttributes;
                PropagationToken token = this.contextManager.getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
                if (token == null) {
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated (no token on the thread)");
                    return;
                }
                Subject callerSubject = this.contextManager.getCallerSubject();
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(callerSubject);
                if (wsCred != null && !wsCred.isUnauthenticated()) {
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated (caller not null, prop token already set correctly)");
                    return;
                }
                if ((wsCred == null || wsCred.isUnauthenticated()) && (callerAttributes = token.getAttributes("com.ibm.wsspi.security.propagation.callers")) != null && callerAttributes.length == 1) {
                    this.contextManager.setPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1", null);
                    Enumeration attributeNames = token.getAttributeNames();
                    while (attributeNames.hasMoreElements()) {
                        String[] tokenAttributes;
                        String[] currentAttributes;
                        String attributeKey = (String)attributeNames.nextElement();
                        if (attributeKey == null || attributeKey.equals("com.ibm.wsspi.security.propagation.callers") || attributeKey.equals("com.ibm.wsspi.security.propagation.hosts") || (currentAttributes = WSSecurityHelper.getPropagationAttributes(attributeKey)) != null || (tokenAttributes = token.getAttributes(attributeKey)) == null || tokenAttributes.length <= 0) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding attributes for " + attributeKey + " to existing prop token");
                        }
                        for (int i = 0; i < tokenAttributes.length; ++i) {
                            WSSecurityHelper.addPropagationAttribute(attributeKey, tokenAttributes[i]);
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.clearPropagationTokenIfCallerSubjectNullOrUnauthenticated", "914", this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Exception determining if propagation token needs to be cleared.", new Object[]{e});
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "clearPropagationTokenIfCallerSubjectNullOrUnauthenticated");
    }
}

