/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.delegation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.delegation.MethodDelegation;
import com.ibm.ws.security.delegation.NoDelegation;
import com.ibm.ws.security.delegation.SAFMethodDelegation;
import com.ibm.ws.security.delegation.SimpleDelegation;

public class DelegationFactory {
    private static final TraceComponent tc = Tr.register(DelegationFactory.class, "Security", "com.ibm.ejs.resources.security");

    public static Delegation getDelegation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDelegation");
        }
        String delegationPolicy = ContextManagerFactory.getInstance().getProperty("com.ibm.CORBA.delegateCredentials");
        Delegation delegation = DelegationFactory.getDelegation(delegationPolicy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDelegation", delegation);
        }
        return delegation;
    }

    public static void clearDelegationCache() {
        MethodDelegation.clearDelegationCache();
    }

    private static Delegation getDelegation(String delegationPolicy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDelegation", delegationPolicy);
        }
        Delegation delegation = null;
        delegation = "simple".equalsIgnoreCase(delegationPolicy) ? new SimpleDelegation() : ("none".equalsIgnoreCase(delegationPolicy) ? new NoDelegation() : ("saf".equalsIgnoreCase(delegationPolicy) ? new SAFMethodDelegation() : new MethodDelegation()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDelegation", delegation);
        }
        return delegation;
    }

    private DelegationFactory() {
    }
}

