/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIClientRIBase;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CSIServerRIBase;
import com.ibm.ISecurityUtilityImpl.ServiceInit;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.connmgmt.ConnectionHandle;
import com.ibm.ws.orb.BOSSObjectKey;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.MultiDomainHelper;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import com.ibm.wsspi.iiop.channel.IIOPLocateFilter;
import com.ibm.wsspi.iiop.channel.IIOPServiceContextFilter;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ForwardRequest;

public class CSIv2ServiceContextFilter
implements IIOPServiceContextFilter,
IIOPLocateFilter {
    private static final TraceComponent tc = Tr.register(CSIv2ServiceContextFilter.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static String FORWARD_REQUEST_KEY = "CSIv2ForwardRequest";
    private static CSIv2ServiceContextFilter _instance = null;
    private ORB thisOrb = null;
    private CSIClientRIBase _csiClientRIBase = null;
    private CSIServerRIBase _csiServerRIBase = null;

    public static CSIv2ServiceContextFilter instance(ORB orb) {
        if (_instance == null) {
            _instance = new CSIv2ServiceContextFilter(orb);
        }
        return _instance;
    }

    private CSIv2ServiceContextFilter(ORB orb) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.thisOrb = orb;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            if (this.thisOrb != null) {
                if (!ServiceInit.isInitialized()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Initializing ServiceInit in SC Filter.");
                    }
                    ServiceInit si = ServiceInit.getInstance();
                    si.initialize(this.thisOrb);
                }
                this._csiClientRIBase = new CSIClientRIBase();
                this._csiClientRIBase.init(this.thisOrb);
                this._csiServerRIBase = new CSIServerRIBase();
                this._csiServerRIBase.init(this.thisOrb);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ORB is not available during init.");
                }
                throw new INITIALIZE("ORB not available for initialization");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void processIncomingContext(ORB orb, GIOPMessageContext msgCtx, GIOPConnectionContext connCtx, ConnectionStateElement elem) throws Exception {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processIncomingContext", new Object[]{orb, msgCtx, connCtx, elem});
        }
        if (msgCtx == null) {
            throw new IllegalArgumentException("GIOPMessageContext is null");
        }
        if (connCtx == null) {
            throw new IllegalArgumentException("GIOPConnectionContext is null");
        }
        if (elem == null) {
            throw new IllegalArgumentException("ConnectionStateElement is null");
        }
        ConnectionHandle connHandle = elem.getConnectionHandle();
        try {
            if (connHandle.isInternal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Internal request");
                }
            } else if (msgCtx.getType() == 0) {
                this._csiServerRIBase.removePrivateContext(msgCtx);
                this._csiServerRIBase.removeSeedContext(msgCtx);
                this._csiServerRIBase.doFilterReceiveRequest(connCtx, msgCtx, elem);
            } else if (msgCtx.getType() == 1) {
                String key = FORWARD_REQUEST_KEY + msgCtx.getRequestId();
                if (elem.getConnectionState(key) != null) {
                    elem.setConnectionState(key, null);
                } else {
                    this._csiServerRIBase.removePrivateContext(msgCtx);
                    this._csiServerRIBase.removeSeedContext(msgCtx);
                }
                this._csiClientRIBase.doFilterReceiveReply(connCtx, msgCtx, elem);
            }
        }
        catch (SystemException sysex) {
            Manager.Ffdc.log(sysex, this, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processIncomingContext", "187", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException while processing incoming service context", (Object)sysex);
            }
            throw sysex;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processIncomingContext", "193", this);
            String msg = "Exception while processing incoming CSIv2 service context";
            INTERNAL ex = new INTERNAL("Exception while processing incoming CSIv2 service context");
            ex.initCause((Throwable)e);
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processIncomingContext");
        }
    }

    public void processOutgoingContext(ORB orb, GIOPMessageContext msgCtx, GIOPConnectionContext connCtx, ConnectionStateElement elem) throws Exception {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processOutgoingContext", new Object[]{orb, msgCtx, connCtx, elem});
        }
        if (msgCtx == null) {
            throw new IllegalArgumentException("GIOPMessageContext is null");
        }
        if (connCtx == null) {
            throw new IllegalArgumentException("GIOPConnectionContext is null");
        }
        if (elem == null) {
            throw new IllegalArgumentException("ConnectionStateElement is null");
        }
        ConnectionHandle connHandle = elem.getConnectionHandle();
        try {
            if (connHandle.isInternal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Internal request");
                }
            } else if (msgCtx.getType() == 0) {
                this._csiClientRIBase.doFilterSendRequest(connCtx, msgCtx, elem);
                this._csiServerRIBase.removePrivateContext(msgCtx);
                this._csiServerRIBase.removeSeedContext(msgCtx);
            } else if (msgCtx.getType() == 1) {
                this._csiServerRIBase.doFilterSendReply(connCtx, msgCtx, elem);
                this._csiServerRIBase.removePrivateContext(msgCtx);
                this._csiServerRIBase.removeSeedContext(msgCtx);
            }
        }
        catch (ForwardRequest fr) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Percolating ForwardRequest", (Object)fr);
            }
            String key = FORWARD_REQUEST_KEY + msgCtx.getRequestId();
            elem.setConnectionState(key, (Object)new Boolean(true));
            throw fr;
        }
        catch (SystemException sysex) {
            Manager.Ffdc.log(sysex, this, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processOutgoingContext", "268", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SystemException while processing outgoing service context", (Object)sysex);
            }
            throw sysex;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processOutgoingContext", "274", this);
            String msg = "Exception while processing outgoing CSIv2 service context";
            INTERNAL ex = new INTERNAL("Exception while processing outgoing CSIv2 service context");
            ex.initCause((Throwable)e);
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processOutgoingContext");
        }
    }

    public boolean processIncomingLocate(BOSSObjectKey bossKey, Profile profile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processIncomingLocate", new Object[]{bossKey, profile});
        }
        byte[] securityDomain = bossKey.getSecurityDomain();
        boolean updated = false;
        if (securityDomain != null && securityDomain.length > 0) {
            String secDomain = new String(securityDomain);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved security domain: " + secDomain);
            }
            try {
                updated = MultiDomainHelper.interceptLocate(secDomain, profile);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.csiv2.CSIv2ServiceContextFilter.processIncomingLocate", "315", this);
                if (e.getMessage() != null) {
                    throw new INTERNAL("Exception while processing incoming locate request, exception: " + e.getMessage(), 1229066424, CompletionStatus.COMPLETED_NO);
                }
                String msg = "Exception while processing incoming locate request, exception: " + e.getClass().getName();
                throw new INTERNAL(msg, 1229066424, CompletionStatus.COMPLETED_NO);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processIncomingLocate", updated);
        }
        return updated;
    }

    public void processOutgoingLocate(BOSSObjectKey bossKey) {
    }
}

