/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.SecurityConfigComponentImpl;

public class SecurityConfigChangeListener
implements ConfigChangeListener {
    private static final TraceComponent tc = Tr.register(SecurityConfigChangeListener.class, "SecurityConfig", "com.ibm.ws.ssl.resources");

    public SecurityConfigChangeListener(SecurityConfigComponentImpl component2) {
    }

    public void configChanged(ConfigRepositoryEvent evt) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "configChanged", evt);
            }
            try {
                ConfigChangeNotifier[] notifiers = evt.getChanges();
                for (int i = 0; i < notifiers.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Document changed: " + notifiers[i].getUri());
                    }
                    String cellSecurityXMLPath = "cells/" + SecurityObjectLocator.getAdminData().getCellName() + "/security.xml";
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security.xml: " + cellSecurityXMLPath);
                    }
                    if (!notifiers[i].getUri().equalsIgnoreCase(cellSecurityXMLPath)) continue;
                    try {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "URI matches, reloading configuration");
                        continue;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.SecurityConfigChangeListener.configChanged", "94", this);
                        Tr.error(tc, "ssl.reinitialize.config.error.CWPKI0026E", new Object[]{e.getMessage()});
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.config.SecurityConfigChangeListener.configChanged", "103", this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception caught: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }
}

