/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.SecurityCookie;
import com.ibm.websphere.security.ProviderFailureException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.utils.DataHelper;
import com.ibm.ws.security.auth.Identity;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.authorize.WSPolicyContextHandlerImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.SecurityCookieImpl;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.ejb.BeanAccessContext;
import com.ibm.ws.security.ejb.BeanAccessManager;
import com.ibm.ws.security.ejb.BeanPermissionRoleMap;
import com.ibm.ws.security.ejb.BeanPermissionRoleMapTable;
import com.ibm.ws.security.ejb.EJBInitializer;
import com.ibm.ws.security.ejb.RunAsMapTable;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.policy.PolicyExtensionAdapterFactory;
import com.ibm.ws.security.policy.RunAsPolicyExtension;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.ContextHandler;
import com.ibm.wsspi.security.policy.EJBSecurityPolicy;
import com.ibm.wsspi.security.policy.WSPolicy;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EnterpriseBean;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.J2EEInit;

public abstract class SecurityCollaborator
implements com.ibm.websphere.csi.SecurityCollaborator,
EJBInitializer {
    private static TraceComponent tc = Tr.register(SecurityCollaborator.class, "Security", "com.ibm.ejs.resources.security");
    private static SecurityConfig security = null;
    protected static final String HOME = "Home";
    protected static final String BEAN = "Bean";
    protected static final String FIND = "find";
    protected static final String EJB_FIND = "ejbFind";
    protected static final String CREATE = "create";
    protected static final String EJB_CREATE = "ejbCreate";
    protected static final String REMOVE = "remove";
    protected static final String EJB_REMOVE = "ejbRemove";
    protected static final String GET_META_DATA = "getEJBMetaData";
    protected static final String EJB_GET_META_DATA = "ejbGetEJBMetaData";
    protected static ContextManager contextManager = ContextManagerFactory.getInstance();
    protected static boolean securityEnabled = false;
    protected static final int PUBLIC = 0;
    protected static final int ACCESSID = 1;
    protected static final int GROUPID = 2;
    protected static EJBJar ejbjar;
    protected static BeanPermissionRoleMapTable beanPermissionRoleMapTable;
    protected static AccessManager beanAccessManager;
    protected static RunAsMapTable runAsMapTbl;
    protected static boolean useJAACProvider;
    protected static int MAX_BEANACCESS_ENTRIES;
    protected static HashMap<String, BeanAccessContext> beanAccessContextCache;
    private static final WebSphereRuntimePermission runAsPerm;
    private static ContextHandler contextHandler;
    private static String providerName;
    private static AuditService auditService;
    private static String className;
    private static String default_realm;
    private ConcurrentHashMap auditOutcome = new ConcurrentHashMap();
    private static String[] jaccHandlerKeyArray;
    private static WSPolicyContextHandlerImpl wpch;
    private static boolean isAuditAuthzSuccessEventEnabled;
    private static boolean isAuditAuthzDeniedEventEnabled;
    protected Hashtable metadataMap = new Hashtable();

    public static RunAsMapTable getRunAsMapTable() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsMapTable");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(runAsPerm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsMapTable", new Boolean(runAsMapTbl == null));
        }
        return runAsMapTbl;
    }

    public static Subject getSubject(String uid, String password) throws LoginException, WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSubject");
        }
        Subject subject = null;
        try {
            subject = contextManager.login(contextManager.getDefaultRealm(), uid, password);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.core.SecurityCollaborator.getSubject", "236");
            Tr.debug(tc, "getSubject() exception occurred: ", new Object[]{e});
            subject = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSubject");
        }
        return subject;
    }

    public SecurityCollaborator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        className = this.getClass().getName();
        this.registerPolicyExtensionAdapter();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public static void initialize() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        securityEnabled = SecurityContext.isSecurityEnabled();
        security = SecurityObjectLocator.getSecurityConfig();
        useJAACProvider = security.getAuthorizationConfig().getBoolean("useJACCProvider");
        J2EEInit.init();
        runAsMapTbl = new RunAsMapTable();
        beanPermissionRoleMapTable = new BeanPermissionRoleMapTable();
        beanAccessManager = new BeanAccessManager();
        beanAccessContextCache = new HashMap(MAX_BEANACCESS_ENTRIES);
        if (auditService == null && (auditService = contextManager.getAuditService()) != null && (contextHandler = auditService.getContextHandler()) == null) {
            Tr.error(tc, "security.audit.service.context.error");
            String msg = "security.audit.service.context.error";
            auditService.processAuditFailure(msg, null);
        }
        default_realm = ContextManagerFactory.getInstance().getDefaultRealm();
        if (auditService != null) {
            isAuditAuthzDeniedEventEnabled = auditService.isEventRequired("SECURITY_AUTHZ", "DENIED");
            isAuditAuthzSuccessEventEnabled = auditService.isEventRequired("SECURITY_AUTHZ", "SUCCESS");
        }
        if (security.getAuthorizationConfig().getBoolean("useJACCProvider")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting the PolicyContextHandlers for JACC.");
            }
            jaccHandlerKeyArray = new String[]{"javax.security.auth.Subject.container", "javax.ejb.EnterpriseBean", "javax.ejb.arguments", "javax.xml.soap.SOAPMessage"};
            wpch = WSPolicyContextHandlerImpl.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void registerPolicyExtensionAdapter() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerPolicyExtensionAdapter()");
        }
        PolicyExtensionAdapterFactory adapterFactory = new PolicyExtensionAdapterFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)adapterFactory, WSPolicy.class);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerPolicyExtensionAdapter()", "WSPolicy adapter factory has been registered.");
        }
    }

    public void setPolicyExtensions(EJBConfigData ejbConfigData) {
        EJBComponentMetaData md2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setPolicyExtensions(EJBConfigData)", ejbConfigData);
        }
        if ((md2 = ejbConfigData.getEJBComponentMetaData()) == null) {
            throw new IllegalArgumentException("EJBComponentMetaData is null.");
        }
        MethodInterface[] iType = MethodInterface.getAllValues();
        for (int i = 0; i < iType.length; ++i) {
            EJBMethodInfo[] methodInfo;
            MethodInterface intf = iType[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MethodInterface = " + intf);
            }
            if ((methodInfo = md2.getEJBMethodMetaData(intf)) != null && methodInfo.length != 0) {
                for (int j = 0; j < methodInfo.length; ++j) {
                    EJBSecurityPolicy p = methodInfo[j].getEJBSecurityPolicy();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJBMethodInfo = " + methodInfo[j] + " EJBSecurityPolicy = " + p);
                    }
                    if (p instanceof WSPolicy) {
                        RunAsPolicyExtension policyExtension;
                        WSPolicy policy = (WSPolicy)((Object)p);
                        Object adapter = policy.getExtensionAdapter(RunAsPolicyExtension.class);
                        if (adapter != null) {
                            policyExtension = (RunAsPolicyExtension)adapter;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting RunAsPolicy extensions in " + policyExtension);
                            }
                        } else {
                            String msg = "RunAsPolicyExtension is null or an invalid type: " + adapter;
                            Tr.error(tc, msg);
                            throw new IllegalArgumentException(msg);
                        }
                        policyExtension.setEjbConfigData(ejbConfigData);
                        policyExtension.setEJBMethodInfo(methodInfo[j]);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Extensions metadata has been retrieved for Method = " + methodInfo[j].getMethodName());
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "EJBSecurityPolicy is not a WSPolicy, policy extensions will be ignored. EJBSecurityPolicy=" + p);
                }
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "EJBMethodInfo[] is null or empty = " + methodInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setPolicyExtensions(EJBConfigData)");
        }
    }

    public CollaboratorCookie installBean(EJBConfigData ejbConfigData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installBean");
        }
        String appName = ejbConfigData.getJ2EEName().getApplication();
        String moduleName = ejbConfigData.getJ2EEName().getModule();
        String beanName = ejbConfigData.getJ2EEName().getComponent();
        SecurityBeanCookie beanCookie = new SecurityBeanCookie(beanName, appName, moduleName);
        beanCookie.setEjbJar((EJBJar)ejbConfigData.getEJBJarDeploymentData());
        beanCookie.setRoleRefList(beanName, (EJBJar)ejbConfigData.getEJBJarDeploymentData());
        beanCookie.setRunAsSettings((EnterpriseBeanExtension)ejbConfigData.getDeploymentExtn());
        this.setPolicyExtensions(ejbConfigData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installBean");
        }
        return beanCookie;
    }

    public void setRunAsMap(String appName, ApplicationBinding appBinding) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRunAsMap");
        }
        RunAsMapTable.addRunAsMap(appName, appBinding.getRunAsMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRunAsMap");
        }
    }

    public abstract CollaboratorCookie preInvoke(EJBKey var1, EJBMethodInfo var2, CollaboratorCookie var3) throws CSIException;

    public abstract CollaboratorCookie preInvoke(EJBKey var1, EJBMethodInfo var2, CollaboratorCookie var3, Object var4, Object[] var5) throws CSIException;

    public abstract void ejbMethodParameterChange(EJBKey var1, EJBMethodInfo var2, CollaboratorCookie var3, Object var4, Object[] var5) throws CSIException;

    protected Subject performAuthorization(EJBKey ejbKey, EJBMethodInfo methodInfo, Subject ownSubject, Subject receivedSubject, Subject invokedSubject, SecurityBeanCookie beanCookie, Object bean, Object[] methodParameters, String methodName) throws CSIException {
        Exception accessException;
        boolean hasAccess;
        Subject curReceived;
        String beanName;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "performAuthorization");
            }
            beanName = beanCookie.getFullBeanName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "methodInfo.getMethodName() : " + methodName);
                Tr.debug(tc, "methodInfo.getHomeName() : " + methodInfo.getHomeName());
                Tr.debug(tc, "methodInfo.getJ2EEName() : " + ((Object)methodInfo.getJ2EEName()).toString());
                Tr.debug(tc, "methodInfo.isHome(): " + methodInfo.isHome());
                Tr.debug(tc, "methodInfo.getMethodSignature = " + methodInfo.getMethodSignature());
                Tr.debug(tc, "invokedSubject is null: " + (invokedSubject == null));
                Tr.debug(tc, "receivedSubject is null: " + (receivedSubject == null));
            }
            curReceived = invokedSubject == null ? receivedSubject : invokedSubject;
            hasAccess = false;
            accessException = null;
            try {
                if (!this.internalUnprotected(methodName)) {
                    if (!useJAACProvider) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling ejbCheckAuthorization");
                        }
                        this.ejbCheckAuthorization(beanName, methodName, curReceived, beanCookie, methodInfo);
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling ejbCheckAuthorization for JACC");
                        }
                        providerName = "JACC";
                        EnterpriseBean ejb = null;
                        if (bean instanceof EnterpriseBean) {
                            ejb = (EnterpriseBean)bean;
                        }
                        this.ejbCheckAuthorizationForJACC(methodName, curReceived, beanCookie, methodInfo, ejb, methodParameters);
                    }
                }
                hasAccess = true;
            }
            catch (Exception e) {
                hasAccess = false;
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "468", this);
                accessException = e;
                if (!tc.isDebugEnabled()) break block27;
                Tr.debug(tc, "Authorization failed accessing EJB ", e);
            }
        }
        String lastTrailId = null;
        String[] eventTrailIds = null;
        if (auditService != null) {
            lastTrailId = auditService.getLastTrailId();
            eventTrailIds = auditService.getEventTrailIds();
        }
        if (!hasAccess) {
            String beanType = methodInfo.isHome() ? HOME : BEAN;
            String sname = "???";
            if (curReceived != null) {
                WSCredential credential = SubjectHelper.getWSCredentialFromSubject(curReceived);
                try {
                    sname = credential.getRealmSecurityName();
                }
                catch (GeneralSecurityException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "489", this);
                    throw new CSIAccessException(e.getMessage(), (Throwable)e);
                }
            }
            Tr.audit(tc, "security.authz.failed.foruser", new Object[]{sname, beanType, ((Object)methodInfo.getJ2EEName()).toString(), methodName, accessException.getMessage()});
            if (auditService != null && isAuditAuthzDeniedEventEnabled) {
                HashMap data = DataHelper.buildSessionData(null, null, null, null);
                contextHandler.buildContextObject("SESSION_CONTEXT", data);
                String rSubj = null;
                if (receivedSubject != null) {
                    rSubj = ((Principal)receivedSubject.getPrincipals().toArray()[0]).getName();
                }
                data = beanName != null && methodName != null ? DataHelper.buildAccessData(beanName.concat(".").concat(methodName), "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null) : (beanName != null && methodName == null ? DataHelper.buildAccessData(beanName, "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null) : (beanName == null && methodName != null ? DataHelper.buildAccessData(methodName, "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null) : DataHelper.buildAccessData(null, "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null)));
                contextHandler.buildContextObject("ACCESS_CONTEXT", data);
                data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
                contextHandler.buildContextObject("EVENT_CONTEXT", data);
                data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
                contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
                data = DataHelper.buildProcessData(auditService.getDomain(), default_realm);
                contextHandler.buildContextObject("PROCESS_CONTEXT", data);
                data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getType()));
                contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
                data = DataHelper.buildProviderData(providerName, "providerSuccess");
                contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
                data = DataHelper.buildPolicyData(null, null);
                contextHandler.buildContextObject("POLICY_CONTEXT", data);
                this.auditOutcome = DataHelper.buildOutcomeData("UNSUCCESSFUL", new Integer(-1), new Integer(-1), "DENIED", 16L);
                try {
                    auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
                }
                catch (ProviderFailureException e) {
                    Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                    String msg = "security.audit.service.sendevent.error";
                    auditService.processAuditFailure(msg, e);
                }
            }
            throw new CSIAccessException(Constants.nls.getFormattedMessage("security.authz.failed.foruser", new Object[]{sname, beanType, ((Object)methodInfo.getJ2EEName()).toString(), methodName, accessException.getMessage()}, "Authorization.failed.for.{0}.while.invoking.({1}){2}.{3}: {4}"));
        }
        if (tc.isDebugEnabled()) {
            if (null == receivedSubject) {
                Tr.debug(tc, "NULL receivedCred");
            }
            if (null == invokedSubject) {
                Tr.debug(tc, "NULL invokedCred");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performAuthorization");
        }
        if (auditService != null && isAuditAuthzSuccessEventEnabled) {
            HashMap data = DataHelper.buildSessionData(null, null, null, null);
            contextHandler.buildContextObject("SESSION_CONTEXT", data);
            String rSubj = null;
            if (receivedSubject != null) {
                rSubj = ((Principal)receivedSubject.getPrincipals().toArray()[0]).getName();
            }
            data = beanName != null && methodName != null ? DataHelper.buildAccessData(beanName.concat(".").concat(methodName), "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null) : (beanName != null && methodName == null ? DataHelper.buildAccessData(beanName, "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null) : (beanName == null && methodName != null ? DataHelper.buildAccessData(methodName, "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null) : DataHelper.buildAccessData(null, "authz", null, rSubj, "authzSuccess", beanName, "ejb", new Long(0L), null, null, null, null)));
            contextHandler.buildContextObject("ACCESS_CONTEXT", data);
            data = DataHelper.buildEventData(lastTrailId, eventTrailIds, new Date(), new Long(0L));
            contextHandler.buildContextObject("EVENT_CONTEXT", data);
            data = DataHelper.buildPropagationData(auditService.getFirstCaller(), auditService.getCallerList());
            contextHandler.buildContextObject("PROPAGATION_CONTEXT", data);
            data = DataHelper.buildProcessData(auditService.getDomain(), default_realm);
            contextHandler.buildContextObject("PROCESS_CONTEXT", data);
            data = DataHelper.buildRegistryData(DataHelper.convertRegistryInfoType(SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getType()));
            contextHandler.buildContextObject("REGISTRY_CONTEXT", data);
            data = DataHelper.buildProviderData(providerName, "providerSuccess");
            contextHandler.buildContextObject("AUTHN_PROVIDER_CONTEXT", data);
            data = DataHelper.buildPolicyData(null, null);
            contextHandler.buildContextObject("POLICY_CONTEXT", data);
            this.auditOutcome = DataHelper.buildOutcomeData("SUCCESSFUL", new Integer(0), new Integer(0), "SUCCESS", 8L);
            try {
                auditService.sendEvent("SECURITY_AUTHZ", this.auditOutcome);
            }
            catch (ProviderFailureException e) {
                Tr.error(tc, "security.audit.service.sendevent.error", new Object[]{e});
                String msg = "security.audit.service.sendevent.error";
                auditService.processAuditFailure(msg, e);
            }
        }
        return invokedSubject != null ? invokedSubject : receivedSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ejbCheckAuthorizationForJACC(String methodIntfName, Subject rcvdSubject, SecurityBeanCookie beanCookie, EJBMethodInfo methodInfo, EnterpriseBean bean, Object[] methodParameters) throws Exception {
        block23: {
            String jaccBeanName;
            String jaccAppName;
            block22: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "ejbCheckAuthorizationForJACC");
                }
                jaccAppName = beanCookie.getAppName();
                jaccBeanName = beanCookie.getBeanName();
                if (!beanCookie.isAdminApp()) break block22;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling default authorization for admin Application " + jaccAppName);
                }
                this.ejbCheckAuthorization(jaccBeanName, methodIntfName, rcvdSubject, beanCookie, methodInfo);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ejbCheckAuthorizationForJACC");
                }
                break block23;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bean instance = " + bean);
                if (methodParameters != null) {
                    for (int i = 0; i < methodParameters.length; ++i) {
                        Tr.debug(tc, "methodParameter[" + i + "] = " + methodParameters[i]);
                    }
                }
            }
            boolean hasJaccAccess = false;
            try {
                StringBuffer sb;
                String s;
                int index;
                String jaccIntfName = methodInfo.getInterfaceType().toString();
                String jaccMethodSig = methodInfo.getMethodSignature();
                String jaccModuleName = beanCookie.getModuleName();
                String jaccMethodName = methodInfo.getMethodName();
                ArrayList<String> jaccMethodSigList = new ArrayList<String>();
                if (jaccMethodSig != null && jaccMethodSig.length() > 0 && (index = jaccMethodSig.indexOf(":")) != -1 && (s = jaccMethodSig.substring(index + 1)) != null && s.length() > 0) {
                    StringTokenizer st = new StringTokenizer(s, ",");
                    while (st.hasMoreTokens()) {
                        jaccMethodSigList.add(st.nextToken());
                    }
                }
                String[] jaccMethodSigArray = jaccMethodSigList.toArray(new String[jaccMethodSigList.size()]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jaccBeanName: " + jaccBeanName);
                    Tr.debug(tc, "jaccAppName: " + jaccAppName);
                    Tr.debug(tc, "jaccModuleName: " + jaccModuleName);
                    Tr.debug(tc, "jaccMethodName: " + jaccMethodName);
                    Tr.debug(tc, "jaccInterfaceName: " + jaccIntfName);
                }
                final EJBMethodPermission ejbPerm = new EJBMethodPermission(jaccBeanName, jaccMethodName, jaccIntfName, jaccMethodSigArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBMethodPermission = " + ejbPerm);
                }
                if ((sb = new StringBuffer(WSAccessManager.getContextID(jaccAppName))) == null) {
                    throw new CSIAccessException("Cannot get the contextID for application: " + jaccAppName);
                }
                sb.append("/").append(jaccModuleName);
                final String contextID = sb.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "contextID: " + contextID);
                }
                final HashMap handlerObjects = new HashMap();
                final Subject jaccSubject = rcvdSubject;
                final EnterpriseBean jaccBean = bean;
                final Object[] jaccMethodArray = methodParameters;
                Boolean jaccAccess = new Boolean(false);
                jaccAccess = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws PolicyContextException {
                        PolicyContext.setContextID(contextID);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Registering JACC context handlers");
                        }
                        for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                            PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                        }
                        handlerObjects.put(jaccHandlerKeyArray[0], jaccSubject);
                        handlerObjects.put(jaccHandlerKeyArray[1], jaccBean);
                        handlerObjects.put(jaccHandlerKeyArray[2], jaccMethodArray);
                        ProtectionDomain pd = null;
                        if (jaccSubject != null && jaccSubject.getPrincipals().size() > 0) {
                            Principal[] principalArray = jaccSubject.getPrincipals().toArray(new Principal[jaccSubject.getPrincipals().size()]);
                            pd = new ProtectionDomain((CodeSource)security.getObject("nullSourceCode"), null, null, principalArray);
                        } else {
                            pd = (ProtectionDomain)security.getObject("nullProtectionDomain");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Setting JACC handler data");
                        }
                        PolicyContext.setHandlerData(handlerObjects);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling JACC implies");
                        }
                        Boolean result = new Boolean(Policy.getPolicy().implies(pd, ejbPerm));
                        return result;
                    }
                });
                hasJaccAccess = jaccAccess;
                Object var25_25 = null;
            }
            catch (Throwable throwable) {
                Object var25_26 = null;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            PolicyContext.setHandlerData(null);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + e);
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "878", this);
                }
                throw throwable;
            }
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + e);
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "878", this);
            }
            if (!hasJaccAccess) {
                Tr.debug(tc, "hasJaccAccess is false");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ejbCheckAuthorizationForJACC is false for Bean: " + jaccBeanName);
                }
                throw new AccessException("JACC Authorization failed for bean: " + jaccBeanName);
            }
            Tr.debug(tc, "hasJaccAccess is true");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ejbCheckAuthorizationForJACC is true for bean: " + jaccBeanName);
            }
        }
    }

    protected boolean isUnprotected(String homeName) {
        return false;
    }

    protected String resolveHomeMethod(String methodName) {
        if (methodName.equals(CREATE)) {
            methodName = EJB_CREATE;
        } else if (methodName.equals(REMOVE)) {
            methodName = EJB_REMOVE;
        } else if (methodName.equals(GET_META_DATA)) {
            methodName = EJB_GET_META_DATA;
        }
        return methodName;
    }

    protected String resolveBeanMethod(String methodName) {
        if (methodName.equals(REMOVE)) {
            methodName = EJB_REMOVE;
        }
        return methodName;
    }

    private boolean internalUnprotected(String methodName) {
        boolean unprotected = false;
        if (methodName != null && methodName.startsWith("ejbTimeout:javax.ejb.Timer:")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ejbTimeout(javax.ejb.Timer) is excluded from authorization checking, EJB spec section 22.2.2.");
            }
            unprotected = true;
        }
        return unprotected;
    }

    public void postInvokeCommon(EJBKey ejbKey, EJBMethodInfo methodInof, SecurityCookie securityCookie, CollaboratorCookie beanCookie) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke");
        }
        if (securityCookie != null) {
            try {
                Subject[] retSubjects = ((SecurityCookieImpl)securityCookie).subjects;
                if (retSubjects != null) {
                    Subject receivedSubject = contextManager.getCallerSubject();
                    if (receivedSubject != null) {
                        receivedSubject = retSubjects[0];
                        contextManager.setCallerSubject(receivedSubject);
                    }
                    if (retSubjects.length > 1) {
                        contextManager.setInvocationSubject(retSubjects[1]);
                    }
                }
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.postInvokeCommon", "966", this);
                throw new CSIAccessException(e.getMessage(), (Throwable)e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    public Principal getCallerPrincipal(CollaboratorCookie cookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerPrincipal", cookie);
        }
        if (securityEnabled) {
            String principalName;
            block32: {
                String name = SecurityContext.getCallerName();
                principalName = null;
                if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    try {
                        String principalClass = null;
                        Subject subject = contextManager.getCallerSubject();
                        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
                        if (cred != null) {
                            try {
                                final WSCredential privCred = cred;
                                principalClass = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                        return privCred.get("com.ibm.wsspi.security.token.caller_principal_class");
                                    }
                                });
                            }
                            catch (PrivilegedActionException e) {
                                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.SecurityCollaborator", "1022", this);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Exception getting CallerPrincipalClass : ", new Object[]{e.getException()});
                                }
                                principalClass = null;
                            }
                        }
                        if (principalClass == null || principalClass.equals("com.ibm.websphere.security.auth.WSPrincipal")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "requested principal class is null or defaulted");
                            }
                            name = SecurityContext.getCallerName();
                            boolean useQualifiedUserName = false;
                            Boolean fqun = security.getBoolean("useDomainQualifiedUserNames");
                            useQualifiedUserName = fqun;
                            if (useQualifiedUserName) {
                                String realm = RealmSecurityName.getRealm(name);
                                name = SecurityContext.unqualifySecurityName(name);
                                if (realm == null || realm.length() < 1) {
                                    realm = security.getActiveUserRegistry().getString("realm");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Registry realm name = " + realm);
                                    }
                                }
                                principalName = RealmSecurityName.getRealmSecurityName(realm, name);
                            } else {
                                principalName = SecurityContext.unqualifySecurityName(name);
                            }
                        } else if (principalClass.equals("com.ibm.ws.security.zos.Principal")) {
                            PlatformCredential platformCred;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "requested principal class is z/OS");
                            }
                            if ((platformCred = (PlatformCredential)cred.get("com.ibm.ws.security.zos.PlatformCredential")) != null) {
                                principalName = platformCred.getUserId();
                            }
                        } else {
                            Class<?> principalLookupClass;
                            Set<?> s;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "requested principal class is custom: " + principalClass);
                            }
                            if ((s = subject.getPrincipals(principalLookupClass = Class.forName(principalClass))) != null && s.size() > 0) {
                                principalName = ((Principal)s.iterator().next()).getName();
                            }
                        }
                        break block32;
                    }
                    catch (Exception e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "caught exception in getCallerPrincipal", e);
                        }
                        break block32;
                    }
                }
                boolean useQualifiedUserName = false;
                Boolean fqun = security.getBoolean("useDomainQualifiedUserNames");
                useQualifiedUserName = fqun;
                if (useQualifiedUserName) {
                    String realm = RealmSecurityName.getRealm(name);
                    name = SecurityContext.unqualifySecurityName(name);
                    if (realm == null || realm.length() < 1) {
                        realm = security.getActiveUserRegistry().getString("realm");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Registry realm name = " + realm);
                        }
                    }
                    principalName = RealmSecurityName.getRealmSecurityName(realm, name);
                } else {
                    principalName = SecurityContext.unqualifySecurityName(name);
                }
            }
            if (principalName != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Principal name = " + principalName);
                }
                Identity p = new Identity(principalName);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCallerPrincipal");
                }
                return p;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SecurityCollaborator  getCallerPrincipal");
        }
        if (!contextManager.getPlatformHelper().isZOS()) {
            return new Identity(ContextManagerFactory.getInstance().getUnauthenticatedString());
        }
        return new Identity("UNAUTHENTICATED");
    }

    private boolean isCallerInRole(SecurityBeanCookie cookie, String roleName, Subject receivedSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCallerInRole(SecurityBeanCookie, String, Subject)", cookie + "roleName=" + roleName);
        }
        SecurityRole secRole = WCCMHelper.createSecurityRole(null, roleName);
        BeanAccessContext ctx = new BeanAccessContext(cookie.getAppName(), null, null);
        boolean isCallerInRole = beanAccessManager.isGrantedRole(ctx, secRole, new WSPrincipal(receivedSubject));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole(SecurityBeanCookie, String, Subject)", "isCallerInRole=" + isCallerInRole);
        }
        return isCallerInRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isCallerInRole(CollaboratorCookie cookie, String roleName, String roleRefName, Object bean, Object[] methodParameters) {
        boolean isJaccCallerInRoleAccess;
        block39: {
            StringBuffer sb;
            EJBRoleRefPermission ejbRRPerm;
            String jaccModuleName;
            Subject receivedSubject;
            block37: {
                block36: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "isCallerInRole(CollaboratorCookie,String,String,EnterpriseBean,Object[])", cookie + " bean=" + bean + " roleName=" + roleName + " roleRefName=" + roleRefName);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying to get the callerSubject.");
                    }
                    receivedSubject = null;
                    try {
                        receivedSubject = contextManager.getCallerSubject();
                    }
                    catch (WSSecurityException e) {
                        FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".isCallerInRole", "1221", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get Caller Subject " + e);
                            Tr.debug(tc, "Try using unauthenticated subject");
                        }
                        try {
                            receivedSubject = SubjectHelper.createUnauthenticatedSubject();
                        }
                        catch (Exception e1) {
                            FFDCFilter.processException((Throwable)e1, this.getClass().getName() + ".isCallerInRole", "1234", this);
                            if (!tc.isDebugEnabled()) break block36;
                            Tr.debug(tc, "Fail to get unauthenticated subject: " + e1);
                        }
                    }
                }
                SecurityBeanCookie beanCookie = (SecurityBeanCookie)cookie;
                if (!security.getAuthorizationConfig().getBoolean("useJACCProvider") || beanCookie.isAdminApp()) {
                    boolean result = this.isCallerInRole(beanCookie, roleName, receivedSubject);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isCallerInRole(CollaboratorCookie,String,String,EnterpriseBean,Object[])", result);
                    }
                    return result;
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "isCallerInRoleForJACC");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "bean instance = " + bean);
                    if (methodParameters != null) {
                        for (int i = 0; i < methodParameters.length; ++i) {
                            Tr.debug(tc, "methodParameter[" + i + "] = " + methodParameters[i]);
                        }
                    }
                }
                isJaccCallerInRoleAccess = false;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling JACC provider for isCallerInRole check.");
                }
                String jaccBeanName = beanCookie.getBeanName();
                String jaccAppName = beanCookie.getAppName();
                jaccModuleName = beanCookie.getModuleName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "jaccBeanName: " + jaccBeanName);
                    Tr.debug(tc, "jaccAppName: " + jaccAppName);
                    Tr.debug(tc, "jaccModuleName: " + jaccModuleName);
                    Tr.debug(tc, "roleRefName: " + roleRefName);
                    Tr.debug(tc, "roleName: " + roleName);
                }
                String jaccRole = roleRefName == null ? roleName : roleRefName;
                ejbRRPerm = new EJBRoleRefPermission(jaccBeanName, jaccRole);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBRoleRefPermission: " + ejbRRPerm);
                }
                if ((sb = new StringBuffer(WSAccessManager.getContextID(jaccAppName))) != null) break block37;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot get the contextID for application: " + jaccAppName + ". Returning false.");
                }
                boolean bl = false;
                Object var22_22 = null;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() {
                            PolicyContext.setHandlerData(null);
                            return null;
                        }
                    });
                }
                catch (Exception e2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                    }
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "1379", this);
                }
                return bl;
            }
            sb.append("/").append(jaccModuleName);
            final String contextID = sb.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "contextID: " + contextID);
            }
            final Subject jaccSubject = receivedSubject;
            final EnterpriseBean jaccBean = bean instanceof EnterpriseBean ? (EnterpriseBean)bean : null;
            final Object[] jaccMethodArray = methodParameters;
            final HashMap handlerObjects = new HashMap();
            Boolean jaccCallerInRole = new Boolean(false);
            jaccCallerInRole = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    PolicyContext.setContextID(contextID);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler(jaccHandlerKeyArray[i], wpch, true);
                    }
                    handlerObjects.put(jaccHandlerKeyArray[0], jaccSubject);
                    handlerObjects.put(jaccHandlerKeyArray[1], jaccBean);
                    handlerObjects.put(jaccHandlerKeyArray[2], jaccMethodArray);
                    ProtectionDomain pd = null;
                    if (jaccSubject != null && jaccSubject.getPrincipals().size() > 0) {
                        Principal[] principalArray = jaccSubject.getPrincipals().toArray(new Principal[jaccSubject.getPrincipals().size()]);
                        pd = new ProtectionDomain((CodeSource)security.getObject("nullSourceCode"), null, null, principalArray);
                    } else {
                        pd = (ProtectionDomain)security.getObject("nullProtectionDomain");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData(handlerObjects);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling JACC implies");
                    }
                    Boolean result = new Boolean(Policy.getPolicy().implies(pd, ejbRRPerm));
                    return result;
                }
            });
            isJaccCallerInRoleAccess = jaccCallerInRole;
            Object var22_23 = null;
            try {
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Exception e2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                }
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "1379", this);
            }
            break block39;
            {
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.isCallerInRole", "1351", this);
                    Tr.error(tc, "security.iscallerinrole.error", new Object[]{roleRefName, e});
                    Object var22_24 = null;
                    try {
                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                        }
                        FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "1379", this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var22_25 = null;
                try {
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception e2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when setting setHandler data: " + e2);
                    }
                    FFDCFilter.processException((Throwable)e2, "com.ibm.ws.security.core.SecurityCollaborator.performAuthorization", "1379", this);
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            if (isJaccCallerInRoleAccess) {
                Tr.debug(tc, "jaccCallerInRole is true");
            } else {
                Tr.debug(tc, "jaccCallerInRole is false");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCallerInRole", String.valueOf(isJaccCallerInRoleAccess));
        }
        return isJaccCallerInRoleAccess;
    }

    public java.security.Identity getCallerIdentity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerIdentity()");
        }
        Identity identity = null;
        if (securityEnabled) {
            Principal o = this.getCallerPrincipal(null);
            Identity identity2 = identity = o instanceof Identity ? (Identity)o : null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerIdentity()", identity);
        }
        return identity;
    }

    public boolean isCallerInRole(java.security.Identity role) {
        throw new RuntimeException("not implemented");
    }

    protected void ejbCheckAuthorization(String beanName, String methodName, Subject rcvdSubject, SecurityBeanCookie beanCookie, EJBMethodInfo methodInfo) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ejbCheckAuthorization", new Object[]{beanName, methodName});
        }
        boolean access_allowed = false;
        String cacheKey = beanCookie.getFullBeanName() + methodInfo.getMethodSignature();
        BeanAccessContext beanAccessContext = beanAccessContextCache.get(cacheKey);
        if (beanAccessContext == null) {
            String appName = beanCookie.getAppName();
            EJBJar ejbJar = beanCookie.getEjbJar();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling getBeanPermissionRoleMap with: " + beanCookie.getAppModName());
            }
            BeanPermissionRoleMap beanPermissionRoleMap = beanPermissionRoleMapTable.getBeanPermissionRoleMap(beanCookie.getAppModName());
            if (tc.isDebugEnabled()) {
                if (null == beanPermissionRoleMap) {
                    Tr.debug(tc, "Created a NULL BeanPermissionRoleMap .... new-up a BeanAccessContext");
                } else {
                    Tr.debug(tc, "Created a not NULL BeanPermissionRoleMap .... new-up a BeanAccessContext");
                }
            }
            beanAccessContext = new BeanAccessContext(appName, beanPermissionRoleMap, ejbJar, methodInfo);
            if (beanAccessContextCache.size() == MAX_BEANACCESS_ENTRIES) {
                beanAccessContextCache.clear();
            }
            beanAccessContextCache.put(cacheKey, beanAccessContext);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling beanAccessManager.checkAccess<>");
            }
            beanAccessManager.checkAccess(beanAccessContext, beanName, methodName, rcvdSubject);
            access_allowed = true;
        }
        catch (AccessException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.ejbCheckAuthorization", "1444", this);
            throw e;
        }
        if (access_allowed && tc.isDebugEnabled()) {
            Tr.debug(tc, "BeanName=" + beanName);
            Tr.debug(tc, "MethodName=" + methodName);
            Tr.debug(tc, "AccessAllowed " + access_allowed);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ejbCheckAuthorization");
        }
    }

    protected void setSubjects(Subject received, Subject invoked) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSubjects");
        }
        Exception ex = null;
        try {
            contextManager.setInvocationSubject(invoked);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.setSubjects", "1475", this);
            ex = e;
        }
        if (ex != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setSubjects", ex);
            }
            throw new CSIAccessException(Constants.nls.getString("security.invalid.creds", "Invalid credentials"));
        }
        try {
            contextManager.setCallerSubject(received);
        }
        catch (WSSecurityException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.setSubjects", "1493", this);
            throw new CSIAccessException(e.getMessage(), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSubjects");
        }
    }

    protected boolean isSystemPrincipal(Subject c) {
        throw new RuntimeException("not implemented");
    }

    protected boolean SetUnauthenticatedSubjectIfNeeded(Subject invokedSubject, Subject receivedSubject) {
        boolean result;
        block6: {
            result = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SetUnauthenticatedSubjectIfNeeded");
            }
            if (invokedSubject == null && receivedSubject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoked and received Subject are null, setting it anonymous/unauthenticated.");
                }
                try {
                    contextManager.setInvocationSubject(SubjectHelper.createUnauthenticatedSubject());
                    result = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.SecurityCollaborator.SetUnauthenticatedSubjectIfNeeded", "1524", this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "contextManager.setInvocationSubject() threw exception when setting SecInvocationSubject to unauthenticated." + e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SetUnauthenticatedSubjectIfNeeded:" + result);
        }
        return result;
    }

    protected static final SecurityCookie getCookie(Subject[] subjects) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCookie()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCookie()");
        }
        return new SecurityCookieImpl(subjects);
    }

    protected static final SecurityCookie getCookie(Subject[] subjects, Object syncToThreadToken, boolean appSyncToOSThread, boolean pushedResource) {
        return new SecurityCookieImpl(subjects, syncToThreadToken, appSyncToOSThread, pushedResource);
    }

    static {
        useJAACProvider = false;
        MAX_BEANACCESS_ENTRIES = 600;
        beanAccessContextCache = null;
        runAsPerm = new WebSphereRuntimePermission("wssecurity.getRunAsMap");
        contextHandler = null;
        providerName = "WebSphere";
        auditService = null;
        className = null;
        default_realm = null;
    }
}

