/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.IpcPackage;
import com.ibm.websphere.models.config.ipc.ssl.EmailFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.ipc.ssl.WSNotification;
import com.ibm.websphere.models.config.jaaslogin.JaasloginFactory;
import com.ibm.websphere.models.config.orb.securityprotocol.SecurityprotocolFactory;
import com.ibm.websphere.models.config.orb.securityprotocol.SecurityprotocolPackage;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.security.Audit;
import com.ibm.websphere.models.config.security.AuditEventFactory;
import com.ibm.websphere.models.config.security.AuditNotificationMonitor;
import com.ibm.websphere.models.config.security.AuditPolicy;
import com.ibm.websphere.models.config.security.AuditPolicyKind;
import com.ibm.websphere.models.config.security.AuditServiceProvider;
import com.ibm.websphere.models.config.security.AuditSpecification;
import com.ibm.websphere.models.config.security.AuditSpecificationKind;
import com.ibm.websphere.models.config.security.Certificate;
import com.ibm.websphere.models.config.security.OutcomeKind;
import com.ibm.websphere.models.config.security.SecurityFactory;
import com.ibm.websphere.models.config.security.SecurityPackage;
import com.ibm.ws.security.core.AbstractConfigBuilder;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;

public class SampleAuditConfigBuilder
extends AbstractConfigBuilder {
    protected SecurityFactory securityFactory;
    protected PropertiesFactory propertiesFactory;
    protected SslFactory sslFactory;
    protected IpcFactory ipcFactory;
    protected JaasloginFactory lf;
    protected SecurityprotocolFactory secProFactory;

    public EList buildRootElements() {
        BasicEList securityExtent = new BasicEList();
        System.out.println("buildRootElements");
        securityExtent.add(this.buildSampleAudit());
        return securityExtent;
    }

    public Audit buildSampleAudit() {
        System.out.println("buildSampleAudit");
        Audit audit = this.securityFactory.createAudit();
        WSNotification noti1 = this.sslFactory.createWSNotification();
        noti1.setName("mailing");
        noti1.setLogToSystemOut(false);
        noti1.setSendEmail(true);
        noti1.setEmailList("utle@us.ibm.com:pbirk@us.ibm.com:alaine@us.ibm.com");
        noti1.setEmailFormat(EmailFormatKind.HTML_LITERAL);
        noti1.setSendSecure(true);
        noti1.setSslConfig("defaultSSLConfig");
        audit.getWsNotifications().add(noti1);
        AuditNotificationMonitor auditNoti = this.securityFactory.createAuditNotificationMonitor();
        auditNoti.setName("Name");
        auditNoti.setEnabled(true);
        auditNoti.setWsNotification(noti1);
        audit.setAuditNotificationMonitor(auditNoti);
        ManagementScope mscope1 = this.sslFactory.createManagementScope();
        mscope1.setScopeName("(cell):$(cell.name)");
        mscope1.setScopeType("cell");
        audit.getManagementScopes().add(mscope1);
        KeyStore keyStore = this.sslFactory.createKeyStore();
        keyStore.setName("DefaultKeyStore");
        keyStore.setPassword("{xor}CDo9Hgw=");
        keyStore.setProvider("IBMJCE");
        keyStore.setLocation("file://${USER_INSTALL_ROOT}/etc/DummyServerKeyFile.jks");
        keyStore.setType("JKS");
        keyStore.setFileBased(true);
        keyStore.setHostList("");
        keyStore.setReadOnly(false);
        keyStore.setInitializeAtStartup(true);
        keyStore.setCustomProviderClass("");
        keyStore.setUseForAcceleration(false);
        keyStore.setManagementScope(mscope1);
        keyStore.setDescription("keyStore description");
        audit.getKeyStores().add(keyStore);
        Certificate cert1 = this.securityFactory.createCertificate();
        Certificate cert2 = this.securityFactory.createCertificate();
        cert1.setAlias("aliasName1");
        cert1.setKeyStore(keyStore);
        cert2.setAlias("aliasName2");
        cert2.setKeyStore(keyStore);
        audit.getCertificates().add(cert1);
        audit.getCertificates().add(cert2);
        System.out.println("Generated certificates");
        AuditSpecification auditSpecification1 = this.securityFactory.createAuditSpecification();
        AuditSpecification auditSpecification2 = this.securityFactory.createAuditSpecification();
        AuditSpecification auditSpecification3 = this.securityFactory.createAuditSpecification();
        auditSpecification1.getEvent().add(AuditSpecificationKind.SECURITY_AUTHN_LITERAL);
        auditSpecification1.getOutcome().add(OutcomeKind.SUCCESS_LITERAL);
        auditSpecification1.setEnabled(true);
        audit.getAuditSpecifications().add(auditSpecification1);
        auditSpecification2.getEvent().add(AuditSpecificationKind.SECURITY_AUTHZ_LITERAL);
        auditSpecification2.getOutcome().add(OutcomeKind.FAILURE_LITERAL);
        auditSpecification2.setEnabled(true);
        audit.getAuditSpecifications().add(auditSpecification2);
        auditSpecification3.getEvent().add(AuditSpecificationKind.SECURITY_SIGNING_LITERAL);
        auditSpecification3.getOutcome().add(OutcomeKind.FAILURE_LITERAL);
        auditSpecification3.setEnabled(true);
        audit.getAuditSpecifications().add(auditSpecification3);
        AuditServiceProvider auditServiceProvider1 = this.securityFactory.createAuditServiceProvider();
        auditServiceProvider1.setName("name");
        auditServiceProvider1.setClassName("className");
        auditServiceProvider1.setEventFormatterClass("className");
        auditServiceProvider1.setMaxFileSize(100);
        auditServiceProvider1.setMaxLogs(5);
        auditServiceProvider1.setFileLocation("");
        auditServiceProvider1.getAuditSpecifications().add(auditSpecification1);
        auditServiceProvider1.getAuditSpecifications().add(auditSpecification2);
        AuditServiceProvider auditServiceProvider2 = this.securityFactory.createAuditServiceProvider();
        auditServiceProvider2.setName("name");
        auditServiceProvider2.setClassName("className");
        auditServiceProvider2.setEventFormatterClass("className");
        auditServiceProvider2.setMaxFileSize(100);
        auditServiceProvider2.setMaxLogs(5);
        auditServiceProvider2.setFileLocation("");
        auditServiceProvider2.getAuditSpecifications().add(auditSpecification1);
        auditServiceProvider2.getAuditSpecifications().add(auditSpecification2);
        auditServiceProvider2.getAuditSpecifications().add(auditSpecification3);
        AuditEventFactory auditEventFactory1 = this.securityFactory.createAuditEventFactory();
        auditEventFactory1.setName("name");
        auditEventFactory1.setClassName("className");
        auditEventFactory1.setAuditServiceProvider(auditServiceProvider1);
        auditEventFactory1.getAuditSpecifications().add(auditSpecification1);
        auditEventFactory1.getAuditSpecifications().add(auditSpecification2);
        auditEventFactory1.getAuditSpecifications().add(auditSpecification3);
        AuditEventFactory auditEventFactory2 = this.securityFactory.createAuditEventFactory();
        auditEventFactory2.setName("name");
        auditEventFactory2.setClassName("className");
        auditEventFactory2.setAuditServiceProvider(auditServiceProvider2);
        auditEventFactory2.getAuditSpecifications().add(auditSpecification1);
        auditEventFactory2.getAuditSpecifications().add(auditSpecification2);
        AuditPolicy ap = this.securityFactory.createAuditPolicy();
        ap.setAuditEnabled(false);
        ap.setAuditPolicy(AuditPolicyKind.FATAL_LITERAL);
        ap.setAuditorId("utle");
        ap.setAuditorPwd("utlepwd");
        ap.setSign(true);
        ap.setEncrypt(true);
        ap.setBatching(true);
        ap.getAuditServiceProviders().add(auditServiceProvider1);
        ap.getAuditServiceProviders().add(auditServiceProvider2);
        ap.getAuditEventFactories().add(auditEventFactory1);
        ap.getAuditEventFactories().add(auditEventFactory2);
        ap.setEncryptionCert(cert1);
        ap.setSecurityXmlSignerKeyStoreName("");
        ap.setSecurityXmlSignerCertAlias("");
        ap.setSecurityXmlSignerScopeName("");
        System.out.println("Generated Audit");
        audit.setAuditPolicy(ap);
        return audit;
    }

    public String getDocumentName() {
        return "audit.xml";
    }

    public void initializeFactories() {
        super.initializeFactories();
        SecurityPackage securitypkg = (SecurityPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/security.xmi");
        this.securityFactory = securitypkg.getSecurityFactory();
        PropertiesPackage propertiespkg = (PropertiesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/properties.xmi");
        this.propertiesFactory = propertiespkg.getPropertiesFactory();
        IpcPackage ipcpkg = (IpcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.xmi");
        this.ipcFactory = ipcpkg.getIpcFactory();
        SslPackage sslpkg = (SslPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/ipc.ssl.xmi");
        this.sslFactory = sslpkg.getSslFactory();
        this.lf = (JaasloginFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/jaaslogin.xmi").getEFactoryInstance();
        SecurityprotocolPackage secPropkg = (SecurityprotocolPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi");
        this.secProFactory = secPropkg.getSecurityprotocolFactory();
    }

    public static void main(String[] args) {
        SampleAuditConfigBuilder adminAuditBuilder = new SampleAuditConfigBuilder();
        adminAuditBuilder.write();
    }
}

