/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.x500.X500Principal;

public final class LTPALoginHelper {
    private static final TraceComponent tc = Tr.register(LTPALoginHelper.class, "Security", "com.ibm.ejs.resources.security");
    private static final LTPALoginHelper _instance = new LTPALoginHelper();
    LTPAServerObject ltpaServer;

    public static LTPALoginHelper instance() {
        return _instance;
    }

    private LTPALoginHelper() {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private LTPAServerObject getLTPAServer() {
        block3: {
            try {
                if (this.ltpaServer == null) {
                    this.ltpaServer = LTPAServerObject.getLTPAServer();
                }
            }
            catch (LTPAConfigException lce) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "LTPA configuration error", lce);
            }
        }
        return this.ltpaServer;
    }

    byte[] login(String realm, String user, String pw) {
        byte[] token;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login", new Object[]{realm, user, pw != null ? "****" : "null"});
            }
            token = null;
            try {
                WSCredential cred = ContextManagerFactory.getInstance().authenticate(realm, user, pw);
                long expiration = cred.getExpiration();
                token = cred.getCredentialToken();
            }
            catch (AuthenticationFailedException afe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication failed", afe);
                }
            }
            catch (CredentialDestroyedException cde) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Credential destroyed", cde);
                }
            }
            catch (Throwable t) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Unexpected exception", t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", token);
        }
        return token;
    }

    boolean isTokenValid(byte[] ltpaToken) {
        boolean isValid;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isTokenValid", ltpaToken);
            }
            isValid = false;
            try {
                WSCredential wscred = this.getLTPAServer().validate(ltpaToken);
                isValid = true;
            }
            catch (WSLoginFailedException lfe) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "invalid credential", ltpaToken);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTokenValid", new Boolean(isValid));
        }
        return isValid;
    }

    public long getRemainingTime(byte[] tokenBytes) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemainingTime", tokenBytes);
        }
        long expirationTime = 0L;
        long millis = 0L;
        try {
            expirationTime = this.getLTPAServer().getExpiration(tokenBytes);
            if (expirationTime > 0L) {
                millis = expirationTime - System.currentTimeMillis();
            }
        }
        catch (Exception ite) {
            Tr.debug(tc, "Token invalid", new Object[]{tokenBytes, ite});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemainingTime", new Long(millis));
        }
        return millis;
    }

    public byte[] encodeDistinguishedName(final String distinguishedName) {
        byte[] encodedName;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "encodeDistinguishedName", distinguishedName);
            }
            encodedName = null;
            try {
                encodedName = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        X500Principal principal = new X500Principal(distinguishedName);
                        return principal.getEncoded();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Unable to encode DN", new Object[]{distinguishedName, pae.getCause()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodeDistinguishedName", encodedName);
        }
        return encodedName;
    }

    public String decodeDistinguishedName(final byte[] encodedName) {
        String distinguishedName;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "decodeDistinguishedName", encodedName);
            }
            distinguishedName = null;
            try {
                distinguishedName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        X500Principal principal = new X500Principal(encodedName);
                        return principal.getName();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Unable to decode DN", new Object[]{encodedName, pae.getCause()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeDistinguishedName", distinguishedName);
        }
        return distinguishedName;
    }

    public byte[] getServerLTPAToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerLTPAToken");
        }
        byte[] ltpaToken = null;
        try {
            Subject serverSubject = ContextManagerFactory.getInstance().getServerSubject();
            WSCredential serverCred = SubjectHelper.getWSCredentialFromSubject(serverSubject);
            try {
                ltpaToken = serverCred.getCredentialToken();
            }
            catch (CredentialDestroyedException cde) {
                FFDCFilter.processException((Throwable)cde, "com.ibm.ws.security.core.LTPALoginHelper", "322", this);
                Tr.error(tc, "security.cred.CredentialDestroyedException");
            }
            catch (CredentialExpiredException cde) {
                Tr.debug(tc, "Server credential has expired and probably shouldn't have", cde);
                Tr.error(tc, "security.cred.CredentialExpiredException");
            }
            if (ltpaToken == null) {
                LTPAServerObject ltpa = LTPAServerObject.getLTPAServer();
                WSCredential wscred = ltpa.createLTPAToken(serverCred);
                ltpaToken = wscred.getCredentialToken();
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.core.LTPALoginHelper", "342", this);
            ltpaToken = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerLTPAToken", ltpaToken);
        }
        return ltpaToken;
    }

    public String getUserFromLTPAToken(byte[] token) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserFromLTPAToken", token);
        }
        String userid = "";
        try {
            LTPAServerObject ltpa = LTPAServerObject.getLTPAServer();
            userid = ltpa.validateGetUser(token);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.LTPALoginHelper", "371", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserFromLTPAToken", userid);
        }
        return userid;
    }
}

