/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.jaaslogin.JAASModuleControlFlag;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;

public class JaasWCCMHelper {
    private static TraceComponent tc = Tr.register("JaasWCCMHelper", null, "com.ibm.ejs.resources.security");
    public static final String SYSTEM_CONFIG_LOGIN_JAAS = "security.loginconfig.system";
    public static final String APPL_CONFIG_LOGIN_JAAS = "security.loginconfig.application";

    public static String convertMapToString(HashMap map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertMapToString, in Map= " + map);
        }
        String result = null;
        StringBuffer sb = new StringBuffer(1024);
        if (map != null) {
            Set aeSet = map.entrySet();
            for (Map.Entry me : aeSet) {
                String alias = (String)me.getKey();
                if (alias == null) {
                    Tr.error(tc, "security.jaasconfig.helper.baddata", new Object[]{"convertMapToString", "alias", null});
                    continue;
                }
                sb.append(me.getKey()).append(" ").append('{').append('\n');
                Vector aeVec = (Vector)me.getValue();
                int aeVecSize = aeVec.size();
                for (int i = 0; i < aeVecSize; ++i) {
                    AppConfigurationEntry ace = (AppConfigurationEntry)aeVec.elementAt(i);
                    JaasWCCMHelper.printACE(sb, ace);
                }
                sb.append("};\n");
            }
        }
        result = sb.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The internal JAAS config map has been converted to:\n" + result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertMapToString");
        }
        return result;
    }

    private static void printACE(StringBuffer sb, AppConfigurationEntry ace) {
        if (sb == null || ace == null) {
            return;
        }
        String flag = ace.getControlFlag().toString();
        flag = flag.substring(flag.indexOf(58) + 1);
        sb.append("    ").append(ace.getLoginModuleName()).append(" ").append(flag);
        Map<String, ?> options = ace.getOptions();
        if (options != null && options.size() > 0) {
            Set<Map.Entry<String, ?>> entrySet = options.entrySet();
            for (Map.Entry<String, ?> me : entrySet) {
                String optionName = me.getKey();
                String optionValue = (String)me.getValue();
                sb.append("\n       ").append(optionName).append('=').append('\"').append(optionValue).append('\"');
            }
        }
        sb.append("   ").append(";\n");
    }

    public static HashMap convertToConfiguration(SecurityConfigObject config, boolean sys, String scopeType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToConfiguration " + config);
        }
        HashMap<String, Vector> configMap = new HashMap<String, Vector>();
        if (config == null) {
            return null;
        }
        SecurityConfigObjectList entries = config.getObjectList("entries");
        for (int i = 0; i < entries.size(); ++i) {
            SecurityConfigObject entry = entries.get(i);
            String name = entry.getString("alias");
            if (name.length() != 0) {
                if (sys) {
                    name = scopeType.equals("application") ? "system.APPDOMAIN." + name : "system." + name;
                }
                if (configMap.containsKey(name)) {
                    Tr.warning(tc, "security.init.wccmjaas.dupentry", new Object[]{name});
                }
                configMap.put(name, JaasWCCMHelper.convertToAppEntry(entry));
                if (!sys || !scopeType.equals("administration")) continue;
                String anotherName = "system.APPDOMAIN." + entry.getString("alias");
                configMap.put(anotherName, JaasWCCMHelper.convertToAppEntry(entry));
                continue;
            }
            Tr.warning(tc, "security.wccmjaas.no.alias", new Object[]{config});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToConfiguration ");
        }
        return configMap;
    }

    private static Vector convertToAppEntry(SecurityConfigObject wcEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToAppEntry " + wcEntry);
        }
        Vector<AppConfigurationEntry> appEntry = new Vector<AppConfigurationEntry>();
        SecurityConfigObjectList loginModules = wcEntry.getObjectList("loginModules");
        for (int i = 0; i < loginModules.size(); ++i) {
            SecurityConfigObject wcLModule = loginModules.get(i);
            appEntry.add(JaasWCCMHelper.convertWCCMtoJaasConfig(wcLModule));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToAppEntry ");
        }
        return appEntry;
    }

    private static AppConfigurationEntry convertWCCMtoJaasConfig(SecurityConfigObject wcLM) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertWCCMtoJaasConfig " + wcLM);
        }
        AppConfigurationEntry appEntry = new AppConfigurationEntry(wcLM.getString("moduleClassName"), JaasWCCMHelper.buildFlag(wcLM), JaasWCCMHelper.buildOptions(wcLM));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertWCCMtoJaasConfig ");
        }
        return appEntry;
    }

    private static AppConfigurationEntry.LoginModuleControlFlag buildFlag(SecurityConfigObject wcLModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildModuleControlFlag " + wcLModule);
        }
        AppConfigurationEntry.LoginModuleControlFlag appFlag = null;
        String authStrat = wcLModule.getString("authenticationStrategy", "REQUIRED");
        if (authStrat.equals("REQUIRED")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        } else if (authStrat.equals("REQUISITE")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        } else if (authStrat.equals("SUFFICIENT")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        } else if (authStrat.equals("OPTIONAL")) {
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        } else {
            System.out.println("Error, invalid JAAS authentication strategy: " + authStrat + ". Using REQUIRED");
            appFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildModuleControlFlag " + appFlag);
        }
        return appFlag;
    }

    private static Map buildOptions(SecurityConfigObject lm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildOptions " + lm);
        }
        HashMap<String, String> opt = new HashMap<String, String>();
        SecurityConfigObjectList options = lm.getObjectList("options");
        for (int i = 0; i < options.size(); ++i) {
            SecurityConfigObject wcOpt = options.get(i);
            opt.put(wcOpt.getString("name"), wcOpt.getString("value"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildOptions " + opt);
        }
        return opt;
    }

    public static HashMap convertToConfiguration(JAASConfiguration conf, boolean sys) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToConfiguration " + conf);
        }
        HashMap<String, Vector> configMap = new HashMap<String, Vector>();
        if (conf == null) {
            return null;
        }
        for (JAASConfigurationEntry entry : conf.getEntries()) {
            if (entry.getAlias().length() != 0) {
                String name = entry.getAlias();
                if (sys) {
                    name = "system." + name;
                }
                if (configMap.containsKey(name)) {
                    Tr.warning(tc, "security.init.wccmjaas.dupentry", new Object[]{name});
                }
                configMap.put(name, JaasWCCMHelper.convertToAppEntry(entry));
                continue;
            }
            Tr.warning(tc, "security.wccmjaas.no.alias", new Object[]{conf});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToConfiguration ");
        }
        return configMap;
    }

    private static Vector convertToAppEntry(JAASConfigurationEntry wcEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertToAppEntry " + wcEntry);
        }
        Vector<AppConfigurationEntry> appEntry = new Vector<AppConfigurationEntry>();
        for (JAASLoginModule wcLModule : wcEntry.getLoginModules()) {
            appEntry.add(JaasWCCMHelper.convertWCCMtoJaasConfig(wcLModule));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertToAppEntry ");
        }
        return appEntry;
    }

    private static AppConfigurationEntry convertWCCMtoJaasConfig(JAASLoginModule wcLM) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertWCCMtoJaasConfig " + wcLM);
        }
        AppConfigurationEntry appEntry = new AppConfigurationEntry(JaasWCCMHelper.buildLoginModule(wcLM), JaasWCCMHelper.buildFlag(wcLM), JaasWCCMHelper.buildOptions(wcLM));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertWCCMtoJaasConfig ");
        }
        return appEntry;
    }

    private static String buildLoginModule(JAASLoginModule lm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildLoginModule " + lm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildLoginModule " + lm);
        }
        return lm.getModuleClassName();
    }

    private static AppConfigurationEntry.LoginModuleControlFlag buildFlag(JAASLoginModule wcLModule) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildModuleControlFlag " + wcLModule);
        }
        JAASModuleControlFlag s = wcLModule.getAuthenticationStrategy();
        int authStrat = s.getValue();
        switch (authStrat) {
            case 0: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            }
            case 1: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
            case 2: {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
            case 3: {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
        }
        System.out.println("Error: switch on wcLModule.getAuthenticationStrategy().getValueAuthenticationStrategy() did not match");
        return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
    }

    private static Map buildOptions(JAASLoginModule lm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildOptions " + lm);
        }
        HashMap<String, String> opt = new HashMap<String, String>();
        for (Property wcOpt : lm.getOptions()) {
            opt.put(wcOpt.getName(), wcOpt.getValue());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildOptions " + opt);
        }
        return opt;
    }
}

