/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.models.base.resources.env.EnvFactory;
import com.ibm.ejs.models.base.resources.env.EnvPackage;
import com.ibm.ejs.models.base.resources.j2c.J2cFactory;
import com.ibm.ejs.models.base.resources.j2c.J2cPackage;
import com.ibm.ejs.models.base.resources.jdbc.JdbcFactory;
import com.ibm.ejs.models.base.resources.jdbc.JdbcPackage;
import com.ibm.ejs.models.base.resources.jms.JmsFactory;
import com.ibm.ejs.models.base.resources.jms.JmsPackage;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.InternalmessagingFactory;
import com.ibm.ejs.models.base.resources.jms.internalmessaging.InternalmessagingPackage;
import com.ibm.ejs.models.base.resources.jms.mqseries.MqseriesFactory;
import com.ibm.ejs.models.base.resources.jms.mqseries.MqseriesPackage;
import com.ibm.ejs.models.base.resources.mail.MailFactory;
import com.ibm.ejs.models.base.resources.mail.MailPackage;
import com.ibm.ejs.models.base.resources.url.UrlFactory;
import com.ibm.ejs.models.base.resources.url.UrlPackage;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;

public abstract class AbstractConfigBuilder {
    public static final String APP_INSTALL_ROOT = "c:/g021122/installedApps";
    public static final String INSTALLABLE_APPS_ROOT = "c:/g021122/installableApps";
    public static final String DEFAULT_CONFIG_ROOT = "/wccm50";
    public static final String DEFAULT_CONTACT = "{Your Contact Info}";
    public static final String CELL_EXTENSION = ".ws-cell";
    public static final String NODE_EXTENSION = ".ws-node";
    public static final String PROCESS_EXTENSION = ".ws-proc";
    public static final String APP_EXTENSION = ".ws-app";
    public static final String CELL_MANAGER_TYPE = "CellManager";
    public static final String NODE_AGENT_TYPE = "NodeAgent";
    public static final String MANAGED_SERVER_TYPE = "ManagedServer";
    protected boolean emitTimestamp = true;
    protected ResourcesFactory resourceFactory;
    protected J2cFactory j2cFactory;
    protected JmsFactory jmsFactory;
    protected MqseriesFactory mqSeriesFactory;
    protected InternalmessagingFactory internalMessagingFactory;
    protected JdbcFactory jdbcFactory;
    protected MailFactory mailFactory;
    protected EnvFactory envFactory;
    protected UrlFactory urlFactory;
    protected static ResourceSet context;
    protected String configRoot;
    protected boolean multiExtent = false;

    public AbstractConfigBuilder() {
        this.initializeFactories();
    }

    public abstract EList buildRootElements();

    public void setConfigRepositoryRoot(String root) {
        this.configRoot = root;
    }

    public String getConfigRepositoryRoot() {
        if (this.configRoot == null || this.configRoot.equals("")) {
            return DEFAULT_CONFIG_ROOT;
        }
        return this.configRoot;
    }

    public String getContactInfo() {
        return DEFAULT_CONTACT;
    }

    protected ResourceSet getContext() {
        if (context == null) {
            context = new WASResourceSetImpl();
            URIConverterImpl uric = new URIConverterImpl();
            URI configRepositoryRoot = URI.createURI(this.getConfigRepositoryRoot());
            context.setURIConverter(uric);
        }
        return context;
    }

    public abstract String getDocumentName();

    public ResourceSet getResourceSet() {
        return this.getContext();
    }

    public void initializeFactories() {
        ArchiveInit.init();
        ConfigInit.init();
        AppdeploymentPackageImpl.init();
        ResourcesPackage resourcespkg = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
        this.resourceFactory = resourcespkg.getResourcesFactory();
        J2cPackage j2cpkg = (J2cPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.j2c.xmi");
        this.j2cFactory = j2cpkg.getJ2cFactory();
        JmsPackage jmspkg = (JmsPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.xmi");
        this.jmsFactory = jmspkg.getJmsFactory();
        InternalmessagingPackage internalMessagingPkg = (InternalmessagingPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.internalmessaging.xmi");
        this.internalMessagingFactory = internalMessagingPkg.getInternalmessagingFactory();
        MqseriesPackage mqSeriesPkg = (MqseriesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jms.mqseries.xmi");
        this.mqSeriesFactory = mqSeriesPkg.getMqseriesFactory();
        JdbcPackage jdbcpkg = (JdbcPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.jdbc.xmi");
        this.jdbcFactory = jdbcpkg.getJdbcFactory();
        MailPackage mailpkg = (MailPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.mail.xmi");
        this.mailFactory = mailpkg.getMailFactory();
        EnvPackage envpkg = (EnvPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.env.xmi");
        this.envFactory = envpkg.getEnvFactory();
        UrlPackage urlpkg = (UrlPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.url.xmi");
        this.urlFactory = urlpkg.getUrlFactory();
    }

    protected Resource makeResource(String uri, EList extent) {
        ResourceSet resSet = this.getContext();
        Resource resource = resSet.createResource(URI.createURI(uri));
        resource.getContents().addAll(extent);
        return resource;
    }

    public void trace(String debugString) {
        System.out.println(debugString);
    }

    public void write() {
        this.write(this.buildRootElements(), this.getConfigRepositoryRoot() + "/" + this.getDocumentName());
    }

    public void write(EList refObjectExtent, String fileName) {
        XMIResource configResource = (XMIResource)this.makeResource(fileName, refObjectExtent);
        try {
            configResource.save(new HashMap());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.AbstractConfigBuilder.write", "206", this);
            e.printStackTrace();
        }
    }

    public void write(EObject rootObject, String fileName) {
        ArrayList<EObject> c = new ArrayList<EObject>();
        c.add(rootObject);
        this.write(c, fileName);
    }

    public void write(Collection refObjectList, String fileName) {
        BasicEList configExtent = new BasicEList();
        configExtent.addAll(refObjectList);
        XMIResource configResource = (XMIResource)this.makeResource(this.getDocumentName(), configExtent);
        try {
            configResource.save(new HashMap());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.AbstractConfigBuilder.write", "226", this);
            e.printStackTrace();
        }
    }
}

