/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.WorkCompletedException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.asynchbeans.ServiceContext;
import com.ibm.ws.asynchbeans.ServiceContextInvalid;
import com.ibm.ws.asynchbeans.ServiceWithContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.context.ContextImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.security.context.ContextManager;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Stack;

public class ServiceWithContextImpl
implements ServiceWithContext {
    private static final TraceComponent log = Tr.register(ServiceWithContextImpl.class, "Security", "com.ibm.ejs.resources.security");
    public static final String svcName = "security";
    public static final String svcDesc = "Security service";
    private static final ThreadLocal threadLocalContextStack = new WSThreadLocal(){

        protected Object initialValue() {
            return new Stack();
        }
    };

    public String getServiceDescription() {
        return svcDesc;
    }

    public String getServiceName() {
        return svcName;
    }

    public ServiceContext peek() {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "peek");
        }
        ServiceContext ctx = null;
        try {
            ctx = (ServiceContext)((Object)ContextManager.getContext());
        }
        catch (WSSecurityException e) {
            FFDCFilter.processException((Throwable)e, "peek", "105", this);
            throw new RuntimeException("Unable to get a security ServiceContext, cause: " + e, e);
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "peek", ctx);
        }
        return ctx;
    }

    public void pop(ServiceContext c) throws ServiceContextInvalid, WorkCompletedException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "pop", c);
        }
        try {
            Stack contextStack = (Stack)threadLocalContextStack.get();
            if (contextStack == null || contextStack.isEmpty()) {
                String msg = "ServiceContext state is invalid, push() must be invoked before pop(), contextStack=" + contextStack;
                WSSecurityException e = new WSSecurityException(msg);
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "pop", msg);
                }
                ServiceContextInvalid ex = new ServiceContextInvalid(this.getServiceName());
                ex.initCause(e);
                throw ex;
            }
            Context ctx = (Context)contextStack.pop();
            this.doPrivSetOrRestore(ctx, false);
            if (log.isDebugEnabled()) {
                Tr.debug(log, "pop", "No. of entries in contextStack after pop=" + contextStack.size());
            }
        }
        catch (WSSecurityException e) {
            FFDCFilter.processException((Throwable)e, "pop", "156", this);
            if (log.isDebugEnabled()) {
                Tr.debug(log, "pop", "The security ServiceContext cannot be popped, cause: " + e);
            }
            ServiceContextInvalid ex = new ServiceContextInvalid(this.getServiceName());
            ex.initCause(e);
            throw ex;
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "pop");
        }
    }

    public void push(ServiceContext c) throws ServiceContextInvalid {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "push", c);
        }
        Context ctx = null;
        try {
            ctx = c == null ? this.createDefaultContext() : (Context)((Object)c);
            try {
                this.doPrivSetOrRestore(ctx, true);
                Stack contextStack = (Stack)threadLocalContextStack.get();
                contextStack.push(ctx);
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "push", "No. of entries in contextStack after push=" + contextStack.size());
                }
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, "push", "210", this);
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "push", "The security ServiceContext cannot be pushed, cause: " + e);
                }
                ServiceContextInvalid ex = new ServiceContextInvalid(this.getServiceName());
                ex.initCause(e);
                throw ex;
            }
        }
        catch (WSSecurityException e) {
            if (log.isDebugEnabled()) {
                Tr.debug(log, "push", "The security ServiceContext cannot be pushed, cause: " + e);
            }
            ServiceContextInvalid ex = new ServiceContextInvalid(this.getServiceName());
            ex.initCause(e);
            throw ex;
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "push", "ServiceContext pushed=" + ctx);
        }
    }

    private Context createDefaultContext() throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "createDefaultContext");
        }
        ContextImpl ctx = new ContextImpl(true);
        if (log.isEntryEnabled()) {
            Tr.exit(log, "createDefaultContext", ctx);
        }
        return ctx;
    }

    private void doPrivSetOrRestore(final Context context, final boolean isSet) throws WSSecurityException {
        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (isSet) {
                    context.setContext();
                } else {
                    context.restoreContext();
                }
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            throw new WSSecurityException("PrivilegedActionException during set/restoreContext: " + e);
        }
    }
}

