/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.context;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.asynchbeans.ServiceContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.security.context.Domain;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.Token;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ContextImpl
implements Serializable,
Context,
ServiceContext {
    private static final long serialVersionUID = 1L;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int CURRENT_VERSION = 2;
    private static final TraceComponent log = Tr.register(ContextImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final SecurityManager sm = System.getSecurityManager();
    private static final WSOpaqueTokenHelper tkHelper = WSOpaqueTokenHelper.getInstance();
    private static Object syncCallerObject = new Object();
    private static Object syncRunAsObject = new Object();
    private static Object syncDeserializeSubjectObject = new Object();
    public static final String DESERIALIZE_ASYNCH_CONTEXT = "system.DESERIALIZE_ASYNCH_CONTEXT";
    public static final WebSphereRuntimePermission PERM_SET = new WebSphereRuntimePermission("setSecurityContext");
    public static final WebSphereRuntimePermission PERM_RESTORE = new WebSphereRuntimePermission("restoreSecurityContext");
    public static final WebSphereRuntimePermission PERM_RUN_WITH = new WebSphereRuntimePermission("runWithSecurityContext");
    public static final WebSphereRuntimePermission PERM_MODIFY_CONTEXT = new WebSphereRuntimePermission("modifySecurityContext");
    public static final WebSphereRuntimePermission PERM_READ_CONTEXT = new WebSphereRuntimePermission("readSecurityContext");
    private int version = 2;
    private boolean isCallerSame = true;
    private byte[] runAsSubjToken;
    private byte[] runAsLoginToken;
    private byte[] callerSubjToken;
    private byte[] callerLoginToken;
    private Domain domain;
    private transient Subject runAsSubj;
    private transient Subject callerSubj;
    private transient Map propagationTokens;
    private transient Stack contextStack = new Stack();
    private transient PrivilegedExceptionAction privGetRunAsSubject = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            ContextManager mgr = ContextManagerFactory.getInstance();
            Subject subj = mgr.getInvocationSubject();
            return subj;
        }
    };
    private transient PrivilegedExceptionAction privGetCallerSubject = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            ContextManager mgr = ContextManagerFactory.getInstance();
            Subject subj = mgr.getCallerSubject();
            return subj;
        }
    };

    public ContextImpl(boolean unauth) throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "ContextImpl(boolean)", "Create context for unauthenticated Subject? " + unauth);
        }
        try {
            this.retrieveAndSaveCurrentSubjects(unauth);
            ContextManager mgr = ContextManagerFactory.getInstance();
            this.propagationTokens = mgr.getPropagationTokens();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "ContextImpl", "248", this);
            WSSecurityException ex = new WSSecurityException("Unable to retrieve current Subjects");
            ex.initCause(e);
            throw ex;
        }
        SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
        this.domain = new Domain();
        if (scm.isAdminAgent()) {
            this.domain.setProfileId(AdminContext.peek());
        } else {
            SecurityConfigResource res = SecurityObjectLocator.popContext();
            if (res != null) {
                this.domain.setApplicationName(res.getName());
                this.domain.setApplicationType(res.getType());
            } else {
                this.domain.setApplicationName("");
                this.domain.setApplicationType("admin");
            }
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "ContextImpl");
        }
    }

    public ContextImpl() throws WSSecurityException {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object runWith(PrivilegedExceptionAction action) throws WSSecurityException {
        Object result;
        block33: {
            Exception actionEx;
            Subject popSubjCaller;
            Subject popSubjRunAs;
            ContextManager mgr;
            block34: {
                block35: {
                    if (log.isEntryEnabled()) {
                        Tr.entry(log, "runWith", action);
                    }
                    if (action == null) {
                        String error = "PrivilegedExceptionAction must not be null.";
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "runWith", error);
                        }
                        WSSecurityException ex = new WSSecurityException(error);
                        throw ex;
                    }
                    if (sm != null) {
                        sm.checkPermission(PERM_RUN_WITH);
                    }
                    mgr = ContextManagerFactory.getInstance();
                    popSubjRunAs = mgr.pushInvocationSubject(this.runAsSubj);
                    popSubjCaller = mgr.pushReceivedSubject(this.callerSubj);
                    if (log.isDebugEnabled()) {
                        Tr.debug(log, "runWith", "Context has been pushed on the running thread.");
                    }
                    result = null;
                    actionEx = null;
                    boolean domainPushed = false;
                    SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
                    try {
                        block32: {
                            try {
                                if (this.domain != null) {
                                    domainPushed = scm.isAdminAgent() ? AdminContext.push(this.domain.getProfileId()) : SecurityObjectLocator.pushContext(this.domain.getApplicationName(), this.domain.getApplicationType());
                                    if (log.isDebugEnabled()) {
                                        Tr.debug(log, "runWith Domain has been pushed on the running thread.");
                                    }
                                } else if (log.isDebugEnabled()) {
                                    Tr.debug(log, "runWith Domain is null, no domain pushed");
                                }
                                result = action.run();
                                if (!log.isDebugEnabled()) break block32;
                                Tr.debug(log, "runWith", "action.run() completed with no errors.");
                            }
                            catch (Exception e) {
                                actionEx = e;
                                FFDCFilter.processException((Throwable)e, "runWith", "344", this);
                                Object var11_12 = null;
                                if (domainPushed) {
                                    if (scm.isAdminAgent()) {
                                        AdminContext.pop();
                                    } else {
                                        SecurityObjectLocator.popContext();
                                    }
                                }
                                if (log.isDebugEnabled()) {
                                    Tr.debug(log, "runWith", "Domain has been popped from the running thread.");
                                }
                                mgr.popInvocationSubject(popSubjRunAs);
                                mgr.popReceivedSubject(popSubjCaller);
                                if (log.isDebugEnabled()) {
                                    Tr.debug(log, "runWith", "Context has been popped from the running thread.");
                                }
                                if (actionEx != null) {
                                    String error = "Exception " + actionEx + " ocurred while running action: " + action;
                                    if (log.isDebugEnabled()) {
                                        Tr.debug(log, "runWith", error);
                                    }
                                    WSSecurityException ex = new WSSecurityException(error);
                                    ex.initCause(actionEx);
                                    throw ex;
                                }
                                break block33;
                            }
                        }
                        Object var11_11 = null;
                        if (!domainPushed) break block34;
                        if (!scm.isAdminAgent()) break block35;
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (domainPushed) {
                            if (scm.isAdminAgent()) {
                                AdminContext.pop();
                            } else {
                                SecurityObjectLocator.popContext();
                            }
                        }
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "runWith", "Domain has been popped from the running thread.");
                        }
                        mgr.popInvocationSubject(popSubjRunAs);
                        mgr.popReceivedSubject(popSubjCaller);
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "runWith", "Context has been popped from the running thread.");
                        }
                        if (actionEx == null) {
                            throw throwable;
                        }
                        String error = "Exception " + actionEx + " ocurred while running action: " + action;
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "runWith", error);
                        }
                        WSSecurityException ex = new WSSecurityException(error);
                        ex.initCause(actionEx);
                        throw ex;
                    }
                    AdminContext.pop();
                    break block34;
                }
                SecurityObjectLocator.popContext();
            }
            if (log.isDebugEnabled()) {
                Tr.debug(log, "runWith", "Domain has been popped from the running thread.");
            }
            mgr.popInvocationSubject(popSubjRunAs);
            mgr.popReceivedSubject(popSubjCaller);
            if (log.isDebugEnabled()) {
                Tr.debug(log, "runWith", "Context has been popped from the running thread.");
            }
            if (actionEx != null) {
                String error = "Exception " + actionEx + " ocurred while running action: " + action;
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "runWith", error);
                }
                WSSecurityException ex = new WSSecurityException(error);
                ex.initCause(actionEx);
                throw ex;
            }
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "runWith", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runWithDomain(PrivilegedExceptionAction action) throws WSSecurityException {
        Exception actionEx;
        Object result;
        block21: {
            block22: {
                if (log.isEntryEnabled()) {
                    Tr.entry(log, "runWithDomain", action);
                }
                if (action == null) {
                    String error = "PrivilegedExceptionAction must not be null.";
                    if (log.isDebugEnabled()) {
                        Tr.debug(log, "runWithDomain", error);
                    }
                    WSSecurityException ex = new WSSecurityException(error);
                    throw ex;
                }
                if (sm != null) {
                    sm.checkPermission(PERM_RUN_WITH);
                }
                SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();
                boolean domainPushed = false;
                result = null;
                actionEx = null;
                try {
                    if (this.domain != null) {
                        domainPushed = scm.isAdminAgent() ? AdminContext.push(this.domain.getProfileId()) : SecurityObjectLocator.pushContext(this.domain.getApplicationName(), this.domain.getApplicationType());
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "runWithDomain", "Domain has been pushed on the running thread.");
                        }
                    }
                    try {
                        result = action.run();
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "runWithDomain", "action.run() completed with no errors.");
                        }
                    }
                    catch (Exception e) {
                        actionEx = e;
                        FFDCFilter.processException((Throwable)e, "runWithDomain", "434", this);
                    }
                    Object var8_9 = null;
                    if (!domainPushed) break block21;
                    if (!scm.isAdminAgent()) break block22;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (domainPushed) {
                        if (scm.isAdminAgent()) {
                            AdminContext.pop();
                        } else {
                            SecurityObjectLocator.popContext();
                        }
                    }
                    if (log.isDebugEnabled()) {
                        Tr.debug(log, "runWithDomain", "Domain has been popped from the running thread.");
                    }
                    if (actionEx != null) {
                        String error = "Exception " + actionEx + " ocurred while running action: " + action;
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "runWithDomain", error);
                        }
                        WSSecurityException ex = new WSSecurityException(error);
                        ex.initCause(actionEx);
                        throw ex;
                    }
                    throw throwable;
                }
                AdminContext.pop();
                break block21;
            }
            SecurityObjectLocator.popContext();
        }
        if (log.isDebugEnabled()) {
            Tr.debug(log, "runWithDomain", "Domain has been popped from the running thread.");
        }
        if (actionEx != null) {
            String error = "Exception " + actionEx + " ocurred while running action: " + action;
            if (log.isDebugEnabled()) {
                Tr.debug(log, "runWithDomain", error);
            }
            WSSecurityException ex = new WSSecurityException(error);
            ex.initCause(actionEx);
            throw ex;
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "runWithDomain", result);
        }
        return result;
    }

    public void restoreContext() throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "popContext");
        }
        if (this.contextStack.isEmpty()) {
            String error = "pushContext() must be invoked before popContext().";
            if (log.isDebugEnabled()) {
                Tr.debug(log, "popContext", error);
            }
            WSSecurityException ex = new WSSecurityException(error);
            throw ex;
        }
        if (sm != null) {
            sm.checkPermission(PERM_RESTORE);
        }
        ContextManager mgr = ContextManagerFactory.getInstance();
        mgr.popReceivedSubject((Subject)this.contextStack.pop());
        mgr.popInvocationSubject((Subject)this.contextStack.pop());
        if (log.isEntryEnabled()) {
            Tr.exit(log, "popContext");
        }
    }

    public void setContext() throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "pushContext");
        }
        if (sm != null) {
            sm.checkPermission(PERM_SET);
        }
        ContextManager mgr = ContextManagerFactory.getInstance();
        this.contextStack.push(mgr.pushInvocationSubject(this.runAsSubj));
        this.contextStack.push(mgr.pushReceivedSubject(this.callerSubj));
        if (log.isEntryEnabled()) {
            Tr.exit(log, "pushContext");
        }
    }

    public Subject getCallerSubject() {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "getCallerSubject");
        }
        if (sm != null) {
            sm.checkPermission(PERM_READ_CONTEXT);
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "getCallerSubject", this.callerSubj);
        }
        return this.callerSubj;
    }

    public Subject getRunAsSubject() {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "getRunAsSubject");
        }
        if (sm != null) {
            sm.checkPermission(PERM_READ_CONTEXT);
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "getRunAsSubject", this.runAsSubj);
        }
        return this.runAsSubj;
    }

    public void setCallerSubject(Subject caller) throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "setCallerSubject", caller);
        }
        if (sm != null) {
            sm.checkPermission(PERM_MODIFY_CONTEXT);
        }
        this.callerSubj = caller;
        boolean bl = this.isCallerSame = this.callerSubj == this.runAsSubj;
        if (log.isEntryEnabled()) {
            Tr.exit(log, "setCallerSubject", this.callerSubj);
        }
    }

    public void setRunAsSubject(Subject runAs) throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "setRunAsSubject", runAs);
        }
        if (sm != null) {
            sm.checkPermission(PERM_MODIFY_CONTEXT);
        }
        this.runAsSubj = runAs;
        boolean bl = this.isCallerSame = this.callerSubj == this.runAsSubj;
        if (log.isEntryEnabled()) {
            Tr.exit(log, "setRunAsSubject", this.runAsSubj);
        }
    }

    public Map getPropagationTokens() throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "getPropagationTokens");
        }
        if (sm != null) {
            sm.checkPermission(PERM_READ_CONTEXT);
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "getPropagationTokens");
        }
        return this.propagationTokens;
    }

    public void setPropagationTokens(Map tokens) throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "setPropagationTokens", tokens);
        }
        if (sm != null) {
            sm.checkPermission(PERM_MODIFY_CONTEXT);
        }
        this.propagationTokens = tokens;
        if (log.isEntryEnabled()) {
            Tr.exit(log, "setPropagationTokens");
        }
    }

    public Domain getDomain() {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "getDomain");
        }
        if (sm != null) {
            sm.checkPermission(PERM_READ_CONTEXT);
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "getDomain", this.domain);
        }
        return this.domain;
    }

    public void setDomain(Domain _domain) throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "setDomain", _domain);
        }
        if (sm != null) {
            sm.checkPermission(PERM_MODIFY_CONTEXT);
        }
        this.domain = _domain;
        if (log.isEntryEnabled()) {
            Tr.exit(log, "setDomain");
        }
    }

    private boolean isCallerSame() {
        return this.isCallerSame;
    }

    private void retrieveAndSaveCurrentSubjects(boolean unauth) throws PrivilegedActionException, WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "retrieveAndSaveCurrentSubjects", "Use unauthenticated Subject? " + unauth);
        }
        if (unauth) {
            Subject subj;
            ContextManager mgr = ContextManagerFactory.getInstance();
            this.runAsSubj = subj = mgr.createUnauthenticatedSubject();
            this.isCallerSame = this.callerSubj == this.runAsSubj;
            this.callerSubj = subj;
            this.isCallerSame = this.callerSubj == this.runAsSubj;
        } else {
            this.runAsSubj = (Subject)AccessController.doPrivileged(this.privGetRunAsSubject);
            this.isCallerSame = this.callerSubj == this.runAsSubj;
            this.callerSubj = (Subject)AccessController.doPrivileged(this.privGetCallerSubject);
            boolean bl = this.isCallerSame = this.callerSubj == this.runAsSubj;
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "retrieveAndSaveCurrentSubjects");
        }
    }

    void initForTest(int ver, String[] id, Subject[] subj, byte[][] runAs, byte[][] caller) {
        this.version = ver;
        this.runAsSubj = subj[0];
        this.callerSubj = subj[1];
        this.runAsSubjToken = runAs[0];
        this.runAsLoginToken = runAs[1];
        this.callerSubjToken = caller[0];
        this.callerLoginToken = caller[1];
    }

    private Subject doLogin(byte[] loginToken, byte[] subjToken) throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "doLogin", new Object[]{"Login token=" + loginToken, "Subject token=" + subjToken});
        }
        ContextManager mgr = ContextManagerFactory.getInstance();
        if (loginToken == null) {
            if (log.isEntryEnabled()) {
                Tr.exit(log, "doLogin", "Login token is null, returning unauthenticated.");
            }
            return mgr.createUnauthenticatedSubject();
        }
        Subject result = null;
        String realm = mgr.getDefaultRealm();
        String loginConfig = DESERIALIZE_ASYNCH_CONTEXT;
        HttpServletRequest req = null;
        HttpServletResponse resp = null;
        HashMap<String, Boolean> appCtx = new HashMap<String, Boolean>();
        appCtx.put("com.ibm.ws.security.context.renewToken", Boolean.TRUE);
        try {
            this.createAndCacheTokenHolderList(subjToken);
            result = mgr.login(realm, loginToken, loginConfig, req, resp, appCtx);
            this.removeTokenHolderListFromCache();
        }
        catch (WSLoginFailedException e) {
            FFDCFilter.processException((Throwable)e, "doLogin", "717", this);
            WSSecurityException ex = new WSSecurityException("Failed to deserialize Context.");
            ex.initCause(e);
            throw ex;
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "doLogin");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createSubjectToken(Subject subj) throws WSLoginFailedException, WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "createSubjectToken", "Subject is null? " + (subj == null));
        }
        byte[] result = null;
        if (subj != null) {
            ContextManager mgr = ContextManagerFactory.getInstance();
            Map tokens = mgr.getPropagationTokens();
            mgr.setPropagationTokens(this.propagationTokens);
            try {
                result = tkHelper.createOpaqueTokenFromSubject(subj);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                mgr.setPropagationTokens(tokens);
                throw throwable;
            }
            mgr.setPropagationTokens(tokens);
            {
            }
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "createSubjectToken", "Token created is null? " + (result == null));
        }
        return result;
    }

    private ArrayList createAndCacheTokenHolderList(byte[] subj) throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "createAndCacheTokenHolderList", subj);
        }
        ContextManager mgr = ContextManagerFactory.getInstance();
        ArrayList tokenList = tkHelper.createTokenHolderListFromOpaqueToken(subj);
        String cacheKey = tkHelper.getOpaqueTokenLookup();
        mgr.put(cacheKey, tokenList);
        if (log.isEntryEnabled()) {
            Tr.exit(log, "createAndCacheTokenHolderList", "tokenList=" + tokenList);
        }
        return tokenList;
    }

    private void removeTokenHolderListFromCache() {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "removeTokenHolderListFromCache");
        }
        ContextManager mgr = ContextManagerFactory.getInstance();
        String cacheKey = tkHelper.getOpaqueTokenLookup();
        mgr.put(cacheKey, null);
        if (log.isEntryEnabled()) {
            Tr.exit(log, "removeTokenHolderListFromCache");
        }
    }

    public String toString() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StringBuffer buf = new StringBuffer(super.toString());
                buf.append(", RunAs=" + ContextImpl.this.runAsSubj);
                buf.append(", Caller=" + ContextImpl.this.callerSubj);
                return buf.toString();
            }
        });
    }

    long getExpirationCushion(SecurityConfig sconfig) {
        long gracePeriod;
        block12: {
            if (log.isEntryEnabled()) {
                Tr.entry(log, "getExpirationCushion", "SecurityConfig = " + sconfig);
            }
            gracePeriod = 60000L;
            try {
                if (sconfig != null) {
                    try {
                        long maxCushion = Long.valueOf(sconfig.getProperty("com.ibm.ws.security.cacheCushionMax")) * 60000L;
                        long cushion = Long.valueOf(sconfig.getProperty("com.ibm.ws.security.authCacheCushionTime")) * 60000L;
                        if (cushion > maxCushion) {
                            gracePeriod = maxCushion;
                        } else if (cushion > 0L) {
                            gracePeriod = cushion;
                        }
                        break block12;
                    }
                    catch (NumberFormatException ex) {
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "NumberFormatException Unable to get security configuration, default value will be used.");
                        }
                        break block12;
                    }
                }
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "Unable to get security configuration, default value will be used.");
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "getExpirationCushion", "831", this);
                if (!log.isDebugEnabled()) break block12;
                Tr.debug(log, "Exception " + ex + " ignored, default value will be used.");
            }
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "getExpirationCushion", "Expiration cushion value = " + gracePeriod);
        }
        return gracePeriod;
    }

    private byte[] privCreateSubjectToken(final Subject mySub) throws WSLoginFailedException, WSSecurityException, PrivilegedActionException {
        return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return ContextImpl.this.createSubjectToken(mySub);
            }
        });
    }

    private AuthenticationToken privCreateAuthTokenFromWSCredential(final WSCredential cred, final WSCredentialTokenMapperInterface mapper) throws WSLoginFailedException, PrivilegedActionException {
        return (AuthenticationToken)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return mapper.createAuthTokenFromWSCredential(cred);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException, Exception {
        block23: {
            if (log.isEntryEnabled()) {
                Tr.entry(log, "writeObject", out);
            }
            try {
                boolean isCushionValid;
                Object object;
                ContextManager mgr = ContextManagerFactory.getInstance();
                WSCredentialTokenMapperInterface mapper = mgr.getWSCredTokenMapper();
                SecurityConfig sconfig = SecurityObjectLocator.getSecurityConfig();
                WSCredential cred = null;
                Token token = null;
                if (this.runAsSubj != null) {
                    object = syncRunAsObject;
                    synchronized (object) {
                        isCushionValid = mapper.checkCushionValidityOfAllTokens(this.runAsSubj, this.getExpirationCushion(sconfig), true);
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "checkCushionValidityOfAllTokens = " + isCushionValid);
                        }
                        if ((cred = SubjectHelper.getWSCredentialFromSubject(this.runAsSubj)) != null && !cred.isUnauthenticated()) {
                            this.runAsSubjToken = this.privCreateSubjectToken(this.runAsSubj);
                            token = this.privCreateAuthTokenFromWSCredential(cred, mapper);
                        }
                        this.runAsLoginToken = token != null ? token.getBytes() : null;
                    }
                }
                if (!this.isCallerSame()) {
                    token = null;
                    object = syncCallerObject;
                    synchronized (object) {
                        isCushionValid = mapper.checkCushionValidityOfAllTokens(this.callerSubj, this.getExpirationCushion(sconfig), true);
                        if (log.isDebugEnabled()) {
                            Tr.debug(log, "checkCushionValidityOfAllTokens = " + isCushionValid);
                        }
                        if ((cred = SubjectHelper.getWSCredentialFromSubject(this.callerSubj)) != null && !cred.isUnauthenticated()) {
                            this.callerSubjToken = this.privCreateSubjectToken(this.callerSubj);
                            token = this.privCreateAuthTokenFromWSCredential(cred, mapper);
                        }
                        this.callerLoginToken = token != null ? token.getBytes() : null;
                        break block23;
                    }
                }
                this.callerSubjToken = this.runAsSubjToken;
                this.callerLoginToken = this.runAsLoginToken;
            }
            catch (PrivilegedActionException e) {
                Throwable rootException = e.getCause();
                if ((rootException instanceof WSLoginFailedException || rootException instanceof WSSecurityException) && log.isDebugEnabled()) {
                    Tr.debug(log, "writeObject: swallowing doPriv login failure");
                }
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "writeObject", "949", this);
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "writeObject", e);
                }
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, "writeObject", "954", this);
                if (!log.isDebugEnabled()) break block23;
                Tr.debug(log, "writeObject", e);
            }
        }
        ObjectOutputStream.PutField fields = out.putFields();
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer("Serializing Context version: " + this.version + ", serialVersionUID=" + 1L);
            buf.append(", isCallerSame=" + this.isCallerSame);
            buf.append(", runAsSubjToken=" + this.runAsSubjToken + ", runAsLoginToken=" + this.runAsLoginToken);
            buf.append(", callerSubjToken=" + this.callerSubjToken + ", callerLoginToken=" + this.callerLoginToken);
            Tr.debug(log, "writeObject", buf.toString());
        }
        fields.put("version", this.version);
        fields.put("isCallerSame", this.isCallerSame);
        fields.put("runAsSubjToken", this.runAsSubjToken);
        fields.put("runAsLoginToken", this.runAsLoginToken);
        if (!this.isCallerSame) {
            fields.put("callerSubjToken", this.callerSubjToken);
            fields.put("callerLoginToken", this.callerLoginToken);
        }
        if (this.version == 2) {
            fields.put("domain", this.domain);
        }
        out.writeFields();
        if (log.isEntryEnabled()) {
            Tr.exit(log, "writeObject", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "readObject", in);
        }
        Object object = syncDeserializeSubjectObject;
        synchronized (object) {
            ObjectInputStream.GetField fields = in.readFields();
            this.version = fields.get("version", 2);
            switch (this.version) {
                case 1: 
                case 2: {
                    if (log.isDebugEnabled()) {
                        Tr.debug(log, "readObject", "Deserializing Context version: " + this.version + ", serialVersionUID=" + 1L);
                    }
                    this.readState(fields, this.version);
                    break;
                }
                default: {
                    try {
                        Tr.warning(log, "The version of the Context being deserialized is: " + this.version + ", it does not match the supported version: " + 2 + ", an attempt will be made to deserialize the required state.");
                        this.readState(fields, 1);
                        break;
                    }
                    catch (IOException e) {
                        throw new InvalidClassException("Unsupported Context version: " + this.version + ", exception: " + e);
                    }
                }
            }
            this.contextStack = new Stack();
            try {
                this.deserializeSubjects();
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, "readObject", "1035", this);
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "readObject", "Unable to deserialize the Subjects in this Context, cause: " + e);
                }
                IOException ex = new IOException("Unable to deserialize the Subjects in this Context");
                ex.initCause(e);
                throw ex;
            }
            if (log.isEntryEnabled()) {
                Tr.exit(log, "readObject", this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserializeSubjects() throws WSSecurityException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "deserializeSubjects", "perform login to get runAsSubject");
        }
        ContextManager mgr = ContextManagerFactory.getInstance();
        Map tokens = mgr.getPropagationTokens();
        try {
            mgr.setPropagationTokens(null);
            if (log.isDebugEnabled()) {
                Tr.debug(log, "deserializeSubjects", "Propagation Tokens before login: " + tokens);
            }
            Subject subj = this.doLogin(this.runAsLoginToken, this.runAsSubjToken);
            if (this.isCallerSame()) {
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "deserializeSubjects", "callerSubject is same as runAsSubject, no need to perform login for callerSubject.");
                }
                this.setRunAsSubject(subj);
                this.setCallerSubject(subj);
                this.setPropagationTokens(mgr.getPropagationTokens());
            } else {
                if (log.isDebugEnabled()) {
                    Tr.debug(log, "deserializeSubjects", "callerSubject is not same as runAsSubject, must perform login to get callerSubject.");
                }
                this.setRunAsSubject(subj);
                mgr.setPropagationTokens(null);
                this.setCallerSubject(this.doLogin(this.callerLoginToken, this.callerSubjToken));
                this.setPropagationTokens(mgr.getPropagationTokens());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            mgr.setPropagationTokens(tokens);
            throw throwable;
        }
        mgr.setPropagationTokens(tokens);
        if (log.isEntryEnabled()) {
            Tr.exit(log, "deserializeSubjects", "Subjects have been successfully deserialized.");
        }
    }

    private void readState(ObjectInputStream.GetField fields, int version) throws IOException {
        if (log.isEntryEnabled()) {
            Tr.entry(log, "readState");
        }
        this.isCallerSame = fields.get("isCallerSame", true);
        this.runAsSubjToken = (byte[])fields.get("runAsSubjToken", null);
        this.runAsLoginToken = (byte[])fields.get("runAsLoginToken", null);
        if (!this.isCallerSame) {
            this.callerSubjToken = (byte[])fields.get("callerSubjToken", null);
            this.callerLoginToken = (byte[])fields.get("callerLoginToken", null);
        }
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer("Deserialized Context version: " + version + ", serialVersionUID=" + 1L);
            buf.append(", isCallerSame=" + this.isCallerSame);
            buf.append(", runAsSubjToken=" + this.runAsSubjToken + ", runAsLoginToken=" + this.runAsLoginToken);
            buf.append(", callerSubjToken=" + this.callerSubjToken + ", callerLoginToken=" + this.callerLoginToken);
            Tr.debug(log, "readState", buf.toString());
        }
        if (version == 2) {
            this.domain = (Domain)fields.get("domain", null);
        }
        if (log.isEntryEnabled()) {
            Tr.exit(log, "readState", "Context state has been successfully deserialized.");
        }
    }
}

