/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.configrpt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.configrpt.Controller;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecItemsReportDomain {
    private static Vector report;
    String pathName = null;
    String profileName = null;
    String wasVersion = null;
    String status = "false";
    boolean fileFound = false;
    int index = 0;
    boolean SAFAuthz = false;
    String domain_Name = null;
    private static ResourceBundle resBundle;
    private static final TraceComponent tc;

    public String doCheck(String path, Locale locale) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "doCheck");
        }
        int result = 0;
        report = new Vector();
        this.fileFound = false;
        Hashtable h = new Hashtable();
        String S = new String();
        resBundle = locale != null ? ResourceBundle.getBundle("com.ibm.ejs.resources.security", locale) : ResourceBundle.getBundle("com.ibm.ejs.resources.security", Locale.getDefault());
        File f = new File(path);
        this.pathName = f.getAbsolutePath();
        int tempResult = this.checkInConfig(f, "domain-security.xml");
        if (tempResult > result) {
            result = tempResult;
        }
        for (int count = 0; count < this.index; ++count) {
            h = (Hashtable)report.get(count);
            S = S + (String)h.get("label") + " ; " + (String)h.get("name") + " ; " + (String)h.get("value") + " ; " + (String)h.get("navigation") + " ; " + "\n";
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "doCheck");
        }
        return S;
    }

    private static String getLabel(String key) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getLabel");
        }
        String message = " ";
        try {
            message = resBundle.getString(key);
            if (message == null) {
                message = new String("Cannot find message key " + key + " in resource bundle" + resBundle.toString());
            }
        }
        catch (Exception e) {
            message = new String(key);
            return message;
        }
        if (message.startsWith("SECJ")) {
            message = message.substring(11, message.length());
        }
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getLabel");
        }
        return message;
    }

    private int findSecParametersInXMLDoc(Document d, String domainName, List resourceName) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findSecParametersInXMLDoc");
        }
        this.domain_Name = domainName;
        int result = 0;
        int tempResult = 0;
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        String label = new String();
        hashTable.put("label", "DOMAIN");
        hashTable.put("name", domainName);
        hashTable.put("value", "resourceName");
        hashTable.put("navigation", "resourceType");
        report.add(this.index, hashTable);
        ++this.index;
        hashTable = new Hashtable(4);
        label = new String();
        hashTable.put("label", SecItemsReportDomain.getLabel("security.configrpt.core.Security.Console.Name"));
        hashTable.put("name", SecItemsReportDomain.getLabel("security.configrpt.core.Security.Configuration.Name"));
        hashTable.put("value", SecItemsReportDomain.getLabel("security.configrpt.core.Value"));
        hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security.Console.Path.Name"));
        report.add(this.index, hashTable);
        ++this.index;
        NodeList secItem = d.getElementsByTagName("security:AppSecurity");
        if (secItem.getLength() != 0) {
            hashTable = new Hashtable(4);
            hashTable.put("label", "_" + SecItemsReportDomain.getLabel("security.configrpt.core.Security.Settings"));
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", " ");
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findSecSettings(d, "security:AppSecurity", 0);
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("authMechanisms")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.Authentication.Mechanisms");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + domainName + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.AuthMechanism"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "authMechanisms");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("userRegistries")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.User.Registry");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + domainName + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.User.Registry"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findUserRegSettings(d);
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("authConfig")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.Auth.Config");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + domainName + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.Auth.Config"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "authConfig");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("applicationLoginConfig")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.Application.Login.Config");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + domainName + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.application.jaas"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "applicationLoginConfig");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("CSI")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.CSI");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + domainName + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.CSI"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "CSI");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("IBM")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.IBM");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.ejbAuth"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "IBM");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("repertoire")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.repertoire");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.SecureEndpoint"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "repertoire");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("keyStores")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.keyStore");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keyStore"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "keyStores");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("trustManagers")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.trustManager");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.trustManager"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "trustManagers");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("keyManagers")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.keyManager");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keyManager"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "keyManagers");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("sslConfigGroups")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.sslConfig");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.sslConfig"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "sslConfigGroups");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("managementScopes")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.managementScope");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.SecureEndpoint"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "managementScopes");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("keySetGroups")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.keySetGroup");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keySetGroup"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "keySetGroups");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("keySets")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.keySets");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keySets"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "keySets");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("wsSchedules")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.WSSchedule");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.CertExpMonitor"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "wsSchedules");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("wsNotifications")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.WSNotification");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.CertExpMonitor"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "wsNotifications");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("wsCertificateExpirationMonitor")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.CertExpMonitor");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.CertExpMonitor"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "wsCertificateExpirationMonitor");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("systemLoginConfig")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.systemLoginConfig");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + domainName + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.system.jaas"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "systemLoginConfig");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("properties")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.properties");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + domainName + " > " + label);
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findPropertySettings(d, label);
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if ((secItem = d.getElementsByTagName("webAuthAttrs")).getLength() != 0) {
            hashTable = new Hashtable(4);
            label = SecItemsReportDomain.getLabel("security.configrpt.core.webAuthAttrs");
            hashTable.put("label", "_" + label);
            hashTable.put("name", " ");
            hashTable.put("value", " ");
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.webAuth"));
            report.add(this.index, hashTable);
            ++this.index;
            tempResult = this.findLoginSettings(d, "webAuthAttrs");
            if (tempResult > result) {
                result = tempResult;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findSecParametersInXMLDoc");
        }
        return result;
    }

    private int findUserRegSettings(Document d) {
        NodeList registries;
        int result = 0;
        String userReg = null;
        String navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.User.Registry");
        NodeList ses = d.getElementsByTagName("security:AppSecurity");
        if (ses.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no security field in domain-security.xml file");
            }
        } else {
            for (int i = 0; i < ses.getLength(); ++i) {
                Node serverEntry = ses.item(i);
                userReg = serverEntry.getAttributes().getNamedItem("activeUserRegistry").getNodeValue();
            }
        }
        if ((registries = d.getElementsByTagName("userRegistries")).getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no user registry field in domain-security.xml file");
            }
        } else {
            for (int i = 0; i < registries.getLength(); ++i) {
                Node registryEntry = registries.item(i);
                String regValue = registryEntry.getAttributes().getNamedItem("xmi:id").getNodeValue();
                if (!regValue.equals(userReg)) continue;
                NamedNodeMap attributes = registryEntry.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node node = attributes.item(j);
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                    Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
                    String label = SecItemsReportDomain.getLabel("security.configrpt.core." + nodeName);
                    hashTable.put("label", label);
                    hashTable.put("name", nodeName);
                    if (nodeName.equals("serverPassword") || nodeName.equals("bindPassword")) {
                        hashTable.put("value", "******");
                    } else {
                        hashTable.put("value", nodeValue);
                    }
                    hashTable.put("navigation", navigation);
                    report.add(this.index, hashTable);
                    ++this.index;
                }
            }
        }
        return result;
    }

    private int findLoginSettings(Document d, String s) {
        int result = 0;
        String navigation = new String();
        boolean underscore = false;
        if (s.equals("authMechanisms")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.AuthMechanism");
        } else if (s.equals("authConfig")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.Auth.Config");
        } else if (s.equals("systemLoginConfig")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.system.jaas");
        } else if (s.equals("applicationLoginConfig")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.application.jaas");
        } else if (s.equals("CSI")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.CSI");
        } else if (s.equals("IBM")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.ejbAuth");
        } else if (s.equals("repertoire")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.SecureEndpoint");
        } else if (s.equals("webAuthAttrs")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.webAuth") + " > " + SecItemsReportDomain.getLabel("security.configrpt.general.settings");
        } else if (s.equals("wsCertificateExpirationMonitor")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.CertExpMonitor");
        } else if (s.equals("keyStores")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keyStore");
        } else if (s.equals("wsNotifications")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.CertExpMonitor");
        } else if (s.equals("wsSchedules")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.CertExpMonitor");
        } else if (s.equals("keySets")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keySets");
        } else if (s.equals("keySetGroups")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keySetGroup");
        } else if (s.equals("sslConfigGroups")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.sslConfig");
        } else if (s.equals("keyManagers")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.keyManager");
        } else if (s.equals("trustManagers")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.trustManager");
        }
        NodeList loginConfig = d.getElementsByTagName(s);
        if (loginConfig.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no " + s + " field in domain-security.xml file");
            }
        } else {
            int item = 0;
            NamedNodeMap attributes = loginConfig.item(item).getAttributes();
            while (attributes != null) {
                for (int aCount = 0; aCount < attributes.getLength(); ++aCount) {
                    Node node = attributes.item(aCount);
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                    Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
                    String label = SecItemsReportDomain.getLabel("security.configrpt.core." + nodeName);
                    hashTable.put("label", label);
                    hashTable.put("name", nodeName);
                    if (nodeName.equals("timeout")) {
                        hashTable.put("value", nodeValue + " " + SecItemsReportDomain.getLabel("security.configrpt.minutes"));
                    } else if (nodeName.startsWith("frequency")) {
                        hashTable.put("value", nodeValue + " " + SecItemsReportDomain.getLabel("security.configrpt.days"));
                    } else if (nodeName.startsWith("password")) {
                        hashTable.put("value", "******");
                    } else {
                        hashTable.put("value", nodeValue);
                    }
                    if (navigation.length() > 0) {
                        hashTable.put("navigation", navigation);
                    } else {
                        hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + label);
                    }
                    report.add(this.index, hashTable);
                    ++this.index;
                }
                NodeList childNodes = loginConfig.item(item).getChildNodes();
                if (childNodes == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no user regsitry field in domain-security.xml file");
                    }
                } else {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node child = childNodes.item(i);
                        if (child.getNodeName().equals("#text")) continue;
                        String s1 = child.getNodeName();
                        this.addChildAttributes(child, s1, navigation);
                        NodeList grandChildNodes = child.getChildNodes();
                        for (int j = 0; j < grandChildNodes.getLength(); ++j) {
                            String s2 = grandChildNodes.item(j).getNodeName();
                            this.addChildAttributes(grandChildNodes.item(j), s2, navigation);
                            NodeList grtGrandChildNodes = grandChildNodes.item(j).getChildNodes();
                            for (int k = 0; k < grtGrandChildNodes.getLength(); ++k) {
                                String s3 = grtGrandChildNodes.item(k).getNodeName();
                                this.addChildAttributes(grtGrandChildNodes.item(k), s3, navigation);
                            }
                        }
                    }
                }
                if (loginConfig.item(++item) == null) break;
                attributes = loginConfig.item(item).getAttributes();
            }
        }
        return result;
    }

    private int addChildAttributes(Node child, String s, String navigation) {
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        int result = 0;
        if (s.equals("trustAssociation")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.trustAssociation");
        } else if (s.equals("interceptors")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.trustAssociation") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.TrustAssociation.interceptors");
        } else if (s.equals("singleSignon")) {
            navigation = SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.webAuth") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.SingleSignon");
        }
        if (!child.getNodeName().equals("#text")) {
            String label = SecItemsReportDomain.getLabel("security.configrpt.core." + s);
            hashTable.put("label", label);
            hashTable.put("name", s);
            hashTable.put("value", " ");
            if (navigation.length() > 0) {
                hashTable.put("navigation", navigation);
            } else {
                hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + label);
            }
            report.add(this.index, hashTable);
            ++this.index;
            NamedNodeMap attributes = child.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node node = attributes.item(j);
                String nodeName = node.getNodeName();
                String nodeValue = node.getNodeValue();
                if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                hashTable = new Hashtable(4);
                label = nodeName.equals("enabled") ? SecItemsReportDomain.getLabel("security.configrpt.core.enableTrust") : SecItemsReportDomain.getLabel("security.configrpt.core." + nodeName);
                hashTable.put("label", label);
                hashTable.put("name", nodeName);
                if (nodeName.startsWith("sessionGCI")) {
                    hashTable.put("value", nodeValue + " " + SecItemsReportDomain.getLabel("security.configrpt.milliseconds"));
                } else if (nodeName.startsWith("password")) {
                    hashTable.put("value", "******");
                } else {
                    hashTable.put("value", nodeValue);
                }
                if (navigation.length() > 0) {
                    hashTable.put("navigation", navigation);
                } else {
                    hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + label);
                }
                report.add(this.index, hashTable);
                ++this.index;
            }
        }
        return result;
    }

    private int findSecSettings(Document d, String s, int tab) {
        int result = 0;
        NodeList ses = d.getElementsByTagName(s);
        Node serverEntry = ses.item(0);
        NamedNodeMap attributes = serverEntry.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            String nodeName = node.getNodeName();
            String nodeValue = node.getNodeValue();
            if (nodeName.startsWith("xmi:") || nodeName.startsWith("xmlns:") || nodeName.equals("OID") || nodeName.equals("activeProtocol")) continue;
            Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
            String label = SecItemsReportDomain.getLabel("security.configrpt.core." + nodeName);
            hashTable.put("label", label);
            hashTable.put("name", nodeName);
            if (nodeName.equals("cacheTimeout")) {
                hashTable.put("value", nodeValue + " " + SecItemsReportDomain.getLabel("security.configrpt.seconds"));
            } else {
                hashTable.put("value", nodeValue);
            }
            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + SecItemsReportDomain.getLabel("security.configrpt.domain.securitySettings"));
            report.add(this.index, hashTable);
            ++this.index;
        }
        return result;
    }

    private int findPropertySettings(Document d, String mainLabel) {
        int result = 0;
        NodeList prop = d.getElementsByTagName("properties");
        if (prop.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no properties field in domain-security.xml file");
            }
        } else {
            for (int i = 2; i < prop.getLength(); ++i) {
                NamedNodeMap attributes = prop.item(i).getAttributes();
                String name = "name";
                String value = "value";
                boolean nameValue = true;
                String requiredName = "name";
                String requiredValue = "value";
                boolean written = false;
                for (int j = 0; j < attributes.getLength(); ++j) {
                    String label;
                    Hashtable<String, String> hashTable;
                    Node node = attributes.item(j);
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                    if (nodeName.equals("name")) {
                        name = node.getNodeValue();
                        nameValue = true;
                    } else if (nodeName.equals("value")) {
                        value = node.getNodeValue();
                        nameValue = true;
                    } else if (nodeName.equals("required")) {
                        if (written) {
                            hashTable = new Hashtable<String, String>(4);
                            label = SecItemsReportDomain.getLabel("security.configrpt.core.Security.property.name");
                            hashTable.put("label", label);
                            hashTable.put("name", nodeName);
                            hashTable.put("value", nodeValue);
                            hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + mainLabel);
                            report.add(this.index, hashTable);
                            ++this.index;
                        } else {
                            requiredName = nodeName;
                            requiredValue = nodeValue;
                        }
                        nameValue = false;
                    }
                    if (name.equals("name") || value.equals("value") || !nameValue) continue;
                    hashTable = new Hashtable(4);
                    label = SecItemsReportDomain.getLabel("security.configrpt.core.Security.property.name");
                    hashTable.put("label", label);
                    hashTable.put("name", name);
                    if (name.startsWith("com.ibm.audit.auditQueueSize")) {
                        hashTable.put("value", value + " " + SecItemsReportDomain.getLabel("security.configrpt.messages"));
                    } else {
                        hashTable.put("value", value);
                    }
                    if (name.startsWith("com.ibm.security.useFIPS")) {
                        hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReportDomain.getLabel("security.configrpt.secure.communications.fips"));
                    } else {
                        hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + mainLabel);
                    }
                    if (name.startsWith("com.ibm.security.SAF.authorization")) {
                        this.SAFAuthz = value.equals("true");
                    }
                    report.add(this.index, hashTable);
                    ++this.index;
                    written = true;
                    if (requiredName.equals("name") || requiredValue.equals("value")) continue;
                    hashTable = new Hashtable(4);
                    label = SecItemsReportDomain.getLabel("security.configrpt.core." + requiredName);
                    hashTable.put("label", label);
                    hashTable.put("name", requiredName);
                    hashTable.put("value", requiredValue);
                    hashTable.put("navigation", SecItemsReportDomain.getLabel("security.configrpt.core.Security") + " > " + SecItemsReportDomain.getLabel("security.configrpt.core.DomainSecurity") + " > " + this.domain_Name + " > " + mainLabel);
                    report.add(this.index, hashTable);
                    ++this.index;
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public String checkName() {
        return "All parameters";
    }

    public String profileName() {
        return this.pathName;
    }

    public String pathName() {
        return this.pathName;
    }

    public String getStatus() {
        return this.status;
    }

    private int checkInConfig(File f, String configFile) {
        int result = 0;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "checkInConfig");
        }
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory() || !kiddos[i].getName().equals("config")) continue;
            String absolutePath = kiddos[i].getAbsolutePath();
            int tempResult = this.checkSecurityConfig(absolutePath, configFile);
            if (tempResult <= result) break;
            result = tempResult;
            break;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "checkInConfig");
        }
        return result;
    }

    private int checkSecurityConfig(String fileName, String configFile) {
        File f;
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "checkSecurityConfig, file: " + fileName);
        }
        if (!(f = new File(fileName + "/waspolicies/default/securitydomains")).isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to find directory " + fileName + "/waspolicies/default/securitydomains, unable to continue security check");
            }
            return 2;
        }
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "checkSecurityConfig");
        }
        return this.processSecurityDomains(f);
    }

    private int processSecurityDomains(File f) {
        int result = 0;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "processSecurityDomains, file: " + f.getName());
        }
        File[] domainDirs = f.listFiles();
        for (int i = 0; i < domainDirs.length; ++i) {
            if (!domainDirs[i].isDirectory()) continue;
            this.getDomainInfo(domainDirs[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "processSecurityDomains");
        }
        return result;
    }

    private void getDomainInfo(File f) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getDomainInfo");
        }
        String domainName = new String();
        ArrayList<String> resourceName = new ArrayList<String>();
        ArrayList<String> resourceType = new ArrayList<String>();
        File domainFile = null;
        boolean domainMap = false;
        boolean domainSec = false;
        File[] domainFiles = f.listFiles();
        for (int j = 0; j < domainFiles.length; ++j) {
            if (domainFiles[j].getName().equals("domain-security-map.xml")) {
                try {
                    NodeList members;
                    Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(domainFiles[j]);
                    NodeList ses = xmlDoc.getElementsByTagName("security:SecurityDomain");
                    if (ses.getLength() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "error: no security:SecurityDomain field in domain-security-map.xml file");
                        }
                    } else {
                        Node domainMapEntry = ses.item(0);
                        NamedNodeMap attributes = domainMapEntry.getAttributes();
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            Node node = attributes.item(i);
                            String nodeName = node.getNodeName();
                            String nodeValue = node.getNodeValue();
                            if (!nodeName.equals("name")) continue;
                            domainName = nodeValue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the domainName is: " + domainName);
                        }
                    }
                    if ((members = xmlDoc.getElementsByTagName("members")).getLength() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "no member field in domain-security-map.xml file");
                        }
                    } else {
                        for (int i = 0; i < members.getLength(); ++i) {
                            Node memberEntry = members.item(i);
                            String resName = memberEntry.getAttributes().getNamedItem("resourceName").getNodeValue();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "the resourceName is: " + resName);
                            }
                            resourceName.add(resName);
                            String resType = memberEntry.getAttributes().getNamedItem("resourceType").getNodeValue();
                            resourceType.add(resType);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "the resourceType is: " + resType);
                        }
                    }
                    domainMap = true;
                    if (!domainSec || domainFile == null) continue;
                    this.configCheckInFile(domainFile, domainName, resourceName);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Exception in attempting to parse XML file " + f.getName() + " to find domain map information");
                }
                continue;
            }
            if (!domainFiles[j].getName().equals("domain-security.xml")) continue;
            if (domainMap) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the domainName is: " + domainName);
                }
                this.configCheckInFile(domainFiles[j], domainName, resourceName);
                continue;
            }
            domainFile = domainFiles[j];
            domainSec = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getDomainInfo");
        }
    }

    private int configCheckInFile(File file, String domainName, ArrayList resourceName) {
        int result = 0;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "configCheckInFile");
        }
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            this.fileFound = true;
            int tempResult = 0;
            if (file.getName().equals("domain-security.xml")) {
                tempResult = this.findSecParametersInXMLDoc(xmlDoc, domainName, resourceName);
            }
            if (tempResult > result) {
                result = tempResult;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in attempting to parse XML file " + file.getName() + " to find domain information");
            }
            result = 1;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "configCheckInFile");
        }
        return result;
    }

    static {
        tc = Tr.register(Controller.class, null, "com.ibm.ejs.resources.security");
    }
}

