/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.configrpt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.configrpt.Controller;
import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecItemsReport {
    private static Vector report;
    String pathName = null;
    String profileName = null;
    String wasVersion = null;
    String status = "false";
    boolean fileFound = false;
    int index = 0;
    boolean SAFAuthz = false;
    private static ResourceBundle resBundle;
    private static final TraceComponent tc;

    public String doCheck(String path, Locale locale) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "doCheck");
        }
        int result = 0;
        report = new Vector();
        this.fileFound = false;
        Hashtable h = new Hashtable();
        String S = new String();
        resBundle = locale != null ? ResourceBundle.getBundle("com.ibm.ejs.resources.security", locale) : ResourceBundle.getBundle("com.ibm.ejs.resources.security", Locale.getDefault());
        File f = new File(path);
        this.pathName = f.getAbsolutePath();
        int tempResult = this.checkInConfig(f, "security.xml");
        if (tempResult > result) {
            result = tempResult;
        }
        if ((tempResult = this.checkInConfig(f, "admin-authz.xml")) > result) {
            result = tempResult;
        }
        if ((tempResult = this.checkInConfig(f, "naming-authz.xml")) > result) {
            result = tempResult;
        }
        for (int count = 0; count < this.index; ++count) {
            h = (Hashtable)report.get(count);
            S = S + (String)h.get("label") + " ; " + (String)h.get("name") + " ; " + (String)h.get("value") + " ; " + (String)h.get("navigation") + " ; " + "\n";
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "doCheck");
        }
        return S;
    }

    private static String getLabel(String key) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getLabel");
        }
        String message = " ";
        try {
            message = resBundle.getString(key);
            if (message == null) {
                message = new String("Cannot find message key " + key + " in resource bundle" + resBundle.toString());
            }
        }
        catch (Exception e) {
            message = new String(key);
            return message;
        }
        if (message.startsWith("SECJ")) {
            message = message.substring(11, message.length());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getLabel");
        }
        return message;
    }

    private int findSecParametersInXMLDoc(Document d) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findSecParametersInXMLDoc");
        }
        int result = 0;
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        String label = new String();
        hashTable.put("label", "DOMAIN");
        hashTable.put("name", "Cell");
        hashTable.put("value", "resourceName");
        hashTable.put("navigation", "resourceType");
        report.add(this.index, hashTable);
        ++this.index;
        hashTable = new Hashtable(4);
        hashTable.put("label", SecItemsReport.getLabel("security.configrpt.core.Security.Console.Name"));
        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.core.Security.Configuration.Name"));
        hashTable.put("value", SecItemsReport.getLabel("security.configrpt.core.Value"));
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security.Console.Path.Name"));
        report.add(this.index, hashTable);
        ++this.index;
        hashTable = new Hashtable(4);
        hashTable.put("label", "_" + SecItemsReport.getLabel("security.configrpt.core.Security.Settings"));
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", " ");
        report.add(this.index, hashTable);
        ++this.index;
        int tempResult = this.findSecSettings(d, "security:Security", 0);
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.Authentication.Mechanisms");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + label);
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "authMechanisms");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.User.Registry");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.activeUserRegistry"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findUserRegSettings(d);
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.Auth.Config");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Ext.authorizationProviders"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "authConfig");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.Application.Login.Config");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.jaasAuth"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "applicationLoginConfig");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.CSI");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.ejbAuth"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "CSI");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.IBM");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.ejbAuth"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "IBM");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.repertoire");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.SecureEndpoint"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "repertoire");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.keyStore");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keyStore"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "keyStores");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.trustManager");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.trustManager"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "trustManagers");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.keyManager");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keyManager"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "keyManagers");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.sslConfig");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.sslConfig"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "sslConfigGroups");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.managementScope");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.SecureEndpoint"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "managementScopes");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.keySetGroup");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keySetGroup"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "keySetGroups");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.keySets");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keySets"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "keySets");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.WSSchedule");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.CertExpMonitor"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "wsSchedules");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.WSNotification");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.CertExpMonitor"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "wsNotifications");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.CertExpMonitor");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.CertExpMonitor"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "wsCertificateExpirationMonitor");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.systemLoginConfig");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.jaasAuth"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "systemLoginConfig");
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.properties");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + label);
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findPropertySettings(d, label);
        if (tempResult > result) {
            result = tempResult;
        }
        hashTable = new Hashtable(4);
        label = SecItemsReport.getLabel("security.configrpt.core.webAuthAttrs");
        hashTable.put("label", "_" + label);
        hashTable.put("name", " ");
        hashTable.put("value", " ");
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.webAuth"));
        report.add(this.index, hashTable);
        ++this.index;
        tempResult = this.findLoginSettings(d, "webAuthAttrs");
        if (tempResult > result) {
            result = tempResult;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findSecParametersInXMLDoc");
        }
        return result;
    }

    private int findUserRegSettings(Document d) {
        NodeList registries;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findUserRegSettings");
        }
        int result = 0;
        String userReg = null;
        String navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.activeUserRegistry");
        NodeList ses = d.getElementsByTagName("security:Security");
        if (ses.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error: no security field in security.xml file");
            }
        } else {
            for (int i = 0; i < ses.getLength(); ++i) {
                Node serverEntry = ses.item(i);
                userReg = serverEntry.getAttributes().getNamedItem("activeUserRegistry").getNodeValue();
            }
        }
        if ((registries = d.getElementsByTagName("userRegistries")).getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error: no user Registry field in security.xml file");
            }
        } else {
            for (int i = 0; i < registries.getLength(); ++i) {
                Node registryEntry = registries.item(i);
                String regValue = registryEntry.getAttributes().getNamedItem("xmi:id").getNodeValue();
                if (!regValue.equals(userReg)) continue;
                NamedNodeMap attributes = registryEntry.getAttributes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node node = attributes.item(j);
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                    Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
                    String label = SecItemsReport.getLabel("security.configrpt.core." + nodeName);
                    hashTable.put("label", label);
                    hashTable.put("name", nodeName);
                    if (nodeName.equals("serverPassword") || nodeName.equals("bindPassword")) {
                        hashTable.put("value", "******");
                    } else {
                        hashTable.put("value", nodeValue);
                    }
                    hashTable.put("navigation", navigation);
                    report.add(this.index, hashTable);
                    ++this.index;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findUserRegSettings");
        }
        return result;
    }

    private int findLoginSettings(Document d, String s) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findLoginSettings");
        }
        int result = 0;
        String navigation = new String();
        boolean underscore = false;
        if (s.equals("authMechanisms")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.AuthMechanism");
        } else if (s.equals("authConfig")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Ext.authorizationProviders");
        } else if (s.equals("systemLoginConfig")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.jaasAuth") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.systemLogin");
        } else if (s.equals("applicationLoginConfig")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.jaasAuth") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.applicationLogin");
        } else if (s.equals("CSI")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.ejbAuth");
        } else if (s.equals("IBM")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.ejbAuth");
        } else if (s.equals("repertoire")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.SecureEndpoint");
        } else if (s.equals("webAuthAttrs")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.webAuth") + " > " + SecItemsReport.getLabel("security.configrpt.general.settings");
        } else if (s.equals("wsCertificateExpirationMonitor")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.CertExpMonitor");
        } else if (s.equals("keyStores")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keyStore");
        } else if (s.equals("wsNotifications")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.CertExpMonitor");
        } else if (s.equals("wsSchedules")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.CertExpMonitor");
        } else if (s.equals("keySets")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keySets");
        } else if (s.equals("keySetGroups")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keySetGroup");
        } else if (s.equals("sslConfigGroups")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.sslConfig");
        } else if (s.equals("keyManagers")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.keyManager");
        } else if (s.equals("trustManagers")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.trustManager");
        }
        NodeList loginConfig = d.getElementsByTagName(s);
        if (loginConfig.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error: no " + s + " field in security.xml file");
            }
        } else {
            int item = 0;
            NamedNodeMap attributes = loginConfig.item(item).getAttributes();
            while (attributes != null) {
                for (int aCount = 0; aCount < attributes.getLength(); ++aCount) {
                    Node node = attributes.item(aCount);
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                    Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
                    String label = SecItemsReport.getLabel("security.configrpt.core." + nodeName);
                    hashTable.put("label", label);
                    hashTable.put("name", nodeName);
                    if (nodeName.equals("timeout")) {
                        hashTable.put("value", nodeValue + " " + SecItemsReport.getLabel("security.configrpt.minutes"));
                    } else if (nodeName.startsWith("frequency")) {
                        hashTable.put("value", nodeValue + " " + SecItemsReport.getLabel("security.configrpt.days"));
                    } else if (nodeName.startsWith("password")) {
                        hashTable.put("value", "******");
                    } else {
                        hashTable.put("value", nodeValue);
                    }
                    if (navigation.length() > 0) {
                        hashTable.put("navigation", navigation);
                    } else {
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + label);
                    }
                    report.add(this.index, hashTable);
                    ++this.index;
                }
                NodeList childNodes = loginConfig.item(item).getChildNodes();
                if (childNodes == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error: no user Registry field in security.xml file");
                    }
                } else {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node child = childNodes.item(i);
                        if (child.getNodeName().equals("#text")) continue;
                        String s1 = child.getNodeName();
                        this.addChildAttributes(child, s1, navigation);
                        NodeList grandChildNodes = child.getChildNodes();
                        for (int j = 0; j < grandChildNodes.getLength(); ++j) {
                            String s2 = grandChildNodes.item(j).getNodeName();
                            this.addChildAttributes(grandChildNodes.item(j), s2, navigation);
                            NodeList grtGrandChildNodes = grandChildNodes.item(j).getChildNodes();
                            for (int k = 0; k < grtGrandChildNodes.getLength(); ++k) {
                                String s3 = grtGrandChildNodes.item(k).getNodeName();
                                this.addChildAttributes(grtGrandChildNodes.item(k), s3, navigation);
                            }
                        }
                    }
                }
                if (loginConfig.item(++item) == null) break;
                attributes = loginConfig.item(item).getAttributes();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findLoginSettings");
        }
        return result;
    }

    private int addChildAttributes(Node child, String s, String navigation) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "addChildAttributes");
        }
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        int result = 0;
        if (s.equals("trustAssociation")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.webAuth") + " > " + SecItemsReport.getLabel("security.configrpt.core.trustAssociation");
        } else if (s.equals("interceptors")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.webAuth") + " > " + SecItemsReport.getLabel("security.configrpt.core.trustAssociation") + " > " + SecItemsReport.getLabel("security.configrpt.core.TrustAssociation.interceptors");
        } else if (s.equals("singleSignon")) {
            navigation = SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.webAuth") + " > " + SecItemsReport.getLabel("security.configrpt.core.SingleSignon");
        }
        if (!child.getNodeName().equals("#text")) {
            String label = SecItemsReport.getLabel("security.configrpt.core." + s);
            hashTable.put("label", label);
            hashTable.put("name", s);
            hashTable.put("value", " ");
            if (navigation.length() > 0) {
                hashTable.put("navigation", navigation);
            } else {
                hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + label);
            }
            report.add(this.index, hashTable);
            ++this.index;
            NamedNodeMap attributes = child.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node node = attributes.item(j);
                String nodeName = node.getNodeName();
                String nodeValue = node.getNodeValue();
                if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                hashTable = new Hashtable(4);
                label = nodeName.equals("enabled") ? SecItemsReport.getLabel("security.configrpt.core.enableTrust") : SecItemsReport.getLabel("security.configrpt.core." + nodeName);
                hashTable.put("label", label);
                hashTable.put("name", nodeName);
                if (nodeName.startsWith("sessionGCI")) {
                    hashTable.put("value", nodeValue + " " + SecItemsReport.getLabel("security.configrpt.milliseconds"));
                } else if (nodeName.startsWith("password")) {
                    hashTable.put("value", "******");
                } else {
                    hashTable.put("value", nodeValue);
                }
                if (navigation.length() > 0) {
                    hashTable.put("navigation", navigation);
                } else {
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + label);
                }
                report.add(this.index, hashTable);
                ++this.index;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "addChildAttributes");
        }
        return result;
    }

    private int findSecSettings(Document d, String s, int tab) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findSecSettings");
        }
        int result = 0;
        NodeList ses = d.getElementsByTagName(s);
        if (ses.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error: no " + s + " field in security.xml file");
            }
        } else {
            Node serverEntry = ses.item(0);
            NamedNodeMap attributes = serverEntry.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                String nodeName = node.getNodeName();
                String nodeValue = node.getNodeValue();
                if (nodeName.startsWith("xmi:") || nodeName.startsWith("xmlns:") || nodeName.equals("OID") || nodeName.equals("activeProtocol")) continue;
                Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
                String label = SecItemsReport.getLabel("security.configrpt.core." + nodeName);
                hashTable.put("label", label);
                hashTable.put("name", nodeName);
                if (nodeName.equals("cacheTimeout")) {
                    hashTable.put("value", nodeValue + " " + SecItemsReport.getLabel("security.configrpt.seconds"));
                } else {
                    hashTable.put("value", nodeValue);
                }
                if (nodeName.equals("activeAuthMechanism")) {
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.AuthMechanism"));
                } else if (nodeName.equals("activeProtocol")) {
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.ejbAuth"));
                } else if (nodeName.equals("cacheTimeout")) {
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.AuthMechanism") + " > " + SecItemsReport.getLabel("security.configrpt.core.AuthMechanism.Expiration"));
                } else if (nodeName.equals("defaultSSLSettings")) {
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.core.SecureEndpoint"));
                } else if (nodeName.equals("dynamicallyUpdateSSLConfig")) {
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + label);
                } else {
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + label);
                }
                report.add(this.index, hashTable);
                ++this.index;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findSecSettings");
        }
        return result;
    }

    private int findPropertySettings(Document d, String mainLabel) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findPropertySettings");
        }
        int result = 0;
        NodeList prop = d.getElementsByTagName("properties");
        if (prop.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error: no properties field in security.xml file");
            }
        } else {
            for (int i = 2; i < prop.getLength(); ++i) {
                NamedNodeMap attributes = prop.item(i).getAttributes();
                String name = "name";
                String value = "value";
                boolean nameValue = true;
                String requiredName = "name";
                String requiredValue = "value";
                boolean written = false;
                for (int j = 0; j < attributes.getLength(); ++j) {
                    String label;
                    Hashtable<String, String> hashTable;
                    Node node = attributes.item(j);
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getNodeValue();
                    if (nodeName.equals("xmi:id") || nodeName.equals("xmi:type") || nodeName.equals("OID")) continue;
                    if (nodeName.equals("name")) {
                        name = node.getNodeValue();
                        nameValue = true;
                    } else if (nodeName.equals("value")) {
                        value = node.getNodeValue();
                        nameValue = true;
                    } else if (nodeName.equals("required")) {
                        if (written) {
                            hashTable = new Hashtable<String, String>(4);
                            label = SecItemsReport.getLabel("security.configrpt.core.Security.property.name");
                            hashTable.put("label", label);
                            hashTable.put("name", nodeName);
                            hashTable.put("value", nodeValue);
                            hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + mainLabel);
                            report.add(this.index, hashTable);
                            ++this.index;
                        } else {
                            requiredName = nodeName;
                            requiredValue = nodeValue;
                        }
                        nameValue = false;
                    }
                    if (name.equals("name") || value.equals("value") || !nameValue) continue;
                    hashTable = new Hashtable(4);
                    label = SecItemsReport.getLabel("security.configrpt.core.Security.property.name");
                    hashTable.put("label", label);
                    hashTable.put("name", name);
                    if (name.startsWith("com.ibm.audit.auditQueueSize")) {
                        hashTable.put("value", value + " " + SecItemsReport.getLabel("security.configrpt.messages"));
                    } else {
                        hashTable.put("value", value);
                    }
                    if (name.startsWith("com.ibm.security.useFIPS")) {
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications") + " > " + SecItemsReport.getLabel("security.configrpt.secure.communications.fips"));
                    } else {
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + mainLabel);
                    }
                    if (name.startsWith("com.ibm.security.SAF.authorization")) {
                        this.SAFAuthz = value.equals("true");
                    }
                    report.add(this.index, hashTable);
                    ++this.index;
                    written = true;
                    if (requiredName.equals("name") || requiredValue.equals("value")) continue;
                    hashTable = new Hashtable(4);
                    label = SecItemsReport.getLabel("security.configrpt.core." + requiredName);
                    hashTable.put("label", label);
                    hashTable.put("name", requiredName);
                    hashTable.put("value", requiredValue);
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + mainLabel);
                    report.add(this.index, hashTable);
                    ++this.index;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findPropertySettings");
        }
        return result;
    }

    private int findAdminRolesInExtAuthz() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findAdminRolesInExtAuthz");
        }
        int result = 0;
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        String label = new String();
        hashTable.put("label", "_" + SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.core.Ext.authorizationProviders"));
        hashTable.put("value", SecItemsReport.getLabel("security.configrpt.core.firstClass"));
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security.Console.Path.Name"));
        report.add(this.index, hashTable);
        ++this.index;
        if (this.SAFAuthz) {
            hashTable = new Hashtable(4);
            hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
            hashTable.put("name", SecItemsReport.getLabel("security.zos.saf.authz.enabled"));
            hashTable.put("value", "com.ibm.security.SAF.authorization");
            hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Ext.authorizationProviders"));
            report.add(this.index, hashTable);
            ++this.index;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findAdminRolesInExtAuthz");
        }
        return result;
    }

    private int findAdminRolesInXMLDoc(Document d) {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findAdminRolesInXMLDoc");
        }
        int result = 0;
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        String label = new String();
        hashTable.put("label", "_" + SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Console.Role.Name"));
        hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Console.Role.Value"));
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security.Console.Path.Name"));
        report.add(this.index, hashTable);
        ++this.index;
        NodeList auth = d.getElementsByTagName("authorizations");
        if (auth.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error: no authorizations field in admin-authz.xml file");
            }
        } else {
            for (int i = 0; i < auth.getLength(); ++i) {
                Node grp;
                Node user;
                int item;
                NodeList users;
                String role = auth.item(i).getAttributes().getNamedItem("role").getNodeValue();
                if (role.equals("SecurityRoleExt_1")) {
                    NodeList subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                    if (subjects == null) continue;
                    int item2 = 0;
                    Node special = subjects.item(item2);
                    while (special != null) {
                        String adminUserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                        if (adminUserId.substring(0, adminUserId.length() - 5).equals("Server")) {
                            adminUserId = "ServerId";
                        } else if (adminUserId.substring(0, adminUserId.length() - 5).equals("PrimaryAdmin")) {
                            adminUserId = "PrimaryAdminId";
                        }
                        hashTable = new Hashtable(4);
                        hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Admin.Role.User"));
                        hashTable.put("value", adminUserId);
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                        report.add(this.index, hashTable);
                        ++this.index;
                        special = subjects.item(++item2);
                    }
                    if (item2 != 0 || special != null) continue;
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Admin.Role.User"));
                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.No.Admin.Role.User"));
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (role.equals("SecurityRoleExt_2")) {
                    users = ((Element)auth.item(i)).getElementsByTagName("users");
                    NodeList groups = ((Element)auth.item(i)).getElementsByTagName("groups");
                    boolean noUser = false;
                    if (users == null && groups == null) continue;
                    if (users != null) {
                        item = 0;
                        user = users.item(item);
                        while (user != null) {
                            String operatorUserId = user.getAttributes().getNamedItem("name").getNodeValue();
                            hashTable = new Hashtable(4);
                            hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                            hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Operator.Role.User"));
                            hashTable.put("value", operatorUserId);
                            hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                            report.add(this.index, hashTable);
                            ++this.index;
                            user = users.item(++item);
                        }
                        if (item == 0 && user == null) {
                            noUser = true;
                        }
                    }
                    if (groups == null) continue;
                    item = 0;
                    grp = groups.item(0);
                    while (grp != null) {
                        String operatorGrpId = grp.getAttributes().getNamedItem("name").getNodeValue();
                        hashTable = new Hashtable(4);
                        hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Operator.Role.Group"));
                        hashTable.put("value", operatorGrpId);
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.Group"));
                        report.add(this.index, hashTable);
                        ++this.index;
                        grp = groups.item(++item);
                    }
                    if (item != 0 || grp != null || !noUser) continue;
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Operator.Role.User"));
                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.No.Operator.Role.User"));
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (role.equals("SecurityRoleExt_3")) {
                    users = ((Element)auth.item(i)).getElementsByTagName("users");
                    NodeList groups = ((Element)auth.item(i)).getElementsByTagName("groups");
                    boolean noUser = false;
                    if (users == null && groups == null) continue;
                    if (users != null) {
                        item = 0;
                        user = users.item(item);
                        while (user != null) {
                            String configUserId = user.getAttributes().getNamedItem("name").getNodeValue();
                            hashTable = new Hashtable(4);
                            hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                            hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Configurator.Role.User"));
                            hashTable.put("value", configUserId);
                            hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                            report.add(this.index, hashTable);
                            ++this.index;
                            user = users.item(++item);
                        }
                        if (item == 0 && user == null) {
                            noUser = true;
                        }
                    }
                    if (groups == null) continue;
                    item = 0;
                    grp = groups.item(0);
                    while (grp != null) {
                        String configGrpId = grp.getAttributes().getNamedItem("name").getNodeValue();
                        hashTable = new Hashtable(4);
                        hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Configurator.Role.Group"));
                        hashTable.put("value", configGrpId);
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.Group"));
                        report.add(this.index, hashTable);
                        ++this.index;
                        grp = groups.item(++item);
                    }
                    if (item != 0 || grp != null || !noUser) continue;
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Configurator.Role.User"));
                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.No.Configurator.Role.User"));
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (role.equals("SecurityRoleExt_4")) {
                    users = ((Element)auth.item(i)).getElementsByTagName("users");
                    NodeList groups = ((Element)auth.item(i)).getElementsByTagName("groups");
                    boolean noUser = false;
                    if (users == null && groups == null) continue;
                    if (users != null) {
                        item = 0;
                        user = users.item(item);
                        while (user != null) {
                            String moderatorUserId = user.getAttributes().getNamedItem("name").getNodeValue();
                            hashTable = new Hashtable(4);
                            hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                            hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Moderator.Role.User"));
                            hashTable.put("value", moderatorUserId);
                            hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                            report.add(this.index, hashTable);
                            ++this.index;
                            user = users.item(++item);
                        }
                        if (item == 0 && user == null) {
                            noUser = true;
                        }
                    }
                    if (groups == null) continue;
                    item = 0;
                    grp = groups.item(0);
                    while (grp != null) {
                        String moderatorGrpId = grp.getAttributes().getNamedItem("name").getNodeValue();
                        hashTable = new Hashtable(4);
                        hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Moderator.Role.Group"));
                        hashTable.put("value", moderatorGrpId);
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.Group"));
                        report.add(this.index, hashTable);
                        ++this.index;
                        grp = groups.item(++item);
                    }
                    if (item != 0 || grp != null || !noUser) continue;
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Moderator.Role.User"));
                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.No.Moderator.Role.User"));
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (role.equals("SecurityRoleExt_5")) {
                    users = ((Element)auth.item(i)).getElementsByTagName("users");
                    NodeList groups = ((Element)auth.item(i)).getElementsByTagName("groups");
                    boolean noUser = false;
                    if (users == null && groups == null) continue;
                    if (users != null) {
                        item = 0;
                        user = users.item(item);
                        while (user != null) {
                            String deployerUserId = user.getAttributes().getNamedItem("name").getNodeValue();
                            hashTable = new Hashtable(4);
                            hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                            hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Deployer.Role.User"));
                            hashTable.put("value", deployerUserId);
                            hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                            report.add(this.index, hashTable);
                            ++this.index;
                            user = users.item(++item);
                        }
                        if (item == 0 && user == null) {
                            noUser = true;
                        }
                    }
                    if (groups == null) continue;
                    item = 0;
                    grp = groups.item(0);
                    while (grp != null) {
                        String deployerGrpId = grp.getAttributes().getNamedItem("name").getNodeValue();
                        hashTable = new Hashtable(4);
                        hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Deployer.Role.Group"));
                        hashTable.put("value", deployerGrpId);
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.Group"));
                        report.add(this.index, hashTable);
                        ++this.index;
                        grp = groups.item(++item);
                    }
                    if (item != 0 || grp != null || !noUser) continue;
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Deployer.Role.User"));
                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.No.Deployer.Role.User"));
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (!role.equals("SecurityRoleExt_6")) continue;
                users = ((Element)auth.item(i)).getElementsByTagName("users");
                NodeList groups = ((Element)auth.item(i)).getElementsByTagName("groups");
                boolean noUser = false;
                if (users == null && groups == null) continue;
                if (users != null) {
                    item = 0;
                    user = users.item(item);
                    while (user != null) {
                        String adminSecurityManagerUserId = user.getAttributes().getNamedItem("name").getNodeValue();
                        hashTable = new Hashtable(4);
                        hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.AdminSecurityManager.Role.User"));
                        hashTable.put("value", adminSecurityManagerUserId);
                        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                        report.add(this.index, hashTable);
                        ++this.index;
                        user = users.item(++item);
                    }
                    if (item == 0 && user == null) {
                        noUser = true;
                    }
                }
                if (groups == null) continue;
                item = 0;
                grp = groups.item(0);
                while (grp != null) {
                    String adminSecurityManagerGrpId = grp.getAttributes().getNamedItem("name").getNodeValue();
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.AdminSecurityManager.Role.Group"));
                    hashTable.put("value", adminSecurityManagerGrpId);
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.Group"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    grp = groups.item(++item);
                }
                if (item != 0 || grp != null || !noUser) continue;
                hashTable = new Hashtable(4);
                hashTable.put("label", SecItemsReport.getLabel("security.configrpt.Console.Users.Groups"));
                hashTable.put("name", SecItemsReport.getLabel("security.configrpt.AdminSecurityManager.Role.User"));
                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.No.AdminSecurityManager.Role.User"));
                hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.Console.User"));
                report.add(this.index, hashTable);
                ++this.index;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findAdminRolesInXMLDoc");
        }
        return result;
    }

    private int findNamingRolesInExtAuthz() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "findNamingRolesInExtAuthz");
        }
        int result = 0;
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        String label = new String();
        hashTable.put("label", "_" + SecItemsReport.getLabel("security.configrpt.Naming.Console.Name"));
        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.core.Ext.authorizationProviders"));
        hashTable.put("value", SecItemsReport.getLabel("security.configrpt.core.firstClass"));
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.Naming.Console.Path"));
        report.add(this.index, hashTable);
        ++this.index;
        if (this.SAFAuthz) {
            hashTable = new Hashtable(4);
            hashTable.put("label", SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
            hashTable.put("name", SecItemsReport.getLabel("security.zos.saf.authz.enabled"));
            hashTable.put("value", "com.ibm.security.SAF.authorization");
            hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security") + " > " + SecItemsReport.getLabel("security.configrpt.core.AdminSecurity") + " > " + SecItemsReport.getLabel("security.configrpt.core.Ext.authorizationProviders"));
            report.add(this.index, hashTable);
            ++this.index;
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "findNamingRolesInExtAuthz");
        }
        return result;
    }

    private int findNamingRolesInXMLDoc(Document d) {
        int result = 0;
        int read = 0;
        int write = 0;
        int create = 0;
        int delete = 0;
        int everyone = 4;
        int allAuth = 3;
        int userid = 2;
        int serverid = 1;
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        String label = new String();
        hashTable.put("label", "_" + SecItemsReport.getLabel("security.configrpt.Naming.Console.Name"));
        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Naming.Role.Name"));
        hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Role.Value"));
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.Naming.Console.Path"));
        report.add(this.index, hashTable);
        ++this.index;
        NodeList auth = d.getElementsByTagName("authorizations");
        if (auth.getLength() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error: no authorizations field in naming-authz.xml file");
            }
        } else {
            for (int i = 0; i < auth.getLength(); ++i) {
                String UserId;
                Node special;
                int j;
                NodeList subjects;
                String role = auth.item(i).getAttributes().getNamedItem("role").getNodeValue();
                if (role.equals("SecurityRoleExt_1")) {
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Naming.Read.Name"));
                    subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                    if (subjects != null) {
                        for (j = 0; j < subjects.getLength(); ++j) {
                            special = subjects.item(j);
                            if (special != null) {
                                UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                                if (UserId.substring(0, UserId.length() - 5).equals("Everyone") && read < everyone) {
                                    read = everyone;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Everyone"));
                                }
                                if (UserId.substring(0, UserId.length() - 5).equals("Server") && read < serverid) {
                                    read = serverid;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Server"));
                                }
                                if (UserId.substring(0, UserId.length() - 5).equals("AllAuthenticatedUsers") && read < allAuth) {
                                    read = allAuth;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.AllAuthenticated"));
                                }
                                if (!UserId.substring(0, UserId.length() - 5).equals("User") || read >= userid) continue;
                                read = userid;
                                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.UserId"));
                                continue;
                            }
                            hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.None"));
                        }
                    }
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.Environment") + " > " + SecItemsReport.getLabel("security.configrpt.Naming") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (role.equals("SecurityRoleExt_2")) {
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Naming.Write.Name"));
                    subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                    if (subjects != null) {
                        for (j = 0; j < subjects.getLength(); ++j) {
                            special = subjects.item(j);
                            if (special != null) {
                                UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                                if (UserId.substring(0, UserId.length() - 5).equals("Everyone") && write < everyone) {
                                    write = everyone;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Everyone"));
                                }
                                if (UserId.substring(0, UserId.length() - 5).equals("Server") && write < serverid) {
                                    write = serverid;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Server"));
                                }
                                if (UserId.substring(0, UserId.length() - 5).equals("AllAuthenticatedUsers") && write < allAuth) {
                                    write = allAuth;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.AllAuthenticated"));
                                }
                                if (!UserId.substring(0, UserId.length() - 5).equals("User") || write >= userid) continue;
                                write = userid;
                                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.UserId"));
                                continue;
                            }
                            hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.None"));
                        }
                    }
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.Environment") + " > " + SecItemsReport.getLabel("security.configrpt.Naming") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (role.equals("SecurityRoleExt_3")) {
                    hashTable = new Hashtable(4);
                    hashTable.put("label", SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                    hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Naming.Create.Name"));
                    subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                    if (subjects != null) {
                        for (j = 0; j < subjects.getLength(); ++j) {
                            special = subjects.item(j);
                            if (special != null) {
                                UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                                if (UserId.substring(0, UserId.length() - 5).equals("Everyone") && create < everyone) {
                                    create = everyone;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Everyone"));
                                }
                                if (UserId.substring(0, UserId.length() - 5).equals("Server") && create < serverid) {
                                    create = serverid;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Server"));
                                }
                                if (UserId.substring(0, UserId.length() - 5).equals("AllAuthenticatedUsers") && create < allAuth) {
                                    create = allAuth;
                                    hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.AllAuthenticated"));
                                }
                                if (!UserId.substring(0, UserId.length() - 5).equals("User") || create >= userid) continue;
                                create = userid;
                                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.UserId"));
                                continue;
                            }
                            hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.None"));
                        }
                    }
                    hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.Environment") + " > " + SecItemsReport.getLabel("security.configrpt.Naming") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                    report.add(this.index, hashTable);
                    ++this.index;
                    continue;
                }
                if (!role.equals("SecurityRoleExt_4")) continue;
                hashTable = new Hashtable(4);
                hashTable.put("label", SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                hashTable.put("name", SecItemsReport.getLabel("security.configrpt.Naming.Delete.Name"));
                subjects = ((Element)auth.item(i)).getElementsByTagName("specialSubjects");
                if (subjects != null) {
                    for (j = 0; j < subjects.getLength(); ++j) {
                        special = subjects.item(j);
                        if (special != null) {
                            UserId = special.getAttributes().getNamedItem("xmi:id").getNodeValue();
                            if (UserId.substring(0, UserId.length() - 5).equals("Everyone") && delete < everyone) {
                                delete = everyone;
                                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Everyone"));
                            }
                            if (UserId.substring(0, UserId.length() - 5).equals("Server") && delete < serverid) {
                                delete = serverid;
                                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.Server"));
                            }
                            if (UserId.substring(0, UserId.length() - 5).equals("AllAuthenticatedUsers") && delete < allAuth) {
                                delete = allAuth;
                                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.AllAuthenticated"));
                            }
                            if (!UserId.substring(0, UserId.length() - 5).equals("User") || delete >= userid) continue;
                            delete = userid;
                            hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.UserId"));
                            continue;
                        }
                        hashTable.put("value", SecItemsReport.getLabel("security.configrpt.Naming.None"));
                    }
                }
                hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.Environment") + " > " + SecItemsReport.getLabel("security.configrpt.Naming") + " > " + SecItemsReport.getLabel("security.configrpt.core.Security.Naming.Navigation"));
                report.add(this.index, hashTable);
                ++this.index;
            }
        }
        return result;
    }

    private int findDRSInXMLDoc(Document d) {
        int result = 0;
        Node drs = d.getElementsByTagName("multibroker:DataReplicationDomain").item(0);
        if (drs == null) {
            return result;
        }
        Hashtable<String, String> hashTable = new Hashtable<String, String>(4);
        hashTable.put("label", "_" + SecItemsReport.getLabel("security.configrpt.DRS.Console.Name"));
        hashTable.put("name", SecItemsReport.getLabel("security.configrpt.DRS.Name"));
        String id = drs.getAttributes().getNamedItem("xmi:id").getNodeValue();
        NodeList drsList = drs.getChildNodes();
        for (int i = 0; i < drsList.getLength(); ++i) {
            Node drsEntry = drsList.item(i);
            if (drsEntry.getNodeName().equals("#text")) continue;
            this.status = drsEntry.getAttributes().getNamedItem("encryptionType").getNodeValue();
            if (this.status == null) continue;
            if (this.status.startsWith("DES") || this.status.equals("TRIPLE_DES")) {
                hashTable.put("value", SecItemsReport.getLabel("security.configrpt.DRS.Encryption.Enabled"));
                continue;
            }
            hashTable.put("value", SecItemsReport.getLabel("security.configrpt.DRS.Encryption.Disabled"));
        }
        hashTable.put("navigation", SecItemsReport.getLabel("security.configrpt.core.Security.Console.Path.Name"));
        report.add(this.index, hashTable);
        ++this.index;
        return result;
    }

    public static void main(String[] args) {
    }

    public String checkName() {
        return "All parameters";
    }

    public String profileName() {
        return this.pathName;
    }

    public String pathName() {
        return this.pathName;
    }

    public String getStatus() {
        return this.status;
    }

    private int checkInConfig(File f, String configFile) {
        int result = 0;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory() || !kiddos[i].getName().equals("config")) continue;
            String absolutePath = kiddos[i].getAbsolutePath();
            int tempResult = this.checkSecurityConfig(absolutePath, configFile);
            if (tempResult <= result) break;
            result = tempResult;
            break;
        }
        return result;
    }

    private int checkSecurityConfig(String fileName, String configFile) {
        boolean result = false;
        File f = new File(fileName + "/cells");
        if (!f.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to find directory " + fileName + "/cells, unable to continue security check");
            }
            return 2;
        }
        return this.configCheck(f, configFile);
    }

    private int configCheck(File f, String configFile) {
        int result = 0;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            int tempResult;
            if (kiddos[i].isFile()) {
                if (!kiddos[i].getName().equals(configFile) || (tempResult = this.configCheckInFile(kiddos[i])) <= result) continue;
                result = tempResult;
                continue;
            }
            if (!kiddos[i].isDirectory() || (tempResult = this.configCheck(kiddos[i], configFile)) <= result) continue;
            result = tempResult;
        }
        return result;
    }

    private int configCheckInFile(File file) {
        int result = 0;
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            this.fileFound = true;
            int tempResult = 0;
            if (file.getName().equals("security.xml")) {
                tempResult = this.findSecParametersInXMLDoc(xmlDoc);
            } else if (file.getName().equals("admin-authz.xml")) {
                tempResult = this.SAFAuthz ? this.findAdminRolesInExtAuthz() : this.findAdminRolesInXMLDoc(xmlDoc);
            } else if (file.getName().equals("naming-authz.xml")) {
                tempResult = this.SAFAuthz ? this.findNamingRolesInExtAuthz() : this.findNamingRolesInXMLDoc(xmlDoc);
            } else if (file.getName().equals("multibroker.xml")) {
                tempResult = this.findDRSInXMLDoc(xmlDoc);
            }
            if (tempResult > result) {
                result = tempResult;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in attempting to parse XML file " + file.getName() + " to find global security enabled");
            }
            result = 1;
        }
        return result;
    }

    static {
        tc = Tr.register(Controller.class, null, "com.ibm.ejs.resources.security");
    }
}

