/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.InterceptorsConfig;
import com.ibm.ws.security.config.InterceptorsConfigImpl;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import com.ibm.ws.security.config.TrustAssociationConfig;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustAssociationConfigImpl
extends GenericConfigHelperImpl
implements TrustAssociationConfig {
    private static final String INTERCEPTORS = "interceptors";
    private static TraceComponent tc = Tr.register(TrustAssociationConfigImpl.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private List<InterceptorsConfig> interceptors = null;

    public TrustAssociationConfigImpl(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, ": ctor" + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        this.initialize_defaults();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor" + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put("enabled", Boolean.FALSE);
    }

    private synchronized void do_getInterceptors() {
        if (this.interceptors == null) {
            SecurityConfigObjectList scol = this.sco.getObjectList(INTERCEPTORS);
            int size = scol.size();
            this.interceptors = new LinkedList<InterceptorsConfig>();
            for (int i = 0; i < size; ++i) {
                this.interceptors.add(new InterceptorsConfigImpl(scol.get(i), this, this.cacheKey));
            }
        }
    }

    @Override
    public List<InterceptorsConfig> getInterceptors() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInterceptors" + this.cacheKey);
        }
        if (this.interceptors == null) {
            this.do_getInterceptors();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInterceptors" + this.cacheKey, this.interceptors);
        }
        return this.interceptors;
    }
}

