/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.CSIv2LayerConfig;
import com.ibm.ws.security.config.GenericConfigHelperImpl;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigObject;
import com.ibm.ws.security.config.SecurityConfigObjectList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSIv2IOBoundConfig
extends GenericConfigHelperImpl {
    public static final String STATEFUL = "stateful";
    public static final String SESSION_GC_INTERVAL = "sessionGCInterval";
    public static final String SESSION_GC_IDLE_TIME = "sessionGCIdleTime";
    private static final String LAYERS = "layers";
    private static TraceComponent tc = Tr.register(CSIv2IOBoundConfig.class, "SecurityConfig", "com.ibm.ejs.resources.security");
    private List<CSIv2LayerConfig> layers = null;

    public CSIv2IOBoundConfig(SecurityConfigObject obj, GenericConfigHelperImpl parent, String _cacheKey) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "ctor " + _cacheKey, new Object[]{obj, parent});
        }
        super.initialize(obj, parent, _cacheKey);
        this.initialize_defaults();
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "ctor" + this.cacheKey, this);
        }
    }

    private void initialize_defaults() {
        this.defaults.put(STATEFUL, false);
        this.defaults.put(SESSION_GC_INTERVAL, 0);
        this.defaults.put(SESSION_GC_IDLE_TIME, 0);
    }

    private synchronized void do_getLayers() {
        if (this.layers == null) {
            SecurityConfigObjectList scol = scm.getObjectList(this.sco, LAYERS, false);
            if (scol == null) {
                return;
            }
            int size = scol.size();
            this.layers = new LinkedList<CSIv2LayerConfig>();
            for (int i = 0; i < size; ++i) {
                this.layers.add(new CSIv2LayerConfig(scol.get(i), this, this.cacheKey));
            }
        }
    }

    public List<CSIv2LayerConfig> getLayers() {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLayers" + this.cacheKey);
        }
        if (this.layers == null) {
            this.do_getLayers();
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLayers" + this.cacheKey, this.layers);
        }
        return this.layers;
    }

    public CSIv2LayerConfig getLayer(String key) {
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLayer: key=" + key + this.cacheKey);
        }
        CSIv2LayerConfig result = null;
        List<CSIv2LayerConfig> list = this.getLayers();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SecurityConfigObject layer = list.get(i).getSCO();
                if (!layer.instanceOf("http://www.ibm.com/websphere/appserver/schemas/5.0/orb.securityprotocol.xmi", key)) continue;
                result = list.get(i);
            }
        }
        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
            Tr.exit(tc, this.cacheKey + "getLayer", result);
        }
        return result;
    }
}

