/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.util;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class WSStdinLoginPrompt
implements Runnable {
    private Thread inputThread = null;
    private int selectionMade = 0;
    private boolean loginID = false;
    private final int timeout = 300000;
    private String[] uIDandPW = new String[2];
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private static final TraceComponent tc = Tr.register(WSStdinLoginPrompt.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static boolean _os400;

    public WSStdinLoginPrompt(String up, String pp) {
        this.userNamePrompt = up;
        this.passwordPrompt = pp;
    }

    public String[] getUidAndPassword() {
        block8: {
            int sleepInterval = 1;
            this.inputThread = new Thread(this);
            this.inputThread.setDaemon(true);
            this.inputThread.start();
            try {
                for (int i = 0; i < this.timeout; i += sleepInterval) {
                    Thread.sleep(sleepInterval);
                    if (this.loginID && !_os400) {
                        System.out.print("\b ");
                    }
                    if (this.selectionMade == 0) continue;
                    return this.uIDandPW;
                }
                if (this.selectionMade != 0) break block8;
                if (this.inputThread.isAlive()) {
                    try {
                        this.inputThread.stop();
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.util.WSStdinLoginPrompt.getUidAndPassword", "106", this);
                    }
                }
                return null;
            }
            catch (InterruptedException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.util.WSStdinLoginPrompt.getUidAndPassword", "114", this);
                if (tc.isDebugEnabled()) {
                    Tr.error(tc, SecurityMessages.getMsgOrUseDefault("ErrMsg???", "Interrupted while sleeping."), new Object[]{e});
                }
                return null;
            }
        }
        return this.uIDandPW;
    }

    private void getPassword(int maxpwLength) {
        int rc = 0;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            if (this.userNamePrompt == null || this.userNamePrompt.length() == 0) {
                String useridString = SecurityMessages.getMsgOrUseDefault("UserID", "User ID") + ": ";
            } else {
                System.out.print(this.userNamePrompt);
            }
            System.out.flush();
            this.uIDandPW[0] = stdin.readLine().trim();
            this.loginID = true;
            if (this.passwordPrompt == null || this.passwordPrompt.length() == 0) {
                String passwordString = SecurityMessages.getMsgOrUseDefault("Password", "Password") + ": ";
                System.out.print(passwordString);
            } else {
                System.out.print(this.passwordPrompt);
            }
            System.out.flush();
            if (_os400 && (rc = this.ntv_startHiddenInputMode()) != 0) {
                Tr.error(tc, "ntv_startHiddenInputMode() failed.  errno from native API Qp0zSetTerminal is " + rc + ".");
            }
            this.uIDandPW[1] = PlatformHelperFactory.getPlatformHelper().isZOS() ? stdin.readLine() : stdin.readLine().trim();
            this.selectionMade = 1;
            if (_os400 && rc == 0 && (rc = this.ntv_endHiddenInputMode()) != 0) {
                Tr.error(tc, "ntv_endHiddenInputMode() failed.  errno from native API Qp0zSetTerminal is " + rc + ".");
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.util.WSStdinLoginPrompt.getPassword", "169", this);
            e.printStackTrace();
        }
    }

    public void run() {
        this.getPassword(64);
    }

    private native int ntv_endHiddenInputMode();

    private native int ntv_startHiddenInputMode();

    static {
        boolean bl = _os400 = System.getProperty("os.name").equals("OS/400");
        if (_os400) {
            String library = System.getProperty("was.install.library", null);
            System.load("/QSYS.LIB/" + library + ".LIB/QWASSTDINP.SRVPGM");
        }
    }
}

