/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module.proxy;

import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSLoginModuleProxy
implements LoginModule {
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private boolean debug;
    private LoginModule loginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        String className = (String)options.get("delegate");
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("delegate is not set");
        }
        if (this.debug) {
            System.out.println("delegate class name: " + className);
        }
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(getCtxClassLoader);
        if (this.debug) {
            if (cl != null) {
                System.out.println("Using the current thread class loader");
            } else {
                System.out.println("Using the class loader that loads the JAAS extension");
            }
        }
        try {
            this.loginModule = cl != null ? (LoginModule)cl.loadClass(className).newInstance() : (LoginModule)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new RuntimeException(e.getMessage());
        }
        this.loginModule.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        return this.loginModule.login();
    }

    public boolean commit() throws LoginException {
        return this.loginModule.commit();
    }

    public boolean abort() throws LoginException {
        return this.loginModule.abort();
    }

    public boolean logout() throws LoginException {
        return this.loginModule.logout();
    }
}

