/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.SecurityServer;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSLoginHelperImpl;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSLoginModuleImpl
implements LoginModule {
    private static SecurityServer securityServer = null;
    private Subject subject;
    private Subject login_subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    protected boolean debug = false;
    protected boolean use_realm_callback = false;
    protected boolean use_appcontext_callback = false;
    private static final TraceComponent tc = Tr.register(WSLoginModuleImpl.class, null, "com.ibm.ejs.resources.security");

    public WSLoginModuleImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSLoginModuleImpl()");
            Tr.exit(tc, "WSLoginModuleImpl()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.use_realm_callback = "true".equalsIgnoreCase((String)this.options.get("use_realm_callback"));
        this.use_appcontext_callback = "true".equalsIgnoreCase((String)this.options.get("use_appcontext_callback"));
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login() throws LoginException {
        block55: {
            Throwable t;
            Map appContextMap;
            String realm;
            byte[] credToken;
            char[] password;
            String uid;
            String myRealm;
            block54: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "login()");
                }
                WSLoginModuleImpl.disableAuthRetryForThread();
                this.succeeded = false;
                this.login_subject = null;
                myRealm = null;
                myRealm = RasHelper.isServer() ? SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm") : WSLoginHelperImpl.getDefaultRealmName();
                if (this.commitSucceeded) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
                    }
                    this.cleanup();
                }
                if (this.callbackHandler == null) {
                    throw new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                }
                if (this.callbackHandler instanceof WSCallbackHandlerImpl) {
                    this.use_realm_callback = true;
                    this.use_appcontext_callback = true;
                }
                Callback[] callbacks = null;
                callbacks = this.use_realm_callback && this.use_appcontext_callback ? new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSRealmNameCallbackImpl("Realm Name: "), new WSAppContextCallback("App Context: ")} : (this.use_realm_callback ? new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSRealmNameCallbackImpl("Realm Name: ")} : (this.use_appcontext_callback ? new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSAppContextCallback("App Context: ")} : new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: ")}));
                uid = null;
                password = null;
                credToken = null;
                realm = null;
                appContextMap = null;
                try {
                    byte[] tmpCred;
                    this.callbackHandler.handle(callbacks);
                    uid = ((NameCallback)callbacks[0]).getName();
                    char[] tmp = ((PasswordCallback)callbacks[1]).getPassword();
                    if (tmp != null) {
                        password = new char[tmp.length];
                        System.arraycopy(tmp, 0, password, 0, tmp.length);
                        ((PasswordCallback)callbacks[1]).clearPassword();
                    }
                    if ((tmpCred = ((WSCredTokenCallbackImpl)callbacks[2]).getCredToken()) != null) {
                        credToken = CredentialsHelper.copyCredToken(tmpCred);
                    }
                    if (this.use_realm_callback) {
                        realm = ((WSRealmNameCallbackImpl)callbacks[3]).getRealmName();
                    }
                    if (this.use_appcontext_callback && this.use_realm_callback) {
                        appContextMap = ((WSAppContextCallback)callbacks[4]).getContext();
                        break block54;
                    }
                    if (this.use_appcontext_callback) {
                        appContextMap = ((WSAppContextCallback)callbacks[3]).getContext();
                    }
                }
                catch (IOException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "305", this);
                    Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), e});
                    throw new WSLoginFailedException("java.io.IOException from CallbackHandler.handle()", e);
                }
                catch (UnsupportedCallbackException uce) {
                    Manager.Ffdc.log(uce, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "312", this);
                    Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), uce.getCallback().toString(), uce});
                    throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user", uce);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uid = " + uid);
                Tr.debug(tc, "password = " + (password == null ? "<null>" : "XXXXXXXX"));
                Tr.debug(tc, "cred token = " + Util.toString(credToken));
                Tr.debug(tc, "realm = " + realm);
                Tr.debug(tc, "app context map = " + appContextMap);
            }
            if (uid == null && password == null && (credToken == null || credToken.length == 0)) {
                throw new WSLoginFailedException("No authentication data.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Successfully gathered authentication information");
            }
            if (uid != null || password != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using uid and password for authentication");
                    StringBuffer buf = new StringBuffer("Authenticating \"");
                    buf.append(myRealm).append('/').append(uid).append("\"");
                    Tr.debug(tc, buf.toString());
                }
                try {
                    if (password == null) {
                        password = new char[]{};
                    }
                    if (realm == null || realm.equalsIgnoreCase(myRealm) || realm.equalsIgnoreCase("<default>")) {
                        this.login_subject = ContextManagerFactory.getInstance().login(myRealm, uid, new String(password), "system.DEFAULT", null, null, null, this.subject);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Subject after authentication: " + this.login_subject);
                        }
                        break block55;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Target realm: " + realm + " does not match current realm, " + myRealm + " creating BasicAuth subject: " + this.login_subject);
                    }
                    this.login_subject = SubjectHelper.createBasicAuthSubject(realm, uid, new String(password));
                    if (appContextMap != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "AppContext found, validating basic auth");
                        }
                        String initialContextFactory = (String)appContextMap.get("java.naming.factory.initial");
                        String providerURL = (String)appContextMap.get("java.naming.provider.url");
                        Hashtable<String, String> env = new Hashtable<String, String>();
                        env.put("java.naming.factory.initial", initialContextFactory);
                        env.put("java.naming.provider.url", providerURL);
                        env.put("com.ibm.websphere.naming.jndicache.cacheobject", "cleared");
                        InitialContext ic = new InitialContext(env);
                        try {
                            final BasicAuthData authData = new BasicAuthData(uid, new String(password), realm);
                            Boolean successObj = (Boolean)ContextManagerFactory.getInstance().runAsSpecified(SubjectHelper.createUnauthenticatedSubject(), new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    boolean result = WSLoginModuleImpl.this.getSecurityServer().simple_authenticate(authData);
                                    return new Boolean(result);
                                }
                            });
                            boolean success = successObj;
                            if (!success) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "simple_authenticate returned false.");
                                }
                                throw new WSLoginFailedException("Userid and/or password is invalid.");
                            }
                            this.succeeded = true;
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "login(): status = " + this.succeeded);
                            }
                            return this.succeeded;
                        }
                        catch (WSLoginFailedException e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl", "437");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to lookup security server");
                            }
                            Tr.error(tc, "security.getting.remote.server.error", new Object[]{e});
                            throw e;
                        }
                        catch (Exception e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl", "444");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed with general exception while getting remote security server");
                            }
                            Tr.error(tc, "security.getting.remote.server.ex", new Object[]{e});
                            throw new WSLoginFailedException(e.getMessage(), e);
                        }
                    }
                    break block55;
                }
                catch (WSLoginFailedException e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "454", this);
                    if (SecurityContext.isServerProcess()) {
                        throw e;
                    }
                    t = ContextManagerFactory.getInstance().getRootException();
                    if (t != null && !(t instanceof WSLoginFailedException)) {
                        throw new WSLoginFailedException(e.getMessage(), t);
                    }
                    if (t != null && t instanceof WSLoginFailedException) {
                        throw (WSLoginFailedException)t;
                    }
                    throw e;
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "472", this);
                    if (SecurityContext.isServerProcess()) {
                        throw new WSLoginFailedException(e.getMessage(), e);
                    }
                    t = ContextManagerFactory.getInstance().getRootException();
                    if (t != null && !(t instanceof WSLoginFailedException)) {
                        throw new WSLoginFailedException(e.getMessage(), t);
                    }
                    if (t != null && t instanceof WSLoginFailedException) {
                        throw (WSLoginFailedException)t;
                    }
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
            }
            if (credToken == null) {
                throw new WSLoginFailedException("No authentication data");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using credential token for authentication");
            }
            try {
                this.login_subject = ContextManagerFactory.getInstance().login(myRealm, credToken, "system.DEFAULT", null, null, null, this.subject);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject after authentication: " + this.login_subject);
                }
            }
            catch (WSLoginFailedException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "506", this);
                if (SecurityContext.isServerProcess()) {
                    throw e;
                }
                t = ContextManagerFactory.getInstance().getRootException();
                if (t != null && !(t instanceof WSLoginFailedException)) {
                    throw new WSLoginFailedException(e.getMessage(), t);
                }
                if (t != null && t instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)t;
                }
                throw e;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.login", "524", this);
                if (SecurityContext.isServerProcess()) {
                    throw new WSLoginFailedException(e.getMessage(), e);
                }
                t = ContextManagerFactory.getInstance().getRootException();
                if (t != null && !(t instanceof WSLoginFailedException)) {
                    throw new WSLoginFailedException(e.getMessage(), t);
                }
                if (t != null && t instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)t;
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        this.succeeded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login(): status = " + this.succeeded);
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bRet = false;
        if (!this.succeeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bRet = false;
        } else {
            if (!this.commitSucceeded) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    if (this.login_subject != null) {
                        this.credential = SubjectHelper.getWSCredentialFromSubject(this.login_subject);
                        this.principal = SubjectHelper.getPrincipalFromSubject(this.login_subject);
                    }
                    if (this.credential != null && this.principal != null) {
                        final Subject login_subject_final = this.login_subject;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                for (Object publicObject : login_subject_final.getPublicCredentials()) {
                                    if (publicObject == null || WSLoginModuleImpl.this.subject.getPublicCredentials().contains(publicObject)) continue;
                                    if (!WSLoginModuleImpl.this.subject.getPublicCredentials().contains(publicObject)) {
                                        if (WSLoginModuleImpl.this.debug || tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding public object to Subject: " + publicObject);
                                        }
                                        WSLoginModuleImpl.this.subject.getPublicCredentials().add(publicObject);
                                    }
                                    if (!(publicObject instanceof WSCredential)) continue;
                                    WSLoginModuleImpl.this.sharedState.put("WSCredential", publicObject);
                                }
                                for (Object privateObject : login_subject_final.getPrivateCredentials()) {
                                    if (privateObject == null || WSLoginModuleImpl.this.subject.getPrivateCredentials().contains(privateObject) || WSLoginModuleImpl.this.subject.getPrivateCredentials().contains(privateObject)) continue;
                                    if (WSLoginModuleImpl.this.debug || tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Adding private object to Subject: " + privateObject);
                                    }
                                    WSLoginModuleImpl.this.subject.getPrivateCredentials().add(privateObject);
                                }
                                for (Principal principalObject : login_subject_final.getPrincipals()) {
                                    if (principalObject == null || WSLoginModuleImpl.this.subject.getPrincipals().contains(principalObject)) continue;
                                    if (!WSLoginModuleImpl.this.subject.getPrincipals().contains(principalObject)) {
                                        if (WSLoginModuleImpl.this.debug || tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Adding principal object to Subject: " + principalObject);
                                        }
                                        WSLoginModuleImpl.this.subject.getPrincipals().add(principalObject);
                                    }
                                    if (!(principalObject instanceof WSPrincipal)) continue;
                                    WSLoginModuleImpl.this.sharedState.put("WSPrincipal", principalObject);
                                }
                                return null;
                            }
                        });
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.commit", "699", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bRet = this.commitSucceeded;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit(): status = " + bRet);
        }
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        if (!this.subject.isReadOnly()) {
            this.cleanup();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block9: {
                    try {
                        if (WSLoginModuleImpl.this.principal != null && WSLoginModuleImpl.this.subject.getPrincipals().contains(WSLoginModuleImpl.this.principal)) {
                            WSLoginModuleImpl.this.subject.getPrincipals().remove(WSLoginModuleImpl.this.principal);
                        }
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.run", "840", this);
                        Tr.error(tc, "security.jaas.removePrinException", new Object[]{this.getClass().getName(), WSLoginModuleImpl.this.principal.getName(), e});
                    }
                    if (WSLoginModuleImpl.this.credential != null) {
                        try {
                            if (WSLoginModuleImpl.this.subject.getPublicCredentials().contains(WSLoginModuleImpl.this.credential)) {
                                WSLoginModuleImpl.this.subject.getPublicCredentials().remove(WSLoginModuleImpl.this.credential);
                            }
                        }
                        catch (Exception e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.run", "856", this);
                            Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                        }
                        try {
                            WSLoginModuleImpl.this.credential.destroy();
                        }
                        catch (Exception e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ws.security.common.auth.module.WSLoginModuleImpl.run", "866", this);
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug(tc, "Credential destroy failed");
                            Tr.debug(tc, Util.toString(e));
                        }
                    }
                }
                return null;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private static void disableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(true));
    }

    private static void enableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(false));
    }

    private SecurityServer getSecurityServer() throws AuthenticationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityServer");
        }
        if (securityServer == null) {
            try {
                securityServer = VaultImpl.getInstance().getSecurityServer();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "", e);
                }
                securityServer = null;
                throw new AuthenticationFailedException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityServer", securityServer);
        }
        return securityServer;
    }
}

