/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.bind;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndFactory;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.security.bind.ApplicationBndType;
import com.ibm.ws.security.bind.EJB3ApplicationBinding;
import com.ibm.ws.security.bind.GroupType;
import com.ibm.ws.security.bind.RunAsType;
import com.ibm.ws.security.bind.SecurityRoleType;
import com.ibm.ws.security.bind.SpecialSubjectType;
import com.ibm.ws.security.bind.UserType;
import com.ibm.ws.security.util.WCCMHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationBindingAdapter
implements EJB3ApplicationBinding {
    private static final TraceComponent tc = Tr.register(ApplicationBindingAdapter.class, "Security", "com.ibm.ejs.resources.security");
    private static final ApplicationbndFactory wccmAppbndFactory = ApplicationbndFactory.eINSTANCE;
    private static final CommonbndFactory wccmCommonbndFactory = CommonbndFactory.eINSTANCE;
    private ApplicationBinding appBinding = null;
    private EARFile earFile = null;
    private InputStream input = null;
    private boolean containsEJB3AppBindings = false;
    private List<SecurityRoleType> securityRoles = null;
    private AuthorizationTable authzTable = null;
    private RunAsMap runAsMap = null;

    public ApplicationBindingAdapter(DeployedObject deployed) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ApplicationBindingAdapter(DeployedObject)", deployed);
        }
        ModuleFile moduleFile = null;
        if (deployed == null || (moduleFile = deployed.getModuleFile()) == null || !moduleFile.isEARFile() || (this.appBinding = (ApplicationBinding)deployed.getBinding()) == null) {
            String msg = "Invalid argument received, deployedObject=" + deployed + ", moduleFile=" + moduleFile + ", appBinding=" + this.appBinding;
            RuntimeWarning ex = new RuntimeWarning(msg);
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.bind.ApplicationBindingAdapter(DeployedObject)", "80", this);
            throw ex;
        }
        this.earFile = (EARFile)moduleFile;
        this.containsEJB3AppBindings = this.earFile.containsFile("META-INF/ibm-application-bnd.xml");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ApplicationBindingAdapter(DeployedObject)", new Object[]{deployed.getName(), "containsEJB3AppBindings=" + this.containsEJB3AppBindings, this.earFile, this.appBinding});
        }
    }

    public ApplicationBindingAdapter(InputStream input) {
        this.input = input;
    }

    @Override
    public AuthorizationTable getAuthorizationTable() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationTable()");
        }
        if (this.authzTable == null) {
            if (this.containsEJB3AppBindings) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create new AuthorizationTable from META-INF/ibm-application-bnd.xml");
                }
                this.authzTable = this.updateAuthorizationTable(this.earFile);
                this.appBinding.setAuthorizationTable(this.authzTable);
            } else if (this.input != null && this.appBinding == null) {
                ApplicationBndType appBindings = this.readApplicationBinding(this.input);
                List<SecurityRoleType> jaxbRoles = this.findSecurityRoles(appBindings);
                this.authzTable = this.createAndFillAuthorizationTable(jaxbRoles);
                this.runAsMap = this.createAndFillRunAsMap(jaxbRoles);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use existing AuthorizationTable if it exists.");
                }
                this.authzTable = this.appBinding.getAuthorizationTable();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizationTable()", this.authzTable);
        }
        return this.authzTable;
    }

    @Override
    public RunAsMap getRunAsMap() throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRunAsMap()");
        }
        if (this.runAsMap == null) {
            if (this.containsEJB3AppBindings) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Create new RunAsMap from META-INF/ibm-application-bnd.xml");
                }
                this.runAsMap = this.updateRunAsMap(this.earFile);
                this.appBinding.setRunAsMap(this.runAsMap);
            } else if (this.input != null && this.appBinding == null) {
                ApplicationBndType appBindings = this.readApplicationBinding(this.input);
                List<SecurityRoleType> jaxbRoles = this.findSecurityRoles(appBindings);
                this.runAsMap = this.createAndFillRunAsMap(jaxbRoles);
                this.authzTable = this.createAndFillAuthorizationTable(jaxbRoles);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use existing RunAsMap if it exists.");
                }
                this.runAsMap = this.appBinding.getRunAsMap();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRunAsMap()", this.runAsMap);
        }
        return this.runAsMap;
    }

    public String toString() {
        EList roles;
        StringBuffer buf = new StringBuffer(super.toString());
        if (this.authzTable != null && this.runAsMap != null && (roles = this.authzTable.getAuthorizations()) != null && !roles.isEmpty()) {
            String NL = System.getProperty("line.separator");
            buf.append(NL + "AuthorizationTable and RunAsMap bindings:");
            for (RoleAssignment role : roles) {
                buf.append(NL + "Role=" + role.getRole());
                buf.append(NL + " Users=" + role.getUsers());
                buf.append(NL + " Groups=" + role.getGroups());
                buf.append(NL + " SpecialSubjects=" + role.getSpecialSubjects());
                BasicAuthData runAs = (BasicAuthData)this.runAsMap.getAuthData(role.getRole());
                buf.append(NL + " RunAs=" + (runAs == null ? "" : runAs.getUserId()));
            }
        }
        return buf.toString();
    }

    private RunAsMap updateRunAsMap(EARFile ear) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRunAsMap(EARFile)", ear);
        }
        RunAsMap result = this.appBinding.getRunAsMap();
        List<SecurityRoleType> jaxbRoles = this.findSecurityRoles(ear);
        if (result == null) {
            result = this.createAndFillRunAsMap(jaxbRoles);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Updating existing RunAsMap");
            }
            if (jaxbRoles != null && !jaxbRoles.isEmpty()) {
                EList raBindings = result.getRunAsBindings();
                for (SecurityRoleType role : jaxbRoles) {
                    if (role.getRunAs() == null) continue;
                    RunAsBinding binding = this.findRunAsBinding(role.getName(), raBindings);
                    if (binding != null) {
                        raBindings.remove(binding);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removed existing RunAsBinding for " + binding.getSecurityRole());
                        }
                    }
                    binding = this.createRunAsBinding(role);
                    raBindings.add(binding);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, binding.getSecurityRole() + " added to RunAsMap bindings.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRunAsMap(EARFile)");
        }
        return result;
    }

    private AuthorizationTable updateAuthorizationTable(EARFile ear) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAuthorizationTable(EARFile)", ear);
        }
        AuthorizationTable result = this.appBinding.getAuthorizationTable();
        List<SecurityRoleType> jaxbRoles = this.findSecurityRoles(ear);
        EList roleAuthorizations = null;
        if (result == null) {
            result = this.createAndFillAuthorizationTable(jaxbRoles);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Updating existing AuthorizationTable");
            }
            if (jaxbRoles != null && !jaxbRoles.isEmpty()) {
                roleAuthorizations = result.getAuthorizations();
                for (SecurityRoleType role : jaxbRoles) {
                    RoleAssignment roleA = this.findRoleAssignment(role.getName(), roleAuthorizations);
                    if (roleA != null) {
                        roleAuthorizations.remove(roleA);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removed existing RoleAssignment for " + roleA.getRole());
                        }
                    }
                    roleA = this.createRoleAssignment(role);
                    roleAuthorizations.add(roleA);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, roleA.getRole() + " added to AuthorizationTable bindings.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAuthorizationTable(EARFile)");
        }
        return result;
    }

    private ApplicationBndType findApplicationBinding(EARFile earFile) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findApplicationBinding(EARFile)", earFile);
        }
        ApplicationBndType appBinding = null;
        try {
            InputStream input = earFile.getResourceInputStream("META-INF/ibm-application-bnd.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ready to parse 'META-INF/ibm-application-bnd.xml' from input stream: " + input);
            }
            appBinding = this.readApplicationBinding(input);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "'META-INF/ibm-application-bnd.xml' parsed successfully.");
            }
            if (input != null) {
                input.close();
            }
        }
        catch (IOException e) {
            String msg = "Unable to parse 'META-INF/ibm-application-bnd.xml'";
            FFDCFilter.processException(e, "com.ibm.ws.security.bind.ApplicationBindingAdapter.findApplicationBinding(EARFile)", "246", this, new Object[]{msg});
            Tr.warning(tc, msg, e.getLocalizedMessage());
            throw new RuntimeWarning(msg, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findApplicationBinding(EARFile)", appBinding);
        }
        return appBinding;
    }

    private ApplicationBndType readApplicationBinding(InputStream input) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readApplicationBinding(InputStream)", this.earFile);
        }
        ApplicationBndType appBinding = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.ws.security.bind", (ClassLoader)this.getClass().getClassLoader());
            JAXBElement root = (JAXBElement)jc.createUnmarshaller().unmarshal(input);
            appBinding = (ApplicationBndType)root.getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InputStream was successfully parsed.");
            }
        }
        catch (JAXBException e) {
            String msg = "Unable to create JAXBContext for package 'com.ibm.ws.security.bind' using classLoader: " + this.getClass().getClassLoader();
            FFDCFilter.processException(e, "com.ibm.ws.security.bind.ApplicationBindingAdapter.readApplicationBinding(InputStream)", "266", this, new Object[]{msg});
            Tr.warning(tc, msg, e.getLocalizedMessage());
            throw new RuntimeWarning(msg, e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readApplicationBinding(InputStream)", appBinding);
        }
        return appBinding;
    }

    private AuthorizationTable createAndFillAuthorizationTable(List<SecurityRoleType> jaxbRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAndFillAuthorizationTable(List<SecurityRoleType>)", jaxbRoles);
        }
        AuthorizationTable result = wccmAppbndFactory.createAuthorizationTable();
        EList roleAuthorizations = result.getAuthorizations();
        try {
            List<RoleAssignment> roles = this.createRoleAssignments(jaxbRoles);
            for (RoleAssignment roleA : roles) {
                roleAuthorizations.add(roleA);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, roleA.getRole() + " added to AuthorizationTable bindings.");
            }
        }
        catch (RuntimeWarning e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to create RoleAssignments: " + e);
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.bind.ApplicationBindingAdapter.createAndFillAuthorizationTable(List<SecurityRoleType>)", "288", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAndFillAuthorizationTable(List<SecurityRoleType>)", result);
        }
        return result;
    }

    private RunAsMap createAndFillRunAsMap(List<SecurityRoleType> jaxbRoles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAndFillRunAsMap(List<SecurityRoleType>)", jaxbRoles);
        }
        RunAsMap result = wccmAppbndFactory.createRunAsMap();
        EList raBindings = result.getRunAsBindings();
        for (SecurityRoleType role : jaxbRoles) {
            if (role.getRunAs() == null) continue;
            RunAsBinding binding = this.createRunAsBinding(role);
            raBindings.add(binding);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, binding.getSecurityRole() + " added to RunAsMap bindings.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAndFillRunAsMap(List<SecurityRoleType>)", result);
        }
        return result;
    }

    private RoleAssignment findRoleAssignment(String role, List<RoleAssignment> roles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRoleAssignment(String,List<RoleAssignment>)", new Object[]{role, roles});
        }
        RoleAssignment result = null;
        for (RoleAssignment roleA : roles) {
            if (!roleA.getRole().getRoleName().equals(role)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found security role=" + roleA.getRole());
            }
            result = roleA;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRoleAssignment(String,List<RoleAssignment>)", role + " role was " + (result == null ? "not " : "") + "found.");
        }
        return result;
    }

    private RunAsBinding findRunAsBinding(String role, List<RunAsBinding> runAsBindings) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findRunAsBinding(String,List<RunAsBinding>)", new Object[]{role, runAsBindings});
        }
        RunAsBinding result = null;
        for (RunAsBinding binding : runAsBindings) {
            if (!binding.getSecurityRole().getRoleName().equals(role)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found security role=" + binding.getSecurityRole());
            }
            result = binding;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findRunAsBinding(String,List<RoleAssignment>)", role + " role was " + (result == null ? "not " : "") + "found.");
        }
        return result;
    }

    private RunAsBinding createRunAsBinding(SecurityRoleType role) {
        RunAsType runAs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRunAsBinding(SecurityRoleType)", role.getName());
        }
        RunAsBinding result = null;
        if (role != null && (runAs = role.getRunAs()) != null) {
            BasicAuthData authData = wccmCommonbndFactory.createBasicAuthData();
            SecurityRole secRole = WCCMHelper.createSecurityRole("", role.getName());
            result = wccmAppbndFactory.createRunAsBinding();
            authData.setUserId(runAs.getUserid());
            authData.setPassword(runAs.getPassword());
            result.setAuthData(authData);
            result.setSecurityRole(secRole);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRunAsBinding(SecurityRoleType)", result.getSecurityRole());
        }
        return result;
    }

    private List<RoleAssignment> createRoleAssignments(List<SecurityRoleType> roles) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRoleAssignments(List<SecurityRoleType>)", roles);
        }
        ArrayList<RoleAssignment> result = new ArrayList<RoleAssignment>();
        if (roles != null && !roles.isEmpty()) {
            for (SecurityRoleType role : roles) {
                result.add(this.createRoleAssignment(role));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRoleAssignments(List<SecurityRoleType>)", result);
        }
        return result;
    }

    private RoleAssignment createRoleAssignment(SecurityRoleType role) throws RuntimeWarning {
        String accessId;
        String name;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRoleAssignment(SecurityRoleType)", role.getName());
        }
        RoleAssignment result = wccmAppbndFactory.createRoleAssignment();
        SecurityRole secRole = WCCMHelper.createSecurityRole("", role.getName());
        for (GroupType group : role.getGroup()) {
            name = group.getName();
            accessId = group.getAccessId();
            result.getGroups().add(WCCMHelper.createGroup(name, accessId));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "group '" + name + "', accessId '" + accessId + "' added to role " + secRole.getRoleName());
        }
        for (UserType user : role.getUser()) {
            name = user.getName();
            accessId = user.getAccessId();
            result.getUsers().add(WCCMHelper.createUser(name, accessId));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "user '" + name + "', accessId '" + accessId + "' added to role " + secRole.getRoleName());
        }
        for (SpecialSubjectType special : role.getSpecialSubject()) {
            SpecialSubject subj = this.createSpecialSubject(special.getType());
            result.getSpecialSubjects().add(subj);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "SpecialSubject '" + special.getType() + "' added to role " + secRole.getRoleName());
        }
        result.setRole(secRole);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRoleAssignment(SecurityRoleType)", result);
        }
        return result;
    }

    private SpecialSubject createSpecialSubject(String name) throws RuntimeWarning {
        SpecialSubject subj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSpecialSubject(String)", name);
        }
        if ("ALL_AUTHENTICATED_USERS".equals(name)) {
            subj = wccmAppbndFactory.createAllAuthenticatedUsers();
        } else if ("ALL_AUTHENTICATED_IN_TRUSTED_REALMS".equals(name)) {
            subj = wccmAppbndFactory.createAllAuthenticatedInTrustedRealms();
            subj.setName("AllAuthenticatedInTrustedRealms");
        } else if ("EVERYONE".equals(name)) {
            subj = wccmAppbndFactory.createEveryone();
        } else if ("SERVER".equals(name)) {
            subj = wccmAppbndFactory.createServer();
            subj.setName("Server");
        } else {
            throw new RuntimeWarning(name + " is not a valid SpecialSubject");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSpecialSubject(String)", subj);
        }
        return subj;
    }

    private List<SecurityRoleType> findSecurityRoles(EARFile earFile) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSecurityRoles(EARFile)", earFile);
        }
        if (this.securityRoles == null) {
            this.securityRoles = this.findSecurityRoles(this.findApplicationBinding(earFile));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findSecurityRoles(EARFile)", this.securityRoles);
        }
        return this.securityRoles;
    }

    private List<SecurityRoleType> findSecurityRoles(ApplicationBndType type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSecurityRoles(ApplicationBndType)", type);
        }
        ArrayList<SecurityRoleType> result = new ArrayList<SecurityRoleType>();
        List<Object> items = type.getSecurityRoleOrProfile();
        for (Object item : items) {
            if (!(item instanceof SecurityRoleType)) continue;
            SecurityRoleType secRole = (SecurityRoleType)item;
            result.add(secRole);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Found security role=" + secRole.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findSecurityRoles(ApplicationBndType)", result.size() + " roles found.");
        }
        return result;
    }
}

