/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.security.AuthorizationConfig;
import com.ibm.websphere.models.config.security.AuthorizationProvider;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class JaccTaskUtil {
    private static TraceComponent tc = Tr.register(JaccTaskUtil.class, null, "com.ibm.ejs.resources.security");
    private static final String nativeJACC = "com.ibm.ws.security.policy.JaccPolicyProxy";
    private static boolean externalJaccEnabled = false;
    private static boolean checked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForJacc(ConfigRepository repository2, boolean isLocal, String cellName, boolean checkForDynamicUpdates) throws Exception {
        if (checked) {
            return externalJaccEnabled;
        }
        boolean jaccEnabled = false;
        String policyClassName = null;
        Resource res = null;
        try {
            if ("true".equals(System.getProperty("com.ibm.websphere.security.jacc.donotpropagate"))) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Propagation to JACC provider disabled");
                }
                jaccEnabled = false;
            } else if (!isLocal) {
                SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                jaccEnabled = security2.getAuthorizationConfig().getBoolean("useJACCProvider");
                policyClassName = security2.getAuthorizationConfig().getAuthorizationProvider().getString("j2eePolicyImplClassName");
            } else {
                AuthorizationConfig authzConfig;
                Security security3 = null;
                StringBuffer sb = new StringBuffer("cells/");
                sb.append(cellName).append("/security.xml");
                DocumentContentSource dcs = repository2.extract(sb.toString());
                WASResourceSetImpl resourceSet = new WASResourceSetImpl();
                URI fileURI = URI.createURI("security.xml");
                res = resourceSet.createResource(fileURI);
                HashMap options = new HashMap();
                res.load(dcs.getSource(), options);
                security3 = (Security)res.getContents().get(0);
                if (security3 != null && (authzConfig = security3.getAuthConfig()) != null) {
                    jaccEnabled = authzConfig.isUseJACCProvider();
                    AuthorizationProvider authzProvider = (AuthorizationProvider)authzConfig.getAuthorizationProviders().get(0);
                    if (authzProvider != null) {
                        policyClassName = authzProvider.getJ2eePolicyImplClassName();
                    }
                }
            }
            Object var16_16 = null;
            if (res != null) {
                res.unload();
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (res != null) {
                res.unload();
            }
            throw throwable;
        }
        if (jaccEnabled && !nativeJACC.equals(policyClassName)) {
            externalJaccEnabled = true;
        }
        checked = true;
        return externalJaccEnabled;
    }

    public static String getContextID(ConfigRepository repository2, AppData aData) throws Exception {
        String deplFile = aData.getDeplURI();
        DocumentContentSource dcs = repository2.extract(deplFile);
        WASResourceSetImpl resourceSet = new WASResourceSetImpl();
        URI fileURI = URI.createURI("deployment.xml");
        Resource res = resourceSet.createResource(fileURI);
        HashMap options = new HashMap();
        res.load(dcs.getSource(), options);
        Deployment d = (Deployment)res.getContents().get(0);
        ApplicationDeployment appdepl = (ApplicationDeployment)d.getDeployedObject();
        String contextID = appdepl.getAppContextIDForSecurity();
        if (res != null) {
            res.unload();
        }
        return contextID;
    }
}

