/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.authorize.JaccTaskUtil;
import com.ibm.ws.security.util.DomainContextHelper;
import java.util.Hashtable;

public class JaccInstallTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(JaccInstallTask.class, null, "com.ibm.ejs.resources.security");
    private static String nativeJACC = "com.ibm.ws.security.policy.JaccPolicyProxy";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performTask(AppData cachedAD, AppData newAD, Hashtable props) throws Exception {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sec-install performTask");
            }
            if (!this._isLocal) {
                String processType = null;
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService != null) {
                    processType = adminService.getProcessType();
                }
                if (processType == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "sec performTask");
                    }
                    return true;
                }
                if (!processType.equals("DeploymentManager") && !processType.equals("UnManagedProcess")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "sec performTask");
                    }
                    return true;
                }
            }
            boolean switched = false;
            String appName = newAD.getAppName();
            try {
                block16: {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Check to see if JACC is enabled");
                        }
                        switched = DomainContextHelper.switchToAppDomainIfDmgr(appName);
                        boolean proceed = JaccTaskUtil.checkForJacc(this._repository, this._isLocal, this._cellName, false);
                        if (!proceed) break block16;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "JACC is enabled");
                        }
                        EARFile earFile = newAD.getEAR();
                        String contextID = newAD.getAppContextIDForSecurity();
                        AppInstallNotify.getInstance().appInstall(earFile, appName, contextID, this._isLocal);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.authorize.JaccInstallTask.performTask", "84", this);
                        Tr.error(tc, "security.jacc.install.task", new Object[]{newAD.getAppName(), e});
                        Object var10_12 = null;
                        if (switched) {
                            DomainContextHelper.unwindAppDomain(appName);
                        }
                        break block17;
                    }
                }
                Object var10_11 = null;
                if (!switched) break block17;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (switched) {
                    DomainContextHelper.unwindAppDomain(appName);
                }
                throw throwable;
            }
            DomainContextHelper.unwindAppDomain(appName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sec performTask");
        }
        return true;
    }
}

