/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.models.base.bindings.applicationbnd.AllAuthenticatedUsers;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.Everyone;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.Server;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBModuleRef;
import com.ibm.etools.commonarchive.WebModuleRef;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.security.AuthorizationConfig;
import com.ibm.websphere.models.config.security.AuthorizationProvider;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityCommon;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.portletcontainer.om.security.PortletApplication;
import com.ibm.ws.portletcontainer.om.security.PortletDefinition;
import com.ibm.ws.portletcontainer.om.security.SecurityConstraint;
import com.ibm.ws.portletcontainer.om.security.TransportGuarantee;
import com.ibm.ws.portletcontainer.util.PortletModelHelper;
import com.ibm.ws.security.authorize.URLMap;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.policy.JaccPolicyDomainProxy;
import com.ibm.ws.security.util.DomainContextHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.security.authorization.RoleConfiguration;
import com.ibm.wsspi.security.authorization.RoleConfigurationException;
import com.ibm.wsspi.security.authorization.RoleConfigurationFactory;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.UserDataConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebResourceCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppInstallNotify {
    private static TraceComponent tc = Tr.register(AppInstallNotify.class, null, "com.ibm.ejs.resources.security");
    private PolicyConfigurationFactory pcf = null;
    private AppInstallNotify appNotify = null;
    private HashMap pcConfigsMap = null;
    private static String FACTORY_NAME = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static final int EXTENSION_PATTERN = 0;
    private static final int PATHPREFIX_PATTERN = 1;
    private static final int EXACT_PATTERN = 2;
    private static final int DEFAULT_PATTERN = 3;
    private String policyCfgFactoryImplClassName = null;
    private RoleConfigurationFactory rcf = null;
    private Policy jPolicy = null;
    private static AuthorizationProvider authzProvider = null;

    private AppInstallNotify() {
        this.initialize();
    }

    public static AppInstallNotify getInstance() {
        return new AppInstallNotify();
    }

    private void initialize() {
        this.pcConfigsMap = new HashMap();
    }

    public void appInstalled(EARFile earFile, String appNamePath) throws Exception {
    }

    public void appInstall(EARFile earFile, String appName, String contextID, boolean isLocal) throws Exception {
        List webRefList;
        List ejbRefList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appInstalled", new Object[]{earFile, appName, contextID});
        }
        if (earFile == null) {
            Tr.error(tc, "security.jacc.tools.earfile.error", new Object[]{appName});
            throw new Exception("The earFile is null");
        }
        if (appName == null) {
            Tr.error(tc, "security.jacc.tools.appname.error");
            throw new Exception("The appName is null");
        }
        if (isLocal) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appInstall in local mode");
            }
            this.getLocalPolicy();
            this.getPCF(isLocal);
            this.getRCF(isLocal);
        }
        if ((ejbRefList = earFile.getEJBModuleRefs()) != null && ejbRefList.size() > 0) {
            for (EJBModuleRef ejbModuleRef : ejbRefList) {
                this.addEJBPermissions(ejbModuleRef, appName, contextID, isLocal, null);
            }
        }
        if ((webRefList = earFile.getWebModuleRefs()) != null && webRefList.size() > 0) {
            for (WebModuleRef webModuleRef : webRefList) {
                this.addWebPermissions(webModuleRef, appName, contextID, isLocal, null);
            }
        }
        this.addAuthorizationTable(earFile, appName, contextID, isLocal);
        JaccPolicyDomainProxy policy = null;
        if (DomainContextHelper.isDmgrAndMultiDomainAndMultiJacc() && !isLocal) {
            policy = (JaccPolicyDomainProxy)Policy.getPolicy();
            this.jPolicy = policy.getDomainPolicy();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using jacc policy from the security domain.");
            }
        }
        if (this.jPolicy == null) {
            this.jPolicy = !isLocal ? Policy.getPolicy() : this.getLocalPolicy();
        }
        if (this.jPolicy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refreshing the policy ");
            }
            this.jPolicy.refresh();
        }
        Tr.audit(tc, "security.jacc.secpolicy.propagated", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appInstalled");
        }
    }

    public void addAuthorizationTable(EARFile earFile, String appName, String contextID, boolean isLocal) throws RoleConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAuthorizationTable");
        }
        if (this.rcf == null) {
            this.rcf = this.getRCF(isLocal);
        }
        if (this.rcf == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addAuthorizationTable: no roleconfiguration");
            }
            return;
        }
        RoleConfiguration rc = null;
        if (this.rcf != null) {
            try {
                rc = this.rcf.getRoleConfiguration(contextID, true);
            }
            catch (RoleConfigurationException pce) {
                FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.AppInstallNotify.addAuthorizationTable", "278", this);
                Tr.error(tc, "security.jacc.tools.rcf", new Object[]{contextID, pce});
                rc = null;
                throw pce;
            }
        }
        if (rc != null) {
            ApplicationBinding appBind = earFile.getBindings();
            AuthorizationTable authTbl = null;
            if (appBind != null) {
                authTbl = appBind.getAuthorizationTable();
            }
            EList assignList = null;
            if (authTbl != null) {
                assignList = authTbl.getAuthorizations();
            }
            Iterator iter = null;
            if (assignList != null) {
                iter = assignList.iterator();
            }
            if (iter != null) {
                while (iter.hasNext()) {
                    EList ss;
                    EList groups;
                    RoleAssignment rax = (RoleAssignment)iter.next();
                    String role = rax.getRole().getRoleName();
                    EList users = rax.getUsers();
                    if (users != null) {
                        rc.addUsersToRole(role, users);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added users: " + users.toString() + " to role: " + role);
                        }
                    }
                    if ((groups = rax.getGroups()) != null) {
                        rc.addGroupsToRole(role, groups);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added groups: " + groups.toString() + " to role: " + role);
                        }
                    }
                    if ((ss = rax.getSpecialSubjects()) == null) continue;
                    for (SpecialSubject ssx : ss) {
                        if (ssx instanceof Everyone) {
                            rc.addEveryoneToRole(role);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "added Everyone to role: " + role);
                            continue;
                        }
                        if (ssx instanceof AllAuthenticatedUsers) {
                            rc.addAuthenticatedUsersToRole(role);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "added AllAuthenticatedUsers to role: " + role);
                            continue;
                        }
                        if (!(ssx instanceof Server) || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "added Server not supported for role: " + role);
                    }
                }
            }
            rc.commit();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Propagated RoleConfiguration information for Application: " + appName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAuthorizationTable");
        }
    }

    public void appUninstalled(String earFileLocation, String appNamePath) throws Exception {
    }

    public void appUninstall(ApplicationDeployment appDepl, String appName, String contextID, boolean isLocal) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appUninstalled", new Object[]{appDepl, appName, contextID});
        }
        if (appDepl == null) {
            throw new Exception("The deployment.xml in the application is null");
        }
        if (appName == null) {
            Tr.error(tc, "security.jacc.tools.appname.error");
            throw new Exception("The appName is null");
        }
        if (isLocal) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appInstall in local mode");
            }
            this.getLocalPolicy();
            this.getPCF(isLocal);
            this.getRCF(isLocal);
        }
        try {
            EList moduleList = appDepl.getModules();
            if (moduleList != null && moduleList.size() > 0) {
                for (int i = 0; i < moduleList.size(); ++i) {
                    ModuleDeployment md2 = (ModuleDeployment)moduleList.get(i);
                    String moduleName = md2.getUri();
                    this.deleteModule(moduleName, appName, contextID, isLocal);
                }
            }
            this.deleteAuthorizationTable(appName, contextID, isLocal);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.authorize.AppInstallNotify.appUninstalled", "386", this);
            Tr.error(tc, "security.jacc.tools.uninstall", new Object[]{appName, e});
            throw e;
        }
        JaccPolicyDomainProxy policy = null;
        if (DomainContextHelper.isDmgrAndMultiDomainAndMultiJacc() && !isLocal) {
            policy = (JaccPolicyDomainProxy)Policy.getPolicy();
            this.jPolicy = policy.getDomainPolicy();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using jacc policy from the security domain.");
            }
        }
        if (this.jPolicy == null) {
            this.jPolicy = !isLocal ? Policy.getPolicy() : this.getLocalPolicy();
        }
        if (this.jPolicy != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Refreshing the policy ");
            }
            this.jPolicy.refresh();
        }
        Tr.audit(tc, "security.jacc.secpolicy.removed", new Object[]{appName});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appUninstalled");
        }
    }

    public void deleteAuthorizationTable(String appName, String contextID, boolean isLocal) throws ClassNotFoundException, PolicyContextException, ArchiveWrappedException, RoleConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAuthorizationTable");
        }
        if (this.rcf == null) {
            this.rcf = this.getRCF(isLocal);
        }
        if (this.rcf == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteAuthorizationTable: no roleconfiguration");
            }
            return;
        }
        if (this.rcf != null) {
            RoleConfiguration rc = null;
            try {
                rc = this.rcf.getRoleConfiguration(contextID, true);
            }
            catch (RoleConfigurationException pce) {
                FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.AppInstallNotify.appUninstalled", "446", this);
                Tr.error(tc, "security.jacc.tools.rcf", new Object[]{contextID, pce});
                rc = null;
                throw pce;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RoleConfiguration to be deleted is: " + rc);
            }
            if (rc != null) {
                rc.delete();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Deleted role configuration for contextID: " + contextID);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAuthorizationTable");
        }
    }

    public void addWebPermissions(WebModuleRef webModuleRef, String appName, String ctxID, boolean isLocal, PolicyConfiguration pc) throws Exception {
        List pConstraintList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addWebPermissions", new Object[]{webModuleRef.getUri(), appName});
        }
        WebApp webApp = null;
        EList constraintList = null;
        EList webRoleList = null;
        UserDataConstraint dataConstraint = null;
        EList webResList = null;
        EList servletList = null;
        EList webRoleRefList = null;
        EList allRoleList = null;
        PolicyConfiguration webPC = null;
        try {
            webApp = (WebApp)webModuleRef.getDeploymentDescriptor();
        }
        catch (DeploymentDescriptorLoadException dde) {
            FFDCFilter.processException((Throwable)dde, "com.ibm.ws.security.authorize.AppInstallNotify.addWebPermissions", "487", this);
            throw dde;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security. authorize.AppInstallNotify.addWPermissions", "491", this);
            throw e;
        }
        if (webApp != null) {
            constraintList = webApp.getConstraints();
            servletList = webApp.getServlets();
            allRoleList = webApp.getSecurityRoles();
        }
        PortletApplication portletApp = PortletModelHelper.getPortletApplication((WebModuleRef)webModuleRef);
        if (tc.isDebugEnabled() && portletApp != null && webApp != null) {
            Tr.debug(tc, "Portlet application: " + portletApp + " exists for webapp: " + webApp);
        }
        String webModuleName = null;
        String altDDName = webModuleRef.getModule().getAltDD();
        if (altDDName == null || altDDName.length() == 0) {
            webModuleName = webModuleRef.getUri();
        } else {
            webModuleName = altDDName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using alt-DD = " + altDDName);
            }
        }
        String contextID = this.getModuleContextID(ctxID, webModuleName);
        try {
            if (this.pcf == null) {
                this.pcf = this.getPCF(isLocal);
            }
            if (this.pcf == null) {
                throw new PolicyContextException("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            webPC = this.pcf.getPolicyConfiguration(contextID, true);
        }
        catch (PolicyContextException pce) {
            FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.AppInstallNotify.addWebPermissions", "530", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{contextID, pce});
            this.pcf = null;
            webPC = null;
            throw pce;
        }
        if (webPC == null) {
            Tr.error(tc, "security.jacc.tools.pcf.null", new Object[]{contextID});
            throw new PolicyContextException("The PolicyConfiguration object is null");
        }
        Permissions webUncheckedPerms = new Permissions();
        Permissions webExcludedPerms = new Permissions();
        ArrayList<String> addedRoleRefList = new ArrayList<String>();
        if (servletList != null) {
            for (int i = 0; i < servletList.size(); ++i) {
                Servlet servlet = (Servlet)servletList.get(i);
                String servletName = servlet.getServletName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servlet Name is: " + servletName);
                }
                if ((webRoleRefList = servlet.getSecurityRoleRefs()) != null) {
                    for (int j = 0; j < webRoleRefList.size(); ++j) {
                        SecurityRoleRef sRoleRef = (SecurityRoleRef)webRoleRefList.get(j);
                        String refName = sRoleRef.getName();
                        String refLink = sRoleRef.getLink();
                        WebRoleRefPermission webRolePerm = new WebRoleRefPermission(servletName, refName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding the following WebRoleRefPermission (roleLink, WebRoleRefPermission) for RoleLink: ", new Object[]{refLink});
                        }
                        webPC.addToRole(refLink, webRolePerm);
                        addedRoleRefList.add(refName);
                    }
                }
                if (allRoleList == null) continue;
                Iterator itr = allRoleList.iterator();
                while (itr.hasNext()) {
                    String roleName = ((SecurityRole)itr.next()).getRoleName();
                    if (addedRoleRefList.contains(roleName)) continue;
                    WebRoleRefPermission webRolePerm = new WebRoleRefPermission(servletName, roleName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the following WebRoleRefPermission (roleLink , WebRoleRefPermission): ", new Object[]{roleName, webRolePerm});
                    }
                    webPC.addToRole(roleName, webRolePerm);
                }
            }
        }
        if (allRoleList != null) {
            Iterator itr = allRoleList.iterator();
            while (itr.hasNext()) {
                String roleName = ((SecurityRole)itr.next()).getRoleName();
                WebRoleRefPermission defaultRoleRefPerm = new WebRoleRefPermission("", roleName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding the following WebRoleRefPermission with empty string (roleName , WebRoleRefPermission): ", new Object[]{roleName, defaultRoleRefPerm});
                }
                webPC.addToRole(roleName, defaultRoleRefPerm);
            }
        }
        if (portletApp != null) {
            List portletList = portletApp.getPortletDefinitions();
            ArrayList<String> pAddedRoleRefList = new ArrayList<String>();
            if (portletList != null) {
                for (int i = 0; i < portletList.size(); ++i) {
                    List portletRoleRefList;
                    PortletDefinition portlet = (PortletDefinition)portletList.get(i);
                    String portletName = portlet.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Portlet Name is: " + portletName);
                    }
                    if ((portletRoleRefList = portlet.getSecurityRoleRefs()) != null) {
                        for (com.ibm.ws.portletcontainer.om.security.SecurityRoleRef pRoleRef : portletRoleRefList) {
                            String pRefName = pRoleRef.getRoleName();
                            String pRefLink = pRoleRef.getRoleLink();
                            WebRoleRefPermission portletRolePerm = new WebRoleRefPermission(portletName, pRefName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding the following WebRoleRefPermission (roleLink, WebRoleRefPermission) for Portlet RoleLink: " + new Object[]{pRefLink});
                            }
                            webPC.addToRole(pRefLink, portletRolePerm);
                            pAddedRoleRefList.add(pRefName);
                        }
                    }
                    if (allRoleList == null) continue;
                    Iterator pItr = allRoleList.iterator();
                    while (pItr.hasNext()) {
                        String pRoleName = ((SecurityRole)pItr.next()).getRoleName();
                        if (pAddedRoleRefList.contains(pRoleName)) continue;
                        WebRoleRefPermission portletRolePerm = new WebRoleRefPermission(portletName, pRoleName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding the following WebRoleRefPermission for Portlet (roleLink , WebRoleRefPermission): " + new Object[]{pRoleName, portletRolePerm});
                        }
                        webPC.addToRole(pRoleName, portletRolePerm);
                    }
                }
            }
        }
        HashMap<String, URLMap> allURLMap = new HashMap<String, URLMap>();
        allURLMap.put("/", new URLMap("/"));
        if (constraintList != null) {
            for (org.eclipse.jst.j2ee.webapplication.SecurityConstraint sc : constraintList) {
                boolean transportSet;
                if (sc == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityConstraint: ", new Object[]{sc});
                }
                AuthConstraint authC = sc.getAuthConstraint();
                webRoleList = null;
                if (authC != null) {
                    webRoleList = authC.getRoles();
                }
                dataConstraint = sc.getUserDataConstraint();
                String userdataConstraint = null;
                if (dataConstraint != null && (transportSet = dataConstraint.isSetTransportGuarantee())) {
                    userdataConstraint = dataConstraint.getTransportGuarantee().getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "transport is set: " + userdataConstraint);
                    }
                }
                webResList = sc.getWebResourceCollections();
                for (WebResourceCollection rc : webResList) {
                    EList url_list = rc.getUrlPattern();
                    if (url_list == null) continue;
                    for (String url : url_list) {
                        URLMap urlMap;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "url being processed is: " + url);
                        }
                        if ((urlMap = (URLMap)allURLMap.get(url)) == null) {
                            urlMap = this.getNewURLMap(url, allURLMap);
                        }
                        EList method_list = rc.getHttpMethodString();
                        ArrayList mList = new ArrayList();
                        if (method_list != null && method_list.size() > 0) {
                            for (Object tHmt : method_list) {
                                String s = (String)tHmt;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, " HTTP Method is:" + s);
                                }
                                mList.add(s);
                            }
                        } else {
                            mList = urlMap.getAllMethods();
                        }
                        if (authC != null && (webRoleList == null || webRoleList.size() < 1)) {
                            urlMap.setExcludedSet(mList);
                        } else if (authC == null) {
                            urlMap.setUncheckedSet(mList);
                        } else if (webRoleList != null && webRoleList != null) {
                            for (String sr : webRoleList) {
                                if (sr.equals("*")) {
                                    EList secRoleList = webApp.getSecurityRoles();
                                    if (secRoleList == null) continue;
                                    Iterator rItr = secRoleList.iterator();
                                    while (rItr.hasNext()) {
                                        String roleName = ((SecurityRole)rItr.next()).getRoleName();
                                        urlMap.setRoleMap(roleName, mList);
                                    }
                                    continue;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting role map for role = " + sr);
                                }
                                urlMap.setRoleMap(sr, mList);
                            }
                        }
                        if (userdataConstraint == null) continue;
                        urlMap.setUserDataMap(userdataConstraint, mList);
                    }
                }
            }
        }
        if (portletApp != null && (pConstraintList = portletApp.getSecurityConstraints()) != null && pConstraintList.size() > 0) {
            for (SecurityConstraint psc : pConstraintList) {
                if (psc == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityConstraint for Portlet: ", new Object[]{psc});
                }
                com.ibm.ws.portletcontainer.om.security.UserDataConstraint pDataConstraint = psc.getUserDataConstraint();
                String pUserDataConstraint = "NONE";
                if (pDataConstraint != null) {
                    TransportGuarantee ptg = pDataConstraint.getTransportGuarantee();
                    pUserDataConstraint = pDataConstraint.getTransportGuarantee().getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "transport set for Portlet is: " + pUserDataConstraint);
                    }
                }
                List portletDefinitions = psc.getPortletDefinitions();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "portletDefinitions are: " + portletDefinitions);
                }
                for (PortletDefinition pd : portletDefinitions) {
                    URLMap urlMap;
                    String url;
                    url = pd.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "url being processed for Portlet is: " + url);
                    }
                    String pUrl = null;
                    if (!url.endsWith("/*")) {
                        StringBuffer sb = new StringBuffer("/");
                        pUrl = sb.append(url).append("/*").toString();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "url modified for Portlet is: " + pUrl);
                        }
                    }
                    if ((urlMap = (URLMap)allURLMap.get(pUrl)) == null) {
                        urlMap = this.getNewURLMap(pUrl, allURLMap);
                    }
                    ArrayList mpList = urlMap.getAllMethods();
                    if (pUserDataConstraint == null) continue;
                    urlMap.setUserDataMap(pUserDataConstraint, mpList);
                }
            }
        }
        for (String url : allURLMap.keySet()) {
            String[] uDataArray;
            String[] exArray;
            URLMap newMap;
            String urlPatternName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "url is: " + url);
            }
            if (this.unqualified(url, urlPatternName = (newMap = (URLMap)allURLMap.get(url)).getURLPattern())) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "url: " + url + " is unqualified");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "urlPatternName: " + urlPatternName);
            }
            if ((exArray = newMap.getExcludedArray()) != null) {
                webExcludedPerms.add(new WebResourcePermission(urlPatternName, exArray));
                webExcludedPerms.add(new WebUserDataPermission(urlPatternName, exArray, null));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "excluded list is null");
            }
            String uArray = newMap.getUncheckedArray();
            webUncheckedPerms.add(new WebResourcePermission(urlPatternName, uArray));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unchecked list is" + uArray);
            }
            if ((uDataArray = newMap.getUserDataArray()) != null) {
                webUncheckedPerms.add(new WebUserDataPermission(urlPatternName, uDataArray, "CONFIDENTIAL"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "methodarray for user data is null");
            }
            String unchkDataArray = newMap.getUnchkDataConstraintArray();
            webUncheckedPerms.add(new WebUserDataPermission(urlPatternName, unchkDataArray));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "methodarray for unchecked user data = " + unchkDataArray);
            }
            HashMap rMap = newMap.getRoleMap();
            for (String role : rMap.keySet()) {
                ArrayList methodList;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "role is " + role);
                }
                if ((methodList = (ArrayList)rMap.get(role)) != null && methodList.size() > 0) {
                    WebResourcePermission wrp = new WebResourcePermission(urlPatternName, methodList.toArray(new String[methodList.size()]));
                    webPC.addToRole(role, wrp);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added the role: " + role + " to the permission " + wrp);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "methodarray for role is null");
            }
        }
        webPC.addToExcludedPolicy(webExcludedPerms);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added the following ExcludedPerms:" + webExcludedPerms);
        }
        webPC.addToUncheckedPolicy(webUncheckedPerms);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Added the following UncheckedPerms:" + webUncheckedPerms);
        }
        this.linkConfiguration(appName, webPC, pc);
        webPC.commit();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addWebPermissions");
        }
    }

    private Set<String> addBeanRoleRefs(PolicyConfiguration ejbPC, Set<String> refLinks, EnterpriseBean eBean, EList roles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addBeanRoleRefs()", "Add EJBRoleRefPermissions for all roles defined in EJB descriptor");
        }
        HashSet<String> roleRefs = new HashSet<String>();
        SecurityConfig sconfig = SecurityObjectLocator.getSecurityConfig();
        Properties props = sconfig.getAuthorizationConfig().getAuthorizationProvider().getProperties();
        if (props != null && "false".equalsIgnoreCase(props.getProperty("createDefaultEJBRoleRefs"))) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addBeanRoleRefs()", "createDefaultEJBRoleRefs custom property set to false, no EJBRoleRefPermissions will be created.");
            }
            return roleRefs;
        }
        if (ejbPC != null && eBean != null) {
            if (roles != null && !roles.isEmpty()) {
                for (SecurityRole role : roles) {
                    String roleName = role.getRoleName();
                    String beanName = eBean.getName();
                    if (roleName != null && beanName != null) {
                        if (refLinks == null || !refLinks.contains(roleName)) {
                            EJBRoleRefPermission ejbRolePerm = new EJBRoleRefPermission(beanName, roleName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Adding EJBRoleRefPermission = " + ejbRolePerm);
                            }
                            try {
                                ejbPC.addToRole(roleName, ejbRolePerm);
                                roleRefs.add(roleName);
                            }
                            catch (PolicyContextException e) {
                                FFDCFilter.processException(e, "addBeanRoleRefs", "899", this, new Object[]{beanName, roleName});
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "Error adding role ref, exception: " + e);
                            }
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "EJBRoleRefPermission not added, one has already been added for role = " + roleName);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Role name or EJB name are null, do nothing.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No roles defined, do nothing.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PolicyConfiguration or EnterpriseBean argument is null, do nothing.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addBeanRoleRefs()", "EJBRoleRefPermissions added for EJB roles = " + roleRefs);
        }
        return roleRefs;
    }

    public void addEJBPermissions(EJBModuleRef ejbModuleRef, String appName, String ctxID, boolean isLocal, PolicyConfiguration pc) throws Exception {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEJBPermissions", new Object[]{ejbModuleRef.getUri(), appName});
        }
        PolicyConfiguration ejbPC = null;
        EJBJar ejbJar = null;
        AssemblyDescriptor ejbAD = null;
        EList mpList = null;
        EList roleList = null;
        EList beanList = null;
        EList roleRefList = null;
        ExcludeList excludedList = null;
        Permissions ejbRolePerms = new Permissions();
        Permissions ejbUncheckedPerms = new Permissions();
        Permissions ejbExcludedPerms = new Permissions();
        try {
            ejbJar = (EJBJar)ejbModuleRef.getDeploymentDescriptor();
        }
        catch (DeploymentDescriptorLoadException dde) {
            FFDCFilter.processException((Throwable)dde, "com.ibm.ws.security.authorize.AppInstallNotify.addEJBPermissions", "947", this);
            throw dde;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.authorize.AppInstallNotify.addEJBPermissions", "951", this);
            throw e;
        }
        if (ejbJar != null) {
            beanList = ejbJar.getEnterpriseBeans();
            ejbAD = ejbJar.getAssemblyDescriptor();
        }
        if (ejbAD != null) {
            mpList = ejbAD.getMethodPermissions();
            excludedList = ejbAD.getExcludeList();
        }
        String ejbModuleName = null;
        String altDDName = ejbModuleRef.getModule().getAltDD();
        if (altDDName == null || altDDName.length() == 0) {
            ejbModuleName = ejbModuleRef.getUri();
        } else {
            ejbModuleName = altDDName;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using alt-DD = " + altDDName);
            }
        }
        String contextID = this.getModuleContextID(ctxID, ejbModuleName);
        try {
            if (this.pcf == null) {
                this.pcf = this.getPCF(isLocal);
            }
            if (this.pcf == null) {
                throw new PolicyContextException("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            ejbPC = this.pcf.getPolicyConfiguration(contextID, true);
        }
        catch (PolicyContextException pce) {
            FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.AppInstallNotify.addEJBPermissions", "985", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{contextID, pce});
            this.pcf = null;
            ejbPC = null;
            throw pce;
        }
        if (ejbPC == null) {
            Tr.error(tc, "security.jacc.tools.pcf.null", new Object[]{contextID});
            throw new PolicyContextException("The PolicyConfiguration object is null");
        }
        if (beanList != null && beanList.size() > 0) {
            for (i = 0; i < beanList.size(); ++i) {
                EnterpriseBean eBean = (EnterpriseBean)beanList.get(i);
                String ejbName = eBean.getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bean Name processed is " + eBean.getName());
                }
                HashSet<String> refLinks = new HashSet<String>();
                roleRefList = eBean.getSecurityRoleRefs();
                if (roleRefList != null) {
                    for (int j = 0; j < roleRefList.size(); ++j) {
                        SecurityRoleRef sRoleRef = (SecurityRoleRef)roleRefList.get(j);
                        String refName = sRoleRef.getName();
                        String refLink = sRoleRef.getLink();
                        EJBRoleRefPermission ejbRolePerm = new EJBRoleRefPermission(ejbName, refName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding the following EJBRoleRefPermission (roleName, refLink): ", new Object[]{refName, refLink});
                        }
                        ejbPC.addToRole(refLink, ejbRolePerm);
                        refLinks.add(refLink);
                    }
                }
                if (ejbAD == null) continue;
                this.addBeanRoleRefs(ejbPC, refLinks, eBean, ejbAD.getSecurityRoles());
            }
        }
        if (mpList != null && mpList.size() > 0) {
            for (i = 0; i < mpList.size(); ++i) {
                MethodPermission mp = (MethodPermission)mpList.get(i);
                EList methodElems = mp.getMethodElements();
                if (mp.isUnchecked()) {
                    ejbUncheckedPerms = this.getEJBPermCollection(methodElems);
                    if (ejbUncheckedPerms == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the following Unchecked permissions: ", new Object[]{ejbUncheckedPerms});
                    }
                    ejbPC.addToUncheckedPolicy(ejbUncheckedPerms);
                    continue;
                }
                roleList = mp.getRoles();
                if (roleList == null || roleList.size() <= 0 || (ejbRolePerms = this.getEJBPermCollection(methodElems)) == null) continue;
                for (int j = 0; j < roleList.size(); ++j) {
                    String roleName = ((SecurityRole)roleList.get(j)).getRoleName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding the following Role Permissions (roleName, EJBRolePermissions): ", new Object[]{roleName, ejbRolePerms});
                    }
                    ejbPC.addToRole(roleName, ejbRolePerms);
                }
            }
        }
        EList methodElements = null;
        if (excludedList != null && (ejbExcludedPerms = this.getEJBPermCollection(methodElements = excludedList.getMethodElements())) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding the following Excluded Permissions: ", new Object[]{ejbExcludedPerms});
            }
            ejbPC.addToExcludedPolicy(ejbExcludedPerms);
        }
        this.linkConfiguration(appName, ejbPC, null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Committing the EJB PolicyConfiguration ");
        }
        ejbPC.commit();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEJBPermissions");
        }
    }

    private PolicyConfigurationFactory getPCF(boolean isLocal) {
        if (this.pcf == null) {
            try {
                if (System.getProperty(FACTORY_NAME) == null) {
                    if (!isLocal) {
                        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                        this.policyCfgFactoryImplClassName = security2.getAuthorizationConfig().getAuthorizationProvider().getString("policyConfigurationFactoryImplClassName");
                    } else {
                        this.policyCfgFactoryImplClassName = this.getLocalPCFName();
                    }
                    if (this.policyCfgFactoryImplClassName != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The policy configuration factory name is:" + this.policyCfgFactoryImplClassName);
                        }
                        System.setProperty(FACTORY_NAME, this.policyCfgFactoryImplClassName);
                        this.pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                    }
                } else {
                    this.pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                }
            }
            catch (ClassNotFoundException cnfe) {
                FFDCFilter.processException((Throwable)cnfe, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "1117", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", new Object[]{cnfe});
                }
                this.pcf = null;
            }
            catch (PolicyContextException pce) {
                FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "1121", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", new Object[]{pce});
                }
                this.pcf = null;
            }
            catch (WorkSpaceException wse) {
                FFDCFilter.processException((Throwable)wse, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "1125", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during getPolicyConfigurationFactory.getPolicyConfigurationFactory:", new Object[]{wse});
                }
                this.pcf = null;
            }
        }
        return this.pcf;
    }

    private RoleConfigurationFactory getRCF(boolean isLocal) {
        if (this.rcf == null) {
            String rcfClassName = null;
            try {
                if (!isLocal) {
                    SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                    rcfClassName = security2.getAuthorizationConfig().getAuthorizationProvider().getString("roleConfigurationFactoryImplClassName");
                } else {
                    rcfClassName = this.getLocalRCFName();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rcfClassName: ", rcfClassName);
                }
                if (rcfClassName != null && rcfClassName.length() > 0) {
                    this.rcf = (RoleConfigurationFactory)Class.forName(rcfClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.authorize.AppInstallNotify.initialize", "1152", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception during the initialization of the roleConfigurationImplClass:", new Object[]{rcfClassName, e});
                }
                this.rcf = null;
            }
        }
        return this.rcf;
    }

    public void linkConfiguration(String appName, PolicyConfiguration pc, PolicyConfiguration oldPC) throws PolicyContextException {
        if (oldPC == null) {
            if (this.pcConfigsMap.containsKey(appName)) {
                PolicyConfiguration linkPC = (PolicyConfiguration)this.pcConfigsMap.get(appName);
                pc.linkConfiguration(linkPC);
            } else {
                this.pcConfigsMap.put(appName, pc);
            }
        } else {
            pc.linkConfiguration(oldPC);
        }
    }

    public PolicyConfiguration getPolicyConfiguration(String moduleName, String appName, String ctxID, boolean isLocal, boolean remove) {
        PolicyConfiguration pc = null;
        String contextID = this.getModuleContextID(ctxID, moduleName);
        try {
            if (this.pcf == null) {
                this.pcf = this.getPCF(isLocal);
            }
            if (this.pcf != null) {
                pc = this.pcf.getPolicyConfiguration(contextID, remove);
            }
        }
        catch (PolicyContextException pce) {
            FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.AppInstallNotify.getPolicyConfiguration", "1186", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{contextID, pce});
            this.pcf = null;
            pc = null;
        }
        return pc;
    }

    public void deleteModule(ModuleRef moduleRef, String appName, String ctxID, boolean isLocal) throws Exception {
        String moduleName = moduleRef.getUri();
        this.deleteModule(moduleName, appName, ctxID, isLocal);
    }

    public void deleteModule(String moduleName, String appName, String ctxID, boolean isLocal) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteModule", new Object[]{moduleName, appName, ctxID});
        }
        PolicyConfiguration pc = null;
        String contextID = this.getModuleContextID(ctxID, moduleName);
        try {
            if (this.pcf == null) {
                this.pcf = this.getPCF(isLocal);
            }
            if (this.pcf == null) {
                throw new Exception("Cannot get the PolicyConfigurationFactory of the JACC provider");
            }
            pc = this.pcf.getPolicyConfiguration(contextID, false);
        }
        catch (ClassNotFoundException cnfe) {
            FFDCFilter.processException((Throwable)cnfe, "com.ibm.ws.security.authorize.AppInstallNotify.deleteModule", "1212", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{contextID, cnfe});
            this.pcf = null;
            pc = null;
            throw new Exception("Failed to get the PolicyConfiguration object", cnfe);
        }
        catch (PolicyContextException pce) {
            FFDCFilter.processException((Throwable)pce, "com.ibm.ws.security.authorize.AppInstallNotify.deleteModule", "1218", this);
            Tr.error(tc, "security.jacc.tools.pcf", new Object[]{contextID, pce});
            this.pcf = null;
            pc = null;
            throw new Exception("Failed to get the PolicyConfiguration object", pce);
        }
        if (pc == null) {
            Tr.error(tc, "security.jacc.tools.pcf.null", new Object[]{contextID});
            throw new Exception("The PolicyConfiguration object is null");
        }
        pc.delete();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteModule");
        }
    }

    private Permissions getEJBPermCollection(EList methodElems) {
        Permissions permCollection = new Permissions();
        if (methodElems != null && methodElems.size() > 0) {
            for (int me = 0; me < methodElems.size(); ++me) {
                List paramList;
                MethodElement mElement = (MethodElement)methodElems.get(me);
                String methodName = mElement.getName();
                EnterpriseBean bean = mElement.getEnterpriseBean();
                if (bean == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "EnterpriseBean for method='" + methodName + "' was not found.");
                    continue;
                }
                String ejbName = bean.getName();
                int methodInfType = mElement.getType().getValue();
                String methodInfName = mElement.getType().getName();
                if (methodName.equals("*")) {
                    methodName = null;
                }
                if (methodInfName != null && methodInfName.equals("Unspecified")) {
                    methodInfName = null;
                }
                String[] paramArray = null;
                if (mElement.hasMethodParams() && (paramList = mElement.getMethodParams()) != null) {
                    paramArray = paramList.toArray(new String[paramList.size()]);
                }
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("addingEJBPermCollection: ejbName = ");
                    buf.append(ejbName).append(", methodName = ").append(methodName).append(", methodInfName = ").append(methodInfName).append(", paramArray = ").append(paramArray);
                    Tr.debug(tc, buf.toString());
                }
                EJBMethodPermission ejbMethodPerm = new EJBMethodPermission(ejbName, methodName, methodInfName, paramArray);
                permCollection.add(ejbMethodPerm);
            }
        } else {
            permCollection = null;
        }
        return permCollection;
    }

    private int urlType(String urlPattern) {
        String pattern = urlPattern.toString();
        if (pattern.startsWith("*.")) {
            return 0;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/*")) {
            return 1;
        }
        if (pattern.equals("/")) {
            return 3;
        }
        return 2;
    }

    private boolean urlPatternMatch(String pattern1, String pattern2) {
        if (pattern1.equals(pattern2)) {
            return true;
        }
        if (pattern1.equals("/*")) {
            return true;
        }
        if (pattern1.startsWith("/") && pattern1.endsWith("/*")) {
            String subPattern = pattern1.substring(0, pattern1.length() - 2);
            int pLength = subPattern.length();
            if (pattern2.startsWith(subPattern) && (pattern2.length() == pLength || pattern2.charAt(pLength + 1) == '/')) {
                return true;
            }
        }
        if (pattern1.startsWith("*.") && pattern2.endsWith(pattern1.substring(1))) {
            return true;
        }
        return pattern1.equals("/");
    }

    private boolean unqualified(String url, String urlPattern) {
        boolean unqualified = false;
        if (urlPattern.indexOf(":") != -1) {
            int idx = urlPattern.indexOf(":");
            StringTokenizer st = new StringTokenizer(urlPattern.substring(idx + 1), ":");
            while (st.hasMoreTokens()) {
                if (!this.urlPatternMatch(st.nextToken(), url)) continue;
                unqualified = true;
                break;
            }
        }
        return unqualified;
    }

    private String getModuleContextID(String appCtxID, String moduleName) {
        String contextID = null;
        if (appCtxID != null && moduleName != null) {
            StringBuffer sb = new StringBuffer(appCtxID);
            sb.append("/").append(moduleName);
            contextID = sb.toString();
        } else {
            contextID = moduleName;
        }
        return contextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthorizationProvider getAuthorizationProvider() throws WorkSpaceException {
        block16: {
            String user2222;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAuthorizationProvider");
            }
            WorkSpace ws = null;
            Resource res = null;
            try {
                block15: {
                    try {
                        String id = "" + System.currentTimeMillis();
                        ws = WorkSpaceManagerFactory.getManager().getWorkSpace(id);
                        RepositoryContextType type = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells");
                        URI uri = URI.createURI("security.xml");
                        Collection c = ws.findContext(type);
                        SecurityCommon security2 = null;
                        Iterator itr = c.iterator();
                        if (itr.hasNext()) {
                            RepositoryContext rc = (RepositoryContext)itr.next();
                            res = rc.getResourceSet().createResource(uri);
                            HashMap options = new HashMap();
                            res.load(options);
                            security2 = (Security)res.getContents().get(0);
                        }
                        AuthorizationConfig authzConfig = null;
                        if (security2 != null) {
                            authzConfig = security2.getAuthConfig();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "authorization config in local mode is: " + authzConfig);
                        }
                        if (authzConfig != null) {
                            authzProvider = (AuthorizationProvider)authzConfig.getAuthorizationProviders().get(0);
                        }
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug(tc, "authorization provider in local mode is: " + authzProvider);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.authorize.AppInstallNotify.getLocalPCFName", "1421", this);
                        Tr.error(tc, "security.jacc.tools.authzprovider.error", new Object[]{e});
                        Object var12_13 = null;
                        if (res != null) {
                            res.unload();
                            res = null;
                        }
                        if (ws != null) {
                            String user2222 = ws.getUserName();
                            WorkSpaceManagerFactory.getManager().removeWorkSpace(user2222);
                        }
                        break block16;
                    }
                }
                Object var12_12 = null;
                if (res != null) {
                    res.unload();
                    res = null;
                }
                if (ws == null) break block16;
                user2222 = ws.getUserName();
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (res != null) {
                    res.unload();
                    res = null;
                }
                if (ws != null) {
                    String user2222 = ws.getUserName();
                    WorkSpaceManagerFactory.getManager().removeWorkSpace(user2222);
                }
                throw throwable;
            }
            WorkSpaceManagerFactory.getManager().removeWorkSpace(user2222);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationProvider");
        }
        return authzProvider;
    }

    private String getLocalPCFName() throws WorkSpaceException {
        String pcfName = null;
        if (authzProvider == null) {
            authzProvider = this.getAuthorizationProvider();
        }
        if (authzProvider != null) {
            pcfName = authzProvider.getPolicyConfigurationFactoryImplClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PolicyConfigurationFactory in localMode is: " + pcfName);
        }
        return pcfName;
    }

    private String getLocalRCFName() throws WorkSpaceException {
        String rcfName = null;
        if (authzProvider == null) {
            authzProvider = this.getAuthorizationProvider();
        }
        if (authzProvider != null) {
            rcfName = authzProvider.getRoleConfigurationFactoryImplClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RoleConfigurationFactory in localMode is: " + rcfName);
        }
        return rcfName;
    }

    private Policy getLocalPolicy() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalPolicy");
        }
        if (this.jPolicy == null) {
            String policyName = System.getProperty("javax.security.jacc.policy.provider");
            if (policyName == null) {
                if (authzProvider == null) {
                    authzProvider = this.getAuthorizationProvider();
                }
                if (authzProvider != null) {
                    policyName = authzProvider.getJ2eePolicyImplClassName();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "PolicyName in local mode is: " + policyName);
                }
            }
            if (policyName != null) {
                Policy.setPolicy((Policy)Class.forName(policyName, true, Thread.currentThread().getContextClassLoader()).newInstance());
                this.jPolicy = Policy.getPolicy();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalPolicy");
        }
        return this.jPolicy;
    }

    private URLMap getNewURLMap(String url, HashMap urlMaps) {
        URLMap urlMap = new URLMap(url);
        for (String prevURL : urlMaps.keySet()) {
            int prevURLType = this.urlType(prevURL);
            switch (this.urlType(url)) {
                case 0: {
                    if (prevURLType == 1 || prevURLType == 2 && this.urlPatternMatch(url, prevURL)) {
                        urlMap.appendURLPattern(prevURL);
                        break;
                    }
                    if (prevURLType != 3) break;
                    ((URLMap)urlMaps.get(prevURL)).appendURLPattern(url);
                    break;
                }
                case 1: {
                    if ((prevURLType == 1 || prevURLType == 2) && this.urlPatternMatch(url, prevURL)) {
                        urlMap.appendURLPattern(prevURL);
                        break;
                    }
                    if (prevURLType == 1 && this.urlPatternMatch(prevURL, url)) {
                        ((URLMap)urlMaps.get(prevURL)).appendURLPattern(url);
                        break;
                    }
                    if (prevURLType != 0 && prevURLType != 3) break;
                    ((URLMap)urlMaps.get(prevURL)).appendURLPattern(url);
                    break;
                }
                case 2: {
                    if ((prevURLType == 0 || prevURLType == 1) && this.urlPatternMatch(prevURL, url)) {
                        ((URLMap)urlMaps.get(prevURL)).appendURLPattern(url);
                        break;
                    }
                    if (prevURLType != 3) break;
                    ((URLMap)urlMaps.get(prevURL)).appendURLPattern(url);
                    break;
                }
                case 3: {
                    if (prevURLType == 3) break;
                    urlMap.appendURLPattern(prevURL);
                    break;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "full urlPattern created is: " + urlMap.getURLPattern());
        }
        urlMaps.put(url, urlMap);
        return urlMap;
    }
}

