/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.rsatoken;

import com.ibm.ws.security.auth.rsatoken.RSATokenThreadContext;
import com.ibm.ws.util.WSThreadLocal;
import java.security.cert.X509Certificate;

public class RSATokenThreadManager
extends WSThreadLocal {
    private static final RSATokenThreadManager thisManager = new RSATokenThreadManager();
    private static final ThreadLocal threadLocStorage = new RSATokenThreadLocal();

    private RSATokenThreadManager() {
    }

    public static RSATokenThreadManager getInstance() {
        return thisManager;
    }

    public void setTargetCertificate(X509Certificate cert) {
        ((RSATokenThreadContext)this.getThreadLocalStorage().get()).targetCertificate = cert;
    }

    public X509Certificate getTargetCertificate() {
        return ((RSATokenThreadContext)this.getThreadLocalStorage().get()).targetCertificate;
    }

    public Boolean isCertificateRetrievalInProcess() {
        return ((RSATokenThreadContext)this.getThreadLocalStorage().get()).certificateRetrievalInProcess;
    }

    public void setCertificateRetrievalInProcess() {
        ((RSATokenThreadContext)this.getThreadLocalStorage().get()).certificateRetrievalInProcess = Boolean.TRUE;
    }

    public void unsetCertificateRetrievalInProcess() {
        ((RSATokenThreadContext)this.getThreadLocalStorage().get()).certificateRetrievalInProcess = Boolean.FALSE;
    }

    public RSATokenThreadContext getThreadLocal() {
        RSATokenThreadContext result = (RSATokenThreadContext)this.getThreadLocalStorage().get();
        if (result == null) {
            result = new RSATokenThreadContext();
            this.getThreadLocalStorage().set(result);
        }
        return result;
    }

    private ThreadLocal getThreadLocalStorage() {
        return threadLocStorage;
    }

    private static final class RSATokenThreadLocal
    extends WSThreadLocal {
        private RSATokenThreadLocal() {
        }

        protected Object initialValue() {
            return new RSATokenThreadContext();
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

