/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.security.util.ConfigUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyKrbAuthMechanism
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ModifyKrbAuthMechanism.class, "ModifyKrbAuthMechanism", "com.ibm.ws.security.auth.kerberos.admintask");
    static final String krb5LoginModuleWrapper = "com.ibm.ws.security.auth.kerberos.Krb5LoginModuleWrapper";
    static final String wsKrb5LoginModule = "com.ibm.ws.security.auth.kerberos.WSKrb5LoginModule";
    static final String ltpaLoginModule = "com.ibm.ws.security.server.lm.ltpaLoginModule";
    static final String pdLoginModuleWrapper = "com.tivoli.pd.as.jacc.cfg.PDLoginModuleWrapper";
    static final String delimiter = "|";
    String krb5Realm = null;
    String krb5Config = null;
    String krb5Keytab = null;
    String serviceName = null;
    String krb5Spn = null;
    Boolean trimUserName = true;
    Boolean enabledGssCredDelegate = true;
    Boolean allowKrbAuthForCsiInbound = true;
    Boolean allowKrbAuthForCsiOutbound = true;
    boolean ltpaLoginModuleExist = false;

    public ModifyKrbAuthMechanism(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyKrbAuthMechanism(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle bundle, String key, Object[] args) {
        return MessageFormatHelper.getFormattedMessage(bundle, key, args);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.krb5Realm = (String)this.getParameter("krb5Realm");
        this.krb5Config = (String)this.getParameter("krb5Config");
        this.krb5Keytab = (String)this.getParameter("krb5Keytab");
        this.serviceName = (String)this.getParameter("serviceName");
        this.trimUserName = (Boolean)this.getParameter("trimUserName");
        this.enabledGssCredDelegate = (Boolean)this.getParameter("enabledGssCredDelegate");
        this.allowKrbAuthForCsiInbound = (Boolean)this.getParameter("allowKrbAuthForCsiInbound");
        this.allowKrbAuthForCsiOutbound = (Boolean)this.getParameter("allowKrbAuthForCsiOutbound");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "krb5Realm:  " + this.krb5Realm);
            Tr.debug(tc, "krb5Config:  " + this.krb5Config);
            Tr.debug(tc, "krb5Keytab:  " + this.krb5Keytab);
            Tr.debug(tc, "serviceName:  " + this.serviceName);
            Tr.debug(tc, "trimUserName:  " + this.trimUserName);
            Tr.debug(tc, "enabledGssCredDelegate:  " + this.enabledGssCredDelegate);
            Tr.debug(tc, "allowKrbAuthForCsiInbound:  " + this.allowKrbAuthForCsiInbound);
            Tr.debug(tc, "allowKrbAuthForCsiOutbound:  " + this.allowKrbAuthForCsiOutbound);
        }
        if (this.serviceName != null && this.serviceName.contains("/")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The service name contains a char slash");
            }
            String msg = this.getMsg(resBundle, "security.admintask.invalid.serviceName", new Object[]{this.serviceName});
            throw new CommandValidationException(msg);
        }
        if (this.serviceName != null) {
            this.krb5Spn = this.serviceName + "/${HOST}";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "krb5Spn:  " + this.krb5Spn);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        File keytab;
        String msg;
        File config;
        String cellNameQualifier = "_Websphere_Config_Data_Display_Name";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        boolean krb5LoginModuleWrapperExist = false;
        boolean wsKrb5LoginModuleExist = false;
        boolean pdLoginModuleWrapperExist = false;
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        if (this.krb5Config != null && this.krb5Config.length() != 0 && !(config = new File(this.krb5Config)).exists()) {
            msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Config});
            Tr.warning(tc, msg);
            result.addWarnings(msg);
        }
        if (this.krb5Keytab != null && this.krb5Keytab.length() != 0 && !(keytab = new File(this.krb5Keytab)).exists()) {
            msg = this.getMsg(resBundle, "security.admintask.fileNotExist", new Object[]{this.krb5Keytab});
            Tr.warning(tc, msg);
            result.addWarnings(msg);
        }
        try {
            boolean krb5ConfigMatch;
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session s = this.getConfigSession();
            security2 = cs.resolve(s, "Cell=:Security=")[0];
            ObjectName activeUserRegistry = (ObjectName)cs.getAttribute(s, security2, "activeUserRegistry");
            String _serverId = null;
            String _serverIdPassword = null;
            boolean useRegServerId = (Boolean)cs.getAttribute(s, activeUserRegistry, "useRegistryServerId", false);
            if (useRegServerId) {
                _serverId = (String)cs.getAttribute(s, activeUserRegistry, "serverId", false);
                _serverIdPassword = (String)cs.getAttribute(s, activeUserRegistry, "serverPassword", false);
            }
            AttributeList attrList2 = new AttributeList();
            ArrayList authMechs = (ArrayList)cs.getAttribute(s, security2, "authMechanisms");
            ObjectName krb5AuthMechObj = Krb5Utils.getAuthMechObj(s, cs, security2, "KRB5");
            if (krb5AuthMechObj != null) {
                attrList2.clear();
                attrList2.add(new Attribute("OID", "oid:1.2.840.113554.1.2.2"));
                attrList2.add(new Attribute("authContextImplClass", "com.ibm.ISecurityLocalObjectTokenBaseImpl.Krb5WSSecurityContextImpl"));
                attrList2.add(new Attribute("authConfig", "system.KRB5"));
                attrList2.add(new Attribute("simpleAuthConfig", "system.KRB5"));
                attrList2.add(new Attribute("authValidationConfig", "system.KRB5"));
                if (this.krb5Realm != null) {
                    attrList2.add(new Attribute("krb5Realm", this.krb5Realm));
                }
                if (this.krb5Config != null) {
                    attrList2.add(new Attribute("krb5Config", this.krb5Config));
                }
                if (this.krb5Keytab != null) {
                    attrList2.add(new Attribute("krb5Keytab", this.krb5Keytab));
                }
                if (this.krb5Spn != null) {
                    attrList2.add(new Attribute("krb5Spn", this.krb5Spn));
                }
                if (this.trimUserName != null) {
                    attrList2.add(new Attribute("trimUserName", this.trimUserName));
                }
                if (this.enabledGssCredDelegate != null) {
                    attrList2.add(new Attribute("enabledGssCredDelegate", this.enabledGssCredDelegate));
                }
                attrList2.add(new Attribute("configured", true));
                cs.setAttributes(s, krb5AuthMechObj, attrList2);
            }
            String _krb5Config = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Config", false);
            String _krb5Keytab = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Keytab", false);
            String _krb5Realm = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Realm", false);
            String spn = (String)cs.getAttribute(s, krb5AuthMechObj, "krb5Spn", false);
            String _krb5Spn = ConfigUtils.expandHost(spn, null);
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand getUserCmd = null;
            CommandResult cmdResult = null;
            getUserCmd = commandMgr.createCommand("validateKrbConfig");
            getUserCmd.setParameter("checkConfigOnly", false);
            getUserCmd.setParameter("validateKrbRealm", true);
            getUserCmd.setParameter("useGlobalSecurityConfig", false);
            getUserCmd.setParameter("serverId", _serverId);
            getUserCmd.setParameter("serverIdPassword", _serverIdPassword);
            getUserCmd.setParameter("krb5Spn", _krb5Spn);
            getUserCmd.setParameter("krb5Config", _krb5Config);
            getUserCmd.setParameter("krb5Keytab", _krb5Keytab);
            getUserCmd.setParameter("krb5Realm", _krb5Realm);
            getUserCmd.setConfigSession(s);
            getUserCmd.execute();
            cmdResult = getUserCmd.getCommandResult();
            if (!cmdResult.isSuccessful()) {
                Throwable e = cmdResult.getException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating Kerberos configuration failed", new Object[]{e});
                }
                Tr.error(tc, "Validating Kerberos configuration failed", new Object[]{e.getMessage()});
                throw new CommandValidationException(e.getMessage());
            }
            boolean spnegoEnabled = false;
            ObjectName spnegoAuthMechObj = Krb5Utils.getAuthMechObj(s, cs, security2, "SPNEGO");
            if (spnegoAuthMechObj != null) {
                spnegoEnabled = (Boolean)cs.getAttribute(s, spnegoAuthMechObj, "enabled", false);
            }
            if (spnegoEnabled && !(krb5ConfigMatch = this.krb5ConfigEquals(s, cs, security2, this.krb5Config, this.krb5Keytab))) {
                getUserCmd = commandMgr.createCommand("validateSpnegoConfig");
                getUserCmd.setParameter("krb5Config", _krb5Config);
                getUserCmd.setParameter("krb5Keytab", _krb5Keytab);
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Validating SPNEGO Web authentication with the new Kerberos configuration failed", new Object[]{e});
                    }
                    Tr.error(tc, "Validating SPNEGO Web authentication with the new Kerberos configuration failed", new Object[]{e.getMessage()});
                    throw new CommandValidationException(e.getMessage());
                }
            }
            ObjectName[] JAASConfigurationEntries = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(null, "JAASConfigurationEntry"), null);
            for (int i = 0; i < JAASConfigurationEntries.length; ++i) {
                Object alias = cs.getAttribute(s, JAASConfigurationEntries[i], "alias");
                if (alias == null || !alias.toString().equals("WEB_INBOUND") && !alias.toString().equals("RMI_INBOUND") && !alias.toString().equals("DEFAULT")) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JAASConfigurationEntries: " + JAASConfigurationEntries[i]);
                }
                AttributeList entriesAttrList = cs.getAttributes(s, JAASConfigurationEntries[i], null, true);
                for (Attribute entriesAttr : entriesAttrList) {
                    if (!entriesAttr.getName().equals("loginModules")) continue;
                    List loginModulesList = (List)entriesAttr.getValue();
                    for (AttributeList attrList2 : loginModulesList) {
                        ObjectName[] loginModuleObjs = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(attrList2), null);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "loginModuleObjs: " + loginModuleObjs);
                        }
                        if (loginModuleObjs == null || loginModuleObjs.length == 0) continue;
                        Object moduleClassName = cs.getAttribute(s, loginModuleObjs[0], "moduleClassName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "moduleClassName: " + moduleClassName.toString());
                        }
                        if (krb5LoginModuleWrapper.equals(moduleClassName.toString())) {
                            krb5LoginModuleWrapperExist = true;
                        }
                        if (wsKrb5LoginModule.equals(moduleClassName.toString())) {
                            wsKrb5LoginModuleExist = true;
                        }
                        if (!pdLoginModuleWrapper.equals(moduleClassName.toString())) continue;
                        pdLoginModuleWrapperExist = true;
                    }
                    if (!krb5LoginModuleWrapperExist) {
                        attrList2.clear();
                        attrList2.add(new Attribute("moduleClassName", krb5LoginModuleWrapper));
                        attrList2.add(new Attribute("authenticationStrategy", "REQUIRED"));
                        cs.addElement(s, JAASConfigurationEntries[i], "loginModules", attrList2, 0);
                    }
                    if (wsKrb5LoginModuleExist) continue;
                    attrList2.clear();
                    attrList2.add(new Attribute("moduleClassName", wsKrb5LoginModule));
                    attrList2.add(new Attribute("authenticationStrategy", "REQUIRED"));
                    if (!pdLoginModuleWrapperExist) {
                        cs.addElement(s, JAASConfigurationEntries[i], "loginModules", attrList2, 1);
                        continue;
                    }
                    cs.addElement(s, JAASConfigurationEntries[i], "loginModules", attrList2, 2);
                }
            }
            ObjectName[] jaasLoginModules = cs.queryConfigObjects(s, null, ConfigServiceHelper.createObjectName(null, "JAASLoginModule"), null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "jaasLoginModules: " + jaasLoginModules);
            }
            if (jaasLoginModules != null && jaasLoginModules.length != 0) {
                for (int i = 0; i < jaasLoginModules.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "jaasLoginModules: " + jaasLoginModules[i]);
                    }
                    Object moduleClassNameObj = cs.getAttribute(s, jaasLoginModules[i], "moduleClassName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "moduleClassNameObj: " + moduleClassNameObj.toString());
                    }
                    if (!krb5LoginModuleWrapper.equals(moduleClassNameObj.toString()) || krb5LoginModuleWrapperExist) continue;
                    attrList2.clear();
                    attrList2.add(new Attribute("name", "credsType"));
                    attrList2.add(new Attribute("value", "both"));
                    attrList2.add(new Attribute("required", false));
                    cs.addElement(s, jaasLoginModules[i], "options", attrList2, -1);
                    attrList2.clear();
                    attrList2.add(new Attribute("name", "tryFirstPass"));
                    attrList2.add(new Attribute("value", "true"));
                    attrList2.add(new Attribute("required", false));
                    cs.addElement(s, jaasLoginModules[i], "options", attrList2, -1);
                    attrList2.clear();
                    attrList2.add(new Attribute("name", "storeSharedStateCredentials"));
                    attrList2.add(new Attribute("value", "true"));
                    attrList2.add(new Attribute("required", false));
                    cs.addElement(s, jaasLoginModules[i], "options", attrList2, -1);
                    attrList2.clear();
                    attrList2.add(new Attribute("name", "refreshKrb5Config"));
                    attrList2.add(new Attribute("value", "true"));
                    attrList2.add(new Attribute("required", false));
                    cs.addElement(s, jaasLoginModules[i], "options", attrList2, -1);
                    attrList2.clear();
                    attrList2.add(new Attribute("name", "renewable"));
                    attrList2.add(new Attribute("value", "true"));
                    attrList2.add(new Attribute("required", false));
                    cs.addElement(s, jaasLoginModules[i], "options", attrList2, -1);
                    attrList2.clear();
                    attrList2.add(new Attribute("name", "forwardable"));
                    attrList2.add(new Attribute("value", "true"));
                    attrList2.add(new Attribute("required", false));
                    cs.addElement(s, jaasLoginModules[i], "options", attrList2, -1);
                    attrList2.clear();
                    attrList2.add(new Attribute("name", "noAddress"));
                    attrList2.add(new Attribute("value", "true"));
                    attrList2.add(new Attribute("required", false));
                    cs.addElement(s, jaasLoginModules[i], "options", attrList2, -1);
                }
            }
            String supportedAuthMechList = null;
            String newAuthMechs = null;
            boolean krbAuthExist = false;
            attrList2.clear();
            attrList2 = (AttributeList)cs.getAttribute(s, security2, "CSI");
            ObjectName csiObj = cs.queryConfigObjects(s, security2, ConfigServiceHelper.createObjectName(attrList2), null)[0];
            AttributeList claims = (AttributeList)cs.getAttribute(s, csiObj, "claims");
            ArrayList layers = (ArrayList)ConfigServiceHelper.getAttributeValue(claims, "layers");
            for (int i = 0; i < layers.size(); ++i) {
                AttributeList layer = (AttributeList)layers.get(i);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (!layerType.equals("MessageLayer")) continue;
                supportedAuthMechList = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI inbound, supportedAuthMechList: " + supportedAuthMechList);
            }
            if (supportedAuthMechList != null && supportedAuthMechList.length() != 0 && (supportedAuthMechList = supportedAuthMechList.toLowerCase()).contains("krb5")) {
                krbAuthExist = true;
            }
            newAuthMechs = supportedAuthMechList;
            if (krbAuthExist) {
                if (!this.allowKrbAuthForCsiInbound.booleanValue()) {
                    newAuthMechs = supportedAuthMechList.replace("krb5|", "");
                }
            } else if (this.allowKrbAuthForCsiInbound.booleanValue()) {
                newAuthMechs = "krb5|" + supportedAuthMechList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI inbound, update supportedAuthMechList: " + newAuthMechs);
            }
            if (newAuthMechs != null) {
                getUserCmd = null;
                cmdResult = null;
                getUserCmd = commandMgr.createCommand("configureCSIInbound");
                getUserCmd.setParameter("supportedAuthMechList", newAuthMechs.toUpperCase());
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting supportedAuthMechList for CSI inbound.", new Object[]{e});
                    }
                    Tr.error(tc, "Error getting supportedAuthMechList for CSI inbound", new Object[]{e.getMessage()});
                    throw new CommandValidationException(e.getMessage());
                }
            }
            supportedAuthMechList = null;
            newAuthMechs = null;
            krbAuthExist = false;
            AttributeList performs = (AttributeList)cs.getAttribute(s, csiObj, "performs");
            layers = (ArrayList)ConfigServiceHelper.getAttributeValue(performs, "layers");
            for (int i = 0; i < layers.size(); ++i) {
                AttributeList layer = (AttributeList)layers.get(i);
                String layerType = (String)ConfigServiceHelper.getAttributeValue(layer, "_Websphere_Config_Data_Type");
                if (!layerType.equals("MessageLayer")) continue;
                supportedAuthMechList = (String)ConfigServiceHelper.getAttributeValue(layer, "supportedAuthMechList");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI outbound, supportedAuthMechList " + supportedAuthMechList);
            }
            if (supportedAuthMechList != null && supportedAuthMechList.length() != 0 && (supportedAuthMechList = supportedAuthMechList.toLowerCase()).contains("krb5")) {
                krbAuthExist = true;
            }
            newAuthMechs = supportedAuthMechList;
            if (krbAuthExist) {
                if (!this.allowKrbAuthForCsiOutbound.booleanValue()) {
                    newAuthMechs = supportedAuthMechList.replace("krb5|", "");
                }
            } else if (this.allowKrbAuthForCsiOutbound.booleanValue()) {
                newAuthMechs = "krb5|" + supportedAuthMechList;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI outbound, update supportedAuthMechList " + newAuthMechs);
            }
            if (newAuthMechs != null) {
                getUserCmd = null;
                cmdResult = null;
                getUserCmd = commandMgr.createCommand("configureCSIOutbound");
                getUserCmd.setParameter("supportedAuthMechList", newAuthMechs.toUpperCase());
                getUserCmd.setConfigSession(s);
                getUserCmd.execute();
                cmdResult = getUserCmd.getCommandResult();
                if (!cmdResult.isSuccessful()) {
                    Throwable e = cmdResult.getException();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error getting supportedAuthMechList for CSI outbound.", new Object[]{e});
                    }
                    Tr.error(tc, "Error getting supportedAuthMechList for CSI outbound", new Object[]{e.getMessage()});
                    throw new CommandValidationException(e.getMessage());
                }
            }
            result.setResult(new Boolean(true));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.auth.kerberos.admintask.ModifyKrbAuthMechanism.afterStepsExecuted", "568", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }

    public boolean krb5ConfigEquals(Session session, ConfigService configService, ObjectName securityObj, String krb5Config, String krb5Keytab) throws Exception {
        ObjectName krb5AuthMechObj;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "krb5ConfigEquals");
        }
        boolean result = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "krb5Config: " + krb5Config);
            Tr.debug(tc, "krb5Keytab: " + krb5Keytab);
        }
        if ((krb5AuthMechObj = Krb5Utils.getAuthMechObj(session, configService, securityObj, "KRB5")) != null) {
            String krb5Auth_krb5Config = (String)configService.getAttribute(session, krb5AuthMechObj, "krb5Config", false);
            String krb5Auth_krb5Keytab = (String)configService.getAttribute(session, krb5AuthMechObj, "krb5Keytab", false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "existing krb5Config: " + krb5Auth_krb5Config);
                Tr.debug(tc, "existing krb5Keytab: " + krb5Auth_krb5Keytab);
            }
            if (krb5Auth_krb5Config != null && krb5Auth_krb5Config.length() != 0 && krb5Auth_krb5Config.equalsIgnoreCase(krb5Config)) {
                if (!(krb5Auth_krb5Keytab != null && krb5Auth_krb5Keytab.length() != 0 || krb5Keytab != null && krb5Keytab.length() != 0)) {
                    result = true;
                } else if (krb5Auth_krb5Keytab != null && krb5Keytab != null && krb5Auth_krb5Keytab.equalsIgnoreCase(krb5Keytab)) {
                    result = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "krb5ConfigEquals " + result);
        }
        return result;
    }
}

