/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.CredentialMapFailedException;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.auth.kerberos.Krb5Utils;
import com.ibm.ws.security.auth.kerberos.NoCredentialFoundException;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.wsspi.security.ltpa.Token;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class Krb5WSCredentialUtils {
    private static final GSSManager _manager = GSSManager.getInstance();
    private static TraceComponent tc = Tr.register(Krb5WSCredentialUtils.class, "Security", "com.ibm.ws.security.auth.kerberos.krbsecurity");

    public static WSCredential Krb5ToRegistryWSCredential(String userName) throws NoCredentialFoundException, CredentialMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5ToRegistryWSCredential", new Object[]{userName});
        }
        Object credential = null;
        String userDN = null;
        String searchUserName = Krb5WSCredentialUtils.adjustUserName(userName);
        UserRegistry _userRegistry = (UserRegistry)SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getUserRegistryImpl();
        if (_userRegistry != null) {
            try {
                Result users;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting DN from userRegistry based on username: " + searchUserName);
                }
                if ((users = _userRegistry.getUsers(searchUserName, 1)).getList().size() > 1) {
                    throw new CredentialMapFailedException("Returned multiple users from the registry for userName: " + searchUserName);
                }
                if (users.getList().size() == 0) {
                    throw new NoCredentialFoundException("Did not find user in userRegistry for userName: " + searchUserName);
                }
                userDN = (String)users.getList().get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DN found is ", userDN);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "calling createCredential from userRegistry");
                }
                credential = _userRegistry.createCredential(userDN);
                credential.set("security.login_uid", searchUserName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returning from createCredential");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5ToRegistryWSCredential", "167");
                e.printStackTrace();
            }
        }
        if (tc.isDebugEnabled()) {
            if (credential == null) {
                Tr.debug(tc, "*** newly created WSCredential is NULL!");
            } else {
                Tr.debug(tc, credential.toString());
            }
        }
        if (credential == null && _userRegistry != null) {
            Tr.error(tc, "security.auth.kerberos.NoCredFound");
            throw new NoCredentialFoundException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Krb5ToRegistryWSCredential()");
        }
        return credential;
    }

    public static String Krb5ToRegistryDN(String userName) throws NoCredentialFoundException, CredentialMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5ToRegistryDN", new Object[]{userName});
        }
        String userDN = null;
        String searchUserName = Krb5WSCredentialUtils.adjustUserName(userName);
        UserRegistry _userRegistry = (UserRegistry)SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getUserRegistryImpl();
        if (_userRegistry != null) {
            try {
                Result users;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting user DN from userRegistry " + searchUserName);
                }
                if ((users = _userRegistry.getUsers(searchUserName, 1)).getList().size() > 1) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Krb5ToRegistryDN()");
                    }
                    throw new CredentialMapFailedException("Returned multiple users from the registry for userName: " + searchUserName);
                }
                if (users.getList().size() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Krb5ToRegistryDN()");
                    }
                    throw new NoCredentialFoundException("Did not find user in userRegistry for userName: " + searchUserName);
                }
                userDN = (String)users.getList().get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "DN found is ", userDN);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Krb5ToRegistryDN()");
                }
                return userDN;
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5ToRegistryDN", "249");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception in Krb5ToRegistryDN: ", new Object[]{e});
                }
                if (e instanceof CredentialMapFailedException) {
                    throw (CredentialMapFailedException)e;
                }
                if (e instanceof NoCredentialFoundException) {
                    throw (NoCredentialFoundException)e;
                }
                throw new NoCredentialFoundException(e.getMessage());
            }
        }
        return null;
    }

    public static WSCredential Krb5ToAuthMechWSCredential(Subject subject, GSSCredential gssCredential, WSCredential urCred) throws NoCredentialFoundException, CredentialMapFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Krb5ToAuthMechWSCredential");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Entry parameters:");
            Tr.debug(tc, subject != null && subject.toString().length() != 0 ? subject.toString() : "subject: NULL");
            Tr.debug(tc, gssCredential != null ? gssCredential.toString() : "gssCredential: NULL");
            Tr.debug(tc, urCred != null ? urCred.toString() : "urCred: NULL");
        }
        long krb5expiration = 0L;
        String authMechOid = "oid:1.2.840.113554.1.2.2";
        WSCredentialImpl credential = null;
        try {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            Long expirationLong = security2.getActiveAuthMechanism().getLong("timeout");
            long expiration = expirationLong * 60L * 1000L + System.currentTimeMillis();
            if (gssCredential != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Krb5ToAuthMechWSCredential for " + ((Object)gssCredential.getName()).toString());
                }
                krb5expiration = (long)(gssCredential.getRemainingLifetime() * 1000) + System.currentTimeMillis();
            } else {
                authMechOid = "oid:1.3.18.0.2.30.2";
                krb5expiration = expiration;
            }
            boolean ltpaSupported = security2.getActiveAuthMechanism().getBoolean("allowLPTAAuth");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Krb5ToAuthMechWSCredential - authMechOid: " + authMechOid + ", krb5expiration: " + krb5expiration + ", ltpaSupported: " + ltpaSupported);
            }
            if (ltpaSupported) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating WSCredential with LTPA token for backwards compatiblity.");
                }
                LTPAServerObject ltpaServer = null;
                byte[] ltpaTokenBytes = null;
                try {
                    ltpaServer = LTPAServerObject.getLTPAServer();
                    String factory = security2.getProperty("com.ibm.wsspi.security.token.authenticationTokenFactory");
                    Token ltpaToken = ltpaServer.createLTPAToken(urCred.getAccessId(), factory);
                    ltpaTokenBytes = ltpaToken.getBytes();
                    long l = expiration = krb5expiration < expiration ? krb5expiration : expiration;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Krb5ToAuthMechWSCredential - expiration: " + expiration);
                    }
                }
                catch (LTPAConfigException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ERROR: Failed to get the LTPA server object.");
                    }
                    FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5ToAuthMechWSCredential", "357");
                    Object[] parms = new Object[]{"createCredential()", e};
                    Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
                }
                credential = new WSCredentialImpl(urCred, authMechOid, ltpaTokenBytes, true, expiration);
            } else {
                credential = new WSCredentialImpl(urCred, authMechOid, new byte[0], true, krb5expiration);
            }
            try {
                KerberosTicket kTicket;
                if (gssCredential != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Krb5ToAuthMechWSCredential - put GSS credential into the subject");
                    }
                    SubjectHelper.putGSSCredentialInSubject(gssCredential, subject);
                }
                if (gssCredential != null | (kTicket = SubjectHelper.getKerberosTicketFromSubject(subject)) != null) {
                    Krb5Utils.createKRBAuthnToken(kTicket, gssCredential, subject);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No gssCred and Kerberos ticket during Krb5ToAuthMechWSCredential, can not create KRBAuthnToken");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5ToAuthMechWSCredential", "386");
                Tr.error(tc, "security.auth.kerberos.CredInvalid", new Object[]{e.getMessage()});
                throw new CredentialMapFailedException(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.Krb5ToAuthMechWSCredential", "392");
            Object[] parms = new Object[]{"createCredential()", e};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw new CredentialMapFailedException(e.getMessage(), e);
        }
        if (credential == null) {
            Tr.error(tc, "security.auth.kerberos.NoCredFound");
            throw new NoCredentialFoundException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Krb5ToAuthMechWSCredential()");
        }
        return credential;
    }

    public static GSSCredential validateToken(byte[] token) throws Exception, GSSException {
        GSSCredential serverCred = null;
        GSSContext serverContext = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken() " + new Object[]{token});
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        try {
            serverCred = contextManager.getServerSpnGSSCred();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateToken: serverCred is :" + serverCred);
            }
        }
        catch (Exception exc) {
            FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.validateToken", "431");
            Object[] parms = new Object[]{"createCredential()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw exc;
        }
        try {
            serverContext = _manager.createContext(serverCred);
        }
        catch (GSSException exc) {
            FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.validateToken", "441");
            Object[] parms = new Object[]{"createContext()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw exc;
        }
        Krb5Utils.setUseSubjectCredsOnly(true);
        byte[] outToken = null;
        Subject subject = null;
        try {
            final GSSContext inServerContext = serverContext;
            final byte[] inCredToken = token;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "validateToken: calling acceptSecContext.");
                    }
                    return inServerContext.acceptSecContext(inCredToken, 0, inCredToken.length);
                }
            };
            try {
                outToken = (byte[])Subject.doAsPrivileged(subject, action, AccessController.getContext());
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.validateToken", "468");
                throw e.getException();
            }
        }
        catch (GSSException exc) {
            Object[] parms = new Object[]{"validateToken()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.validateToken", "474");
            throw new WSLoginFailedException(exc.getMessage(), exc);
        }
        catch (Exception e) {
            Object[] parms = new Object[]{serverContext, "validateToken()", e};
            Tr.error(tc, "security.auth.kerberos.exception", parms);
            FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.validateToken", "480");
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        if (outToken == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "validateToken: outToken is null");
        }
        if (subject != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validateToken: " + subject.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateToken: subject is null.");
        }
        GSSCredential gssCred = null;
        try {
            gssCred = serverContext.getDelegCred();
        }
        catch (GSSException exc) {
            FFDCFilter.processException(exc, "com.ibm.ws.security.auth.kerberos.validateToken", "505");
            Object[] parms = new Object[]{"getDelegCred()", exc};
            Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            throw exc;
        }
        if (tc.isDebugEnabled()) {
            if (gssCred == null) {
                Tr.debug(tc, "validateToken: gssCred is null.");
            } else {
                Tr.debug(tc, "validateToken: gssCred is not null.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken()");
        }
        return gssCred;
    }

    public static String adjustUserName(String userName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "adjustUserName() " + userName);
        }
        String user = userName;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        boolean trimUserName = security2.getActiveAuthMechanism().getBoolean("trimUserName");
        String kerberos_realm = security2.getActiveAuthMechanism().getString("krb5Realm");
        int i = userName.indexOf("@");
        if (trimUserName) {
            if (i < 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is nothing to trim in the principal name.");
                }
            } else {
                user = userName.substring(0, i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Principal name was trimmed to: " + user);
                }
            }
        } else if (i < 0 && kerberos_realm != null && !kerberos_realm.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "kerberos_realm: " + kerberos_realm);
            }
            user = userName + "@" + kerberos_realm;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "adjustUserName() " + user);
        }
        return user;
    }
}

