/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnToken;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactory;
import com.ibm.wsspi.wssecurity.platform.token.KRBAuthnTokenFactoryFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class Krb5Utils {
    private static final GSSManager _mgr = GSSManager.getInstance();
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static Oid krb5MechOid = null;
    private static Oid spnegoMechOid = null;
    private static TraceComponent tc = Tr.register(Krb5Utils.class, "Security", "com.ibm.ws.security.auth.kerberos.krbsecurity");

    public static GSSCredential createGSSCredential(Subject temp_subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createGSSCredential(temp_subject)");
        }
        GSSCredential gssCred = null;
        KerberosTicket kTicket = null;
        try {
            kTicket = SubjectHelper.getKerberosTicketFromSubject(temp_subject);
            if (kTicket != null) {
                final String _myName = kTicket.getClient().getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Name for cred: " + _myName);
                }
                gssCred = (GSSCredential)Subject.doAs(temp_subject, new PrivilegedExceptionAction(){

                    public Object run() throws GSSException, Exception {
                        block4: {
                            try {
                                GSSName _gssName = null;
                                _gssName = _myName != null ? _mgr.createName(_myName, GSSName.NT_USER_NAME, Krb5Utils.getKrb5MechOid()) : null;
                                GSSCredential _gssCred = _mgr.createCredential(_gssName.canonicalize(Krb5Utils.getKrb5MechOid()), 0, Krb5Utils.getKrb5MechOid(), 1);
                                return _gssCred;
                            }
                            catch (GSSException gsse) {
                                FFDCFilter.processException((Throwable)gsse, "com.ibm.security.auth.kerberos.krb5utils.createGSSCredential", "136", this);
                                if (tc.isEntryEnabled()) {
                                    Tr.error(tc, "security.auth.kerberos.GSSException", new Object[]{"createName() or createCredential()", gsse});
                                }
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.security.auth.kerberos.krb5utils.createGSSCredential", "141", this);
                                if (!tc.isEntryEnabled()) break block4;
                                Tr.error(tc, "security.auth.kerberos.Exception", new Object[]{"createName() or createCredential()", e});
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            Tr.debug(tc, "Exception in Subject.doAS.", new Object[]{e.getException().toString()});
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createGSSCredential(temp_subject) " + gssCred);
        }
        return gssCred;
    }

    public static GSSCredential createGSSCredential(KerberosTicket kTicket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createGSSCredential(kTicket)");
        }
        GSSCredential gssCred = null;
        try {
            if (kTicket != null) {
                final String _myName = kTicket.getClient().getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "kTicket client name: " + _myName);
                }
                Subject temp_subject = new Subject();
                temp_subject.getPrivateCredentials().add(kTicket);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Add Kerberos ticket in temp_subject = " + temp_subject);
                }
                gssCred = (GSSCredential)Subject.doAs(temp_subject, new PrivilegedExceptionAction(){

                    public Object run() throws GSSException, Exception {
                        block4: {
                            try {
                                GSSName _gssName = null;
                                _gssName = _myName != null ? _mgr.createName(_myName, GSSName.NT_USER_NAME, Krb5Utils.getKrb5MechOid()) : null;
                                GSSCredential _gssCred = _mgr.createCredential(_gssName.canonicalize(Krb5Utils.getKrb5MechOid()), 0, Krb5Utils.getKrb5MechOid(), 1);
                                return _gssCred;
                            }
                            catch (GSSException gsse) {
                                FFDCFilter.processException((Throwable)gsse, "com.ibm.security.auth.kerberos.krb5utils.createGSSCredential", "207", this);
                                if (tc.isEntryEnabled()) {
                                    Tr.error(tc, "security.auth.kerberos.GSSException", new Object[]{"createName() or createCredential()", gsse});
                                }
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.security.auth.kerberos.krb5utils.createGSSCredential", "212", this);
                                if (!tc.isEntryEnabled()) break block4;
                                Tr.error(tc, "security.auth.kerberos.Exception", new Object[]{"createName() or createCredential()", e});
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            Tr.debug(tc, "Exception in Subject.doAS.", new Object[]{e.getException().toString()});
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createGSSCredential(kTicket) " + gssCred);
        }
        return gssCred;
    }

    public static Oid getKrb5MechOid() {
        if (krb5MechOid != null) {
            return krb5MechOid;
        }
        try {
            krb5MechOid = new Oid(KRB5_OID);
        }
        catch (GSSException ex) {
            FFDCFilter.processException(ex, "com.ibm.security.auth.kerberos.krb5utils.getKrb5MechOid", "244");
            Object[] parms = new Object[]{Oid.class, "Oid(\"1.2.840.113554.1.2.2\")", ex};
            Tr.debug(tc, "krb5MechOid is null", parms);
            krb5MechOid = null;
        }
        return krb5MechOid;
    }

    public static Oid getSpnegoMechOid() {
        if (spnegoMechOid != null) {
            return spnegoMechOid;
        }
        try {
            spnegoMechOid = new Oid(SPNEGO_OID);
        }
        catch (GSSException ex) {
            FFDCFilter.processException(ex, "com.ibm.security.auth.kerberos.krb5utils.getSpnegoMechOid", "264");
            Object[] parms = new Object[]{Oid.class, "Oid(\"1.3.6.1.5.5.2\")", ex};
            Tr.debug(tc, "spnegoMechOid is null", parms);
            spnegoMechOid = null;
        }
        return spnegoMechOid;
    }

    public static void setUseSubjectCredsOnly(boolean useSubjectCredsOnly) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseSubjectCredsOnly");
        }
        final String value = useSubjectCredsOnly ? "true" : "false";
        String property = "javax.security.auth.useSubjectCredsOnly";
        String temp = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String t = System.getProperty("javax.security.auth.useSubjectCredsOnly");
                System.setProperty("javax.security.auth.useSubjectCredsOnly", value);
                return t;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "useSubjectCredsOnly property previous: " + (temp != null ? temp : "<null>") + " and now: " + value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseSubjectCredsOnly");
        }
    }

    public static void setKrbConfigProp(String krb5Config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKrbConfigProp");
        }
        if (krb5Config != null && krb5Config.length() != 0) {
            final String inKrb5Config = krb5Config;
            String cf = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String property = "java.security.krb5.conf";
                    String c = System.getProperty("java.security.krb5.conf");
                    System.setProperty("java.security.krb5.conf", inKrb5Config);
                    return c;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "java.security.krb5.conf property previous: " + (cf != null ? cf : "<null>") + " and now: " + krb5Config);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKrbConfigProp");
        }
    }

    public static void setKrbKeytabProp(String krb5Keytab) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKrbKeytabProp");
        }
        if (krb5Keytab != null && krb5Keytab.length() != 0) {
            String kt;
            block7: {
                final String inKrb5Keytab = krb5Keytab;
                kt = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        String k = System.getProperty("KRB5_KTNAME");
                        System.setProperty("KRB5_KTNAME", inKrb5Keytab);
                        return k;
                    }
                });
                if (kt != null && kt.length() > 0 && !kt.equals(krb5Keytab)) {
                    Thread.dumpStack();
                    Tr.warning(tc, "security.auth.kerberos.cannot.resetkeytab", new Object[]{krb5Keytab, kt, kt});
                }
                try {
                    KeyTab.getInstance((String)krb5Keytab);
                }
                catch (IOException e) {
                    FFDCFilter.processException(e, "com.ibm.security.auth.kerberos.krb5utils.setKrbKeytabProp", "353");
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KRB5_KTNAME property previous: " + (kt != null ? kt : "<null>") + " and now: " + krb5Keytab);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKrbKeytabProp");
        }
    }

    public static boolean isKrb5Login(String authMechOid, String uid) {
        String regionId;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKrb5Login: Oid:" + authMechOid + " uid: " + (uid != null ? uid : "<null>"));
        }
        boolean result = true;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        String activeAuthMechOid = security2.getActiveAuthMechanism().getString("OID");
        if (!OID.compareOIDs(activeAuthMechOid, "oid:1.2.840.113554.1.2.2")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "activeAuthMechanism is not KRB5. Handling login outside this login module");
            }
            return false;
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
        if (internalServerId != null && contextManager.isInternalServerId(uid)) {
            Tr.debug(tc, "internal server ID. Handling login outside this login module");
            return false;
        }
        if (uid == null && authMechOid != null) {
            if (OID.compareOIDs(authMechOid, "oid:1.2.840.113554.1.2.2")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication mechanism is Kerberos. Handling login as Kerberos.");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Authentication mechanism is NOT Kerberos. Handling login outside this login module.");
            }
            return false;
        }
        if (PlatformHelperFactory.getPlatformHelper().isZOS() && security2.getActiveUserRegistry().getType().equals("LOCALOS") && (regionId = ContextManagerFactory.getInstance().getRegionId()) != null && regionId.length() != 0 && regionId.equals(uid)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "region ID for zOS. Handling login outside this login module");
            }
            return false;
        }
        String krb5Config = security2.getAuthMechanism("KRB5").getString("krb5Config");
        if (krb5Config != null) {
            Krb5Utils.setKrbConfigProp(krb5Config);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKrb5Login " + result);
        }
        return result;
    }

    public static String getKrb5Realm() throws Exception {
        String krb5Config;
        String krb5Realm = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Realm");
        if ((krb5Realm == null || krb5Realm.length() == 0) && (krb5Config = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Config")) != null && krb5Config.length() > 0) {
            krb5Realm = Krb5Utils.getDefaultRealm(krb5Config);
        }
        return krb5Realm;
    }

    public static String getDefaultRealm(String krb5Config) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultRealm");
        }
        String defaultKrb5Realm = null;
        try {
            if (RasHelper.isServer()) {
                if (krb5Config == null || krb5Config.length() == 0) {
                    krb5Config = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Config");
                }
                if (krb5Config != null && krb5Config.length() > 0) {
                    Krb5Utils.setKrbConfigProp(krb5Config);
                    Config krb5Cfg = Config.getInstance();
                    Config.refresh();
                    krb5Cfg = Config.getInstance();
                    defaultKrb5Realm = krb5Cfg.getDefaultRealm();
                }
            } else {
                Config krb5Cfg = Config.getInstance();
                Config.refresh();
                krb5Cfg = Config.getInstance();
                defaultKrb5Realm = krb5Cfg.getDefaultRealm();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.security.auth.kerberos.krb5utils.getDefaultRealm", "476");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultRealm " + defaultKrb5Realm);
        }
        return defaultKrb5Realm;
    }

    public static String getKrb5Keytab() throws Exception {
        String krb5Keytab;
        block3: {
            String krb5Config;
            krb5Keytab = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Keytab");
            if ((krb5Keytab == null || krb5Keytab.length() == 0) && (krb5Config = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Config")) != null && krb5Config.length() > 0) {
                krb5Keytab = Krb5Utils.getDefaultKeytab(krb5Config);
            }
            try {
                KeyTab.getInstance((String)krb5Keytab);
            }
            catch (IOException e) {
                FFDCFilter.processException(e, "com.ibm.security.auth.kerberos.krb5utils.getKrb5Keytab", "502");
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
        }
        return krb5Keytab;
    }

    public static String getDefaultKeytab(String krb5Config) throws Exception {
        String defaultKrb5Keytab;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDefaultKeytab");
            }
            defaultKrb5Keytab = null;
            String keytab = null;
            try {
                if (krb5Config == null || krb5Config.length() == 0) {
                    krb5Config = SecurityObjectLocator.getSecurityConfig().getAuthMechanism("KRB5").getString("krb5Config");
                }
                if (krb5Config != null && krb5Config.length() > 0) {
                    Krb5Utils.setKrbConfigProp(krb5Config);
                    Config krb5Cfg = Config.getInstance();
                    Config.refresh();
                    krb5Cfg = Config.getInstance();
                    keytab = krb5Cfg.getDefault("default_keytab_name", "libdefaults");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.security.auth.kerberos.krb5utils.getDefaultKeytab", "533");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                }
                throw e;
            }
            if (keytab != null && keytab.length() > 0 && ((defaultKrb5Keytab = keytab.substring(keytab.indexOf(":") + 1, keytab.length())) == null || defaultKrb5Keytab.length() == 0)) {
                defaultKrb5Keytab = keytab;
            }
            try {
                KeyTab.getInstance(defaultKrb5Keytab);
            }
            catch (IOException e) {
                FFDCFilter.processException(e, "com.ibm.security.auth.kerberos.krb5utils.getDefaultKeytab", "549");
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, e.getMessage(), new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultKeytab " + defaultKrb5Keytab);
        }
        return defaultKrb5Keytab;
    }

    public static ObjectName getAuthMechObj(Session session, ConfigService configService, ObjectName securityObj, String authType) throws Exception {
        ObjectName authMechObj;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAuthMechObj");
            }
            authMechObj = null;
            try {
                ArrayList mechanisms = (ArrayList)configService.getAttribute(session, securityObj, "authMechanisms");
                if (mechanisms != null) {
                    for (int i = 0; i < mechanisms.size(); ++i) {
                        ObjectName[] matches;
                        AttributeList authAttrs = (AttributeList)mechanisms.get(i);
                        Object authObj = ConfigServiceHelper.getAttributeValue(authAttrs, "_Websphere_Config_Data_Type");
                        if (!authObj.toString().equals(authType) || (matches = configService.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(authAttrs), null))[0] == null) continue;
                        authMechObj = matches[0];
                    }
                }
            }
            catch (InvalidAttributeNameException e) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "getAuthMechObj caught an unexpected exception.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthMechObj " + authMechObj);
        }
        return authMechObj;
    }

    public static void createKRBAuthnToken(KerberosTicket kTicket, GSSCredential gssCred, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKRBAuthnToken");
        }
        if (subject != null && gssCred != null | kTicket != null) {
            try {
                KRBAuthnToken krbAuthnToken;
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (gssCred != null) {
                    map.put(KRBAuthnTokenFactory.GSS_CREDENTIAL, gssCred);
                }
                if (kTicket != null) {
                    map.put(KRBAuthnTokenFactory.KERBEROS_TICKET, kTicket);
                }
                if ((krbAuthnToken = KRBAuthnTokenFactoryFactory.getFactory().createToken(map)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "KRBAuthnToken: ", krbAuthnToken);
                    }
                    SubjectHelper.putKerberosAuthnTokenToSubject(krbAuthnToken, subject);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.auth.kerberos.createKRBAuthnToken", "621");
                Object[] parms = new Object[]{"KRBAuthnToken()", e};
                Tr.error(tc, "security.auth.kerberos.unexpectedexception", parms);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Subject is null or Kerberos ticket and gssCred are null - not good");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKRBAuthnToken ");
        }
    }
}

