/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.kerberos;

import com.ibm.ws.security.auth.kerberos.KerberosPolicy;
import com.ibm.ws.security.auth.kerberos.KerberosThreadContext;
import com.ibm.ws.util.WSThreadLocal;

public class KerberosThreadManager
extends WSThreadLocal {
    private static final KerberosThreadManager thisManager = new KerberosThreadManager();
    private static final ThreadLocal threadLocStorage = new KerberosThreadLocal();

    private KerberosThreadManager() {
    }

    public static KerberosThreadManager getInstance() {
        return thisManager;
    }

    public void setKerberosPolicy(KerberosPolicy kp) {
        ((KerberosThreadContext)this.getThreadLocalStorage().get()).kerberosPolicy = kp;
    }

    public KerberosPolicy getKerberosPolicy() {
        return ((KerberosThreadContext)this.getThreadLocalStorage().get()).kerberosPolicy;
    }

    public Boolean isKerberosPolicyRetrievalInProcess() {
        return ((KerberosThreadContext)this.getThreadLocalStorage().get()).kerberosPolicyRetrievalInProcess;
    }

    public void setKerberosPolicyRetrievalInProcess() {
        ((KerberosThreadContext)this.getThreadLocalStorage().get()).kerberosPolicyRetrievalInProcess = Boolean.TRUE;
    }

    public void unsetKerberosPolicyRetrievalInProcess() {
        ((KerberosThreadContext)this.getThreadLocalStorage().get()).kerberosPolicyRetrievalInProcess = Boolean.FALSE;
    }

    public KerberosThreadContext getThreadLocal() {
        KerberosThreadContext result = (KerberosThreadContext)this.getThreadLocalStorage().get();
        if (result == null) {
            result = new KerberosThreadContext();
            this.getThreadLocalStorage().set(result);
        }
        return result;
    }

    private ThreadLocal getThreadLocalStorage() {
        return threadLocStorage;
    }

    private static final class KerberosThreadLocal
    extends WSThreadLocal {
        private KerberosThreadLocal() {
        }

        protected Object initialValue() {
            return new KerberosThreadContext();
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

