/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.j2c;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.j2c.WSAuthDataAliasCallback;
import com.ibm.ws.security.auth.j2c.WSManagedConnectionFactoryCallback;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSPrincipalMappingCallbackHandler
implements CallbackHandler {
    private static final TraceComponent tc = Tr.register(WSPrincipalMappingCallbackHandler.class, null, "com.ibm.ejs.resources.security");
    private String wspm_userID = null;
    private String wspm_password = null;
    private String wspm_alias = null;
    private ManagedConnectionFactory wspm_mcf = null;

    public WSPrincipalMappingCallbackHandler(String userID, String password, ManagedConnectionFactory mcf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSPrincipalMappingCallbackHandler(userID = \"" + userID + "\")");
        }
        this.wspm_userID = userID;
        this.wspm_password = password;
        this.wspm_mcf = mcf;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSPrincipalMappingCallbackHandler(userID, password, mcf");
        }
    }

    public WSPrincipalMappingCallbackHandler(String authDataAlias, ManagedConnectionFactory mcf) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSPrincipalMappingCallbackHandler(authdataAlias = \"" + authDataAlias + "\")");
        }
        this.wspm_alias = authDataAlias;
        this.wspm_mcf = mcf;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSPrincipalMappingCallbackHandler(authDataAlias, mcf");
        }
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(callbacks)");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback nc;
            if (callbacks[i] instanceof WSManagedConnectionFactoryCallback) {
                WSManagedConnectionFactoryCallback mcfc = (WSManagedConnectionFactoryCallback)callbacks[i];
                mcfc.setManagedConnectionFactory(this.wspm_mcf);
                continue;
            }
            if (callbacks[i] instanceof WSAuthDataAliasCallback) {
                nc = (WSAuthDataAliasCallback)callbacks[i];
                ((WSAuthDataAliasCallback)nc).setAlias(this.wspm_alias);
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                nc = (NameCallback)callbacks[i];
                ((NameCallback)nc).setName(this.wspm_userID);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                if (this.wspm_password != null) {
                    pc.setPassword(this.wspm_password.toCharArray());
                    continue;
                }
                pc.setPassword(null);
                continue;
            }
            Integer iobj = new Integer(i);
            Tr.warning(tc, "security.j2c.unrecognizedCallbackIndex", new Object[]{iobj, callbacks[i]});
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks)");
        }
    }
}

